/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepositoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.ThumbnailCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.service.permission.LayoutPermissionUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.servlet.InactiveRequestHandler;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ServiceProxyFactory;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.model.impl.ImageImpl;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerEntry;
import com.liferay.trash.kernel.model.TrashEntry;
import com.liferay.trash.kernel.util.TrashUtil;
import com.liferay.users.admin.kernel.file.uploads.UserFileUploadsSettings;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.text.Format;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class WebServerServlet
extends HttpServlet {
    public static final String PATH_PORTLET_FILE_ENTRY = "portlet_file_entry";
    private static final boolean _WEB_SERVER_SERVLET_VERSION_VERBOSITY_DEFAULT = StringUtil.equalsIgnoreCase(PropsValues.WEB_SERVER_SERVLET_VERSION_VERBOSITY, ReleaseInfo.getName());
    private static final boolean _WEB_SERVER_SERVLET_VERSION_VERBOSITY_PARTIAL = StringUtil.equalsIgnoreCase(PropsValues.WEB_SERVER_SERVLET_VERSION_VERBOSITY, "partial");
    private static final Log _log = LogFactoryUtil.getLog(WebServerServlet.class);
    private static final Set<String> _acceptRangesMimeTypes = SetUtil.fromArray(PropsValues.WEB_SERVER_SERVLET_ACCEPT_RANGES_MIME_TYPES);
    private static volatile InactiveRequestHandler _inactiveRequestHandler = ServiceProxyFactory.newServiceTrackedInstance(InactiveRequestHandler.class, WebServerServlet.class, "_inactiveRequestHandler", false);
    private static volatile UserFileUploadsSettings _userFileUploadsSettings = ServiceProxyFactory.newServiceTrackedInstance(UserFileUploadsSettings.class, WebServerServlet.class, "_userFileUploadsSettings", false);
    private final Format _dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat("d MMM yyyy HH:mm z");
    private boolean _lastModified = true;
    private TemplateResource _templateResource;

    /*
     * Exception decompiling
     */
    public static boolean hasFiles(HttpServletRequest httpServletRequest) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._lastModified = GetterUtil.getBoolean(servletConfig.getInitParameter("last_modified"), true);
        Class<?> clazz = ((Object)((Object)this)).getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        String templateId = "com/liferay/portal/webserver/dependencies/template.ftl";
        URL url = classLoader.getResource(templateId);
        this._templateResource = new URLTemplateResource(templateId, url);
    }

    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        User user = null;
        try {
            user = WebServerServlet._getUser(httpServletRequest);
            if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, user.getCompanyId())) {
                return;
            }
            PrincipalThreadLocal.setName(user.getUserId());
            PrincipalThreadLocal.setPassword(PortalUtil.getUserPassword(httpServletRequest));
            PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
            PermissionThreadLocal.setPermissionChecker(permissionChecker);
            if (this._lastModified) {
                long ifModifiedSince;
                long lastModified = this.getLastModified(httpServletRequest);
                if (lastModified > 0L && (ifModifiedSince = httpServletRequest.getDateHeader("If-Modified-Since")) > 0L && ifModifiedSince == lastModified) {
                    httpServletResponse.setStatus(304);
                    return;
                }
                if (lastModified > 0L) {
                    httpServletResponse.setDateHeader("Last-Modified", lastModified);
                }
            }
            TransactionConfig.Builder builder = new TransactionConfig.Builder();
            builder.setReadOnly(true);
            builder.setRollbackForClasses(Exception.class);
            TransactionInvokerUtil.invoke(builder.build(), this._createFileServingCallable(httpServletRequest, httpServletResponse, user));
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError(404, (Exception)nsfee, httpServletRequest, httpServletResponse);
        }
        catch (NoSuchFolderException nsfe) {
            PortalUtil.sendError(404, (Exception)nsfe, httpServletRequest, httpServletResponse);
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, user, httpServletRequest, httpServletResponse);
        }
        catch (Exception e) {
            PortalUtil.sendError(e, httpServletRequest, httpServletResponse);
        }
        catch (Throwable t) {
            PortalUtil.sendError(new Exception(t), httpServletRequest, httpServletResponse);
        }
    }

    protected static FileEntry getPortletFileEntry(HttpServletRequest httpServletRequest, String[] pathArray) throws Exception {
        User user;
        String uuid = pathArray[3];
        long groupId = GetterUtil.getLong(pathArray[1]);
        FileEntry fileEntry = PortletFileRepositoryUtil.getPortletFileEntry(uuid, groupId);
        if (!fileEntry.containsPermission(PermissionCheckerFactoryUtil.create(user = WebServerServlet._getUser(httpServletRequest)), "VIEW")) {
            throw new PrincipalException.MustHavePermission(user.getUserId(), "VIEW");
        }
        int status = ParamUtil.getInteger(httpServletRequest, "status", 0);
        if (status != 8 && fileEntry.isInTrash()) {
            return null;
        }
        return fileEntry;
    }

    protected Image convertFileEntry(boolean smallImage, FileEntry fileEntry) throws PortalException {
        try {
            ImageImpl image = new ImageImpl();
            image.setModifiedDate(fileEntry.getModifiedDate());
            InputStream is = null;
            is = smallImage ? ImageProcessorUtil.getThumbnailAsStream(fileEntry.getFileVersion(), 0) : fileEntry.getContentStream();
            byte[] bytes = FileUtil.getBytes(is);
            image.setTextObj(bytes);
            image.setType(fileEntry.getExtension());
            return image;
        }
        catch (PortalException pe) {
            throw pe;
        }
        catch (SystemException se) {
            throw se;
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }

    protected Image getDefaultImage(HttpServletRequest httpServletRequest, long imageId) {
        String path = GetterUtil.getString(httpServletRequest.getPathInfo());
        if (path.startsWith("/company_logo") || path.startsWith("/layout_set_logo") || path.startsWith("/logo")) {
            return ImageToolUtil.getDefaultCompanyLogo();
        }
        if (path.startsWith("/organization_logo")) {
            return ImageToolUtil.getDefaultOrganizationLogo();
        }
        if (path.startsWith("/user_female_portrait")) {
            return ImageToolUtil.getDefaultUserFemalePortrait();
        }
        if (path.startsWith("/user_male_portrait")) {
            return ImageToolUtil.getDefaultUserMalePortrait();
        }
        if (path.startsWith("/user_portrait")) {
            return ImageToolUtil.getDefaultUserPortrait();
        }
        return null;
    }

    protected FileEntry getFileEntry(String[] pathArray) throws Exception {
        if (pathArray.length == 1) {
            long fileShortcutId = GetterUtil.getLong(pathArray[0]);
            FileShortcut dlFileShortcut = DLAppServiceUtil.getFileShortcut(fileShortcutId);
            return DLAppServiceUtil.getFileEntry(dlFileShortcut.getToFileEntryId());
        }
        if (pathArray.length == 2) {
            long groupId = GetterUtil.getLong(pathArray[0]);
            return DLAppServiceUtil.getFileEntryByUuidAndGroupId(pathArray[1], groupId);
        }
        if (pathArray.length == 3) {
            long groupId = GetterUtil.getLong(pathArray[0]);
            long folderId = GetterUtil.getLong(pathArray[1]);
            String fileName = HttpUtil.decodeURL(pathArray[2]);
            if (fileName.contains("?")) {
                fileName = fileName.substring(0, fileName.indexOf("?"));
            }
            return DLAppServiceUtil.getFileEntry(groupId, folderId, fileName);
        }
        long groupId = GetterUtil.getLong(pathArray[0]);
        String uuid = pathArray[3];
        return DLAppServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
    }

    protected Image getImage(HttpServletRequest httpServletRequest, boolean getDefault) throws Exception {
        Image image = null;
        long imageId = this.getImageId(httpServletRequest);
        if (imageId > 0L) {
            image = ImageServiceUtil.getImage(imageId);
            String path = GetterUtil.getString(httpServletRequest.getPathInfo());
            if (path.startsWith("/layout_icon") || path.startsWith("/logo")) {
                Layout layout = LayoutLocalServiceUtil.fetchLayoutByIconImageId(true, imageId);
                if (layout != null) {
                    PermissionChecker permissionChecker;
                    User user = PortalUtil.getUser(httpServletRequest);
                    if (user == null) {
                        long companyId = PortalUtil.getCompanyId(httpServletRequest);
                        user = UserLocalServiceUtil.getDefaultUser(companyId);
                    }
                    if (!LayoutPermissionUtil.contains(permissionChecker = PermissionCheckerFactoryUtil.create(user), layout, "VIEW")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, Layout.class.getName(), layout.getPlid(), "VIEW");
                    }
                }
            } else if (path.startsWith("/layout_set_logo")) {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSetByLogoId(true, imageId);
                if (layoutSet != null) {
                    User user = PortalUtil.getUser(httpServletRequest);
                    if (user == null) {
                        long companyId = PortalUtil.getCompanyId(httpServletRequest);
                        user = UserLocalServiceUtil.getDefaultUser(companyId);
                    }
                    PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
                    Group group = layoutSet.getGroup();
                    if (!group.isShowSite(permissionChecker, layoutSet.isPrivateLayout()) && !GroupPermissionUtil.contains(permissionChecker, layoutSet.getGroupId(), "VIEW")) {
                        throw new PrincipalException.MustHavePermission(permissionChecker, LayoutSet.class.getName(), layoutSet.getLayoutSetId(), "VIEW");
                    }
                }
            } else if (path.startsWith("/user_female_portrait") || path.startsWith("/user_male_portrait") || path.startsWith("/user_portrait")) {
                image = this.getUserPortraitImageResized(image, imageId);
            }
        } else {
            String uuid = ParamUtil.getString(httpServletRequest, "uuid");
            long groupId = ParamUtil.getLong(httpServletRequest, "groupId");
            boolean igSmallImage = ParamUtil.getBoolean(httpServletRequest, "igSmallImage");
            if (Validator.isNotNull(uuid) && groupId > 0L) {
                try {
                    FileEntry fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
                    image = this.convertFileEntry(igSmallImage, fileEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (getDefault && image == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("Get a default image for " + imageId);
            }
            image = this.getDefaultImage(httpServletRequest, imageId);
        }
        return image;
    }

    protected byte[] getImageBytes(HttpServletRequest httpServletRequest, Image image) throws PortalException {
        byte[] textObj = image.getTextObj();
        if (textObj == null || textObj.length == 0) {
            throw new NoSuchFileException();
        }
        try {
            if (!PropsValues.IMAGE_AUTO_SCALE) {
                return textObj;
            }
            ImageBag imageBag = null;
            if (image.getImageId() == 0L) {
                imageBag = ImageToolUtil.read(textObj);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                image.setHeight(renderedImage.getHeight());
                image.setWidth(renderedImage.getWidth());
            }
            int height = ParamUtil.getInteger(httpServletRequest, "height", image.getHeight());
            int width = ParamUtil.getInteger(httpServletRequest, "width", image.getWidth());
            if (height >= image.getHeight() && width >= image.getWidth()) {
                return textObj;
            }
            if (image.getImageId() != 0L) {
                imageBag = ImageToolUtil.read(textObj);
            }
            RenderedImage renderedImage = ImageToolUtil.scale(imageBag.getRenderedImage(), height, width);
            return ImageToolUtil.getBytes(renderedImage, imageBag.getType());
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn("Error scaling image " + image.getImageId(), e);
            }
            return textObj;
        }
    }

    protected long getImageId(HttpServletRequest httpServletRequest) {
        long imageId = ParamUtil.getLong(httpServletRequest, "image_id");
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong(httpServletRequest, "img_id");
        }
        if (imageId <= 0L) {
            imageId = ParamUtil.getLong(httpServletRequest, "i_id");
        }
        User user = null;
        if (imageId <= 0L) {
            long companyId = ParamUtil.getLong(httpServletRequest, "companyId");
            String screenName = ParamUtil.getString(httpServletRequest, "screenName");
            if (companyId > 0L && Validator.isNotNull(screenName) && (user = UserLocalServiceUtil.fetchUserByScreenName(companyId, screenName)) != null) {
                imageId = user.getPortraitId();
            }
        }
        if (_userFileUploadsSettings.isImageCheckToken() && imageId > 0L) {
            String imageIdToken = ParamUtil.getString(httpServletRequest, "img_id_token");
            if (user == null) {
                user = UserLocalServiceUtil.fetchUserByPortraitId(imageId);
            }
            if (user != null && !imageIdToken.equals(DigesterUtil.digest(user.getUserUuid()))) {
                return 0L;
            }
        }
        return imageId;
    }

    protected long getLastModified(HttpServletRequest httpServletRequest) {
        try {
            Date modifiedDate = null;
            Image image = this.getImage(httpServletRequest, true);
            if (image != null) {
                modifiedDate = image.getModifiedDate();
            } else {
                String path = HttpUtil.fixPath(httpServletRequest.getPathInfo());
                String[] pathArray = StringUtil.split(path, '/');
                if (pathArray.length == 0) {
                    return -1L;
                }
                if (pathArray[0].equals("language")) {
                    return -1L;
                }
                FileEntry fileEntry = null;
                try {
                    fileEntry = this.getFileEntry(pathArray);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (fileEntry == null) {
                    return -1L;
                }
                String version = ParamUtil.getString(httpServletRequest, "version");
                if (Validator.isNotNull(version)) {
                    FileVersion fileVersion = fileEntry.getFileVersion(version);
                    modifiedDate = fileVersion.getModifiedDate();
                } else {
                    modifiedDate = fileEntry.getModifiedDate();
                }
            }
            if (modifiedDate == null) {
                modifiedDate = PortalUtil.getUptime();
            }
            return modifiedDate.getTime() / 1000L * 1000L;
        }
        catch (PrincipalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn(pe, pe);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return -1L;
    }

    protected Image getUserPortraitImageResized(Image image, long imageId) throws PortalException {
        if (image == null) {
            return null;
        }
        int usersImageMaxHeight = _userFileUploadsSettings.getImageMaxHeight();
        int usersImageMaxWidth = _userFileUploadsSettings.getImageMaxWidth();
        if (usersImageMaxHeight > 0 && image.getHeight() > usersImageMaxHeight || usersImageMaxWidth > 0 && image.getWidth() > usersImageMaxWidth) {
            User user = UserLocalServiceUtil.getUserByPortraitId(imageId);
            UserLocalServiceUtil.updatePortrait(user.getUserId(), image.getTextObj());
            return ImageLocalServiceUtil.getImage(imageId);
        }
        return image;
    }

    protected boolean isLegacyImageGalleryImageId(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        try {
            long imageId = this.getImageId(httpServletRequest);
            if (imageId == 0L) {
                return false;
            }
            Repository repository = RepositoryProviderUtil.getImageRepository(imageId);
            if (!repository.isCapabilityProvided(ThumbnailCapability.class)) {
                return false;
            }
            ThumbnailCapability thumbnailCapability = repository.getCapability(ThumbnailCapability.class);
            FileEntry fileEntry = thumbnailCapability.fetchImageFileEntry(imageId);
            if (fileEntry == null) {
                return false;
            }
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String queryString = "";
            if (imageId == thumbnailCapability.getSmallImageId(fileEntry)) {
                queryString = "&imageThumbnail=1";
            } else if (imageId == thumbnailCapability.getCustom1ImageId(fileEntry)) {
                queryString = "&imageThumbnail=2";
            } else if (imageId == thumbnailCapability.getCustom2ImageId(fileEntry)) {
                queryString = "&imageThumbnail=3";
            }
            FileVersion fileVersion = fileEntry.getFileVersion();
            if (PropsValues.DL_FILE_ENTRY_IG_THUMBNAIL_GENERATION && Validator.isNotNull(queryString)) {
                ImageProcessorUtil.hasImages(fileVersion);
            }
            String url = DLUtil.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString);
            httpServletResponse.setHeader("Location", url);
            httpServletResponse.setStatus(301);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean isSupportsRangeHeader(String contentType) {
        return _acceptRangesMimeTypes.contains(contentType);
    }

    protected void processPrincipalException(Throwable t, User user, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (!user.isDefaultUser()) {
            PortalUtil.sendError(401, (Exception)t, httpServletRequest, httpServletResponse);
            return;
        }
        String redirect = PortalUtil.getPathMain() + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL(httpServletRequest);
        redirect = HttpUtil.addParameter(redirect, "redirect", currentURL);
        httpServletResponse.sendRedirect(redirect);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void sendDocumentLibrary(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user, String path, String[] pathArray) throws Exception {
        Group group = WebServerServlet._getGroup(user.getCompanyId(), pathArray[0]);
        WebServerServlet._checkDirectoryIndexingEnabled(group);
        long groupId = group.getGroupId();
        long folderId = 0L;
        for (int i = 1; i < pathArray.length; ++i) {
            String name = pathArray[i];
            try {
                Folder folder = DLAppServiceUtil.getFolder(groupId, folderId, name);
                folderId = folder.getFolderId();
                continue;
            }
            catch (NoSuchFolderException nsfe) {
                if (i != pathArray.length - 1) {
                    throw nsfe;
                }
                String title = name;
                this.sendFile(httpServletResponse, user, groupId, folderId, title);
                return;
            }
        }
        try {
            this.sendFile(httpServletResponse, user, groupId, folderId, "index.html");
            return;
        }
        catch (Exception e) {
            block12: {
                if (!(e instanceof NoSuchFileEntryException) && !(e instanceof PrincipalException)) throw e;
                try {
                    this.sendFile(httpServletResponse, user, groupId, folderId, "index.htm");
                    return;
                }
                catch (NoSuchFileEntryException nsfee) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(nsfee, nsfee);
                    }
                }
                catch (PrincipalException pe) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug(pe, pe);
                }
            }
            ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
            webServerEntries.add(new WebServerEntry(path, "../"));
            List<Folder> folders = DLAppServiceUtil.getFolders(groupId, folderId);
            for (Folder folder : folders) {
                WebServerEntry webServerEntry = new WebServerEntry(path, folder.getName() + "/", folder.getCreateDate(), folder.getModifiedDate(), folder.getDescription(), 0L);
                webServerEntries.add(webServerEntry);
            }
            List<FileEntry> fileEntries = DLAppServiceUtil.getFileEntries(groupId, folderId);
            for (FileEntry fileEntry : fileEntries) {
                WebServerEntry webServerEntry = new WebServerEntry(path, fileEntry.getTitle(), fileEntry.getCreateDate(), fileEntry.getModifiedDate(), fileEntry.getDescription(), fileEntry.getSize());
                webServerEntries.add(webServerEntry);
            }
            this.sendHTML(httpServletResponse, path, webServerEntries);
            return;
        }
    }

    protected void sendFile(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, User user, String[] pathArray) throws Exception {
        FileEntry fileEntry = this.getFileEntry(pathArray);
        if (fileEntry == null) {
            throw new NoSuchFileEntryException();
        }
        if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, fileEntry.getCompanyId())) {
            return;
        }
        String version = ParamUtil.getString(httpServletRequest, "version");
        if (Validator.isNull(version) && Validator.isNotNull(fileEntry.getVersion())) {
            version = fileEntry.getVersion();
        }
        String tempFileId = DLUtil.getTempFileId(fileEntry.getFileEntryId(), version);
        if (fileEntry.isInTrash()) {
            int status = ParamUtil.getInteger(httpServletRequest, "status", 0);
            if (status != 8) {
                throw new NoSuchFileEntryException();
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            String portletId = PortletProviderUtil.getPortletId(TrashEntry.class.getName(), PortletProvider.Action.VIEW);
            if (!PortletPermissionUtil.hasControlPanelAccessPermission(permissionChecker, fileEntry.getGroupId(), portletId)) {
                throw new PrincipalException.MustHavePermission(permissionChecker, FileEntry.class.getName(), fileEntry.getFileEntryId(), "ACCESS_IN_CONTROL_PANEL");
            }
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        if (ParamUtil.getInteger(httpServletRequest, "height") > 0 || ParamUtil.getInteger(httpServletRequest, "width") > 0) {
            InputStream inputStream = fileVersion.getContentStream(true);
            Image image = ImageToolUtil.getImage(inputStream);
            this.writeImage(image, httpServletRequest, httpServletResponse);
            return;
        }
        String fileName = fileVersion.getFileName();
        boolean converted = false;
        String targetExtension = ParamUtil.getString(httpServletRequest, "targetExtension");
        int imageThumbnail = ParamUtil.getInteger(httpServletRequest, "imageThumbnail");
        int documentThumbnail = ParamUtil.getInteger(httpServletRequest, "documentThumbnail");
        int previewFileIndex = ParamUtil.getInteger(httpServletRequest, "previewFileIndex");
        boolean audioPreview = ParamUtil.getBoolean(httpServletRequest, "audioPreview");
        boolean imagePreview = ParamUtil.getBoolean(httpServletRequest, "imagePreview");
        boolean videoPreview = ParamUtil.getBoolean(httpServletRequest, "videoPreview");
        int videoThumbnail = ParamUtil.getInteger(httpServletRequest, "videoThumbnail");
        InputStream inputStream = null;
        long contentLength = 0L;
        if (imageThumbnail > 0 && imageThumbnail <= 3) {
            fileName = FileUtil.stripExtension(fileName).concat(".").concat(ImageProcessorUtil.getThumbnailType(fileVersion));
            int thumbnailIndex = imageThumbnail - 1;
            inputStream = ImageProcessorUtil.getThumbnailAsStream(fileVersion, thumbnailIndex);
            contentLength = ImageProcessorUtil.getThumbnailFileSize(fileVersion, thumbnailIndex);
            converted = true;
        } else if (documentThumbnail > 0 && documentThumbnail <= 3) {
            fileName = FileUtil.stripExtension(fileName).concat(".").concat("png");
            int thumbnailIndex = documentThumbnail - 1;
            inputStream = PDFProcessorUtil.getThumbnailAsStream(fileVersion, thumbnailIndex);
            contentLength = PDFProcessorUtil.getThumbnailFileSize(fileVersion, thumbnailIndex);
            converted = true;
        } else if (previewFileIndex > 0) {
            fileName = FileUtil.stripExtension(fileName).concat(".").concat("png");
            inputStream = PDFProcessorUtil.getPreviewAsStream(fileVersion, previewFileIndex);
            contentLength = PDFProcessorUtil.getPreviewFileSize(fileVersion, previewFileIndex);
            converted = true;
        } else if (audioPreview || videoPreview) {
            String type = ParamUtil.getString(httpServletRequest, "type");
            fileName = FileUtil.stripExtension(fileName).concat(".").concat(type);
            if (audioPreview) {
                inputStream = AudioProcessorUtil.getPreviewAsStream(fileVersion, type);
                contentLength = AudioProcessorUtil.getPreviewFileSize(fileVersion, type);
            } else {
                inputStream = VideoProcessorUtil.getPreviewAsStream(fileVersion, type);
                contentLength = VideoProcessorUtil.getPreviewFileSize(fileVersion, type);
            }
            converted = true;
        } else if (imagePreview) {
            String type = ImageProcessorUtil.getPreviewType(fileVersion);
            fileName = FileUtil.stripExtension(fileName).concat(".").concat(type);
            inputStream = ImageProcessorUtil.getPreviewAsStream(fileVersion);
            contentLength = ImageProcessorUtil.getPreviewFileSize(fileVersion);
            converted = true;
        } else if (videoThumbnail > 0 && videoThumbnail <= 3) {
            fileName = FileUtil.stripExtension(fileName).concat(".").concat("jpg");
            int thumbnailIndex = videoThumbnail - 1;
            inputStream = VideoProcessorUtil.getThumbnailAsStream(fileVersion, thumbnailIndex);
            contentLength = VideoProcessorUtil.getThumbnailFileSize(fileVersion, thumbnailIndex);
            converted = true;
        } else {
            File convertedFile;
            inputStream = fileVersion.getContentStream(true);
            contentLength = fileVersion.getSize();
            if (Validator.isNotNull(targetExtension) && (convertedFile = DocumentConversionUtil.convert(tempFileId, inputStream, fileVersion.getExtension(), targetExtension)) != null) {
                fileName = FileUtil.stripExtension(fileName).concat(".").concat(targetExtension);
                inputStream = new FileInputStream(convertedFile);
                contentLength = convertedFile.length();
                converted = true;
            }
        }
        FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check(inputStream);
        if (flashMagicBytesUtilResult.isFlash()) {
            fileName = FileUtil.stripExtension(fileName) + ".swf";
        }
        inputStream = flashMagicBytesUtilResult.getInputStream();
        String contentType = null;
        contentType = converted ? MimeTypesUtil.getContentType(fileName) : fileVersion.getMimeType();
        if (_log.isDebugEnabled()) {
            _log.debug("Content type set to " + contentType);
        }
        if (this.isSupportsRangeHeader(contentType)) {
            ServletResponseUtil.sendFileWithRangeHeader(httpServletRequest, httpServletResponse, fileName, inputStream, contentLength, contentType);
        } else {
            boolean download = ParamUtil.getBoolean(httpServletRequest, "download");
            if (download) {
                ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, inputStream, contentLength, contentType, "attachment");
            } else {
                ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, inputStream, contentLength, contentType);
            }
        }
    }

    protected void sendFile(HttpServletResponse httpServletResponse, User user, long groupId, long folderId, String title) throws Exception {
        FileEntry fileEntry = DLAppServiceUtil.getFileEntry(groupId, folderId, title);
        ServletResponseUtil.sendFile(null, httpServletResponse, title, fileEntry.getContentStream(), fileEntry.getSize(), fileEntry.getMimeType(), "attachment");
    }

    protected void sendGroups(HttpServletResponse httpServletResponse, User user, String path) throws Exception {
        if (!PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED) {
            httpServletResponse.setStatus(403);
            throw new PrincipalException();
        }
        ArrayList<WebServerEntry> webServerEntries = new ArrayList<WebServerEntry>();
        List<Group> groups = WebDAVUtil.getGroups(user);
        for (Group group : groups) {
            if (!WebServerServlet._isDirectoryIndexingEnabled(group)) continue;
            String name = HttpUtil.fixPath(group.getFriendlyURL());
            WebServerEntry webServerEntry = new WebServerEntry(path, name + "/", null, null, group.getDescription(), 0L);
            webServerEntries.add(webServerEntry);
        }
        this.sendHTML(httpServletResponse, path, webServerEntries);
    }

    protected void sendHTML(HttpServletResponse httpServletResponse, String path, List<WebServerEntry> webServerEntries) throws Exception {
        Template template = TemplateManagerUtil.getTemplate("ftl", this._templateResource, true);
        template.put("dateFormat", this._dateFormat);
        template.put("entries", webServerEntries);
        template.put("path", HttpUtil.encodePath(path));
        if (!_WEB_SERVER_SERVLET_VERSION_VERBOSITY_DEFAULT) {
            if (_WEB_SERVER_SERVLET_VERSION_VERBOSITY_PARTIAL) {
                template.put("releaseInfo", ReleaseInfo.getName());
            } else {
                template.put("releaseInfo", ReleaseInfo.getReleaseInfo());
            }
        }
        template.put("validator", Validator_IW.getInstance());
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        template.processTemplate(httpServletResponse.getWriter());
    }

    protected void sendPortletFileEntry(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String[] pathArray) throws Exception {
        boolean download;
        FileEntry fileEntry = WebServerServlet.getPortletFileEntry(httpServletRequest, pathArray);
        if (fileEntry == null) {
            return;
        }
        if (this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, fileEntry.getCompanyId())) {
            return;
        }
        String fileName = HttpUtil.decodeURL(HtmlUtil.escape(pathArray[2]));
        if (fileEntry.isInTrash()) {
            fileName = TrashUtil.getOriginalTitle(fileName);
        }
        if (download = ParamUtil.getBoolean(httpServletRequest, "download")) {
            ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, fileEntry.getContentStream(), fileEntry.getSize(), fileEntry.getMimeType(), "attachment");
        } else {
            InputStream is = fileEntry.getContentStream();
            FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check(is);
            is = flashMagicBytesUtilResult.getInputStream();
            if (flashMagicBytesUtilResult.isFlash()) {
                fileName = FileUtil.stripExtension(fileName) + ".swf";
            }
            ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, is, fileEntry.getSize(), fileEntry.getMimeType());
        }
    }

    protected void writeImage(Image image, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws PortalException {
        block6: {
            if (image == null) {
                return;
            }
            String contentType = null;
            String type = image.getType();
            if (!type.equals("na")) {
                contentType = MimeTypesUtil.getExtensionContentType(type);
                httpServletResponse.setContentType(contentType);
            }
            String fileName = ParamUtil.getString(httpServletRequest, "fileName");
            byte[] bytes = this.getImageBytes(httpServletRequest, image);
            try {
                if (Validator.isNotNull(fileName)) {
                    ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, bytes, contentType);
                } else {
                    ServletResponseUtil.write(httpServletResponse, bytes);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block6;
                _log.warn(e, e);
            }
        }
    }

    private static void _checkDirectoryIndexingEnabled(Group group) throws Exception {
        if (!WebServerServlet._isDirectoryIndexingEnabled(group)) {
            if (_log.isDebugEnabled()) {
                _log.debug("Directory indexing is not enabled for group " + group.getGroupId());
            }
            throw new NoSuchFolderException();
        }
    }

    private static void _checkFileEntry(String[] pathArray) throws Exception {
        block9: {
            if (pathArray.length == 1) {
                long fileShortcutId = GetterUtil.getLong(pathArray[0]);
                FileShortcut fileShortcut = DLAppLocalServiceUtil.getFileShortcut(fileShortcutId);
                DLAppLocalServiceUtil.getFileEntry(fileShortcut.getToFileEntryId());
            } else if (pathArray.length != 2) {
                if (pathArray.length == 3) {
                    long groupId = GetterUtil.getLong(pathArray[0]);
                    long folderId = GetterUtil.getLong(pathArray[1]);
                    String fileName = HttpUtil.decodeURL(pathArray[2]);
                    try {
                        DLAppLocalServiceUtil.getFileEntry(groupId, folderId, fileName);
                    }
                    catch (RepositoryException re) {
                        if (_log.isDebugEnabled()) {
                            _log.debug(re, re);
                        }
                        break block9;
                    }
                }
                long groupId = GetterUtil.getLong(pathArray[0]);
                String uuid = pathArray[3];
                try {
                    DLAppLocalServiceUtil.getFileEntryByUuidAndGroupId(uuid, groupId);
                }
                catch (RepositoryException re) {
                    if (!_log.isDebugEnabled()) break block9;
                    _log.debug(re, re);
                }
            }
        }
    }

    private static Group _getGroup(long companyId, String name) throws Exception {
        Group group = GroupLocalServiceUtil.fetchFriendlyURLGroup(companyId, "/" + name);
        if (group != null) {
            return group;
        }
        User user = UserLocalServiceUtil.getUserByScreenName(companyId, name);
        group = user.getGroup();
        return group;
    }

    private static User _getUser(HttpServletRequest httpServletRequest) throws Exception {
        User user;
        HttpSession session = httpServletRequest.getSession();
        if (PortalSessionThreadLocal.getHttpSession() == null) {
            PortalSessionThreadLocal.setHttpSession(session);
        }
        if ((user = PortalUtil.getUser(httpServletRequest)) != null) {
            return user;
        }
        String userIdString = (String)session.getAttribute("j_username");
        String password = (String)session.getAttribute("j_password");
        if (userIdString != null && password != null) {
            long userId = GetterUtil.getLong(userIdString);
            user = UserLocalServiceUtil.getUser(userId);
        } else {
            long companyId = PortalUtil.getCompanyId(httpServletRequest);
            Company company = CompanyLocalServiceUtil.getCompany(companyId);
            user = company.getDefaultUser();
        }
        return user;
    }

    private static boolean _isDirectoryIndexingEnabled(Group group) {
        UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
        return GetterUtil.getBoolean(typeSettingsProperties.getProperty("directoryIndexingEnabled"), PropsValues.WEB_SERVER_SERVLET_DIRECTORY_INDEXING_ENABLED);
    }

    private Callable<Void> _createFileServingCallable(final HttpServletRequest httpServletRequest, final HttpServletResponse httpServletResponse, final User user) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String path = HttpUtil.fixPath(httpServletRequest.getPathInfo());
                String[] pathArray = StringUtil.split(path, '/');
                if (pathArray.length == 0) {
                    WebServerServlet.this.sendGroups(httpServletResponse, user, httpServletRequest.getServletPath() + "/" + path);
                } else if (Validator.isNumber(pathArray[0])) {
                    WebServerServlet.this.sendFile(httpServletRequest, httpServletResponse, user, pathArray);
                } else if (WebServerServlet.PATH_PORTLET_FILE_ENTRY.equals(pathArray[0])) {
                    WebServerServlet.this.sendPortletFileEntry(httpServletRequest, httpServletResponse, pathArray);
                } else {
                    if (PropsValues.WEB_SERVER_SERVLET_CHECK_IMAGE_GALLERY && WebServerServlet.this.isLegacyImageGalleryImageId(httpServletRequest, httpServletResponse)) {
                        return null;
                    }
                    Image image = WebServerServlet.this.getImage(httpServletRequest, true);
                    if (image != null) {
                        if (image.getCompanyId() != user.getCompanyId() && WebServerServlet.this._processCompanyInactiveRequest(httpServletRequest, httpServletResponse, image.getCompanyId())) {
                            return null;
                        }
                        WebServerServlet.this.writeImage(image, httpServletRequest, httpServletResponse);
                    } else {
                        WebServerServlet.this.sendDocumentLibrary(httpServletRequest, httpServletResponse, user, httpServletRequest.getServletPath() + "/" + path, pathArray);
                    }
                }
                return null;
            }
        };
    }

    private boolean _processCompanyInactiveRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, long companyId) throws IOException {
        if (companyId == 0L || PortalInstances.isCompanyActive(companyId)) {
            return false;
        }
        _inactiveRequestHandler.processInactiveRequest(httpServletRequest, httpServletResponse, "this-instance-is-inactive-please-contact-the-administrator");
        if (_log.isDebugEnabled()) {
            _log.debug("Processed company inactive request");
        }
        return true;
    }
}

