/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.URLCodec;
import java.util.Date;

public class WebServerEntry {
    private Date _createDate;
    private String _description;
    private Date _modifiedDate;
    private String _name;
    private String _path;
    private long _size;

    public WebServerEntry(String path, String name) {
        this(path, name, null, null, null, 0L);
    }

    public WebServerEntry(String path, String name, Date createDate, Date modifiedDate, String description, long size) {
        this._path = this.getPath(path, name);
        this._name = name;
        this._createDate = createDate;
        this._modifiedDate = modifiedDate;
        this._description = GetterUtil.getString(description);
        this._size = size;
    }

    public Date getCreateDate() {
        return this._createDate;
    }

    public String getDescription() {
        return this._description;
    }

    public Date getModifiedDate() {
        return this._modifiedDate;
    }

    public String getName() {
        return this._name;
    }

    public String getPath() {
        return this._path;
    }

    public long getSize() {
        return this._size;
    }

    public void setCreateDate(Date createDate) {
        this._createDate = createDate;
    }

    public void setDescription(String description) {
        this._description = description;
    }

    public void setModifiedDate(Date modifiedDate) {
        this._modifiedDate = modifiedDate;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setPath(String path) {
        this._path = path;
    }

    public void setSize(long size) {
        this._size = size;
    }

    protected String getPath(String path, String name) {
        if (name.endsWith("/")) {
            name = HttpUtil.fixPath(name, false, true);
            return this.getPath(path, name) + "/";
        }
        path = path.endsWith("/") ? path + URLCodec.encodeURL(name, true) : path + "/" + URLCodec.encodeURL(name, true);
        return path;
    }
}

