/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webserver;

import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DynamicResourceServlet
extends WebServerServlet {
    private File _tempDir;

    @Override
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._tempDir = (File)this.getServletContext().getAttribute("javax.servlet.context.tempdir");
    }

    @Override
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String fileName;
        String contentType;
        long ifModifiedSince;
        String spriteRootDirName;
        String pathInfo;
        String servletPath = httpServletRequest.getServletPath();
        String path = servletPath.concat(pathInfo = URLDecoder.decode(httpServletRequest.getPathInfo(), "UTF-8"));
        if (!this.isAllowedPath(path)) {
            httpServletResponse.setStatus(404);
            return;
        }
        File rootDir = this._tempDir;
        File file = new File(rootDir, path);
        if (servletPath.equals("/sprite") && Validator.isNotNull(spriteRootDirName = PropsValues.SPRITE_ROOT_DIR)) {
            rootDir = new File(spriteRootDirName);
            file = new File(rootDir, pathInfo);
        }
        String canonicalPath = file.getCanonicalPath();
        if (!file.exists() || file.isDirectory() || !file.canRead() || file.isHidden() || !canonicalPath.startsWith(rootDir.getCanonicalPath())) {
            httpServletResponse.setStatus(404);
            return;
        }
        long lastModified = file.lastModified();
        if (lastModified > 0L && (ifModifiedSince = httpServletRequest.getDateHeader("If-Modified-Since")) > 0L && ifModifiedSince == lastModified) {
            httpServletResponse.setStatus(304);
            return;
        }
        if (lastModified > 0L) {
            httpServletResponse.setDateHeader("Last-Modified", lastModified);
        }
        if (this.isSupportsRangeHeader(contentType = MimeTypesUtil.getContentType(fileName = file.getName()))) {
            ServletResponseUtil.sendFileWithRangeHeader(httpServletRequest, httpServletResponse, fileName, new FileInputStream(file), file.length(), contentType);
        } else {
            ServletResponseUtil.sendFile(httpServletRequest, httpServletResponse, fileName, new FileInputStream(file), file.length(), contentType);
        }
    }

    protected boolean isAllowedPath(String path) {
        for (String allowedPath : PropsValues.DYNAMIC_RESOURCE_SERVLET_ALLOWED_PATHS) {
            if (!path.startsWith(allowedPath)) continue;
            return true;
        }
        return false;
    }
}

