/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.webdav.methods.MethodFactory;
import com.liferay.portal.util.PropsUtil;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class MethodFactoryImpl
implements MethodFactory {
    @Override
    public Method create(HttpServletRequest httpServletRequest) throws WebDAVException {
        String method = httpServletRequest.getMethod();
        Map methods = MethodHolder._methods;
        Method methodImpl = (Method)methods.get(StringUtil.toUpperCase(method));
        if (methodImpl == null) {
            throw new WebDAVException("Method " + method + " is not implemented");
        }
        return methodImpl;
    }

    private static class MethodHolder {
        private static final Map<String, Object> _methods = new HashMap<String, Object>(){
            {
                try {
                    for (String methodName : Method.SUPPORTED_METHOD_NAMES) {
                        String defaultClassName = methodName.substring(1);
                        defaultClassName = StringUtil.toLowerCase(defaultClassName);
                        defaultClassName = methodName.substring(0, 1) + defaultClassName;
                        defaultClassName = "com.liferay.portal.webdav.methods." + defaultClassName + "MethodImpl";
                        String className = GetterUtil.getString(PropsUtil.get(MethodFactoryImpl.class.getName() + "." + methodName), defaultClassName);
                        this.put(methodName, InstanceFactory.newInstance(MethodFactoryImpl.class.getClassLoader(), className));
                    }
                }
                catch (Exception e) {
                    throw new ExceptionInInitializerError(e);
                }
            }
        };

        private MethodHolder() {
        }
    }
}

