/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.methods.Method;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetMethodImpl
implements Method {
    private static final Log _log = LogFactoryUtil.getLog(GetMethodImpl.class);

    @Override
    public int process(WebDAVRequest webDAVRequest) throws WebDAVException {
        InputStream is = null;
        try {
            WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
            Resource resource = storage.getResource(webDAVRequest);
            if (resource == null) {
                return 404;
            }
            try {
                is = resource.getContentAsStream();
            }
            catch (Exception e) {
                _log.error(e.getMessage());
            }
            if (is != null) {
                block9: {
                    String fileName = resource.getDisplayName();
                    FlashMagicBytesUtil.Result flashMagicBytesUtilResult = FlashMagicBytesUtil.check(is);
                    if (flashMagicBytesUtilResult.isFlash()) {
                        fileName = FileUtil.stripExtension(fileName) + ".swf";
                    }
                    is = flashMagicBytesUtilResult.getInputStream();
                    try {
                        HttpServletRequest httpServletRequest = webDAVRequest.getHttpServletRequest();
                        HttpServletResponse httpServletResponse = webDAVRequest.getHttpServletResponse();
                        ServletResponseUtil.sendFileWithRangeHeader(httpServletRequest, httpServletResponse, fileName, is, resource.getSize(), resource.getContentType());
                    }
                    catch (Exception e) {
                        if (!_log.isWarnEnabled()) break block9;
                        _log.warn(e, e);
                    }
                }
                return 200;
            }
            return 404;
        }
        catch (Exception e) {
            throw new WebDAVException(e);
        }
    }
}

