/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav.methods;

import com.liferay.petra.xml.DocUtil;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.WebDAVProps;
import com.liferay.portal.kernel.service.WebDAVPropsLocalServiceUtil;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.webdav.Resource;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Namespace;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletResponse;

public abstract class BasePropMethodImpl
implements Method {
    public static final QName ALLPROP = BasePropMethodImpl.createQName("allprop");
    public static final QName CREATIONDATE = BasePropMethodImpl.createQName("creationdate");
    public static final QName DISPLAYNAME = BasePropMethodImpl.createQName("displayname");
    public static final QName GETCONTENTLENGTH = BasePropMethodImpl.createQName("getcontentlength");
    public static final QName GETCONTENTTYPE = BasePropMethodImpl.createQName("getcontenttype");
    public static final QName GETLASTMODIFIED = BasePropMethodImpl.createQName("getlastmodified");
    public static final QName ISREADONLY = BasePropMethodImpl.createQName("isreadonly");
    public static final QName LOCKDISCOVERY = BasePropMethodImpl.createQName("lockdiscovery");
    public static final QName RESOURCETYPE = BasePropMethodImpl.createQName("resourcetype");
    private static final Log _log = LogFactoryUtil.getLog(BasePropMethodImpl.class);
    private static final List<QName> _allCollectionProps = Arrays.asList(CREATIONDATE, DISPLAYNAME, GETLASTMODIFIED, GETCONTENTTYPE, LOCKDISCOVERY, RESOURCETYPE);
    private static final List<QName> _allSimpleProps = Arrays.asList(CREATIONDATE, DISPLAYNAME, GETLASTMODIFIED, GETCONTENTTYPE, GETCONTENTLENGTH, ISREADONLY, LOCKDISCOVERY, RESOURCETYPE);

    protected static QName createQName(String name) {
        return SAXReaderUtil.createQName(name, WebDAVUtil.DAV_URI);
    }

    protected void addResponse(String href, Element multistatusElement) throws Exception {
        Element responseElement = DocUtil.add(multistatusElement, BasePropMethodImpl.createQName("response"));
        DocUtil.add(responseElement, BasePropMethodImpl.createQName("href"), href);
        Element propstatElement = DocUtil.add(responseElement, BasePropMethodImpl.createQName("propstat"));
        DocUtil.add(propstatElement, BasePropMethodImpl.createQName("status"), "HTTP/1.1 404 Not Found");
    }

    protected void addResponse(WebDAVRequest webDAVRequest, Resource resource, Set<QName> props, Element multistatus) throws Exception {
        Lock lock;
        props = new HashSet<QName>(props);
        Element responseElement = DocUtil.add(multistatus, BasePropMethodImpl.createQName("response"));
        DocUtil.add(responseElement, BasePropMethodImpl.createQName("href"), resource.getHREF());
        Element successStatElement = DocUtil.add(responseElement, BasePropMethodImpl.createQName("propstat"));
        Element successPropElement = DocUtil.add(successStatElement, BasePropMethodImpl.createQName("prop"));
        Element failureStatElement = DocUtil.add(responseElement, BasePropMethodImpl.createQName("propstat"));
        Element failurePropElement = DocUtil.add(failureStatElement, BasePropMethodImpl.createQName("prop"));
        boolean hasSuccess = false;
        boolean hasFailure = false;
        if (props.contains(ALLPROP)) {
            props.remove(ALLPROP);
            if (resource.isCollection()) {
                props.addAll(_allCollectionProps);
            } else {
                props.addAll(_allSimpleProps);
            }
        }
        if (props.contains(CREATIONDATE)) {
            props.remove(CREATIONDATE);
            DocUtil.add(successPropElement, CREATIONDATE, resource.getCreateDate());
            hasSuccess = true;
        }
        if (props.contains(DISPLAYNAME)) {
            props.remove(DISPLAYNAME);
            DocUtil.add(successPropElement, DISPLAYNAME, resource.getDisplayName());
            hasSuccess = true;
        }
        if (props.contains(GETLASTMODIFIED)) {
            props.remove(GETLASTMODIFIED);
            DocUtil.add(successPropElement, GETLASTMODIFIED, resource.getModifiedDate());
            hasSuccess = true;
        }
        if (props.contains(GETCONTENTTYPE)) {
            props.remove(GETCONTENTTYPE);
            DocUtil.add(successPropElement, GETCONTENTTYPE, resource.getContentType());
            hasSuccess = true;
        }
        if (props.contains(GETCONTENTLENGTH)) {
            props.remove(GETCONTENTLENGTH);
            if (!resource.isCollection()) {
                DocUtil.add(successPropElement, GETCONTENTLENGTH, resource.getSize());
                hasSuccess = true;
            } else {
                DocUtil.add(failurePropElement, GETCONTENTLENGTH);
                hasFailure = true;
            }
        }
        if (props.contains(ISREADONLY)) {
            props.remove(ISREADONLY);
            lock = resource.getLock();
            if (lock == null || resource.isLocked()) {
                DocUtil.add(successPropElement, ISREADONLY, Boolean.FALSE.toString());
            } else {
                DocUtil.add(successPropElement, ISREADONLY, Boolean.TRUE.toString());
            }
            hasSuccess = true;
        }
        if (props.contains(LOCKDISCOVERY)) {
            props.remove(LOCKDISCOVERY);
            lock = resource.getLock();
            if (lock != null) {
                Element lockDiscoveryElement = DocUtil.add(successPropElement, LOCKDISCOVERY);
                Element activeLockElement = DocUtil.add(lockDiscoveryElement, BasePropMethodImpl.createQName("activelock"));
                Element lockTypeElement = DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("locktype"));
                DocUtil.add(lockTypeElement, BasePropMethodImpl.createQName("write"));
                Element lockScopeElement = DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("lockscope"));
                DocUtil.add(lockScopeElement, BasePropMethodImpl.createQName("exclusive"));
                if (resource.isCollection()) {
                    DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("depth"), "Infinity");
                }
                DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("owner"), lock.getOwner());
                long timeRemaining = 0L;
                Date expirationDate = lock.getExpirationDate();
                if (expirationDate != null) {
                    long now = System.currentTimeMillis();
                    timeRemaining = (expirationDate.getTime() - now) / 1000L;
                    if (timeRemaining <= 0L) {
                        timeRemaining = 1L;
                    }
                }
                if (timeRemaining > 0L) {
                    DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("timeout"), "Second-" + timeRemaining);
                } else {
                    DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("timeout"), "Infinite");
                }
                if (webDAVRequest.getUserId() == lock.getUserId()) {
                    Element lockTokenElement = DocUtil.add(activeLockElement, BasePropMethodImpl.createQName("locktoken"));
                    DocUtil.add(lockTokenElement, BasePropMethodImpl.createQName("href"), "opaquelocktoken:" + lock.getUuid());
                }
                hasSuccess = true;
            } else {
                DocUtil.add(failurePropElement, LOCKDISCOVERY);
                hasFailure = true;
            }
        }
        if (props.contains(RESOURCETYPE)) {
            props.remove(RESOURCETYPE);
            Element resourceTypeElement = DocUtil.add(successPropElement, RESOURCETYPE);
            if (resource.isCollection()) {
                DocUtil.add(resourceTypeElement, BasePropMethodImpl.createQName("collection"));
            }
            hasSuccess = true;
        }
        WebDAVProps webDAVProps = WebDAVPropsLocalServiceUtil.getWebDAVProps(webDAVRequest.getCompanyId(), resource.getClassName(), resource.getPrimaryKey());
        Set<QName> customProps = webDAVProps.getPropsSet();
        for (QName qName : props) {
            if (customProps.contains(qName)) {
                Namespace namespace = qName.getNamespace();
                String name = qName.getName();
                String prefix = namespace.getPrefix();
                String uri = namespace.getURI();
                String text = webDAVProps.getText(name, prefix, uri);
                DocUtil.add(successPropElement, qName, text);
                hasSuccess = true;
                continue;
            }
            DocUtil.add(failurePropElement, qName);
            hasFailure = true;
        }
        if (hasSuccess) {
            DocUtil.add(successStatElement, BasePropMethodImpl.createQName("status"), "HTTP/1.1 200 OK");
        } else {
            responseElement.remove(successStatElement);
        }
        if (!hasSuccess && hasFailure) {
            DocUtil.add(failureStatElement, BasePropMethodImpl.createQName("status"), "HTTP/1.1 404 Not Found");
        } else {
            responseElement.remove(failureStatElement);
        }
    }

    protected void addResponse(WebDAVStorage storage, WebDAVRequest webDAVRequest, Resource resource, Set<QName> props, Element multistatusElement, long depth) throws Exception {
        this.addResponse(webDAVRequest, resource, props, multistatusElement);
        if (resource.isCollection() && depth != 0L) {
            List<Resource> storageResources = storage.getResources(webDAVRequest);
            for (Resource storageResource : storageResources) {
                this.addResponse(webDAVRequest, storageResource, props, multistatusElement);
            }
        }
    }

    protected int writeResponseXML(WebDAVRequest webDAVRequest, Set<QName> props) throws Exception {
        WebDAVStorage storage = webDAVRequest.getWebDAVStorage();
        Document document = SAXReaderUtil.createDocument();
        Element multistatusElement = SAXReaderUtil.createElement(BasePropMethodImpl.createQName("multistatus"));
        document.setRootElement(multistatusElement);
        Resource resource = storage.getResource(webDAVRequest);
        if (resource != null) {
            int status;
            block5: {
                long depth = WebDAVUtil.getDepth(webDAVRequest.getHttpServletRequest());
                this.addResponse(storage, webDAVRequest, resource, props, multistatusElement, depth);
                String xml = document.formattedString("    ");
                if (_log.isDebugEnabled()) {
                    _log.debug("Response XML\n" + xml);
                }
                status = 207;
                HttpServletResponse httpServletResponse = webDAVRequest.getHttpServletResponse();
                httpServletResponse.setContentType("text/xml; charset=UTF-8");
                httpServletResponse.setStatus(status);
                try {
                    ServletResponseUtil.write(httpServletResponse, xml);
                    httpServletResponse.flushBuffer();
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn(e, e);
                }
            }
            return status;
        }
        if (_log.isDebugEnabled()) {
            _log.debug("No resource found for " + storage.getRootPath() + webDAVRequest.getPath());
        }
        return 404;
    }
}

