/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.kernel.webdav.methods.Method;
import com.liferay.portal.kernel.webdav.methods.MethodFactory;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webdav.CompanyWebDAVStorageImpl;
import com.liferay.portal.webdav.GroupWebDAVStorageImpl;
import com.liferay.portal.webdav.WebDAVRequestImpl;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVServlet
extends HttpServlet {
    private static final Log _log = LogFactoryUtil.getLog(WebDAVServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        WebDAVStorage storage;
        String userAgent;
        int status;
        block22: {
            block23: {
                block21: {
                    status = 412;
                    userAgent = httpServletRequest.getHeader("User-Agent");
                    if (_log.isDebugEnabled()) {
                        _log.debug("User agent " + userAgent);
                    }
                    if (!this.isIgnoredResource(httpServletRequest)) break block21;
                    status = 404;
                    httpServletResponse.setStatus(status);
                    if (!_log.isInfoEnabled()) return;
                    String xLitmus = GetterUtil.getString(httpServletRequest.getHeader("X-Litmus"));
                    if (Validator.isNotNull(xLitmus)) {
                        xLitmus = xLitmus + " ";
                    }
                    _log.info(StringBundler.concat(xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status));
                    return;
                }
                storage = this.getStorage(httpServletRequest);
                if (storage != null) break block22;
                if (!_log.isDebugEnabled()) break block23;
                _log.debug("Invalid WebDAV path " + httpServletRequest.getPathInfo());
            }
            httpServletResponse.setStatus(status);
            if (!_log.isInfoEnabled()) return;
            String xLitmus = GetterUtil.getString(httpServletRequest.getHeader("X-Litmus"));
            if (Validator.isNotNull(xLitmus)) {
                xLitmus = xLitmus + " ";
            }
            _log.info(StringBundler.concat(xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status));
            return;
        }
        try {
            if (storage.getRootPath() == null) {
                storage.setRootPath(this.getRootPath(httpServletRequest));
            }
            PermissionChecker permissionChecker = null;
            String remoteUser = httpServletRequest.getRemoteUser();
            if (remoteUser != null) {
                PrincipalThreadLocal.setName(remoteUser);
                long userId = GetterUtil.getLong(remoteUser);
                User user = UserLocalServiceUtil.getUserById(userId);
                permissionChecker = PermissionCheckerFactoryUtil.create(user);
                PermissionThreadLocal.setPermissionChecker(permissionChecker);
            }
            MethodFactory methodFactory = storage.getMethodFactory();
            Method method = methodFactory.create(httpServletRequest);
            try {
                WebDAVRequestImpl webDAVRequest = new WebDAVRequestImpl(storage, httpServletRequest, httpServletResponse, userAgent, permissionChecker);
                status = method.process(webDAVRequest);
            }
            catch (WebDAVException wdave) {
                void var12_19;
                boolean logError = false;
                WebDAVException webDAVException = wdave;
                while (var12_19 != null) {
                    if (var12_19 instanceof PrincipalException) {
                        logError = true;
                    }
                    Throwable throwable = var12_19.getCause();
                }
                if (logError) {
                    _log.error(wdave, wdave);
                } else if (_log.isWarnEnabled()) {
                    _log.warn(wdave, wdave);
                }
                status = 412;
            }
        }
        catch (Exception e) {
            try {
                _log.error(e, e);
            }
            catch (Throwable throwable) {
                httpServletResponse.setStatus(status);
                if (!_log.isInfoEnabled()) throw throwable;
                String xLitmus = GetterUtil.getString(httpServletRequest.getHeader("X-Litmus"));
                if (Validator.isNotNull(xLitmus)) {
                    xLitmus = xLitmus + " ";
                }
                _log.info(StringBundler.concat(xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status));
                throw throwable;
            }
            httpServletResponse.setStatus(status);
            if (!_log.isInfoEnabled()) return;
            String xLitmus = GetterUtil.getString(httpServletRequest.getHeader("X-Litmus"));
            if (Validator.isNotNull(xLitmus)) {
                xLitmus = xLitmus + " ";
            }
            _log.info(StringBundler.concat(xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status));
            return;
        }
        httpServletResponse.setStatus(status);
        if (!_log.isInfoEnabled()) return;
        String xLitmus = GetterUtil.getString(httpServletRequest.getHeader("X-Litmus"));
        if (Validator.isNotNull(xLitmus)) {
            xLitmus = xLitmus + " ";
        }
        _log.info(StringBundler.concat(xLitmus, httpServletRequest.getMethod(), " ", httpServletRequest.getRequestURI(), " ", status));
        return;
    }

    protected String getRootPath(HttpServletRequest httpServletRequest) {
        String contextPath = HttpUtil.fixPath(PortalUtil.getPathContext(httpServletRequest), false, true);
        String servletPath = HttpUtil.fixPath(httpServletRequest.getServletPath(), false, true);
        return contextPath.concat(servletPath);
    }

    protected WebDAVStorage getStorage(HttpServletRequest httpServletRequest) {
        String pathInfo = WebDAVUtil.stripManualCheckInRequiredPath(httpServletRequest.getPathInfo());
        pathInfo = WebDAVUtil.stripOfficeExtension(pathInfo);
        String[] pathArray = WebDAVUtil.getPathArray(pathInfo, true);
        WebDAVStorage storage = null;
        if (pathArray.length == 0) {
            storage = (WebDAVStorage)InstancePool.get(CompanyWebDAVStorageImpl.class.getName());
        } else if (pathArray.length == 1) {
            storage = (WebDAVStorage)InstancePool.get(GroupWebDAVStorageImpl.class.getName());
        } else if (pathArray.length >= 2) {
            storage = WebDAVUtil.getStorage(pathArray[1]);
        }
        return storage;
    }

    protected boolean isIgnoredResource(HttpServletRequest httpServletRequest) {
        Object[] pathArray = WebDAVUtil.getPathArray(httpServletRequest.getPathInfo(), true);
        if (ArrayUtil.isEmpty(pathArray)) {
            return false;
        }
        for (String ignore : PropsValues.WEBDAV_IGNORE) {
            String[] ignoreArray = ignore.split("/");
            if (ignoreArray.length > pathArray.length) continue;
            boolean match = true;
            for (int i = 1; i <= ignoreArray.length; ++i) {
                if (((String)pathArray[pathArray.length - i]).equals(ignoreArray[ignoreArray.length - i])) continue;
                match = false;
                break;
            }
            if (!match) continue;
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("Skipping over ", httpServletRequest.getMethod(), " ", httpServletRequest.getPathInfo()));
            }
            return true;
        }
        return false;
    }
}

