/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webdav;

import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVRequest;
import com.liferay.portal.kernel.webdav.WebDAVStorage;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class WebDAVRequestImpl
implements WebDAVRequest {
    private static final String _APPLE_DOUBLE_PREFIX = "._";
    private final long _companyId;
    private final long _groupId;
    private final HttpServletRequest _httpServletRequest;
    private final HttpServletResponse _httpServletResponse;
    private final String _lockUuid;
    private final boolean _manualCheckInRequired;
    private final String _path;
    private final PermissionChecker _permissionChecker;
    private final WebDAVStorage _storage;
    private final String _userAgent;
    private final long _userId;

    public WebDAVRequestImpl(WebDAVStorage storage, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String userAgent, PermissionChecker permissionChecker) throws WebDAVException {
        this._storage = storage;
        this._httpServletRequest = httpServletRequest;
        this._httpServletResponse = httpServletResponse;
        this._userAgent = userAgent;
        this._lockUuid = WebDAVUtil.getLockUuid(httpServletRequest);
        String pathInfo = HttpUtil.fixPath(this._httpServletRequest.getPathInfo(), false, true);
        String strippedPathInfo = WebDAVUtil.stripManualCheckInRequiredPath(pathInfo);
        if (strippedPathInfo.length() != pathInfo.length()) {
            pathInfo = strippedPathInfo;
            this._manualCheckInRequired = true;
        } else {
            this._manualCheckInRequired = false;
        }
        this._path = WebDAVUtil.stripOfficeExtension(pathInfo);
        this._companyId = PortalUtil.getCompanyId(httpServletRequest);
        this._groupId = WebDAVUtil.getGroupId(this._companyId, this._path);
        this._userId = GetterUtil.getLong(this._httpServletRequest.getRemoteUser());
        this._permissionChecker = permissionChecker;
    }

    @Override
    public long getCompanyId() {
        return this._companyId;
    }

    @Override
    public long getGroupId() {
        return this._groupId;
    }

    @Override
    public HttpServletRequest getHttpServletRequest() {
        return this._httpServletRequest;
    }

    @Override
    public HttpServletResponse getHttpServletResponse() {
        return this._httpServletResponse;
    }

    @Override
    public String getLockUuid() {
        return this._lockUuid;
    }

    @Override
    public String getPath() {
        return this._path;
    }

    @Override
    public String[] getPathArray() {
        return WebDAVUtil.getPathArray(this._path);
    }

    @Override
    public PermissionChecker getPermissionChecker() {
        return this._permissionChecker;
    }

    @Override
    public String getRootPath() {
        return this._storage.getRootPath();
    }

    @Override
    public long getUserId() {
        return this._userId;
    }

    @Override
    public WebDAVStorage getWebDAVStorage() {
        return this._storage;
    }

    @Override
    public boolean isAppleDoubleRequest() {
        String[] pathArray = this.getPathArray();
        String name = WebDAVUtil.getResourceName(pathArray);
        return this.isMac() && name.startsWith(_APPLE_DOUBLE_PREFIX);
    }

    @Override
    public boolean isLitmus() {
        return this._userAgent.contains("litmus");
    }

    @Override
    public boolean isMac() {
        return this._userAgent.contains("WebDAVFS");
    }

    @Override
    public boolean isManualCheckInRequired() {
        return this._manualCheckInRequired;
    }

    @Override
    public boolean isWindows() {
        return this._userAgent.contains("Microsoft Data Access Internet Publishing Provider");
    }
}

