/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.webcache;

import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheHelperUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.webcache.WebCacheException;
import com.liferay.portal.kernel.webcache.WebCacheItem;
import com.liferay.portal.kernel.webcache.WebCachePool;

public class WebCachePoolImpl
implements WebCachePool {
    private static final String _CACHE_NAME = WebCachePool.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(WebCachePoolImpl.class);
    private PortalCache<String, Object> _portalCache;

    public void afterPropertiesSet() {
        this._portalCache = PortalCacheHelperUtil.getPortalCache("SINGLE_VM_PORTAL_CACHE_MANAGER", _CACHE_NAME);
    }

    @Override
    public void clear() {
        this._portalCache.removeAll();
    }

    @Override
    public Object get(String key, WebCacheItem wci) {
        Object obj;
        block5: {
            obj = this._portalCache.get(key);
            if (obj != null) {
                return obj;
            }
            try {
                obj = wci.convert(key);
                if (obj == null) {
                    return null;
                }
                int timeToLive = (int)(wci.getRefreshTime() / 1000L);
                this._portalCache.put(key, obj, timeToLive);
            }
            catch (WebCacheException wce) {
                if (!_log.isWarnEnabled()) break block5;
                Throwable cause = wce.getCause();
                if (cause != null) {
                    _log.warn(cause, cause);
                }
                _log.warn(wce, wce);
            }
        }
        return obj;
    }

    @Override
    public void remove(String key) {
        this._portalCache.remove(key);
    }
}

