/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify.test.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.test.rule.Inject;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portal.verify.test.util.BaseVerifyProcessTestCase;
import java.util.List;
import javax.portlet.PortletPreferences;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public abstract class BaseCompanySettingsVerifyProcessTestCase
extends BaseVerifyProcessTestCase {
    @Inject
    protected CompanyLocalService companyLocalService;
    @Inject
    protected PrefsProps prefsProps;
    @Inject
    protected SettingsFactory settingsFactory;
    private static BundleContext _bundleContext;

    @BeforeClass
    public static void setUpClass() {
        Bundle bundle = FrameworkUtil.getBundle(BaseCompanySettingsVerifyProcessTestCase.class);
        _bundleContext = bundle.getBundleContext();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        UnicodeProperties properties = new UnicodeProperties();
        this.populateLegacyProperties(properties);
        List<Company> companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            this.companyLocalService.updatePreferences(company.getCompanyId(), properties);
        }
    }

    @Override
    @After
    public void tearDown() throws Exception {
        List<Company> companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            Settings settings = this.getSettings(company.getCompanyId());
            ModifiableSettings modifiableSettings = settings.getModifiableSettings();
            modifiableSettings.reset();
            modifiableSettings.store();
        }
        super.tearDown();
    }

    @Override
    protected void doVerify() throws VerifyException {
        super.doVerify();
        List<Company> companies = this.companyLocalService.getCompanies(false);
        for (Company company : companies) {
            PortletPreferences portletPreferences = this.prefsProps.getPreferences(company.getCompanyId(), true);
            Settings settings = this.getSettings(company.getCompanyId());
            Assert.assertNotNull(settings);
            this.doVerify(portletPreferences, settings);
        }
    }

    protected abstract void doVerify(PortletPreferences var1, Settings var2);

    protected Settings getSettings(long companyId) {
        try {
            return this.settingsFactory.getSettings(new CompanyServiceSettingsLocator(companyId, this.getSettingsId()));
        }
        catch (SettingsException se) {
            throw new IllegalStateException(se);
        }
    }

    protected abstract String getSettingsId();

    @Override
    protected VerifyProcess getVerifyProcess() {
        try {
            Object[] serviceReferences = _bundleContext.getServiceReferences(VerifyProcess.class.getName(), StringBundler.concat("(&(objectClass=", VerifyProcess.class.getName(), ")(verify.process.name=", this.getVerifyProcessName(), "))"));
            if (ArrayUtil.isEmpty(serviceReferences)) {
                throw new IllegalStateException("Unable to get verify process");
            }
            return (VerifyProcess)_bundleContext.getService((ServiceReference)serviceReferences[0]);
        }
        catch (Exception ise) {
            throw new IllegalStateException("Unable to get verify process");
        }
    }

    protected abstract String getVerifyProcessName();

    protected abstract void populateLegacyProperties(UnicodeProperties var1);
}

