/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.verify.model.VerifiableGroupedModel;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.Callable;

public class VerifyGroupedModel
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(VerifyGroupedModel.class);

    public void verify(VerifiableGroupedModel ... verifiableGroupedModels) throws Exception {
        ArrayList<String> unverifiedTableNames = new ArrayList<String>();
        for (VerifiableGroupedModel verifiableGroupedModel : verifiableGroupedModels) {
            unverifiedTableNames.add(verifiableGroupedModel.getTableName());
        }
        ArrayList<VerifiableGroupedModelCallable> verifiableGroupedModelCallables = new ArrayList<VerifiableGroupedModelCallable>(unverifiedTableNames.size());
        while (!unverifiedTableNames.isEmpty()) {
            int count = unverifiedTableNames.size();
            for (VerifiableGroupedModel verifiableGroupedModel : verifiableGroupedModels) {
                if (unverifiedTableNames.contains(verifiableGroupedModel.getRelatedTableName()) || !unverifiedTableNames.contains(verifiableGroupedModel.getTableName())) continue;
                VerifiableGroupedModelCallable verifiableGroupedModelCallable = new VerifiableGroupedModelCallable(verifiableGroupedModel);
                verifiableGroupedModelCallables.add(verifiableGroupedModelCallable);
                unverifiedTableNames.remove(verifiableGroupedModel.getTableName());
            }
            if (unverifiedTableNames.size() != count) continue;
            throw new VerifyException("Circular dependency detected " + unverifiedTableNames);
        }
        this.doVerify(verifiableGroupedModelCallables);
    }

    @Override
    protected void doVerify() throws Exception {
        Map<String, VerifiableGroupedModel> verifiableGroupedModelsMap = PortalBeanLocatorUtil.locate(VerifiableGroupedModel.class);
        Collection<VerifiableGroupedModel> verifiableGroupedModels = verifiableGroupedModelsMap.values();
        this.verify(verifiableGroupedModels.toArray(new VerifiableGroupedModel[0]));
    }

    /*
     * Exception decompiling
     */
    protected long getGroupId(Connection con, String tableName, String primaryKeColumnName, long primKey) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected boolean isForceConcurrent(Collection<? extends Callable<Void>> callables) {
        return true;
    }

    protected void verifyGroupedModel(VerifiableGroupedModel verifiableGroupedModel) throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer(verifiableGroupedModel.getTableName());){
            StringBundler sb = new StringBundler(7);
            sb.append("select ");
            sb.append(verifiableGroupedModel.getPrimaryKeyColumnName());
            sb.append(", ");
            sb.append(verifiableGroupedModel.getRelatedPrimaryKeyColumnName());
            sb.append(" from ");
            sb.append(verifiableGroupedModel.getTableName());
            sb.append(" where groupId is null");
            try (Connection con = DataAccess.getConnection();
                 PreparedStatement ps1 = con.prepareStatement(sb.toString());
                 ResultSet rs = ps1.executeQuery();){
                sb = new StringBundler(5);
                sb.append("update ");
                sb.append(verifiableGroupedModel.getTableName());
                sb.append(" set groupId = ? where ");
                sb.append(verifiableGroupedModel.getPrimaryKeyColumnName());
                sb.append(" = ?");
                try (PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch(con.prepareStatement(sb.toString()));){
                    while (rs.next()) {
                        long relatedPrimKey = rs.getLong(verifiableGroupedModel.getRelatedPrimaryKeyColumnName());
                        long groupId = this.getGroupId(con, verifiableGroupedModel.getRelatedTableName(), verifiableGroupedModel.getRelatedPrimaryKeyColumnName(), relatedPrimKey);
                        if (groupId <= 0L) continue;
                        ps2.setLong(1, groupId);
                        long primKey = rs.getLong(verifiableGroupedModel.getPrimaryKeyColumnName());
                        ps2.setLong(2, primKey);
                        ps2.addBatch();
                    }
                    ps2.executeBatch();
                }
            }
        }
    }

    private class VerifiableGroupedModelCallable
    implements Callable<Void> {
        private final VerifiableGroupedModel _verifiableGroupedModel;

        @Override
        public Void call() throws Exception {
            VerifyGroupedModel.this.verifyGroupedModel(this._verifiableGroupedModel);
            return null;
        }

        private VerifiableGroupedModelCallable(VerifiableGroupedModel verifiableGroupedModel) {
            this._verifiableGroupedModel = verifiableGroupedModel;
        }
    }
}

