/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.settings.CompanyServiceSettingsLocator;
import com.liferay.portal.kernel.settings.ModifiableSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.settings.SettingsDescriptor;
import com.liferay.portal.kernel.settings.SettingsException;
import com.liferay.portal.kernel.settings.SettingsFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.PrefsPropsUtil;
import com.liferay.portal.verify.VerifyProcess;
import java.io.IOException;
import java.util.Dictionary;
import java.util.List;
import java.util.Set;
import javax.portlet.ValidatorException;

public abstract class BaseCompanySettingsVerifyProcess
extends VerifyProcess {
    private static final Log _log = LogFactoryUtil.getLog(BaseCompanySettingsVerifyProcess.class);

    @Override
    protected void doVerify() throws Exception {
        this.verifyProperties();
    }

    protected abstract CompanyLocalService getCompanyLocalService();

    protected abstract Set<String> getLegacyPropertyKeys();

    protected Dictionary<String, String> getPropertyValues(long companyId) {
        HashMapDictionary<String, String> dictionary = new HashMapDictionary<String, String>();
        for (String[] renamePropertykeys : this.getRenamePropertyKeysArray()) {
            String propertyValue = PrefsPropsUtil.getString(companyId, renamePropertykeys[0]);
            if (propertyValue == null) continue;
            ((Dictionary)dictionary).put(renamePropertykeys[1], propertyValue);
        }
        return dictionary;
    }

    protected String[][] getRenamePropertyKeysArray() {
        return new String[0][0];
    }

    protected abstract SettingsFactory getSettingsFactory();

    protected abstract String getSettingsId();

    protected void storeSettings(long companyId, String settingsId, Dictionary<String, String> dictionary) throws IOException, SettingsException, ValidatorException {
        SettingsFactory settingsFactory = this.getSettingsFactory();
        Settings settings = settingsFactory.getSettings(new CompanyServiceSettingsLocator(companyId, settingsId));
        ModifiableSettings modifiableSettings = settings.getModifiableSettings();
        SettingsDescriptor settingsDescriptor = settingsFactory.getSettingsDescriptor(settingsId);
        for (String name : settingsDescriptor.getAllKeys()) {
            String oldValue;
            String value = dictionary.get(name);
            if (value == null || value.equals(oldValue = settings.getValue(name, null))) continue;
            modifiableSettings.setValue(name, value);
        }
        modifiableSettings.store();
    }

    protected void verifyProperties() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            CompanyLocalService companyLocalService = this.getCompanyLocalService();
            List<Company> companies = companyLocalService.getCompanies(false);
            for (Company company : companies) {
                Dictionary<String, String> dictionary = this.getPropertyValues(company.getCompanyId());
                if (!dictionary.isEmpty()) {
                    this.storeSettings(company.getCompanyId(), this.getSettingsId(), dictionary);
                }
                Set<String> keys = this.getLegacyPropertyKeys();
                if (_log.isInfoEnabled()) {
                    _log.info(StringBundler.concat("Removing preference keys ", keys, " for company ", company.getCompanyId()));
                }
                companyLocalService.removePreferences(company.getCompanyId(), keys.toArray(new String[0]));
            }
        }
    }
}

