/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.validation;

import com.liferay.osgi.util.ServiceTrackerFactory;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.validation.ModelValidator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.annotation.versioning.ProviderType;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

@ProviderType
public class ModelValidatorRegistryUtil {
    private static final ModelValidatorRegistryUtil _instance = new ModelValidatorRegistryUtil();
    private final BundleContext _bundleContext;
    private final Map<String, ModelValidator<?>> _modelvalidators = new ConcurrentHashMap();
    private final ServiceTracker<ModelValidator<?>, ModelValidator<?>> _serviceTracker;

    public static <T extends ClassedModel> ModelValidator<T> getModelValidator(Class<T> modelClass) {
        return ModelValidatorRegistryUtil.getModelValidator(modelClass.getName());
    }

    public static <T extends ClassedModel> ModelValidator<T> getModelValidator(String className) {
        return _instance._getModelValidator(className);
    }

    public static <T extends ClassedModel, U extends ModelValidator<T>> U getSpecificModelValidator(Class<T> modelClass, Class<U> modelValidatorClass) {
        ModelValidator<T> modelValidator = ModelValidatorRegistryUtil.getModelValidator(modelClass);
        return (U)modelValidator;
    }

    private ModelValidatorRegistryUtil() {
        Bundle bundle = FrameworkUtil.getBundle(ModelValidatorRegistryUtil.class);
        this._bundleContext = bundle.getBundleContext();
        this._serviceTracker = ServiceTrackerFactory.open(this._bundleContext, ModelValidator.class, new ModelValidatorServiceTrackerCustomizer());
        this._serviceTracker.open();
    }

    private <T extends ClassedModel> ModelValidator<T> _getModelValidator(String className) {
        return this._modelvalidators.get(className);
    }

    private class ModelValidatorServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<ModelValidator<?>, ModelValidator<?>> {
        private ModelValidatorServiceTrackerCustomizer() {
        }

        public ModelValidator<?> addingService(ServiceReference<ModelValidator<?>> serviceReference) {
            ModelValidator modelValidator = (ModelValidator)ModelValidatorRegistryUtil.this._bundleContext.getService(serviceReference);
            String modelClassName = GetterUtil.getString(serviceReference.getProperty("model.class.name"));
            ModelValidatorRegistryUtil.this._modelvalidators.put(modelClassName, modelValidator);
            return modelValidator;
        }

        public void modifiedService(ServiceReference<ModelValidator<?>> serviceReference, ModelValidator<?> modelValidator) {
            this.removedService(serviceReference, modelValidator);
            this.addingService((ServiceReference)serviceReference);
        }

        public void removedService(ServiceReference<ModelValidator<?>> serviceReference, ModelValidator<?> modelValidator) {
            ModelValidatorRegistryUtil.this._bundleContext.ungetService(serviceReference);
            String modelClassName = GetterUtil.getString(serviceReference.getProperty("model.class.name"));
            ModelValidatorRegistryUtil.this._modelvalidators.remove(modelClassName);
        }
    }
}

