/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util.test;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.test.randomizerbumpers.RandomizerBumper;
import com.liferay.portal.kernel.test.util.RandomTestUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.FileItem;
import com.liferay.portal.kernel.util.ProgressTracker;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.theme.ThemeDisplayFactory;
import com.liferay.portal.upload.LiferayFileItem;
import com.liferay.portal.upload.LiferayFileItemFactory;
import com.liferay.portal.upload.LiferayServletRequest;
import com.liferay.portal.upload.UploadServletRequestImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpSession;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.mock.web.MockMultipartHttpServletRequest;

public class PortletContainerTestUtil {
    private static final Log _log = LogFactoryUtil.getLog(PortletContainerTestUtil.class);

    public static Map<String, FileItem[]> getFileParameters(int size, byte[] bytes) throws Exception {
        return PortletContainerTestUtil.getFileParameters(size, null, bytes);
    }

    public static Map<String, FileItem[]> getFileParameters(int size, String namespace, byte[] bytes) throws Exception {
        HashMap<String, FileItem[]> fileParameters = new HashMap<String, FileItem[]>();
        LiferayFileItemFactory fileItemFactory = new LiferayFileItemFactory(UploadServletRequestImpl.getTempDir());
        for (int i = 0; i < size; ++i) {
            String fileParameter = "fileParameter" + i;
            if (namespace != null) {
                fileParameter = namespace.concat(fileParameter);
            }
            LiferayFileItem[] liferayFileItems = new LiferayFileItem[2];
            for (int j = 0; j < liferayFileItems.length; ++j) {
                liferayFileItems[j] = fileItemFactory.createItem(RandomTestUtil.randomString(new RandomizerBumper[0]), RandomTestUtil.randomString(new RandomizerBumper[0]), true, RandomTestUtil.randomString(new RandomizerBumper[0]));
                try (OutputStream outputStream = liferayFileItems[j].getOutputStream();){
                    outputStream.write(bytes);
                    continue;
                }
            }
            fileParameters.put(fileParameter, liferayFileItems);
        }
        return fileParameters;
    }

    public static HttpServletRequest getHttpServletRequest(Group group, Layout layout) throws PortalException {
        MockHttpServletRequest httpServletRequest = new MockHttpServletRequest();
        httpServletRequest.setAttribute("LAYOUT", layout);
        ThemeDisplay themeDisplay = ThemeDisplayFactory.create();
        Company company = CompanyLocalServiceUtil.getCompany(layout.getCompanyId());
        themeDisplay.setCompany(company);
        themeDisplay.setLayout(layout);
        themeDisplay.setLayoutSet(layout.getLayoutSet());
        themeDisplay.setPlid(layout.getPlid());
        themeDisplay.setPortalURL(TestPropsValues.PORTAL_URL);
        themeDisplay.setRequest(httpServletRequest);
        themeDisplay.setScopeGroupId(group.getGroupId());
        themeDisplay.setSiteGroupId(group.getGroupId());
        themeDisplay.setUser(TestPropsValues.getUser());
        httpServletRequest.setAttribute("LIFERAY_SHARED_THEME_DISPLAY", themeDisplay);
        return httpServletRequest;
    }

    public static LiferayServletRequest getMultipartRequest(String fileNameParameter, byte[] bytes) {
        MockMultipartHttpServletRequest mockMultipartHttpServletRequest = new MockMultipartHttpServletRequest();
        mockMultipartHttpServletRequest.addFile(new MockMultipartFile(fileNameParameter, bytes));
        mockMultipartHttpServletRequest.setContent(bytes);
        mockMultipartHttpServletRequest.setContentType("multipart/form-data;boundary=" + System.currentTimeMillis());
        mockMultipartHttpServletRequest.setCharacterEncoding("UTF-8");
        MockHttpSession mockHttpSession = new MockHttpSession();
        mockHttpSession.setAttribute(ProgressTracker.PERCENT, new Object());
        mockMultipartHttpServletRequest.setSession(mockHttpSession);
        return new LiferayServletRequest(mockMultipartHttpServletRequest);
    }

    public static Response getPortalAuthentication(HttpServletRequest httpServletRequest, Layout layout, String portletId) throws Exception {
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, portletId, layout.getPlid(), "RESOURCE_PHASE");
        return PortletContainerTestUtil.request(portletURL.toString());
    }

    public static Map<String, List<String>> getRegularParameters(int size) {
        HashMap<String, List<String>> regularParameters = new HashMap<String, List<String>>();
        for (int i = 0; i < size; ++i) {
            ArrayList<String> items = new ArrayList<String>();
            for (int j = 0; j < 10; ++j) {
                items.add(RandomTestUtil.randomString(new RandomizerBumper[0]));
            }
            regularParameters.put("regularParameter" + i, items);
        }
        return regularParameters;
    }

    /*
     * Exception decompiling
     */
    public static Response postMultipart(String url, MockMultipartHttpServletRequest mockMultipartHttpServletRequest, String fileNameParameter) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static Response request(String url) throws IOException {
        return PortletContainerTestUtil.request(url, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static Response request(String url, Map<String, List<String>> headers) throws IOException {
        URL urlObject = new URL(url);
        HttpURLConnection httpURLConnection = (HttpURLConnection)urlObject.openConnection();
        httpURLConnection.setConnectTimeout(1500000);
        httpURLConnection.setInstanceFollowRedirects(true);
        httpURLConnection.setReadTimeout(1500000);
        for (Object entry : headers.entrySet()) {
            String key = entry.getKey();
            for (String value : entry.getValue()) {
                if (key.equals("Cookie")) {
                    httpURLConnection.addRequestProperty(key, value.split(";", 2)[0]);
                    continue;
                }
                httpURLConnection.setRequestProperty(key, value);
            }
        }
        try {
            Response response;
            InputStream inputStream;
            Object entry;
            block34: {
                block35: {
                    inputStream = httpURLConnection.getInputStream();
                    entry = null;
                    Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
                    response = new Response(httpURLConnection.getResponseCode(), StringUtil.read(inputStream), headerFields.get("Set-Cookie"));
                    if (inputStream == null) break block34;
                    if (entry == null) break block35;
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)entry).addSuppressed(throwable);
                    }
                    break block34;
                }
                inputStream.close();
            }
            return response;
            catch (Throwable throwable) {
                try {
                    try {
                        entry = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (inputStream != null) {
                            if (entry != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)entry).addSuppressed(throwable3);
                                }
                            } else {
                                inputStream.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException ioe) {
                    try (InputStream inputStream2 = httpURLConnection.getErrorStream();){
                        if (inputStream2 != null) {
                            while (inputStream2.read() != -1) {
                            }
                        }
                    }
                    Response response2 = new Response(httpURLConnection.getResponseCode(), null, null);
                    return response2;
                }
            }
        }
        finally {
            httpURLConnection.disconnect();
        }
    }

    public static class Response {
        private final String _body;
        private final int _code;
        private final List<String> _cookies;

        public String getBody() {
            return this._body;
        }

        public int getCode() {
            return this._code;
        }

        public List<String> getCookies() {
            return this._cookies;
        }

        private Response(int code, String body, List<String> cookies) {
            this._code = code;
            this._body = body;
            this._cookies = cookies;
        }
    }
}

