/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.events.EventsProcessorUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.PortletCategory;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.WebAppPool;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class PortalInstances {
    private static final String _GET_COMPANY_IDS = "select companyId from Company";
    private static final Log _log = LogFactoryUtil.getLog(PortalInstances.class);
    private static final Set<String> _autoLoginIgnoreHosts;
    private static final Set<String> _autoLoginIgnorePaths;
    private static long[] _companyIds;
    private static final Set<String> _virtualHostsIgnoreHosts;
    private static final Set<String> _virtualHostsIgnorePaths;
    private static String[] _webIds;

    public static void addCompanyId(long companyId) {
        if (ArrayUtil.contains(_companyIds, companyId)) {
            return;
        }
        long[] companyIds = new long[_companyIds.length + 1];
        System.arraycopy(_companyIds, 0, companyIds, 0, _companyIds.length);
        companyIds[PortalInstances._companyIds.length] = companyId;
        _companyIds = companyIds;
    }

    public static long getCompanyId(HttpServletRequest httpServletRequest) {
        long cookieCompanyId;
        if (_log.isDebugEnabled()) {
            _log.debug("Get company id");
        }
        Long companyIdObj = (Long)httpServletRequest.getAttribute("COMPANY_ID");
        if (_log.isDebugEnabled()) {
            _log.debug("Company id from request " + companyIdObj);
        }
        if (companyIdObj != null) {
            return companyIdObj;
        }
        long companyId = PortalInstances._getCompanyIdByVirtualHosts(httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug("Company id from host " + companyId);
        }
        if (companyId <= 0L && (cookieCompanyId = GetterUtil.getLong(CookieKeys.getCookie(httpServletRequest, "COMPANY_ID", false))) > 0L) {
            try {
                if (CompanyLocalServiceUtil.fetchCompanyById(cookieCompanyId) == null) {
                    if (_log.isWarnEnabled()) {
                        _log.warn("Company id from cookie " + cookieCompanyId + " does not exist");
                    }
                } else {
                    companyId = cookieCompanyId;
                    if (_log.isDebugEnabled()) {
                        _log.debug("Company id from cookie " + companyId);
                    }
                }
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        if (companyId <= 0L) {
            companyId = PortalInstances.getDefaultCompanyId();
            if (_log.isDebugEnabled()) {
                _log.debug("Default company id " + companyId);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Set company id " + companyId);
        }
        httpServletRequest.setAttribute("COMPANY_ID", (Object)companyId);
        CompanyThreadLocal.setCompanyId(companyId);
        if (Validator.isNotNull(PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME) && httpServletRequest.getAttribute("VIRTUAL_HOST_LAYOUT_SET") == null) {
            try {
                Group group = GroupLocalServiceUtil.getGroup(companyId, PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME);
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(group.getGroupId(), false);
                if (Validator.isNull(layoutSet.getVirtualHostname())) {
                    httpServletRequest.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
                }
            }
            catch (Exception e) {
                _log.error(e, e);
            }
        }
        return companyId;
    }

    public static long[] getCompanyIds() {
        return _companyIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getCompanyIdsBySQL() throws SQLException {
        ArrayList<Long> companyIds = new ArrayList<Long>();
        Connection con = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            con = DataAccess.getConnection();
            ps = con.prepareStatement(_GET_COMPANY_IDS);
            rs = ps.executeQuery();
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                companyIds.add(companyId);
            }
        }
        catch (Throwable throwable) {
            DataAccess.cleanUp(con, ps, rs);
            throw throwable;
        }
        DataAccess.cleanUp(con, ps, rs);
        return ArrayUtil.toArray(companyIds.toArray(new Long[0]));
    }

    public static long getDefaultCompanyId() {
        return _companyIds[0];
    }

    public static String[] getWebIds() {
        if (_webIds != null) {
            return _webIds;
        }
        if (Validator.isNull(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
            throw new RuntimeException("Default web id must not be null");
        }
        try {
            List<Company> companies = CompanyLocalServiceUtil.getCompanies(false);
            ArrayList<String> webIdsList = new ArrayList<String>(companies.size());
            for (Company company : companies) {
                String webId = company.getWebId();
                if (webId.equals(PropsValues.COMPANY_DEFAULT_WEB_ID)) {
                    webIdsList.add(0, webId);
                    continue;
                }
                webIdsList.add(webId);
            }
            _webIds = webIdsList.toArray(new String[0]);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        if (ArrayUtil.isEmpty(_webIds)) {
            _webIds = new String[]{PropsValues.COMPANY_DEFAULT_WEB_ID};
        }
        return _webIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long initCompany(ServletContext servletContext, String webId) {
        if (_log.isDebugEnabled()) {
            _log.debug("Begin initializing company with web id " + webId);
        }
        long companyId = 0L;
        try {
            Company company = CompanyLocalServiceUtil.checkCompany(webId);
            companyId = company.getCompanyId();
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        Long currentThreadCompanyId = CompanyThreadLocal.getCompanyId();
        String currentThreadPrincipalName = PrincipalThreadLocal.getName();
        try {
            User user;
            CompanyThreadLocal.setCompanyId(companyId);
            String principalName = null;
            long userId = PrincipalThreadLocal.getUserId();
            if (userId > 0L && (user = UserLocalServiceUtil.fetchUser(userId)) != null && user.getCompanyId() == companyId) {
                principalName = currentThreadPrincipalName;
            }
            PrincipalThreadLocal.setName(principalName);
            if (_log.isDebugEnabled()) {
                _log.debug("Initialize display");
            }
            try {
                String xml = HttpUtil.URLtoString(servletContext.getResource("/WEB-INF/liferay-display.xml"));
                PortletCategory portletCategory = (PortletCategory)WebAppPool.get(companyId, "PORTLET_CATEGORY");
                if (portletCategory == null) {
                    portletCategory = new PortletCategory();
                }
                PortletCategory newPortletCategory = PortletLocalServiceUtil.getEARDisplay(xml);
                portletCategory.merge(newPortletCategory);
                for (long currentCompanyId : _companyIds) {
                    PortletCategory currentPortletCategory = (PortletCategory)WebAppPool.get(currentCompanyId, "PORTLET_CATEGORY");
                    if (currentPortletCategory == null) continue;
                    portletCategory.merge(currentPortletCategory);
                }
                WebAppPool.put(companyId, "PORTLET_CATEGORY", portletCategory);
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Process application startup events");
            }
            try {
                EventsProcessorUtil.process("application.startup.events", PropsValues.APPLICATION_STARTUP_EVENTS, new String[]{String.valueOf(companyId)});
            }
            catch (Exception e) {
                _log.error(e, e);
            }
            if (_log.isDebugEnabled()) {
                _log.debug(StringBundler.concat("End initializing company with web id ", webId, " and company id ", companyId));
            }
            PortalInstances.addCompanyId(companyId);
        }
        finally {
            CompanyThreadLocal.setCompanyId(currentThreadCompanyId);
            PrincipalThreadLocal.setName(currentThreadPrincipalName);
        }
        return companyId;
    }

    public static boolean isAutoLoginIgnoreHost(String host) {
        return _autoLoginIgnoreHosts.contains(host);
    }

    public static boolean isAutoLoginIgnorePath(String path) {
        return _autoLoginIgnorePaths.contains(path);
    }

    public static boolean isCompanyActive(long companyId) {
        try {
            Company company = CompanyLocalServiceUtil.fetchCompanyById(companyId);
            if (company != null) {
                return company.isActive();
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return false;
    }

    public static boolean isVirtualHostsIgnoreHost(String host) {
        return _virtualHostsIgnoreHosts.contains(host);
    }

    public static boolean isVirtualHostsIgnorePath(String path) {
        return _virtualHostsIgnorePaths.contains(path);
    }

    public static void reload(ServletContext servletContext) {
        String[] webIds;
        _companyIds = new long[0];
        _webIds = null;
        for (String webId : webIds = PortalInstances.getWebIds()) {
            PortalInstances.initCompany(servletContext, webId);
        }
    }

    public static void removeCompany(long companyId) {
        try {
            EventsProcessorUtil.process("application.shutdown.events", PropsValues.APPLICATION_SHUTDOWN_EVENTS, new String[]{String.valueOf(companyId)});
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        _companyIds = ArrayUtil.remove(_companyIds, companyId);
        _webIds = null;
        PortalInstances.getWebIds();
        WebAppPool.remove(companyId, "PORTLET_CATEGORY");
    }

    private static long _getCompanyIdByVirtualHosts(HttpServletRequest httpServletRequest) {
        String host = PortalUtil.getHost(httpServletRequest);
        if (_log.isDebugEnabled()) {
            _log.debug("Host " + host);
        }
        if (Validator.isNull(host) || PortalInstances.isVirtualHostsIgnoreHost(host)) {
            return 0L;
        }
        try {
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost(host);
            if (virtualHost == null) {
                return 0L;
            }
            if (virtualHost.getLayoutSetId() != 0L) {
                LayoutSet layoutSet = LayoutSetLocalServiceUtil.getLayoutSet(virtualHost.getLayoutSetId());
                if (_log.isDebugEnabled()) {
                    _log.debug(StringBundler.concat("Company ", virtualHost.getCompanyId(), " is associated with layout set ", virtualHost.getLayoutSetId()));
                }
                httpServletRequest.setAttribute("VIRTUAL_HOST_LAYOUT_SET", (Object)layoutSet);
            }
            return virtualHost.getCompanyId();
        }
        catch (Exception e) {
            _log.error(e, e);
            return 0L;
        }
    }

    private PortalInstances() {
    }

    static {
        _companyIds = new long[0];
        _autoLoginIgnoreHosts = SetUtil.fromArray(PropsUtil.getArray("auto.login.ignore.hosts"));
        _autoLoginIgnorePaths = SetUtil.fromArray(PropsUtil.getArray("auto.login.ignore.paths"));
        _virtualHostsIgnoreHosts = SetUtil.fromArray(PropsUtil.getArray("virtual.hosts.ignore.hosts"));
        _virtualHostsIgnorePaths = SetUtil.fromArray(PropsUtil.getArray("virtual.hosts.ignore.paths"));
    }
}

