/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.document.library.kernel.exception.ImageSizeException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.expando.kernel.exception.ValueDataException;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.exportimport.kernel.staging.StagingUtil;
import com.liferay.petra.encryptor.Encryptor;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.events.StartupHelperUtil;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.cache.thread.local.Lifecycle;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCache;
import com.liferay.portal.kernel.cache.thread.local.ThreadLocalCacheManager;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeThreadLocal;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.exception.ImageTypeException;
import com.liferay.portal.kernel.exception.NoSuchGroupException;
import com.liferay.portal.kernel.exception.NoSuchImageException;
import com.liferay.portal.kernel.exception.NoSuchLayoutException;
import com.liferay.portal.kernel.exception.NoSuchUserException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.RSSFeedException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.image.ImageBag;
import com.liferay.portal.kernel.image.ImageToolUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ColorScheme;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupConstants;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutFriendlyURL;
import com.liferay.portal.kernel.model.LayoutFriendlyURLComposite;
import com.liferay.portal.kernel.model.LayoutQueryStringComposite;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutType;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Organization;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.model.PublicRenderParameter;
import com.liferay.portal.kernel.model.ResourcePermission;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.RoleConstants;
import com.liferay.portal.kernel.model.Team;
import com.liferay.portal.kernel.model.Theme;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroup;
import com.liferay.portal.kernel.model.VirtualHost;
import com.liferay.portal.kernel.model.impl.VirtualLayout;
import com.liferay.portal.kernel.portlet.FriendlyURLMapper;
import com.liferay.portal.kernel.portlet.FriendlyURLMapperThreadLocal;
import com.liferay.portal.kernel.portlet.FriendlyURLResolver;
import com.liferay.portal.kernel.portlet.FriendlyURLResolverRegistryUtil;
import com.liferay.portal.kernel.portlet.InvokerPortlet;
import com.liferay.portal.kernel.portlet.LayoutFriendlyURLSeparatorComposite;
import com.liferay.portal.kernel.portlet.LiferayPortletConfig;
import com.liferay.portal.kernel.portlet.LiferayPortletMode;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayRenderRequest;
import com.liferay.portal.kernel.portlet.LiferayRenderResponse;
import com.liferay.portal.kernel.portlet.LiferayStateAwareResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletBag;
import com.liferay.portal.kernel.portlet.PortletBagPool;
import com.liferay.portal.kernel.portlet.PortletConfigFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletIdCodec;
import com.liferay.portal.kernel.portlet.PortletInstanceFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletQNameUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactory;
import com.liferay.portal.kernel.portlet.RequestBackedPortletURLFactoryUtil;
import com.liferay.portal.kernel.security.auth.AlwaysAllowDoAsUser;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGeneratorFactory;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.service.ClassNameLocalServiceUtil;
import com.liferay.portal.kernel.service.CompanyLocalServiceUtil;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.ImageLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutFriendlyURLLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.service.LayoutSetLocalServiceUtil;
import com.liferay.portal.kernel.service.OrganizationLocalServiceUtil;
import com.liferay.portal.kernel.service.PortletLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourceLocalServiceUtil;
import com.liferay.portal.kernel.service.ResourcePermissionLocalServiceUtil;
import com.liferay.portal.kernel.service.TicketLocalServiceUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.service.UserServiceUtil;
import com.liferay.portal.kernel.service.VirtualHostLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.service.permission.UserPermissionUtil;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.DynamicServletRequest;
import com.liferay.portal.kernel.servlet.HttpSessionWrapper;
import com.liferay.portal.kernel.servlet.NonSerializableObjectRequestWrapper;
import com.liferay.portal.kernel.servlet.PersistentHttpServletRequestWrapper;
import com.liferay.portal.kernel.servlet.PortalMessages;
import com.liferay.portal.kernel.servlet.PortalSessionContext;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.servlet.PortalWebResourcesUtil;
import com.liferay.portal.kernel.servlet.ServletContextUtil;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.servlet.filters.compoundsessionid.CompoundSessionIdSplitterUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.BreadcrumbEntry;
import com.liferay.portal.kernel.struts.StrutsAction;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.upload.UploadServletRequest;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.ClassUtil;
import com.liferay.portal.kernel.util.CookieKeys;
import com.liferay.portal.kernel.util.DeterminateKeyGenerator;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InetAddressUtil;
import com.liferay.portal.kernel.util.InheritableMap;
import com.liferay.portal.kernel.util.ListMergeable;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalInetSocketAddressEventListener;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.SessionClicks;
import com.liferay.portal.kernel.util.StringComparator;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.QName;
import com.liferay.portal.language.LanguageResources;
import com.liferay.portal.model.impl.CookieRemotePreference;
import com.liferay.portal.model.impl.LayoutTypeImpl;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.security.jaas.JAASHelper;
import com.liferay.portal.security.sso.SSOUtil;
import com.liferay.portal.servlet.filters.i18n.I18nFilter;
import com.liferay.portal.spring.context.PortalContextLoaderListener;
import com.liferay.portal.upload.UploadPortletRequestImpl;
import com.liferay.portal.upload.UploadServletRequestImpl;
import com.liferay.portal.util.LayoutClone;
import com.liferay.portal.util.LayoutCloneFactory;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import com.liferay.portal.util.PortalInstances;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.WebServerServlet;
import com.liferay.portlet.LiferayPortletUtil;
import com.liferay.portlet.PortletPreferencesImpl;
import com.liferay.portlet.PortletPreferencesWrapper;
import com.liferay.portlet.admin.util.OmniadminUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTracker;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.sites.kernel.util.SitesUtil;
import com.liferay.util.JS;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.PreferencesValidator;
import javax.portlet.RenderRequest;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.StateAwareResponse;
import javax.portlet.ValidatorException;
import javax.portlet.WindowState;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class PortalImpl
implements Portal {
    private static final Log _logWebServerServlet = LogFactoryUtil.getLog(WebServerServlet.class);
    private static final String _J_SECURITY_CHECK = "j_security_check";
    private static final String _LOCALHOST = "localhost";
    private static final Locale _NULL_LOCALE;
    private static final String _PRIVATE_GROUP_SERVLET_MAPPING;
    private static final String _PRIVATE_USER_SERVLET_MAPPING;
    private static final String _PUBLIC_GROUP_SERVLET_MAPPING;
    private static final Log _log;
    private static final Pattern _bannedResourceIdPattern;
    private static final Map<Long, String> _cdnHostHttpMap;
    private static final Map<Long, String> _cdnHostHttpsMap;
    private static final MethodHandler _resetCDNHostsMethodHandler;
    private static final Date _upTime;
    private final String[] _allSystemGroups;
    private final String[] _allSystemOrganizationRoles;
    private final String[] _allSystemRoles;
    private final String[] _allSystemSiteRoles;
    private final List<AlwaysAllowDoAsUser> _alwaysAllowDoAsUsers = new ArrayList<AlwaysAllowDoAsUser>();
    private final Set<String> _computerAddresses = new HashSet<String>();
    private final String _computerName;
    private String[] _customSqlKeys;
    private String[] _customSqlValues;
    private volatile StrutsAction _editDiscussionStrutsAction;
    private volatile StrutsAction _getCommentsStrutsAction;
    private final String _pathContext;
    private final String _pathFriendlyURLPrivateGroup;
    private final String _pathFriendlyURLPrivateUser;
    private final String _pathFriendlyURLPublic;
    private final String _pathImage;
    private final String _pathMain;
    private final String _pathModule;
    private final String _pathProxy;
    private final Map<String, Long> _plidToPortletIdMap = new ConcurrentHashMap<String, Long>();
    private final Set<PortalInetSocketAddressEventListener> _portalInetSocketAddressEventListeners = new CopyOnWriteArraySet<PortalInetSocketAddressEventListener>();
    private final AtomicReference<InetSocketAddress> _portalLocalInetSocketAddress = new AtomicReference();
    @Deprecated
    private final AtomicInteger _portalPort = new AtomicInteger(-1);
    private final AtomicReference<InetSocketAddress> _portalServerInetSocketAddress = new AtomicReference();
    private final Set<String> _reservedParams;
    private final AtomicReference<InetSocketAddress> _securePortalLocalInetSocketAddress = new AtomicReference();
    @Deprecated
    private final AtomicInteger _securePortalPort = new AtomicInteger(-1);
    private final AtomicReference<InetSocketAddress> _securePortalServerInetSocketAddress = new AtomicReference();
    private final String _servletContextName;
    private final String[] _sortedSystemGroups;
    private final String[] _sortedSystemOrganizationRoles;
    private final String[] _sortedSystemRoles;
    private final String[] _sortedSystemSiteRoles;
    private final boolean _validPortalDomainCheckDisabled;

    public PortalImpl() {
        String computerName = System.getProperty("env.COMPUTERNAME");
        if (Validator.isNull(computerName)) {
            computerName = System.getProperty("env.HOST");
        }
        if (Validator.isNull(computerName)) {
            computerName = System.getProperty("env.HOSTNAME");
        }
        if (Validator.isNull(computerName)) {
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                computerName = inetAddress.getHostName();
            }
            catch (UnknownHostException inetAddress) {
                // empty catch block
            }
        }
        this._computerName = computerName;
        try {
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : networkInterfaces) {
                ArrayList<InetAddress> inetAddresses = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress inetAddress : inetAddresses) {
                    if (!(inetAddress instanceof Inet4Address)) continue;
                    this._computerAddresses.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            _log.error("Unable to determine server's IP addresses");
            _log.error(e, e);
        }
        this._pathProxy = PropsValues.PORTAL_PROXY_PATH;
        this._pathContext = this._pathProxy.concat(this.getContextPath(PortalContextLoaderListener.getPortalServletContextPath()));
        this._pathFriendlyURLPrivateGroup = this._pathContext + _PRIVATE_GROUP_SERVLET_MAPPING;
        this._pathFriendlyURLPrivateUser = this._pathContext + _PRIVATE_USER_SERVLET_MAPPING;
        this._pathFriendlyURLPublic = this._pathContext + _PUBLIC_GROUP_SERVLET_MAPPING;
        this._pathImage = this._pathContext + "/image";
        this._pathMain = this._pathContext + "/c";
        this._pathModule = this._pathContext + "/o";
        Object[] customSystemGroups = PropsUtil.getArray("system.groups");
        this._allSystemGroups = ArrayUtil.isEmpty(customSystemGroups) ? GroupConstants.SYSTEM_GROUPS : (String[])ArrayUtil.append(GroupConstants.SYSTEM_GROUPS, customSystemGroups);
        this._sortedSystemGroups = new String[this._allSystemGroups.length];
        System.arraycopy(this._allSystemGroups, 0, this._sortedSystemGroups, 0, this._allSystemGroups.length);
        Arrays.sort(this._sortedSystemGroups, new StringComparator());
        Object[] customSystemRoles = PropsUtil.getArray("system.roles");
        this._allSystemRoles = ArrayUtil.isEmpty(customSystemRoles) ? RoleConstants.SYSTEM_ROLES : (String[])ArrayUtil.append(RoleConstants.SYSTEM_ROLES, customSystemRoles);
        this._sortedSystemRoles = new String[this._allSystemRoles.length];
        System.arraycopy(this._allSystemRoles, 0, this._sortedSystemRoles, 0, this._allSystemRoles.length);
        Arrays.sort(this._sortedSystemRoles, new StringComparator());
        Object[] customSystemOrganizationRoles = PropsUtil.getArray("system.organization.roles");
        this._allSystemOrganizationRoles = ArrayUtil.isEmpty(customSystemOrganizationRoles) ? RoleConstants.SYSTEM_ORGANIZATION_ROLES : (String[])ArrayUtil.append(RoleConstants.SYSTEM_ORGANIZATION_ROLES, customSystemOrganizationRoles);
        this._sortedSystemOrganizationRoles = new String[this._allSystemOrganizationRoles.length];
        System.arraycopy(this._allSystemOrganizationRoles, 0, this._sortedSystemOrganizationRoles, 0, this._allSystemOrganizationRoles.length);
        Arrays.sort(this._sortedSystemOrganizationRoles, new StringComparator());
        Object[] customSystemSiteRoles = PropsUtil.getArray("system.site.roles");
        this._allSystemSiteRoles = ArrayUtil.isEmpty(customSystemSiteRoles) ? RoleConstants.SYSTEM_SITE_ROLES : (String[])ArrayUtil.append(RoleConstants.SYSTEM_SITE_ROLES, customSystemSiteRoles);
        this._sortedSystemSiteRoles = new String[this._allSystemSiteRoles.length];
        System.arraycopy(this._allSystemSiteRoles, 0, this._sortedSystemSiteRoles, 0, this._allSystemSiteRoles.length);
        Arrays.sort(this._sortedSystemSiteRoles, new StringComparator());
        this._reservedParams = new HashSet<String>();
        this._reservedParams.add("p_auth");
        this._reservedParams.add("p_auth_secret");
        this._reservedParams.add("p_l_back_url");
        this._reservedParams.add("p_l_id");
        this._reservedParams.add("p_l_mode");
        this._reservedParams.add("p_l_reset");
        this._reservedParams.add("p_p_auth");
        this._reservedParams.add("p_p_id");
        this._reservedParams.add("p_p_i_id");
        this._reservedParams.add("p_p_lifecycle");
        this._reservedParams.add("p_p_url_type");
        this._reservedParams.add("p_p_state");
        this._reservedParams.add("p_p_state_rcv");
        this._reservedParams.add("p_p_mode");
        this._reservedParams.add("p_p_resource_id");
        this._reservedParams.add("p_p_cacheability");
        this._reservedParams.add("p_p_async");
        this._reservedParams.add("p_p_hub");
        this._reservedParams.add("p_p_width");
        this._reservedParams.add("p_p_col_id");
        this._reservedParams.add("p_p_col_pos");
        this._reservedParams.add("p_p_col_count");
        this._reservedParams.add("p_p_boundary");
        this._reservedParams.add("p_p_decorate");
        this._reservedParams.add("p_p_static");
        this._reservedParams.add("p_p_isolated");
        this._reservedParams.add("p_t_lifecycle");
        this._reservedParams.add("p_v_l_s_g_id");
        this._reservedParams.add("p_f_id");
        this._reservedParams.add("p_j_a_id");
        this._reservedParams.add("saveLastPath");
        this._reservedParams.add("scroll");
        this._reservedParams.add("switchGroup");
        this._servletContextName = PortalContextLoaderListener.getPortalServletContextName();
        this._validPortalDomainCheckDisabled = ArrayUtil.isEmpty(PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) || ArrayUtil.contains(PropsValues.VIRTUAL_HOSTS_VALID_HOSTS, "*");
        try {
            Registry registry = RegistryUtil.getRegistry();
            ServiceTracker<AlwaysAllowDoAsUser, AlwaysAllowDoAsUser> alwaysAllowDoAsUserServiceTracker = registry.trackServices(AlwaysAllowDoAsUser.class, new AlwaysAllowDoAsUserServiceTrackerCustomizer());
            alwaysAllowDoAsUserServiceTracker.open();
            ServiceTracker<PortalInetSocketAddressEventListener, PortalInetSocketAddressEventListener> portalInetSocketAddressEventListenerServiceTracker = registry.trackServices(PortalInetSocketAddressEventListener.class, new PortalInetSocketAddressEventListenerServiceTrackerCustomizer());
            portalInetSocketAddressEventListenerServiceTracker.open();
            ServiceTracker<StrutsAction, StrutsAction> commentsStrutsActionServiceTracker = registry.trackServices(StrutsAction.class, new CommentsStrutsActionServiceTrackerCustomizer());
            commentsStrutsActionServiceTracker.open();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void addPageDescription(String description, HttpServletRequest httpServletRequest) {
        ListMergeable<String> descriptionListMergeable = (ListMergeable<String>)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION");
        if (descriptionListMergeable == null) {
            descriptionListMergeable = new ListMergeable<String>();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", descriptionListMergeable);
        }
        descriptionListMergeable.add(description);
    }

    @Override
    public void addPageKeywords(String keywords, HttpServletRequest httpServletRequest) {
        String[] keywordsArray;
        ListMergeable<String> keywordsListMergeable = (ListMergeable<String>)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        if (keywordsListMergeable == null) {
            keywordsListMergeable = new ListMergeable<String>();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_KEYWORDS", keywordsListMergeable);
        }
        for (String keyword : keywordsArray = StringUtil.split(keywords)) {
            if (keywordsListMergeable.contains(StringUtil.toLowerCase(keyword))) continue;
            keywordsListMergeable.add(StringUtil.toLowerCase(keyword));
        }
    }

    @Override
    public void addPageSubtitle(String subtitle, HttpServletRequest httpServletRequest) {
        ListMergeable<String> subtitleListMergeable = (ListMergeable<String>)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_SUBTITLE");
        if (subtitleListMergeable == null) {
            subtitleListMergeable = new ListMergeable<String>();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", subtitleListMergeable);
        }
        subtitleListMergeable.add(subtitle);
    }

    @Override
    public void addPageTitle(String title, HttpServletRequest httpServletRequest) {
        ListMergeable<String> titleListMergeable = (ListMergeable<String>)httpServletRequest.getAttribute("LIFERAY_SHARED_PAGE_TITLE");
        if (titleListMergeable == null) {
            titleListMergeable = new ListMergeable<String>();
            httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_TITLE", titleListMergeable);
        }
        titleListMergeable.add(title);
    }

    @Override
    public boolean addPortalInetSocketAddressEventListener(PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        return this._portalInetSocketAddressEventListeners.add(portalInetSocketAddressEventListener);
    }

    @Override
    public void addPortletBreadcrumbEntry(HttpServletRequest httpServletRequest, String title, String url) {
        this.addPortletBreadcrumbEntry(httpServletRequest, title, url, null);
    }

    @Override
    public void addPortletBreadcrumbEntry(HttpServletRequest httpServletRequest, String title, String url, Map<String, Object> data) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        boolean portletBreadcrumbEntry = false;
        if (Validator.isNotNull(portletDisplay.getId()) && !portletDisplay.isFocused()) {
            portletBreadcrumbEntry = true;
        }
        this.addPortletBreadcrumbEntry(httpServletRequest, title, url, null, portletBreadcrumbEntry);
    }

    @Override
    public void addPortletBreadcrumbEntry(HttpServletRequest httpServletRequest, String title, String url, Map<String, Object> data, boolean portletBreadcrumbEntry) {
        ArrayList<BreadcrumbEntry> breadcrumbEntries;
        String name = "LIFERAY_SHARED_PORTLET_BREADCRUMBS";
        if (portletBreadcrumbEntry) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            name = name + "_" + portletDisplay.getId();
        }
        if ((breadcrumbEntries = (ArrayList<BreadcrumbEntry>)httpServletRequest.getAttribute(name)) == null) {
            breadcrumbEntries = new ArrayList<BreadcrumbEntry>();
            httpServletRequest.setAttribute(name, breadcrumbEntries);
        }
        BreadcrumbEntry breadcrumbEntry = new BreadcrumbEntry();
        breadcrumbEntry.setData(data);
        breadcrumbEntry.setTitle(title);
        breadcrumbEntry.setURL(url);
        breadcrumbEntries.add(breadcrumbEntry);
    }

    @Override
    public void addPortletDefaultResource(HttpServletRequest httpServletRequest, Portlet portlet) throws PortalException {
        String name = ResourceActionsUtil.getPortletBaseResource(portlet.getRootPortletId());
        if (Validator.isNull(name)) {
            return;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = themeDisplay.getLayout();
        long groupId = 0L;
        groupId = layout.isTypeControlPanel() ? themeDisplay.getScopeGroupId() : this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(themeDisplay.getCompanyId(), groupId, name);
    }

    @Override
    public void addPortletDefaultResource(long companyId, Layout layout, Portlet portlet) throws PortalException {
        String name = ResourceActionsUtil.getPortletBaseResource(portlet.getRootPortletId());
        if (Validator.isNull(name)) {
            return;
        }
        long groupId = this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(companyId, groupId, name);
    }

    @Override
    public String addPreservedParameters(ThemeDisplay themeDisplay, Layout layout, String url, boolean doAsUser) {
        return this.addPreservedParameters(themeDisplay, url, layout.isTypeControlPanel(), doAsUser);
    }

    @Override
    public String addPreservedParameters(ThemeDisplay themeDisplay, String url) {
        return this.addPreservedParameters(themeDisplay, themeDisplay.getLayout(), url, true);
    }

    @Override
    public String addPreservedParameters(ThemeDisplay themeDisplay, String url, boolean typeControlPanel, boolean doAsUser) {
        if (doAsUser) {
            if (Validator.isNotNull(themeDisplay.getDoAsUserId())) {
                url = HttpUtil.setParameter(url, "doAsUserId", themeDisplay.getDoAsUserId());
            }
            if (Validator.isNotNull(themeDisplay.getDoAsUserLanguageId())) {
                url = HttpUtil.setParameter(url, "doAsUserLanguageId", themeDisplay.getDoAsUserLanguageId());
            }
        }
        if (typeControlPanel) {
            if (Validator.isNotNull(themeDisplay.getPpid())) {
                url = HttpUtil.setParameter(url, "p_p_id", themeDisplay.getPpid());
            }
            if (themeDisplay.getDoAsGroupId() > 0L) {
                url = HttpUtil.setParameter(url, "doAsGroupId", themeDisplay.getDoAsGroupId());
            }
            if (themeDisplay.getRefererGroupId() != 0L) {
                url = HttpUtil.setParameter(url, "refererGroupId", themeDisplay.getRefererGroupId());
            }
            if (themeDisplay.getRefererPlid() != 0L) {
                url = HttpUtil.setParameter(url, "refererPlid", themeDisplay.getRefererPlid());
            }
        }
        return url;
    }

    @Override
    public void addUserLocaleOptionsMessage(HttpServletRequest httpServletRequest) {
        boolean ignoreUserLocaleOptions = GetterUtil.getBoolean(SessionClicks.get(httpServletRequest.getSession(), "ignoreUserLocaleOptions", Boolean.FALSE.toString()));
        if (ignoreUserLocaleOptions) {
            return;
        }
        boolean showUserLocaleOptionsMessage = ParamUtil.getBoolean(httpServletRequest, "showUserLocaleOptionsMessage", true);
        if (!showUserLocaleOptionsMessage) {
            return;
        }
        PortalMessages.add(httpServletRequest, "animation", (Object)false);
        PortalMessages.add(httpServletRequest, "jspPath", (Object)"/html/common/themes/user_locale_options.jsp");
        PortalMessages.add(httpServletRequest, "timeout", (Object)-1);
    }

    @Override
    public void clearRequestParameters(RenderRequest renderRequest) {
        LiferayRenderRequest liferayRenderRequest = (LiferayRenderRequest)renderRequest;
        if (liferayRenderRequest.isTriggeredByActionURL()) {
            liferayRenderRequest.clearRenderParameters();
        }
    }

    @Override
    public void copyRequestParameters(ActionRequest actionRequest, ActionResponse actionResponse) {
        LiferayStateAwareResponse liferayStateAwareResponse;
        if (actionResponse instanceof LiferayStateAwareResponse && (liferayStateAwareResponse = (LiferayStateAwareResponse)actionResponse).getRedirectLocation() != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Cannot copy parameters on a redirected LiferayStateAwareResponse");
            }
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this.getLiferayPortletResponse((PortletResponse)actionResponse);
        StateAwareResponse stateAwareResponse = (StateAwareResponse)liferayPortletResponse;
        Map renderParameters = stateAwareResponse.getRenderParameterMap();
        actionResponse.setRenderParameter("p_p_lifecycle", "1");
        Enumeration enu = actionRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (renderParameters.get(actionResponse.getNamespace() + param) != null) continue;
            String[] values = actionRequest.getParameterValues(param);
            values = values == null ? new String[]{} : ArrayUtil.filter(values, s -> s != null);
            actionResponse.setRenderParameter(param, values);
        }
    }

    @Override
    public String escapeRedirect(String url) {
        if (Validator.isNull(url)) {
            return url;
        }
        if ((url = url.trim()).charAt(0) == '/' && (url.length() == 1 || url.length() > 1 && url.charAt(1) != '/')) {
            return url;
        }
        String domain = HttpUtil.getDomain(url);
        if (domain.isEmpty()) {
            return null;
        }
        if (!this._validPortalDomainCheckDisabled && this.isValidPortalDomain(domain)) {
            return url;
        }
        String securityMode = PropsValues.REDIRECT_URL_SECURITY_MODE;
        if (securityMode.equals("domain")) {
            String[] allowedDomains = PropsValues.REDIRECT_URL_DOMAINS_ALLOWED;
            if (allowedDomains.length == 0) {
                return url;
            }
            for (String allowedDomain : allowedDomains) {
                if (allowedDomain.startsWith("*.") && (allowedDomain.regionMatches(1, domain, domain.length() - (allowedDomain.length() - 1), allowedDomain.length() - 1) || allowedDomain.regionMatches(2, domain, 0, domain.length()))) {
                    return url;
                }
                if (!allowedDomain.equals(domain)) continue;
                return url;
            }
            if (_log.isWarnEnabled()) {
                _log.warn("Redirect URL " + url + " is not allowed");
            }
            url = null;
        } else {
            block16: {
                String[] allowedIps;
                if (!securityMode.equals("ip") && _log.isWarnEnabled()) {
                    _log.warn(StringBundler.concat("Property \"", "redirect.url.security.mode", "\" has invalid value: ", securityMode));
                }
                if ((allowedIps = PropsValues.REDIRECT_URL_IPS_ALLOWED).length == 0) {
                    return url;
                }
                try {
                    InetAddress inetAddress = InetAddressUtil.getInetAddressByName(domain);
                    String hostAddress = inetAddress.getHostAddress();
                    boolean serverIpIsHostAddress = this._computerAddresses.contains(hostAddress);
                    for (String ip : allowedIps) {
                        if ((!serverIpIsHostAddress || !ip.equals("SERVER_IP")) && !ip.equals(hostAddress)) continue;
                        return url;
                    }
                    if (_log.isWarnEnabled()) {
                        _log.warn("Redirect URL " + url + " is not allowed");
                    }
                }
                catch (UnknownHostException uhe) {
                    if (!_log.isDebugEnabled()) break block16;
                    _log.debug("Unable to determine IP for redirect URL " + url);
                }
            }
            url = null;
        }
        return url;
    }

    @Override
    public String generateRandomKey(HttpServletRequest httpServletRequest, String input) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay.isAjax() || themeDisplay.isIsolated() || themeDisplay.isLifecycleResource() || themeDisplay.isStateExclusive()) {
            return StringUtil.randomId();
        }
        StringBundler sb = new StringBundler(5);
        sb.append(DeterminateKeyGenerator.generate(input));
        sb.append("_");
        Object columnId = httpServletRequest.getAttribute("RENDER_PORTLET_COLUMN_ID");
        if (columnId != null) {
            sb.append(JS.getSafeName(columnId.toString()));
        }
        sb.append("_");
        Object columnPos = httpServletRequest.getAttribute("RENDER_PORTLET_COLUMN_POS");
        if (columnPos != null) {
            sb.append(JS.getSafeName(columnPos.toString()));
        }
        return sb.toString();
    }

    @Override
    public String getAbsoluteURL(HttpServletRequest httpServletRequest, String url) {
        String portalURL = this.getPortalURL(httpServletRequest);
        if (url.charAt(0) == '/' && Validator.isNotNull(portalURL)) {
            url = portalURL.concat(url);
        }
        if (!CookieKeys.hasSessionId(httpServletRequest) && url.startsWith(portalURL)) {
            HttpSession session = httpServletRequest.getSession();
            url = this.getURLWithSessionId(url, session.getId());
        }
        return url;
    }

    @Override
    public LayoutQueryStringComposite getActualLayoutQueryStringComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        List<Layout> layouts;
        Layout layout = null;
        if (Validator.isNull(friendlyURL)) {
            layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, 0L, true, 0, 1);
            if (layouts.isEmpty()) {
                throw new NoSuchLayoutException(StringBundler.concat("{groupId=", groupId, ", privateLayout=", privateLayout, "}"));
            }
        } else {
            return this.getPortletFriendlyURLMapperLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        }
        layout = layouts.get(0);
        return new LayoutQueryStringComposite(layout, friendlyURL, "");
    }

    @Override
    public String getActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        String actualURL = null;
        if (friendlyURL != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
            long companyId = PortalInstances.getCompanyId(httpServletRequest);
            for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
                if (!friendlyURL.startsWith(urlSeparator)) continue;
                try {
                    FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver(urlSeparator);
                    actualURL = friendlyURLResolver.getActualURL(companyId, groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
                    break;
                }
                catch (Exception e) {
                    throw new NoSuchLayoutException(e);
                }
            }
        }
        if (actualURL == null) {
            actualURL = this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, params, requestContext);
        }
        return actualURL;
    }

    @Override
    public String getAlternateURL(String canonicalURL, ThemeDisplay themeDisplay, Locale locale, Layout layout) throws PortalException {
        Map<Locale, String> alternateURLs = this._getAlternateURLs(canonicalURL, themeDisplay, layout, Collections.singleton(locale));
        return alternateURLs.get(locale);
    }

    @Override
    public Map<Locale, String> getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        Set<Locale> availableLocales = LanguageUtil.getAvailableLocales(themeDisplay.getSiteGroupId());
        return this._getAlternateURLs(canonicalURL, themeDisplay, layout, availableLocales);
    }

    @Override
    public long[] getAncestorSiteGroupIds(long groupId) {
        int i = 0;
        Set<Group> groups = this.getAncestorSiteGroups(groupId, false);
        long[] groupIds = new long[groups.size()];
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    @Override
    public BaseModel<?> getBaseModel(ResourcePermission resourcePermission) throws PortalException {
        String modelName = resourcePermission.getName();
        String primKey = resourcePermission.getPrimKey();
        return this.getBaseModel(modelName, primKey);
    }

    @Override
    public BaseModel<?> getBaseModel(String modelName, String primKey) throws PortalException {
        if (!modelName.contains(".model.")) {
            return null;
        }
        Object[] parts = StringUtil.split(modelName, '.');
        if (parts.length <= 2 || !parts[parts.length - 2].equals("model")) {
            return null;
        }
        parts[parts.length - 2] = "service";
        String serviceName = StringUtil.merge(parts, ".") + "LocalServiceUtil";
        String methodName = "get" + (String)parts[parts.length - 1];
        Method method = null;
        try {
            Class<?> serviceUtil = Class.forName(serviceName);
            if (Validator.isNumber(primKey)) {
                method = serviceUtil.getMethod(methodName, Long.TYPE);
                return (BaseModel)method.invoke(null, Long.valueOf(primKey));
            }
            method = serviceUtil.getMethod(methodName, String.class);
            return (BaseModel)method.invoke(null, primKey);
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof PortalException) {
                throw (PortalException)cause;
            }
            if (cause instanceof SystemException) {
                throw (SystemException)cause;
            }
            throw new SystemException(cause);
        }
    }

    @Override
    public List<Group> getBrowsableScopeGroups(long userId, long companyId, long groupId, String portletId) throws PortalException {
        ArrayList<Group> groups = new ArrayList<Group>();
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("usersGroups", userId);
        groups.addAll(0, GroupLocalServiceUtil.search(companyId, null, null, params, -1, -1));
        List<Organization> organizations = OrganizationLocalServiceUtil.getUserOrganizations(userId);
        for (Organization organization : organizations) {
            groups.add(0, organization.getGroup());
        }
        if (PropsValues.LAYOUT_USER_PRIVATE_LAYOUTS_ENABLED || PropsValues.LAYOUT_USER_PUBLIC_LAYOUTS_ENABLED) {
            groups.add(0, GroupLocalServiceUtil.getUserGroup(companyId, userId));
        }
        groups.addAll(0, this.getCurrentAndAncestorSiteGroups(groupId));
        ArrayList<Group> filteredGroups = new ArrayList<Group>();
        for (Group group : ListUtil.unique(groups)) {
            if (group.hasStagingGroup()) {
                Group stagingGroup = group.getStagingGroup();
                if (stagingGroup.getGroupId() != groupId || !group.isStagedPortlet(portletId) || group.isStagedRemotely() || !group.isStagedPortlet("com_liferay_document_library_web_portlet_DLPortlet")) continue;
                filteredGroups.add(stagingGroup);
                continue;
            }
            filteredGroups.add(group);
        }
        return filteredGroups;
    }

    @Override
    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout) throws PortalException {
        return this.getCanonicalURL(completeURL, themeDisplay, layout, false, true);
    }

    @Override
    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout, boolean forceLayoutFriendlyURL) throws PortalException {
        return this.getCanonicalURL(completeURL, themeDisplay, layout, forceLayoutFriendlyURL, true);
    }

    @Override
    public String getCanonicalURL(String completeURL, ThemeDisplay themeDisplay, Layout layout, boolean forceLayoutFriendlyURL, boolean includeQueryString) throws PortalException {
        String groupFriendlyURL = "";
        String parametersURL = "";
        if (Validator.isNotNull(completeURL)) {
            int pos = (completeURL = this.removeRedirectParameter(completeURL)).indexOf("/-/");
            if (pos == -1) {
                pos = completeURL.indexOf(63);
            }
            groupFriendlyURL = completeURL;
            if (pos != -1) {
                groupFriendlyURL = completeURL.substring(0, pos);
                parametersURL = completeURL.substring(pos);
            }
        }
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        String canonicalLayoutFriendlyURL = "";
        String defaultLayoutFriendlyURL = null;
        Locale siteDefaultLocale = this.getSiteDefaultLocale(layout.getGroupId());
        defaultLayoutFriendlyURL = siteDefaultLocale.equals(themeDisplay.getLocale()) ? themeDisplay.getLayoutFriendlyURL(layout) : layout.getFriendlyURL(this.getSiteDefaultLocale(layout.getGroupId()));
        if ((!layout.isFirstParent() || Validator.isNotNull(parametersURL)) && (groupFriendlyURL.contains(themeDisplay.getLayoutFriendlyURL(layout)) || groupFriendlyURL.contains("/" + layout.getLayoutId()))) {
            canonicalLayoutFriendlyURL = defaultLayoutFriendlyURL;
        } else if (forceLayoutFriendlyURL) {
            canonicalLayoutFriendlyURL = defaultLayoutFriendlyURL;
        }
        groupFriendlyURL = this.getGroupFriendlyURL(layout.getLayoutSet(), themeDisplay, true, layout.isTypeControlPanel());
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            String groupFriendlyURLDomain = HttpUtil.getDomain(groupFriendlyURL);
            int pos = groupFriendlyURL.indexOf(groupFriendlyURLDomain);
            if (pos > 0) {
                pos = groupFriendlyURL.indexOf(47, pos + groupFriendlyURLDomain.length());
                if (Validator.isNotNull(this._pathContext)) {
                    pos = groupFriendlyURL.indexOf(47, pos + this._pathContext.length());
                }
            }
            StringBundler sb = new StringBundler(3);
            if (pos <= 0 || pos >= groupFriendlyURL.length()) {
                sb.append(groupFriendlyURL);
                sb.append(this._buildI18NPath(siteDefaultLocale, layout.getGroup()));
                if (!canonicalLayoutFriendlyURL.startsWith("/")) {
                    sb.append("/");
                }
            } else {
                String groupFriendlyURLPrefix = groupFriendlyURL.substring(0, pos);
                String groupFriendlyURLSuffix = groupFriendlyURL.substring(pos);
                sb.append(groupFriendlyURLPrefix);
                sb.append(this._buildI18NPath(siteDefaultLocale, layout.getGroup()));
                sb.append(groupFriendlyURLSuffix);
            }
            groupFriendlyURL = sb.toString();
        }
        groupFriendlyURL = groupFriendlyURL.concat(canonicalLayoutFriendlyURL);
        if (includeQueryString) {
            if (groupFriendlyURL.endsWith("/") && parametersURL.startsWith("/")) {
                parametersURL = parametersURL.substring(1);
            }
            groupFriendlyURL = groupFriendlyURL.concat(parametersURL);
        } else if (parametersURL.startsWith("/-/")) {
            int y;
            int x = 0;
            if (groupFriendlyURL.endsWith("/") && parametersURL.startsWith("/")) {
                x = 1;
            }
            if ((y = parametersURL.indexOf(63)) == -1) {
                y = parametersURL.length();
            }
            groupFriendlyURL = groupFriendlyURL.concat(parametersURL.substring(x, y));
        }
        return groupFriendlyURL;
    }

    @Override
    public String getCDNHost(boolean secure) {
        long companyId = CompanyThreadLocal.getCompanyId();
        if (secure) {
            return this.getCDNHostHttps(companyId);
        }
        return this.getCDNHostHttp(companyId);
    }

    @Override
    public String getCDNHost(HttpServletRequest httpServletRequest) throws PortalException {
        boolean cdnEnabled = ParamUtil.getBoolean(httpServletRequest, "cdn_enabled", true);
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        if (!cdnEnabled || portletId.equals("com_liferay_portal_settings_web_portlet_PortalSettingsPortlet")) {
            return "";
        }
        String cdnHost = null;
        Company company = this.getCompany(httpServletRequest);
        cdnHost = httpServletRequest.isSecure() ? this.getCDNHostHttps(company.getCompanyId()) : this.getCDNHostHttp(company.getCompanyId());
        if (Validator.isUrl(cdnHost)) {
            return cdnHost;
        }
        return "";
    }

    @Override
    public String getCDNHostHttp(long companyId) {
        String cdnHostHttp = _cdnHostHttpMap.get(companyId);
        if (cdnHostHttp != null) {
            return cdnHostHttp;
        }
        try {
            cdnHostHttp = PrefsPropsUtil.getString(companyId, "cdn.host.http", PropsValues.CDN_HOST_HTTP);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cdnHostHttp == null || cdnHostHttp.startsWith("${") || !Validator.isUrl(cdnHostHttp)) {
            cdnHostHttp = "";
        }
        _cdnHostHttpMap.put(companyId, cdnHostHttp);
        return cdnHostHttp;
    }

    @Override
    public String getCDNHostHttps(long companyId) {
        String cdnHostHttps;
        block4: {
            cdnHostHttps = _cdnHostHttpsMap.get(companyId);
            if (cdnHostHttps != null) {
                return cdnHostHttps;
            }
            try {
                cdnHostHttps = PrefsPropsUtil.getString(companyId, "cdn.host.https", PropsValues.CDN_HOST_HTTPS);
            }
            catch (SystemException se) {
                if (!_log.isDebugEnabled()) break block4;
                _log.debug(se, se);
            }
        }
        if (cdnHostHttps == null || cdnHostHttps.startsWith("${") || !Validator.isUrl(cdnHostHttps)) {
            cdnHostHttps = "";
        }
        _cdnHostHttpsMap.put(companyId, cdnHostHttps);
        return cdnHostHttps;
    }

    @Override
    public String getClassName(long classNameId) {
        try {
            ClassName className = ClassNameLocalServiceUtil.getClassName(classNameId);
            return className.getValue();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get class name from id " + classNameId, e);
        }
    }

    @Override
    public long getClassNameId(Class<?> clazz) {
        return this.getClassNameId(clazz.getName());
    }

    @Override
    public long getClassNameId(String value) {
        ResultSet rs;
        PreparedStatement ps;
        Connection con;
        block5: {
            long l;
            if (!StartupHelperUtil.isUpgrading()) {
                return ClassNameLocalServiceUtil.getClassNameId(value);
            }
            con = null;
            ps = null;
            rs = null;
            try {
                con = DataAccess.getConnection();
                ps = con.prepareStatement("select classNameId from ClassName_ where value = ?");
                ps.setString(1, value);
                rs = ps.executeQuery();
                if (!rs.next()) break block5;
                l = rs.getLong("classNameId");
            }
            catch (Exception e) {
                try {
                    throw new RuntimeException("Unable to get class name ID from value " + value, e);
                }
                catch (Throwable throwable) {
                    DataAccess.cleanUp(con, ps, rs);
                    throw throwable;
                }
            }
            DataAccess.cleanUp(con, ps, rs);
            return l;
        }
        DataAccess.cleanUp(con, ps, rs);
        return 0L;
    }

    @Override
    public Company getCompany(HttpServletRequest httpServletRequest) throws PortalException {
        long companyId = this.getCompanyId(httpServletRequest);
        if (companyId <= 0L) {
            return null;
        }
        Company company = (Company)httpServletRequest.getAttribute("COMPANY");
        if (company == null) {
            company = CompanyLocalServiceUtil.fetchCompanyById(companyId);
            if (company == null) {
                company = CompanyLocalServiceUtil.getCompanyById(PortalInstances.getDefaultCompanyId());
            }
            httpServletRequest.setAttribute("COMPANY", (Object)company);
        }
        return company;
    }

    @Override
    public Company getCompany(PortletRequest portletRequest) throws PortalException {
        return this.getCompany(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public long getCompanyId(HttpServletRequest httpServletRequest) {
        return PortalInstances.getCompanyId(httpServletRequest);
    }

    @Override
    public long getCompanyId(PortletRequest portletRequest) {
        return this.getCompanyId(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public long[] getCompanyIds() {
        return PortalInstances.getCompanyIds();
    }

    @Override
    public Set<String> getComputerAddresses() {
        return this._computerAddresses;
    }

    @Override
    public String getComputerName() {
        return this._computerName;
    }

    @Override
    public String getControlPanelFullURL(long scopeGroupId, String ppid, Map<String, String[]> params) throws PortalException {
        Group group = GroupLocalServiceUtil.getGroup(scopeGroupId);
        Group controlPanelDisplayGroup = this.getControlPanelDisplayGroup(group.getCompanyId(), scopeGroupId, 0L, ppid);
        Company company = CompanyLocalServiceUtil.getCompany(controlPanelDisplayGroup.getCompanyId());
        return this._getSiteAdminURL(this.getPortalURL(company.getVirtualHostname(), this.getPortalServerPort(false), false), controlPanelDisplayGroup, ppid, params);
    }

    @Override
    public long getControlPanelPlid(long companyId) throws PortalException {
        Group controlPanelGroup = GroupLocalServiceUtil.getGroup(companyId, "Control Panel");
        return LayoutLocalServiceUtil.getDefaultPlid(controlPanelGroup.getGroupId(), true);
    }

    @Override
    public long getControlPanelPlid(PortletRequest portletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this.getControlPanelPlid(themeDisplay.getCompanyId());
    }

    @Override
    public PortletURL getControlPanelPortletURL(HttpServletRequest httpServletRequest, Group group, String portletId, long refererGroupId, long refererPlid, String lifecycle) {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create(httpServletRequest);
        if (group == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = this.getControlPanelDisplayGroup(themeDisplay.getControlPanelGroup(), themeDisplay.getScopeGroup(), themeDisplay.getDoAsGroupId(), portletId);
        }
        return requestBackedPortletURLFactory.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, lifecycle);
    }

    @Override
    public PortletURL getControlPanelPortletURL(HttpServletRequest httpServletRequest, String portletId, String lifecycle) {
        return this.getControlPanelPortletURL(httpServletRequest, null, portletId, 0L, 0L, lifecycle);
    }

    @Override
    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, Group group, String portletId, long refererGroupId, long refererPlid, String lifecycle) {
        RequestBackedPortletURLFactory requestBackedPortletURLFactory = RequestBackedPortletURLFactoryUtil.create(portletRequest);
        if (group == null) {
            ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = this.getControlPanelDisplayGroup(themeDisplay.getControlPanelGroup(), themeDisplay.getScopeGroup(), themeDisplay.getDoAsGroupId(), portletId);
        }
        return requestBackedPortletURLFactory.createControlPanelPortletURL(portletId, group, refererGroupId, refererPlid, lifecycle);
    }

    @Override
    public PortletURL getControlPanelPortletURL(PortletRequest portletRequest, String portletId, String lifecycle) {
        return this.getControlPanelPortletURL(portletRequest, null, portletId, 0L, 0L, lifecycle);
    }

    @Override
    public String getCreateAccountURL(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay) throws Exception {
        if (Validator.isNull(PropsValues.COMPANY_SECURITY_STRANGERS_URL)) {
            long plid = themeDisplay.getPlid();
            Layout layout = themeDisplay.getLayout();
            if (layout.isPrivateLayout()) {
                plid = LayoutLocalServiceUtil.getDefaultPlid(layout.getGroupId(), false);
            }
            LiferayPortletURL createAccountURL = PortletURLFactoryUtil.create(httpServletRequest, "com_liferay_login_web_portlet_LoginPortlet", plid, "RENDER_PHASE");
            createAccountURL.setParameter("saveLastPath", Boolean.FALSE.toString());
            createAccountURL.setParameter("mvcRenderCommandName", "/login/create_account");
            createAccountURL.setPortletMode(PortletMode.VIEW);
            createAccountURL.setWindowState(WindowState.MAXIMIZED);
            if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS) {
                return createAccountURL.toString();
            }
            String portalURL = this.getPortalURL(httpServletRequest);
            String portalURLSecure = this.getPortalURL(httpServletRequest, true);
            return StringUtil.replaceFirst(createAccountURL.toString(), portalURL, portalURLSecure);
        }
        try {
            Layout layout = LayoutLocalServiceUtil.getFriendlyURLLayout(themeDisplay.getScopeGroupId(), false, PropsValues.COMPANY_SECURITY_STRANGERS_URL);
            return this.getLayoutURL(layout, themeDisplay);
        }
        catch (NoSuchLayoutException nsle) {
            if (_log.isDebugEnabled()) {
                _log.debug(nsle, nsle);
            }
            return "";
        }
    }

    @Override
    public long[] getCurrentAndAncestorSiteGroupIds(long groupId) throws PortalException {
        return this.getCurrentAndAncestorSiteGroupIds(groupId, false);
    }

    @Override
    public long[] getCurrentAndAncestorSiteGroupIds(long groupId, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        List<Group> groups = this.getCurrentAndAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled);
        long[] groupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            groupIds[i] = group.getGroupId();
        }
        return groupIds;
    }

    @Override
    public long[] getCurrentAndAncestorSiteGroupIds(long[] groupIds) throws PortalException {
        return this.getCurrentAndAncestorSiteGroupIds(groupIds, false);
    }

    @Override
    public long[] getCurrentAndAncestorSiteGroupIds(long[] groupIds, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        List<Group> groups = this.getCurrentAndAncestorSiteGroups(groupIds, checkContentSharingWithChildrenEnabled);
        long[] currentAndAncestorSiteGroupIds = new long[groups.size()];
        for (int i = 0; i < groups.size(); ++i) {
            Group group = groups.get(i);
            currentAndAncestorSiteGroupIds[i] = group.getGroupId();
        }
        return currentAndAncestorSiteGroupIds;
    }

    @Override
    public List<Group> getCurrentAndAncestorSiteGroups(long groupId) throws PortalException {
        return this.getCurrentAndAncestorSiteGroups(groupId, false);
    }

    @Override
    public List<Group> getCurrentAndAncestorSiteGroups(long groupId, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Group siteGroup = this.getCurrentSiteGroup(groupId);
        if (siteGroup != null) {
            groups.add(siteGroup);
        }
        groups.addAll(this.getAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled));
        return new ArrayList<Group>(groups);
    }

    @Override
    public List<Group> getCurrentAndAncestorSiteGroups(long[] groupIds) throws PortalException {
        return this.getCurrentAndAncestorSiteGroups(groupIds, false);
    }

    @Override
    public List<Group> getCurrentAndAncestorSiteGroups(long[] groupIds, boolean checkContentSharingWithChildrenEnabled) throws PortalException {
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        for (long groupId : groupIds) {
            groups.addAll(this.getCurrentAndAncestorSiteGroups(groupId, checkContentSharingWithChildrenEnabled));
        }
        return new ArrayList<Group>(groups);
    }

    @Override
    public String getCurrentCompleteURL(HttpServletRequest httpServletRequest) {
        String currentCompleteURL = (String)httpServletRequest.getAttribute("CURRENT_COMPLETE_URL");
        if (currentCompleteURL == null) {
            currentCompleteURL = HttpUtil.getCompleteURL(httpServletRequest);
            httpServletRequest.setAttribute("CURRENT_COMPLETE_URL", (Object)currentCompleteURL);
        }
        return currentCompleteURL;
    }

    @Override
    public String getCurrentURL(HttpServletRequest httpServletRequest) {
        String currentURL = (String)httpServletRequest.getAttribute("CURRENT_URL");
        if (currentURL != null) {
            return currentURL;
        }
        currentURL = ParamUtil.getString(httpServletRequest, "currentURL");
        if (Validator.isNull(currentURL) && Validator.isNotNull(currentURL = HttpUtil.getCompleteURL(httpServletRequest)) && !currentURL.contains(_J_SECURITY_CHECK)) {
            currentURL = currentURL.substring(currentURL.indexOf("://") + "://".length());
            currentURL = currentURL.substring(currentURL.indexOf(47));
        }
        if (Validator.isNull(currentURL)) {
            currentURL = this.getPathMain();
        }
        httpServletRequest.setAttribute("CURRENT_URL", (Object)currentURL);
        return currentURL;
    }

    @Override
    public String getCurrentURL(PortletRequest portletRequest) {
        return (String)portletRequest.getAttribute("CURRENT_URL");
    }

    @Override
    public String getCustomSQLFunctionIsNotNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNOTNULL;
    }

    @Override
    public String getCustomSQLFunctionIsNull() {
        return PropsValues.CUSTOM_SQL_FUNCTION_ISNULL;
    }

    @Override
    public Date getDate(int month, int day, int year) {
        try {
            return this.getDate(month, day, year, null);
        }
        catch (PortalException pe) {
            throw new RuntimeException(pe);
        }
    }

    @Override
    public Date getDate(int month, int day, int year, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, null, clazz);
    }

    @Override
    public Date getDate(int month, int day, int year, int hour, int min, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, hour, min, null, clazz);
    }

    @Override
    public Date getDate(int month, int day, int year, int hour, int min, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        if (!Validator.isGregorianDate(month, day, year)) {
            if (clazz != null) {
                try {
                    throw clazz.newInstance();
                }
                catch (PortalException pe) {
                    throw pe;
                }
                catch (Exception e) {
                    throw new PortalException(e);
                }
            }
            return null;
        }
        Calendar cal = null;
        cal = timeZone == null ? CalendarFactoryUtil.getCalendar() : CalendarFactoryUtil.getCalendar(timeZone);
        if (hour == -1 || min == -1) {
            cal.set(year, month, day, 0, 0, 0);
        } else {
            cal.set(year, month, day, hour, min, 0);
        }
        cal.set(14, 0);
        Date date = cal.getTime();
        return date;
    }

    @Override
    public Date getDate(int month, int day, int year, TimeZone timeZone, Class<? extends PortalException> clazz) throws PortalException {
        return this.getDate(month, day, year, -1, -1, timeZone, clazz);
    }

    @Override
    public long getDefaultCompanyId() {
        return PortalInstances.getDefaultCompanyId();
    }

    @Override
    public String getEmailFromAddress(PortletPreferences preferences, long companyId, String defaultValue) {
        if (Validator.isNull(defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.address");
        }
        return preferences.getValue("emailFromAddress", defaultValue);
    }

    @Override
    public String getEmailFromName(PortletPreferences preferences, long companyId, String defaultValue) {
        if (Validator.isNull(defaultValue)) {
            defaultValue = PrefsPropsUtil.getString(companyId, "admin.email.from.name");
        }
        return preferences.getValue("emailFromName", defaultValue);
    }

    @Override
    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, HttpServletRequest httpServletRequest) throws PortalException {
        HashMap<String, Serializable> attributes = new HashMap<String, Serializable>();
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enu = httpServletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            if (!param.contains("ExpandoAttributeName--")) continue;
            String name = ParamUtil.getString(httpServletRequest, param);
            names.add(name);
        }
        for (String name : names) {
            int type = expandoBridge.getAttributeType(name);
            UnicodeProperties properties = expandoBridge.getAttributeProperties(name);
            String displayType = GetterUtil.getString(properties.getProperty("display-type"), "text-box");
            Serializable value = this.getExpandoValue(httpServletRequest, "ExpandoAttribute--" + name + "--", type, displayType);
            attributes.put(name, value);
        }
        return attributes;
    }

    @Override
    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, PortletRequest portletRequest) throws PortalException {
        return this.getExpandoBridgeAttributes(expandoBridge, this.getHttpServletRequest(portletRequest));
    }

    @Override
    public Map<String, Serializable> getExpandoBridgeAttributes(ExpandoBridge expandoBridge, UploadPortletRequest uploadPortletRequest) throws PortalException {
        return this.getExpandoBridgeAttributes(expandoBridge, (HttpServletRequest)uploadPortletRequest);
    }

    @Override
    public Serializable getExpandoValue(HttpServletRequest httpServletRequest, String name, int type, String displayType) throws PortalException {
        Object value = null;
        if (type == 1) {
            value = ParamUtil.getBoolean(httpServletRequest, name);
        } else if (type != 2) {
            if (type == 3) {
                int valueDateMonth = ParamUtil.getInteger(httpServletRequest, name + "Month");
                int valueDateDay = ParamUtil.getInteger(httpServletRequest, name + "Day");
                int valueDateYear = ParamUtil.getInteger(httpServletRequest, name + "Year");
                int valueDateHour = ParamUtil.getInteger(httpServletRequest, name + "Hour");
                int valueDateMinute = ParamUtil.getInteger(httpServletRequest, name + "Minute");
                int valueDateAmPm = ParamUtil.getInteger(httpServletRequest, name + "AmPm");
                if (valueDateAmPm == 1) {
                    valueDateHour += 12;
                }
                TimeZone timeZone = null;
                User user = this.getUser(httpServletRequest);
                if (user != null) {
                    timeZone = user.getTimeZone();
                }
                value = this.getDate(valueDateMonth, valueDateDay, valueDateYear, valueDateHour, valueDateMinute, timeZone, ValueDataException.class);
            } else if (type != 4) {
                if (type == 5) {
                    value = ParamUtil.getDouble(httpServletRequest, name);
                } else if (type == 6) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getDoubleValues((String[])values);
                } else if (type == 7) {
                    value = Float.valueOf(ParamUtil.getFloat(httpServletRequest, name));
                } else if (type == 8) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getFloatValues((String[])values);
                } else if (type == 9) {
                    value = ParamUtil.getInteger(httpServletRequest, name);
                } else if (type == 10) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getIntegerValues((String[])values);
                } else if (type == 11) {
                    value = ParamUtil.getLong(httpServletRequest, name);
                } else if (type == 12) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getLongValues((String[])values);
                } else if (type == 17) {
                    value = ParamUtil.getNumber(httpServletRequest, name);
                } else if (type == 18) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getNumberValues((String[])values);
                } else if (type == 13) {
                    value = ParamUtil.getShort(httpServletRequest, name);
                } else if (type == 14) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = GetterUtil.getShortValues((String[])values);
                } else if (type == 16) {
                    Object[] values = httpServletRequest.getParameterValues(name);
                    if (displayType.equals("text-box") && !ArrayUtil.isEmpty(values)) {
                        values = StringUtil.splitLines((String)values[0]);
                    }
                    value = values;
                } else {
                    value = type == 20 ? (Serializable)((Object)LocalizationUtil.getLocalizationMap(httpServletRequest, name)) : ParamUtil.getString(httpServletRequest, name);
                }
            }
        }
        return value;
    }

    @Override
    public Serializable getExpandoValue(PortletRequest portletRequest, String name, int type, String displayType) throws PortalException {
        return this.getExpandoValue(this.getHttpServletRequest(portletRequest), name, type, displayType);
    }

    @Override
    public Serializable getExpandoValue(UploadPortletRequest uploadPortletRequest, String name, int type, String displayType) throws PortalException {
        return this.getExpandoValue((HttpServletRequest)uploadPortletRequest, name, type, displayType);
    }

    @Override
    @Deprecated
    public String getFacebookURL(Portlet portlet, String facebookCanvasPageURL, ThemeDisplay themeDisplay) throws PortalException {
        String facebookURL = this.getServletURL(portlet, "/facebook/" + facebookCanvasPageURL, themeDisplay);
        if (!facebookURL.endsWith("/")) {
            facebookURL = facebookURL + "/";
        }
        return facebookURL;
    }

    @Override
    public String getFirstPageLayoutTypes(HttpServletRequest httpServletRequest) {
        StringBundler sb = new StringBundler();
        for (String type : LayoutTypeControllerTracker.getTypes()) {
            LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(type);
            if (!layoutTypeController.isFirstPageable()) continue;
            sb.append(LanguageUtil.get(httpServletRequest, "layout.types." + type));
            sb.append(",");
            sb.append(" ");
        }
        if (sb.index() >= 2) {
            sb.setIndex(sb.index() - 2);
        }
        return sb.toString();
    }

    @Override
    public String getForwardedHost(HttpServletRequest httpServletRequest) {
        String serverName = httpServletRequest.getServerName();
        if (!PropsValues.WEB_SERVER_FORWARDED_HOST_ENABLED) {
            return serverName;
        }
        String forwardedHost = httpServletRequest.getHeader(PropsValues.WEB_SERVER_FORWARDED_HOST_HEADER);
        if (Validator.isBlank(forwardedHost) || forwardedHost.equals(serverName)) {
            return serverName;
        }
        if (this._validPortalDomainCheckDisabled) {
            if (!Validator.isHostName(forwardedHost)) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Invalid forwarded host: " + forwardedHost);
                }
                return serverName;
            }
        } else if (!this.isValidPortalDomain(forwardedHost)) {
            if (_log.isWarnEnabled()) {
                _log.warn("Invalid forwarded host: " + forwardedHost);
            }
            return serverName;
        }
        return forwardedHost;
    }

    @Override
    public int getForwardedPort(HttpServletRequest httpServletRequest) {
        if (!PropsValues.WEB_SERVER_FORWARDED_PORT_ENABLED) {
            return httpServletRequest.getServerPort();
        }
        return GetterUtil.getInteger(httpServletRequest.getHeader(PropsValues.WEB_SERVER_FORWARDED_PORT_HEADER), httpServletRequest.getServerPort());
    }

    @Override
    public String getFullName(String firstName, String middleName, String lastName) {
        FullNameGenerator fullNameGenerator = FullNameGeneratorFactory.getInstance();
        return fullNameGenerator.getFullName(firstName, middleName, lastName);
    }

    @Override
    public String getGlobalLibDir() {
        return PropsValues.LIFERAY_LIB_GLOBAL_DIR;
    }

    @Override
    public String getGoogleGadgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.GOOGLE_GADGET_SERVLET_MAPPING, themeDisplay);
    }

    @Override
    public String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getGroupFriendlyURL(layoutSet, themeDisplay, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getGroupFriendlyURL(layoutSet, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    @Override
    public int[] getGroupFriendlyURLIndex(String requestURI) {
        if (requestURI.startsWith(_PRIVATE_GROUP_SERVLET_MAPPING + "/") || requestURI.startsWith(_PRIVATE_USER_SERVLET_MAPPING + "/") || requestURI.startsWith(_PUBLIC_GROUP_SERVLET_MAPPING + "/")) {
            int x = requestURI.indexOf("/", 1);
            int y = requestURI.indexOf(47, x + 1);
            if (y == -1) {
                requestURI = requestURI + "/";
                y = requestURI.indexOf(47, x + 1);
            }
            return new int[]{x, y};
        }
        return null;
    }

    @Override
    @Deprecated
    public String[] getGroupPermissions(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameterValues("groupPermissions");
    }

    @Override
    @Deprecated
    public String[] getGroupPermissions(HttpServletRequest httpServletRequest, String className) {
        String[] groupPermissions = httpServletRequest.getParameterValues("groupPermissions_" + className);
        String inputPermissionsShowOptions = httpServletRequest.getParameter("inputPermissionsShowOptions");
        return this.getGroupPermissions(groupPermissions, className, inputPermissionsShowOptions);
    }

    @Override
    @Deprecated
    public String[] getGroupPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("groupPermissions");
    }

    @Override
    @Deprecated
    public String[] getGroupPermissions(PortletRequest portletRequest, String className) {
        String[] groupPermissions = portletRequest.getParameterValues("groupPermissions_" + className);
        String inputPermissionsShowOptions = portletRequest.getParameter("inputPermissionsShowOptions");
        return this.getGroupPermissions(groupPermissions, className, inputPermissionsShowOptions);
    }

    @Override
    @Deprecated
    public String[] getGuestPermissions(HttpServletRequest httpServletRequest) {
        return httpServletRequest.getParameterValues("guestPermissions");
    }

    @Override
    @Deprecated
    public String[] getGuestPermissions(HttpServletRequest httpServletRequest, String className) {
        String[] guestPermissions = httpServletRequest.getParameterValues("guestPermissions_" + className);
        String inputPermissionsShowOptions = httpServletRequest.getParameter("inputPermissionsShowOptions");
        return this.getGuestPermissions(guestPermissions, className, inputPermissionsShowOptions);
    }

    @Override
    @Deprecated
    public String[] getGuestPermissions(PortletRequest portletRequest) {
        return portletRequest.getParameterValues("guestPermissions");
    }

    @Override
    @Deprecated
    public String[] getGuestPermissions(PortletRequest portletRequest, String className) {
        String[] guestPermissions = portletRequest.getParameterValues("guestPermissions_" + className);
        String inputPermissionsShowOptions = portletRequest.getParameter("inputPermissionsShowOptions");
        return this.getGuestPermissions(guestPermissions, className, inputPermissionsShowOptions);
    }

    @Override
    public String getHomeURL(HttpServletRequest httpServletRequest) throws PortalException {
        String portalURL = this.getPortalURL(httpServletRequest);
        return portalURL + this._pathContext + this.getRelativeHomeURL(httpServletRequest);
    }

    @Override
    public String getHost(HttpServletRequest httpServletRequest) {
        int pos;
        String host = (httpServletRequest = this.getOriginalServletRequest(httpServletRequest)).getHeader("Host");
        if (host != null && (pos = (host = StringUtil.toLowerCase(host.trim())).indexOf(58)) >= 0) {
            host = host.substring(0, pos);
        }
        return host;
    }

    @Override
    public String getHost(PortletRequest portletRequest) {
        return this.getHost(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public HttpServletRequest getHttpServletRequest(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)portletRequest.getAttribute("com.liferay.portal.kernel.servlet.PortletServletRequest");
        if (httpServletRequest != null) {
            return httpServletRequest;
        }
        if (portletRequest instanceof LiferayPortletRequest) {
            LiferayPortletRequest liferayPortletRequest = (LiferayPortletRequest)portletRequest;
            return liferayPortletRequest.getHttpServletRequest();
        }
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        return liferayPortletRequest.getHttpServletRequest();
    }

    @Override
    public HttpServletResponse getHttpServletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof LiferayPortletResponse) {
            LiferayPortletResponse liferayPortletResponse = (LiferayPortletResponse)portletResponse;
            return liferayPortletResponse.getHttpServletResponse();
        }
        LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
        return liferayPortletResponse.getHttpServletResponse();
    }

    @Override
    public String getI18nPathLanguageId(Locale locale, String defaultI18nPathLanguageId) {
        String i18nPathLanguageId = StringUtil.replaceFirst(defaultI18nPathLanguageId, '_', '-');
        if (!LanguageUtil.isDuplicateLanguageCode(locale.getLanguage())) {
            i18nPathLanguageId = locale.getLanguage();
        } else {
            Locale priorityLocale = LanguageUtil.getLocale(locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                i18nPathLanguageId = locale.getLanguage();
            }
        }
        return i18nPathLanguageId;
    }

    @Override
    public String getJsSafePortletId(String portletId) {
        return JS.getSafeName(portletId);
    }

    @Override
    public String getLayoutActualURL(Layout layout) {
        return this.getLayoutActualURL(layout, this.getPathMain());
    }

    @Override
    public String getLayoutActualURL(Layout layout, String mainPath) {
        HashMap<String, String> variables = new HashMap<String, String>();
        Layout browsableLayout = this.getBrowsableLayout(layout);
        String groupIdString = String.valueOf(browsableLayout.getGroupId());
        variables.put("liferay:groupId", groupIdString);
        variables.put("liferay:layoutId", String.valueOf(browsableLayout.getLayoutId()));
        variables.put("liferay:mainPath", mainPath);
        variables.put("liferay:plid", String.valueOf(browsableLayout.getPlid()));
        variables.put("liferay:privateLayout", String.valueOf(browsableLayout.isPrivateLayout()));
        String pvlsgid = "0";
        if (browsableLayout instanceof VirtualLayout) {
            pvlsgid = groupIdString;
        }
        variables.put("liferay:pvlsgid", pvlsgid);
        variables.putAll(layout.getTypeSettingsProperties());
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        return LayoutTypeImpl.getURL(layoutTypeController.getURL(), variables);
    }

    @Override
    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL) throws PortalException {
        return this.getLayoutActualURL(groupId, privateLayout, mainPath, friendlyURL, null, null);
    }

    @Override
    public String getLayoutActualURL(long groupId, boolean privateLayout, String mainPath, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        UnicodeProperties typeSettingsProperties;
        LayoutQueryStringComposite actualLayoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        Layout layout = actualLayoutQueryStringComposite.getLayout();
        String queryString = actualLayoutQueryStringComposite.getQueryString();
        String layoutActualURL = this.getLayoutActualURL(layout, mainPath);
        if (Validator.isNotNull(queryString)) {
            layoutActualURL = layoutActualURL.concat(queryString);
        } else if (params.isEmpty() && Validator.isNotNull(queryString = (typeSettingsProperties = layout.getTypeSettingsProperties()).getProperty("query-string")) && layoutActualURL.contains("?")) {
            layoutActualURL = layoutActualURL.concat("&").concat(queryString);
        }
        return layoutActualURL;
    }

    @Override
    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        if (themeDisplay.getLayout() == layout) {
            return this.getLayoutFriendlyURL(themeDisplay);
        }
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (!layoutTypeController.isURLFriendliable()) {
            return null;
        }
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        if (layoutSet == null || layoutSet.getGroupId() != layout.getGroupId() || layoutSet.isPrivateLayout() != layout.isPrivateLayout()) {
            layoutSet = LayoutSetLocalServiceUtil.fetchLayoutSet(layout.getGroupId(), layout.isPrivateLayout());
        }
        if (layoutSet == null) {
            return null;
        }
        String groupFriendlyURL = this.getGroupFriendlyURL(layoutSet, themeDisplay, false, layout.isTypeControlPanel());
        return groupFriendlyURL.concat(themeDisplay.getLayoutFriendlyURL(layout));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLayoutFriendlyURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutFriendlyURL(layout, themeDisplay);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    @Override
    public String getLayoutFriendlyURL(ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (!layoutTypeController.isURLFriendliable()) {
            return null;
        }
        Group group = themeDisplay.getSiteGroup();
        LayoutSet layoutSet = themeDisplay.getLayoutSet();
        if (group.getGroupId() != layoutSet.getGroupId()) {
            group = layoutSet.getGroup();
        }
        String groupFriendlyURL = this._getGroupFriendlyURL(group, themeDisplay.getLayoutSet(), themeDisplay, false, layout.isTypeControlPanel());
        return groupFriendlyURL.concat(themeDisplay.getLayoutFriendlyURL(layout));
    }

    @Override
    @Deprecated
    public LayoutFriendlyURLComposite getLayoutFriendlyURLComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = this.getLayoutFriendlyURLSeparatorComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        return layoutFriendlyURLSeparatorComposite;
    }

    @Override
    public LayoutFriendlyURLSeparatorComposite getLayoutFriendlyURLSeparatorComposite(long groupId, boolean privateLayout, String friendlyURL, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        LayoutFriendlyURLSeparatorComposite layoutFriendlyURLSeparatorComposite = null;
        if (friendlyURL != null) {
            HttpServletRequest httpServletRequest = (HttpServletRequest)requestContext.get("request");
            long companyId = PortalInstances.getCompanyId(httpServletRequest);
            for (String urlSeparator : FriendlyURLResolverRegistryUtil.getURLSeparators()) {
                if (!friendlyURL.startsWith(urlSeparator)) continue;
                try {
                    FriendlyURLResolver friendlyURLResolver = FriendlyURLResolverRegistryUtil.getFriendlyURLResolver(urlSeparator);
                    layoutFriendlyURLSeparatorComposite = friendlyURLResolver.getLayoutFriendlyURLSeparatorComposite(companyId, groupId, privateLayout, friendlyURL, params, requestContext);
                    break;
                }
                catch (Exception e) {
                    throw new NoSuchLayoutException(e);
                }
            }
        }
        if (layoutFriendlyURLSeparatorComposite != null) {
            return layoutFriendlyURLSeparatorComposite;
        }
        LayoutQueryStringComposite layoutQueryStringComposite = this.getActualLayoutQueryStringComposite(groupId, privateLayout, friendlyURL, params, requestContext);
        return new LayoutFriendlyURLSeparatorComposite(layoutQueryStringComposite.getLayout(), layoutQueryStringComposite.getFriendlyURL(), "/-/");
    }

    @Override
    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutFullURL(layout, themeDisplay, true);
    }

    @Override
    public String getLayoutFullURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        String layoutURL = this.getLayoutURL(layout, themeDisplay, doAsUser);
        if (!HttpUtil.hasProtocol(layoutURL)) {
            layoutURL = this.getPortalURL(layout, themeDisplay) + layoutURL;
        }
        return layoutURL;
    }

    @Override
    public String getLayoutFullURL(long groupId, String portletId) throws PortalException {
        return this.getLayoutFullURL(groupId, portletId, false);
    }

    @Override
    public String getLayoutFullURL(long groupId, String portletId, boolean secure) throws PortalException {
        long parentGroupId;
        long plid = this.getPlidFromPortletId(groupId, portletId);
        if (plid == 0L) {
            return null;
        }
        StringBundler sb = new StringBundler(4);
        Layout layout = LayoutLocalServiceUtil.getLayout(plid);
        Group group = GroupLocalServiceUtil.getGroup(groupId);
        if (group.isLayout() && (parentGroupId = group.getParentGroupId()) > 0L) {
            group = GroupLocalServiceUtil.getGroup(parentGroupId);
        }
        String virtualHostname = null;
        LayoutSet layoutSet = layout.getLayoutSet();
        if (Validator.isNotNull(layoutSet.getVirtualHostname())) {
            virtualHostname = layoutSet.getVirtualHostname();
        } else {
            Company company = CompanyLocalServiceUtil.getCompany(layout.getCompanyId());
            virtualHostname = company.getVirtualHostname();
        }
        String portalURL = this.getPortalURL(virtualHostname, this.getPortalServerPort(secure), secure);
        sb.append(portalURL);
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(this.getPathFriendlyURLPrivateUser());
            } else {
                sb.append(this.getPathFriendlyURLPrivateGroup());
            }
        } else {
            sb.append(this.getPathFriendlyURLPublic());
        }
        sb.append(group.getFriendlyURL());
        sb.append(layout.getFriendlyURL());
        return sb.toString();
    }

    @Override
    public String getLayoutFullURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutFullURL(themeDisplay.getLayout(), themeDisplay);
    }

    @Override
    public String getLayoutRelativeURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutRelativeURL(layout, themeDisplay, true);
    }

    @Override
    public String getLayoutRelativeURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        String layoutFullURL = this.getLayoutFullURL(layout, themeDisplay, doAsUser);
        return HttpUtil.removeDomain(layoutFullURL);
    }

    @Override
    public String getLayoutSetDisplayURL(LayoutSet layoutSet, boolean secureConnection) throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompany(layoutSet.getCompanyId());
        int portalPort = this.getPortalServerPort(secureConnection);
        String portalURL = this.getPortalURL(company.getVirtualHostname(), portalPort, secureConnection);
        String virtualHostname = this.getVirtualHostname(layoutSet);
        if (Validator.isNotNull(virtualHostname) && !StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST)) {
            int index = portalURL.indexOf("://");
            String portalDomain = portalURL.substring(index + 3);
            virtualHostname = this.getCanonicalDomain(virtualHostname, portalDomain);
            if ((virtualHostname = this.getPortalURL(virtualHostname, portalPort, secureConnection)).contains(portalDomain)) {
                return virtualHostname.concat(this.getPathContext());
            }
        }
        StringBundler sb = new StringBundler(4);
        sb.append(portalURL);
        sb.append(this.getPathContext());
        Group group = layoutSet.getGroup();
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        sb.append(friendlyURL);
        sb.append(group.getFriendlyURL());
        return sb.toString();
    }

    @Override
    public String getLayoutSetFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        String virtualHostname = this.getVirtualHostname(layoutSet);
        if (Validator.isNotNull(virtualHostname) && !StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST)) {
            String portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
            Layout curLayout = themeDisplay.getLayout();
            LayoutSet curLayoutSet = curLayout.getLayoutSet();
            long curLayoutSetId = curLayoutSet.getLayoutSetId();
            if (layoutSet.getLayoutSetId() != curLayoutSetId || portalURL.startsWith(themeDisplay.getURLPortal())) {
                String layoutSetFriendlyURL = portalURL + this._pathContext;
                if (themeDisplay.isI18n()) {
                    layoutSetFriendlyURL = layoutSetFriendlyURL + themeDisplay.getI18nPath();
                }
                return this.addPreservedParameters(themeDisplay, layoutSetFriendlyURL);
            }
        }
        Group group = GroupLocalServiceUtil.getGroup(layoutSet.getGroupId());
        String friendlyURL = null;
        friendlyURL = layoutSet.isPrivateLayout() ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        if (themeDisplay.isI18n()) {
            friendlyURL = themeDisplay.getI18nPath() + friendlyURL;
        }
        String layoutSetFriendlyURL = this._pathContext + friendlyURL + group.getFriendlyURL();
        return this.addPreservedParameters(themeDisplay, layoutSetFriendlyURL);
    }

    @Override
    public String getLayoutTarget(Layout layout) {
        UnicodeProperties typeSettingsProps = layout.getTypeSettingsProperties();
        String target = typeSettingsProps.getProperty("target");
        target = Validator.isNull(target) ? "" : "target=\"" + HtmlUtil.escapeAttribute(target) + "\"";
        return target;
    }

    @Override
    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutURL(layout, themeDisplay, true);
    }

    @Override
    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, boolean doAsUser) throws PortalException {
        if (layout == null) {
            return themeDisplay.getPathMain() + "/portal/layout";
        }
        if (layout.isTypeURL()) {
            String url = layout.getTypeSettingsProperty("url");
            if (Validator.isNotNull(url) && !url.startsWith("/") && !url.startsWith(this.getPortalURL(layout, themeDisplay))) {
                return url;
            }
            return this.addPreservedParameters(themeDisplay, layout, this.getLayoutActualURL(layout), doAsUser);
        }
        String layoutFriendlyURL = this.getLayoutFriendlyURL(layout, themeDisplay);
        if (Validator.isNotNull(layoutFriendlyURL)) {
            layoutFriendlyURL = this.addPreservedParameters(themeDisplay, layout, layoutFriendlyURL, doAsUser);
            return layoutFriendlyURL;
        }
        String layoutURL = this.getLayoutActualURL(layout);
        layoutURL = this.addPreservedParameters(themeDisplay, layout, layoutURL, doAsUser);
        return layoutURL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getLayoutURL(Layout layout, ThemeDisplay themeDisplay, Locale locale) throws PortalException {
        String i18nLanguageId = themeDisplay.getI18nLanguageId();
        String i18nPath = themeDisplay.getI18nPath();
        Locale originalLocale = themeDisplay.getLocale();
        try {
            this.setThemeDisplayI18n(themeDisplay, locale);
            String string = this.getLayoutURL(layout, themeDisplay, true);
            return string;
        }
        finally {
            this.resetThemeDisplayI18n(themeDisplay, i18nLanguageId, i18nPath, originalLocale);
        }
    }

    @Override
    public String getLayoutURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getLayoutURL(themeDisplay.getLayout(), themeDisplay);
    }

    @Override
    public LiferayPortletRequest getLiferayPortletRequest(PortletRequest portletRequest) {
        if (portletRequest instanceof LiferayPortletRequest) {
            return (LiferayPortletRequest)portletRequest;
        }
        return LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
    }

    @Override
    public LiferayPortletResponse getLiferayPortletResponse(PortletResponse portletResponse) {
        if (portletResponse instanceof LiferayPortletResponse) {
            return (LiferayPortletResponse)portletResponse;
        }
        return LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
    }

    @Override
    public Locale getLocale(HttpServletRequest httpServletRequest) {
        Locale locale = (Locale)httpServletRequest.getAttribute("LOCALE");
        if (locale == _NULL_LOCALE) {
            return null;
        }
        if (locale == null) {
            locale = this.getLocale(httpServletRequest, null, false);
            if (locale == null) {
                httpServletRequest.setAttribute("LOCALE", (Object)_NULL_LOCALE);
            } else {
                httpServletRequest.setAttribute("LOCALE", (Object)locale);
            }
        }
        return locale;
    }

    @Override
    public Locale getLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, boolean initialize) {
        Locale cookieLocale;
        Locale userLocale;
        String doAsUserLanguageId;
        String i18nLanguageId;
        User user = null;
        if (initialize) {
            try {
                user = this.initUser(httpServletRequest);
            }
            catch (NoSuchUserException nsue) {
                if (_log.isDebugEnabled()) {
                    _log.debug(nsue, nsue);
                }
                return null;
            }
            catch (Exception nsue) {
                // empty catch block
            }
        }
        Locale locale = null;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (themeDisplay != null) {
            locale = themeDisplay.getLocale();
            if (LanguageUtil.isAvailableLocale(themeDisplay.getSiteGroupId(), locale)) {
                return locale;
            }
        }
        long groupId = 0L;
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        if (layout != null && !layout.isTypeControlPanel()) {
            try {
                long scopeGroupId = this.getScopeGroupId(httpServletRequest);
                groupId = this.getSiteGroupId(scopeGroupId);
            }
            catch (Exception scopeGroupId) {
                // empty catch block
            }
        }
        if (Validator.isNotNull(i18nLanguageId = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_ID"))) {
            locale = LocaleUtil.fromLanguageId(i18nLanguageId, true, false);
            if (LanguageUtil.isAvailableLocale(groupId, locale)) {
                return locale;
            }
            if (groupId > 0L) {
                String i18nLanguageCode;
                boolean inheritLocales = true;
                try {
                    inheritLocales = LanguageUtil.isInheritLocales(groupId);
                }
                catch (PortalException pe) {
                    _log.error("Unable to check if group " + groupId + " inherits locales", pe);
                }
                if (!inheritLocales && LanguageUtil.isAvailableLocale(groupId, locale = LanguageUtil.getLocale(groupId, i18nLanguageCode = (String)httpServletRequest.getAttribute("I18N_LANGUAGE_CODE")))) {
                    return locale;
                }
            }
        }
        if (Validator.isNotNull(doAsUserLanguageId = ParamUtil.getString(httpServletRequest, "doAsUserLanguageId")) && LanguageUtil.isAvailableLocale(groupId, locale = LocaleUtil.fromLanguageId(doAsUserLanguageId))) {
            return locale;
        }
        HttpSession session = httpServletRequest.getSession(false);
        if (session != null && LanguageUtil.isAvailableLocale(groupId, locale = (Locale)session.getAttribute("LOCALE"))) {
            return locale;
        }
        if (user == null) {
            try {
                user = this.getUser(httpServletRequest);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (user != null && !user.isDefaultUser() && LanguageUtil.isAvailableLocale(groupId, userLocale = this.getAvailableLocale(groupId, user.getLocale()))) {
            if (initialize) {
                this.setLocale(httpServletRequest, httpServletResponse, userLocale);
            }
            return userLocale;
        }
        String languageId = CookieKeys.getCookie(httpServletRequest, "GUEST_LANGUAGE_ID", false);
        if (Validator.isNotNull(languageId) && LanguageUtil.isAvailableLocale(groupId, cookieLocale = this.getAvailableLocale(groupId, LocaleUtil.fromLanguageId(languageId)))) {
            if (initialize) {
                this.setLocale(httpServletRequest, httpServletResponse, cookieLocale);
            }
            return cookieLocale;
        }
        if (PropsValues.LOCALE_DEFAULT_REQUEST) {
            Enumeration locales = httpServletRequest.getLocales();
            while (locales.hasMoreElements()) {
                Locale requestLocale = this.getAvailableLocale(groupId, (Locale)locales.nextElement());
                if (!LanguageUtil.isAvailableLocale(groupId, requestLocale)) continue;
                if (initialize) {
                    this.setLocale(httpServletRequest, httpServletResponse, requestLocale);
                }
                return requestLocale;
            }
        }
        if (groupId > 0L) {
            try {
                Group group = GroupLocalServiceUtil.getGroup(groupId);
                UnicodeProperties typeSettingsProperties = group.getTypeSettingsProperties();
                String defaultLanguageId = typeSettingsProperties.getProperty("languageId");
                if (Validator.isNotNull(defaultLanguageId) && LanguageUtil.isAvailableLocale(groupId, locale = LocaleUtil.fromLanguageId(defaultLanguageId))) {
                    if (initialize) {
                        this.setLocale(httpServletRequest, httpServletResponse, locale);
                    }
                    return locale;
                }
            }
            catch (Exception group) {
                // empty catch block
            }
        }
        Company company = null;
        try {
            company = this.getCompany(httpServletRequest);
        }
        catch (Exception typeSettingsProperties) {
            // empty catch block
        }
        if (company == null) {
            return null;
        }
        User defaultUser = null;
        try {
            defaultUser = company.getDefaultUser();
        }
        catch (Exception defaultLanguageId) {
            // empty catch block
        }
        if (defaultUser == null) {
            return null;
        }
        Locale defaultUserLocale = this.getAvailableLocale(groupId, defaultUser.getLocale());
        if (LanguageUtil.isAvailableLocale(groupId, defaultUserLocale)) {
            if (initialize) {
                this.setLocale(httpServletRequest, httpServletResponse, defaultUserLocale);
            }
            return defaultUserLocale;
        }
        try {
            if (themeDisplay != null) {
                return themeDisplay.getSiteDefaultLocale();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            return this.getSiteDefaultLocale(groupId);
        }
        catch (Exception e) {
            return LocaleUtil.getDefault();
        }
    }

    @Override
    public Locale getLocale(PortletRequest portletRequest) {
        return this.getLocale(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public String getLocalizedFriendlyURL(HttpServletRequest httpServletRequest, Layout layout, Locale locale, Locale originalLocale) {
        String contextPath;
        String requestURI = httpServletRequest.getRequestURI();
        HttpServletRequest originalHttpServletRequest = this.getOriginalServletRequest(httpServletRequest);
        if (originalHttpServletRequest.getPathInfo() == null) {
            requestURI = originalHttpServletRequest.getRequestURI();
        }
        if (Validator.isNotNull(contextPath = this.getPathContext()) && requestURI.contains(contextPath)) {
            requestURI = requestURI.substring(contextPath.length());
        }
        requestURI = StringUtil.replace(requestURI, "//", "/");
        String layoutFriendlyURL = null;
        if (originalLocale == null) {
            int y;
            String path = httpServletRequest.getPathInfo();
            int x = path.indexOf(47, 1);
            if (x != -1 && x + 1 != path.length()) {
                layoutFriendlyURL = path.substring(x);
            }
            if ((y = layoutFriendlyURL.indexOf("/~")) != -1 && (y = layoutFriendlyURL.indexOf(47, 3)) != -1 && y + 1 != layoutFriendlyURL.length()) {
                layoutFriendlyURL = layoutFriendlyURL.substring(y);
            }
            if ((y = layoutFriendlyURL.indexOf("/-/")) != -1) {
                layoutFriendlyURL = layoutFriendlyURL.substring(0, y);
            }
        } else {
            layoutFriendlyURL = layout.getFriendlyURL(originalLocale);
        }
        if (requestURI.contains(layoutFriendlyURL)) {
            requestURI = StringUtil.replaceFirst(requestURI, layoutFriendlyURL, layout.getFriendlyURL(locale));
        }
        boolean appendI18nPath = true;
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 0 || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && locale.equals(LocaleUtil.getDefault())) {
            appendI18nPath = false;
        }
        String localizedFriendlyURL = contextPath;
        if (appendI18nPath) {
            String i18nPath = "/" + this.getI18nPathLanguageId(locale, LocaleUtil.toLanguageId(locale));
            localizedFriendlyURL = localizedFriendlyURL + i18nPath;
        }
        localizedFriendlyURL = localizedFriendlyURL + requestURI;
        String queryString = httpServletRequest.getQueryString();
        if (Validator.isNull(queryString)) {
            queryString = (String)httpServletRequest.getAttribute("javax.servlet.forward.query_string");
        }
        if (Validator.isNotNull(queryString)) {
            localizedFriendlyURL = localizedFriendlyURL + "?" + queryString;
        }
        return localizedFriendlyURL;
    }

    @Override
    public String getMailId(String mx, String popPortletPrefix, Object ... ids) {
        StringBundler sb = new StringBundler(ids.length * 2 + 7);
        sb.append("<");
        sb.append(popPortletPrefix);
        if (!popPortletPrefix.endsWith(".")) {
            sb.append(".");
        }
        for (int i = 0; i < ids.length; ++i) {
            Object id = ids[i];
            if (i != 0) {
                sb.append(".");
            }
            sb.append(id);
        }
        sb.append("@");
        if (Validator.isNotNull(PropsValues.POP_SERVER_SUBDOMAIN)) {
            sb.append(PropsValues.POP_SERVER_SUBDOMAIN);
            sb.append(".");
        }
        sb.append(mx);
        sb.append(">");
        return sb.toString();
    }

    @Override
    public String getNetvibesURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.NETVIBES_SERVLET_MAPPING, themeDisplay);
    }

    @Override
    public String getNewPortletTitle(String portletTitle, String oldScopeName, String newScopeName) {
        if (portletTitle.endsWith(" (" + oldScopeName + ")")) {
            int pos = portletTitle.lastIndexOf(" (" + oldScopeName + ")");
            portletTitle = portletTitle.substring(0, pos);
        }
        if (Validator.isNull(newScopeName)) {
            return portletTitle;
        }
        return StringUtil.appendParentheticalSuffix(portletTitle, newScopeName);
    }

    @Override
    public HttpServletRequest getOriginalServletRequest(HttpServletRequest httpServletRequest) {
        HttpServletRequest currentHttpServletRequest = httpServletRequest;
        PersistentHttpServletRequestWrapper currentRequestWrapper = null;
        PersistentHttpServletRequestWrapper originalHttpServletRequest = null;
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper) {
            if (currentHttpServletRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentHttpServletRequest;
                persistentHttpServletRequestWrapper = persistentHttpServletRequestWrapper.clone();
                if (originalHttpServletRequest == null) {
                    originalHttpServletRequest = persistentHttpServletRequestWrapper;
                }
                if (currentRequestWrapper != null) {
                    currentRequestWrapper.setRequest((ServletRequest)persistentHttpServletRequestWrapper);
                }
                currentRequestWrapper = persistentHttpServletRequestWrapper;
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (currentRequestWrapper != null) {
            currentRequestWrapper.setRequest((ServletRequest)currentHttpServletRequest);
        }
        if (originalHttpServletRequest != null) {
            return originalHttpServletRequest;
        }
        return currentHttpServletRequest;
    }

    @Override
    public String getPathContext() {
        return this._pathContext;
    }

    @Override
    public String getPathContext(HttpServletRequest httpServletRequest) {
        return this.getPathContext(httpServletRequest.getContextPath());
    }

    @Override
    public String getPathContext(PortletRequest portletRequest) {
        return this.getPathContext(portletRequest.getContextPath());
    }

    @Override
    public String getPathContext(String contextPath) {
        return this._pathProxy.concat(this.getContextPath(contextPath));
    }

    @Override
    public String getPathFriendlyURLPrivateGroup() {
        return this._pathFriendlyURLPrivateGroup;
    }

    @Override
    public String getPathFriendlyURLPrivateUser() {
        return this._pathFriendlyURLPrivateUser;
    }

    @Override
    public String getPathFriendlyURLPublic() {
        return this._pathFriendlyURLPublic;
    }

    @Override
    public String getPathImage() {
        return this._pathImage;
    }

    @Override
    public String getPathMain() {
        return this._pathMain;
    }

    @Override
    public String getPathModule() {
        return this._pathModule;
    }

    @Override
    public String getPathProxy() {
        return this._pathProxy;
    }

    @Override
    public long getPlidFromFriendlyURL(long companyId, String friendlyURL) {
        if (Validator.isNull(friendlyURL) || friendlyURL.equals("/")) {
            return 0L;
        }
        String[] urlParts = friendlyURL.split("\\/", 4);
        if (friendlyURL.charAt(0) != '/' && urlParts.length != 4) {
            return 0L;
        }
        boolean privateLayout = true;
        String urlPrefix = "/" + urlParts[1];
        if (_PUBLIC_GROUP_SERVLET_MAPPING.equals(urlPrefix)) {
            privateLayout = false;
        } else if (_PRIVATE_GROUP_SERVLET_MAPPING.equals(urlPrefix) || _PRIVATE_USER_SERVLET_MAPPING.equals(urlPrefix)) {
            privateLayout = true;
        } else {
            return 0L;
        }
        Group group = null;
        try {
            group = GroupLocalServiceUtil.getFriendlyURLGroup(companyId, "/" + urlParts[2]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (group == null) {
            return 0L;
        }
        Layout layout = null;
        try {
            if (urlParts.length == 4) {
                String layoutFriendlyURL = "/" + urlParts[3];
                layout = LayoutLocalServiceUtil.getFriendlyURLLayout(group.getGroupId(), privateLayout, layoutFriendlyURL);
            } else {
                List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(group.getGroupId(), privateLayout, 0L, true, 0, 1);
                if (!layouts.isEmpty()) {
                    layout = layouts.get(0);
                } else {
                    return 0L;
                }
            }
            return layout.getPlid();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    @Override
    public long getPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long plid = 0L;
        StringBundler sb = new StringBundler(5);
        sb.append(groupId);
        sb.append(" ");
        sb.append(privateLayout);
        sb.append(" ");
        sb.append(portletId);
        String key = sb.toString();
        Long plidObj = this._plidToPortletIdMap.get(key);
        if (plidObj == null) {
            plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
            if (plid != 0L) {
                this._plidToPortletIdMap.put(key, plid);
            }
        } else {
            plid = plidObj;
            boolean validPlid = false;
            try {
                Layout layout = LayoutLocalServiceUtil.getLayout(plid);
                LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
                if (layoutTypePortlet.hasDefaultScopePortletId(groupId, portletId)) {
                    validPlid = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!validPlid) {
                this._plidToPortletIdMap.remove(key);
                plid = this.doGetPlidFromPortletId(groupId, privateLayout, portletId);
                if (plid != 0L) {
                    this._plidToPortletIdMap.put(key, plid);
                }
            }
        }
        return plid;
    }

    @Override
    public long getPlidFromPortletId(long groupId, String portletId) {
        long plid = this.getPlidFromPortletId(groupId, false, portletId);
        if (plid == 0L) {
            plid = this.getPlidFromPortletId(groupId, true, portletId);
        }
        if (plid == 0L && _log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Portlet ", portletId, " does not exist on a page in group ", groupId));
        }
        return plid;
    }

    @Override
    public PortalInetSocketAddressEventListener[] getPortalInetSocketAddressEventListeners() {
        return this._portalInetSocketAddressEventListeners.toArray(new PortalInetSocketAddressEventListener[0]);
    }

    @Override
    public String getPortalLibDir() {
        return PropsValues.LIFERAY_LIB_PORTAL_DIR;
    }

    @Override
    public InetAddress getPortalLocalInetAddress(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalLocalInetSocketAddress.get() : this._portalLocalInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    @Override
    public int getPortalLocalPort(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalLocalInetSocketAddress.get() : this._portalLocalInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return -1;
        }
        return inetSocketAddress.getPort();
    }

    @Override
    public Properties getPortalProperties() {
        return PropsUtil.getProperties();
    }

    @Override
    public InetAddress getPortalServerInetAddress(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalServerInetSocketAddress.get() : this._portalServerInetSocketAddress.get();
        if (inetSocketAddress == null) {
            return null;
        }
        return inetSocketAddress.getAddress();
    }

    @Override
    public int getPortalServerPort(boolean secure) {
        InetSocketAddress inetSocketAddress = null;
        inetSocketAddress = secure ? this._securePortalServerInetSocketAddress.get() : this._portalServerInetSocketAddress.get();
        if (inetSocketAddress == null) {
            if (secure) {
                return PropsValues.WEB_SERVER_HTTPS_PORT;
            }
            return PropsValues.WEB_SERVER_HTTP_PORT;
        }
        return inetSocketAddress.getPort();
    }

    @Override
    public String getPortalURL(HttpServletRequest httpServletRequest) {
        return this.getPortalURL(httpServletRequest, this.isSecure(httpServletRequest));
    }

    @Override
    public String getPortalURL(HttpServletRequest httpServletRequest, boolean secure) {
        int serverPort = this.getForwardedPort(httpServletRequest);
        if (Validator.isNull(PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(this.getForwardedHost(httpServletRequest), serverPort, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, serverPort, secure);
    }

    @Override
    public String getPortalURL(Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        String serverName = themeDisplay.getServerName();
        if (layout == null) {
            layout = themeDisplay.getLayout();
        }
        if (layout != null) {
            Layout virtualHostLayout = layout;
            long refererPlid = themeDisplay.getRefererPlid();
            if (refererPlid > 0L) {
                virtualHostLayout = LayoutLocalServiceUtil.getLayout(refererPlid);
            }
            return this.getPortalURL(virtualHostLayout.getLayoutSet(), themeDisplay);
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    @Override
    public String getPortalURL(LayoutSet layoutSet, ThemeDisplay themeDisplay) {
        String domain;
        String serverName = themeDisplay.getServerName();
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNotNull(virtualHostname) && (domain = themeDisplay.getPortalDomain()).startsWith(virtualHostname)) {
            serverName = virtualHostname;
        }
        return this.getPortalURL(serverName, themeDisplay.getServerPort(), themeDisplay.isSecure());
    }

    @Override
    public String getPortalURL(PortletRequest portletRequest) {
        return this.getPortalURL(portletRequest, portletRequest.isSecure());
    }

    @Override
    public String getPortalURL(PortletRequest portletRequest, boolean secure) {
        int port = portletRequest.getServerPort();
        if (Validator.isNull(PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(portletRequest.getServerName(), port, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, port, secure);
    }

    @Override
    public String getPortalURL(String serverName, int serverPort, boolean secure) {
        if (Validator.isNull(PropsValues.WEB_SERVER_HOST)) {
            return this._getPortalURL(serverName, serverPort, secure);
        }
        return this._getPortalURL(PropsValues.WEB_SERVER_HOST, serverPort, secure);
    }

    @Override
    public String getPortalURL(ThemeDisplay themeDisplay) throws PortalException {
        return this.getPortalURL((Layout)null, themeDisplay);
    }

    @Override
    public String getPortalWebDir() {
        return PropsValues.LIFERAY_WEB_PORTAL_DIR;
    }

    @Override
    public PortletConfig getPortletConfig(long companyId, String portletId, ServletContext servletContext) throws PortletException {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(companyId, portletId);
        InvokerPortlet invokerPortlet = PortletInstanceFactoryUtil.create(portlet, servletContext);
        return invokerPortlet.getPortletConfig();
    }

    @Override
    public String getPortletDescription(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create(portlet, servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletDescription = LanguageUtil.get(resourceBundle, "javax.portlet.description".concat(".").concat(portlet.getRootPortletId()), null);
        if (Validator.isNull(portletDescription)) {
            portletDescription = LanguageUtil.get(resourceBundle, "javax.portlet.description");
        }
        return portletDescription;
    }

    @Override
    public String getPortletDescription(Portlet portlet, User user) {
        return this.getPortletDescription(portlet.getPortletId(), user);
    }

    @Override
    public String getPortletDescription(String portletId, Locale locale) {
        return LanguageUtil.get(locale, "javax.portlet.description".concat(".").concat(portletId));
    }

    @Override
    public String getPortletDescription(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId(languageId);
        return this.getPortletDescription(portletId, locale);
    }

    @Override
    public String getPortletDescription(String portletId, User user) {
        return LanguageUtil.get(user.getLocale(), "javax.portlet.description".concat(".").concat(portletId));
    }

    public LayoutQueryStringComposite getPortletFriendlyURLMapperLayoutQueryStringComposite(long groupId, boolean privateLayout, String url, Map<String, String[]> params, Map<String, Object> requestContext) throws PortalException {
        int x;
        boolean foundFriendlyURLMapper = false;
        String friendlyURL = url;
        String queryString = "";
        List<Portlet> portlets = PortletLocalServiceUtil.getFriendlyURLMapperPortlets();
        for (Portlet portlet : portlets) {
            FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
            if (url.endsWith("/" + friendlyURLMapper.getMapping())) {
                url = url + "/";
            }
            int pos = -1;
            pos = friendlyURLMapper.isCheckMappingWithPrefix() ? url.indexOf("/-/" + friendlyURLMapper.getMapping() + "/") : url.indexOf("/" + friendlyURLMapper.getMapping() + "/");
            if (pos == -1) continue;
            foundFriendlyURLMapper = true;
            friendlyURL = url.substring(0, pos);
            InheritableMap<String, String[]> actualParams = new InheritableMap<String, String[]>();
            if (params != null) {
                actualParams.setParentMap(params);
            }
            HashMap<String, String> prpIdentifiers = new HashMap<String, String>();
            Set<PublicRenderParameter> publicRenderParameters = portlet.getPublicRenderParameters();
            for (PublicRenderParameter publicRenderParameter : publicRenderParameters) {
                QName qName = publicRenderParameter.getQName();
                String publicRenderParameterIdentifier = qName.getLocalPart();
                String publicRenderParameterName = PortletQNameUtil.getPublicRenderParameterName(qName);
                prpIdentifiers.put(publicRenderParameterIdentifier, publicRenderParameterName);
            }
            FriendlyURLMapperThreadLocal.setPRPIdentifiers(prpIdentifiers);
            if (friendlyURLMapper.isCheckMappingWithPrefix()) {
                friendlyURLMapper.populateParams(url.substring(pos + 2), actualParams, requestContext);
            } else {
                friendlyURLMapper.populateParams(url.substring(pos), actualParams, requestContext);
            }
            queryString = "&" + HttpUtil.parameterMapToString(actualParams, false);
            break;
        }
        if (!foundFriendlyURLMapper && (x = url.indexOf("/-/")) != -1) {
            String ppid;
            int y = url.indexOf(47, x + 3);
            if (y == -1) {
                y = url.length();
            }
            if (Validator.isNotNull(ppid = url.substring(x + 3, y))) {
                friendlyURL = url.substring(0, x);
                HashMap<Object, Object> actualParams = null;
                actualParams = params != null ? new HashMap<String, String[]>(params) : new HashMap();
                actualParams.put("p_p_id", new String[]{ppid});
                actualParams.put("p_p_lifecycle", new String[]{"0"});
                actualParams.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
                actualParams.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
                queryString = "&" + HttpUtil.parameterMapToString(actualParams, false);
            }
        }
        if ((friendlyURL = StringUtil.replace(friendlyURL, "//", "/")).endsWith("/")) {
            friendlyURL = friendlyURL.substring(0, friendlyURL.length() - 1);
        }
        Layout layout = null;
        if (Validator.isNotNull(friendlyURL)) {
            layout = LayoutLocalServiceUtil.getFriendlyURLLayout(groupId, privateLayout, friendlyURL);
        } else {
            long defaultPlid = LayoutLocalServiceUtil.getDefaultPlid(groupId, privateLayout);
            layout = LayoutLocalServiceUtil.getLayout(defaultPlid);
        }
        return new LayoutQueryStringComposite(layout, friendlyURL, queryString);
    }

    @Override
    public String getPortletId(HttpServletRequest httpServletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)httpServletRequest.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    @Override
    public String getPortletId(PortletRequest portletRequest) {
        LiferayPortletConfig liferayPortletConfig = (LiferayPortletConfig)portletRequest.getAttribute("javax.portlet.config");
        if (liferayPortletConfig != null) {
            return liferayPortletConfig.getPortletId();
        }
        return null;
    }

    @Override
    public String getPortletLongTitle(Portlet portlet, Locale locale) {
        return this.getPortletLongTitle(portlet.getPortletId(), locale);
    }

    @Override
    public String getPortletLongTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create(portlet, servletContext);
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        try {
            String portletLongTitle = ResourceBundleUtil.getString(resourceBundle, "javax.portlet.long-title");
            if (portletLongTitle.startsWith("javax.portlet.long-title")) {
                portletLongTitle = this.getPortletTitle(portlet, servletContext, locale);
            }
            return portletLongTitle;
        }
        catch (Exception e) {
            return this.getPortletTitle(portlet, servletContext, locale);
        }
    }

    @Override
    public String getPortletLongTitle(Portlet portlet, String languageId) {
        return this.getPortletLongTitle(portlet.getPortletId(), languageId);
    }

    @Override
    public String getPortletLongTitle(Portlet portlet, User user) {
        return this.getPortletLongTitle(portlet.getPortletId(), user);
    }

    @Override
    public String getPortletLongTitle(String portletId, Locale locale) {
        String portletLongTitle = LanguageUtil.get(locale, "javax.portlet.long-title".concat(".").concat(portletId), "");
        if (Validator.isNull(portletLongTitle)) {
            portletLongTitle = this.getPortletTitle(portletId, locale);
        }
        return portletLongTitle;
    }

    @Override
    public String getPortletLongTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId(languageId);
        return this.getPortletLongTitle(portletId, locale);
    }

    @Override
    public String getPortletLongTitle(String portletId, User user) {
        return this.getPortletLongTitle(portletId, user.getLocale());
    }

    @Override
    public String getPortletNamespace(String portletId) {
        return "_".concat(portletId).concat("_");
    }

    @Override
    public String getPortletTitle(Portlet portlet, Locale locale) {
        return this.getPortletTitle(portlet.getPortletId(), locale);
    }

    @Override
    public String getPortletTitle(Portlet portlet, ServletContext servletContext, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.create(portlet, servletContext);
        return this._getPortletTitle(portlet.getRootPortletId(), portletConfig, locale);
    }

    @Override
    public String getPortletTitle(Portlet portlet, String languageId) {
        return this.getPortletTitle(portlet.getPortletId(), languageId);
    }

    @Override
    public String getPortletTitle(Portlet portlet, User user) {
        return this.getPortletTitle(portlet.getPortletId(), user);
    }

    @Override
    public String getPortletTitle(PortletRequest portletRequest) {
        Layout layout;
        ThemeDisplay themeDisplay;
        long portletScopeGroupId;
        String portletId = (String)portletRequest.getAttribute("PORTLET_ID");
        PortletConfig portletConfig = PortletConfigFactoryUtil.get(portletId);
        Locale locale = portletRequest.getLocale();
        String portletTitle = this._getPortletTitle(PortletIdCodec.decodePortletName(portletId), portletConfig, locale);
        if (portletConfig == null) {
            Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(portletRequest), portletId);
            HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
            ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
            portletTitle = this.getPortletTitle(portlet, servletContext, locale);
        }
        if ((portletScopeGroupId = this._getScopeGroupId(themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY"), layout = themeDisplay.getLayout(), portletId)) != layout.getGroupId()) {
            Group portletScopeGroup = GroupLocalServiceUtil.fetchGroup(portletScopeGroupId);
            String portletScopeName = portletScopeGroup.getName(locale);
            try {
                portletScopeName = portletScopeGroup.getDescriptiveName(locale);
            }
            catch (PortalException pe) {
                _log.error("Unable to get descriptive name", pe);
            }
            return this.getNewPortletTitle(portletTitle, "", portletScopeName);
        }
        return portletTitle;
    }

    @Override
    public String getPortletTitle(PortletResponse portletResponse) {
        LiferayPortletResponse liferayPortletResponse = LiferayPortletUtil.getLiferayPortletResponse(portletResponse);
        if (liferayPortletResponse instanceof LiferayRenderResponse) {
            return ((LiferayRenderResponse)liferayPortletResponse).getTitle();
        }
        return null;
    }

    @Override
    public String getPortletTitle(String portletId, Locale locale) {
        PortletConfig portletConfig = PortletConfigFactoryUtil.get(portletId);
        return this.getPortletTitle(portletId, portletConfig.getResourceBundle(locale));
    }

    @Override
    public String getPortletTitle(String portletId, ResourceBundle resourceBundle) {
        portletId = PortletIdCodec.decodePortletName(portletId);
        String portletTitle = LanguageUtil.get(resourceBundle, "javax.portlet.title".concat(".").concat(portletId), null);
        if (Validator.isNull(portletTitle)) {
            portletTitle = ResourceBundleUtil.getString(resourceBundle, "javax.portlet.title");
        }
        return portletTitle;
    }

    @Override
    public String getPortletTitle(String portletId, String languageId) {
        Locale locale = LocaleUtil.fromLanguageId(languageId);
        return this.getPortletTitle(portletId, locale);
    }

    @Override
    public String getPortletTitle(String portletId, User user) {
        return LanguageUtil.get(user.getLocale(), "javax.portlet.title".concat(".").concat(portletId));
    }

    @Override
    public String getPortletXmlFileName() {
        if (PropsValues.AUTO_DEPLOY_CUSTOM_PORTLET_XML) {
            return "portlet-custom.xml";
        }
        return "portlet.xml";
    }

    @Override
    public PortletPreferences getPreferences(HttpServletRequest httpServletRequest) {
        RenderRequest renderRequest = (RenderRequest)httpServletRequest.getAttribute("javax.portlet.request");
        PortletPreferencesImpl portletPreferences = null;
        if (renderRequest != null) {
            PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)renderRequest.getPreferences();
            portletPreferences = portletPreferencesWrapper.getPortletPreferencesImpl();
        }
        return portletPreferences;
    }

    @Override
    public PreferencesValidator getPreferencesValidator(Portlet portlet) {
        PortletBag portletBag = PortletBagPool.get(portlet.getRootPortletId());
        if (portletBag == null) {
            return null;
        }
        List<PreferencesValidator> preferencesValidatorInstances = portletBag.getPreferencesValidatorInstances();
        if (preferencesValidatorInstances.isEmpty()) {
            return null;
        }
        return preferencesValidatorInstances.get(0);
    }

    @Override
    public String getRelativeHomeURL(HttpServletRequest httpServletRequest) throws PortalException {
        Company company = this.getCompany(httpServletRequest);
        String homeURL = company.getHomeURL();
        if (Validator.isNull(homeURL)) {
            homeURL = PropsValues.COMPANY_DEFAULT_HOME_URL;
        }
        return homeURL;
    }

    @Override
    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle(locale);
    }

    @Override
    public long getScopeGroupId(HttpServletRequest httpServletRequest) throws PortalException {
        String portletId = this.getPortletId(httpServletRequest);
        return this.getScopeGroupId(httpServletRequest, portletId);
    }

    @Override
    public long getScopeGroupId(HttpServletRequest httpServletRequest, String portletId) throws PortalException {
        return this.getScopeGroupId(httpServletRequest, portletId, false);
    }

    @Override
    public long getScopeGroupId(HttpServletRequest httpServletRequest, String portletId, boolean checkStagingGroup) throws PortalException {
        Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long scopeGroupId = 0L;
        if (layout != null) {
            Group layoutGroup;
            Group group = layout.getGroup();
            long doAsGroupId = ParamUtil.getLong(httpServletRequest, "doAsGroupId");
            if (doAsGroupId <= 0L) {
                HttpServletRequest originalHttpServletRequest = this.getOriginalServletRequest(httpServletRequest);
                doAsGroupId = ParamUtil.getLong(originalHttpServletRequest, "doAsGroupId");
            }
            Group doAsGroup = null;
            if (doAsGroupId > 0L) {
                doAsGroup = GroupLocalServiceUtil.fetchGroup(doAsGroupId);
            }
            if (group.isControlPanel()) {
                if (doAsGroupId > 0L) {
                    scopeGroupId = doAsGroupId;
                }
                if ((group = GroupLocalServiceUtil.fetchGroup(scopeGroupId)) != null && group.hasStagingGroup()) {
                    try {
                        Group stagingGroup = StagingUtil.getPermissionStagingGroup(group);
                        scopeGroupId = stagingGroup.getGroupId();
                    }
                    catch (Exception stagingGroup) {}
                }
            } else if (doAsGroup != null) {
                scopeGroupId = doAsGroupId;
            }
            if (group != null && group.isInheritContent() && !(layoutGroup = layout.getGroup()).isControlPanel()) {
                scopeGroupId = group.getParentGroupId();
            }
            if (portletId != null && group != null && (group.isStaged() || group.isStagingGroup())) {
                Group liveGroup = group;
                if (group.isStagingGroup()) {
                    liveGroup = group.getLiveGroup();
                }
                if (liveGroup.isStaged() && !liveGroup.isStagedPortlet(portletId)) {
                    Layout liveGroupLayout = LayoutLocalServiceUtil.fetchLayoutByUuidAndGroupId(layout.getUuid(), liveGroup.getGroupId(), layout.isPrivateLayout());
                    if (liveGroupLayout != null && liveGroupLayout.hasScopeGroup()) {
                        scopeGroupId = this._getScopeGroupId(themeDisplay, liveGroupLayout, portletId);
                    } else if (checkStagingGroup && !liveGroup.isStagedRemotely()) {
                        Group stagingGroup = liveGroup.getStagingGroup();
                        scopeGroupId = stagingGroup.getGroupId();
                    } else {
                        scopeGroupId = liveGroup.getGroupId();
                    }
                }
            }
        }
        if (scopeGroupId <= 0L) {
            scopeGroupId = this._getScopeGroupId(themeDisplay, layout, portletId);
        }
        return scopeGroupId;
    }

    @Override
    public long getScopeGroupId(Layout layout) {
        if (layout == null) {
            return 0L;
        }
        return layout.getGroupId();
    }

    @Override
    public long getScopeGroupId(Layout layout, String portletId) {
        return this._getScopeGroupId(null, layout, portletId);
    }

    @Override
    public long getScopeGroupId(long plid) {
        Layout layout = null;
        try {
            layout = LayoutLocalServiceUtil.getLayout(plid);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.getScopeGroupId(layout);
    }

    @Override
    public long getScopeGroupId(PortletRequest portletRequest) throws PortalException {
        return this.getScopeGroupId(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public User getSelectedUser(HttpServletRequest httpServletRequest) throws PortalException {
        return this.getSelectedUser(httpServletRequest, true);
    }

    @Override
    public User getSelectedUser(HttpServletRequest httpServletRequest, boolean checkPermission) throws PortalException {
        User user;
        block2: {
            long userId = ParamUtil.getLong(httpServletRequest, "p_u_i_d");
            user = null;
            try {
                user = checkPermission ? UserServiceUtil.getUserById(userId) : UserLocalServiceUtil.getUserById(userId);
            }
            catch (NoSuchUserException nsue) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug(nsue, nsue);
            }
        }
        return user;
    }

    @Override
    public User getSelectedUser(PortletRequest portletRequest) throws PortalException {
        return this.getSelectedUser(portletRequest, true);
    }

    @Override
    public User getSelectedUser(PortletRequest portletRequest, boolean checkPermission) throws PortalException {
        return this.getSelectedUser(this.getHttpServletRequest(portletRequest), checkPermission);
    }

    @Override
    public String getServletContextName() {
        return this._servletContextName;
    }

    @Override
    public long[] getSharedContentSiteGroupIds(long companyId, long groupId, long userId) throws PortalException {
        int sitesContentSharingWithChildrenEnabled;
        LinkedHashSet<Group> groups = new LinkedHashSet<Group>();
        Group siteGroup = this.getCurrentSiteGroup(groupId);
        if (siteGroup != null) {
            groups.add(siteGroup);
            groups.addAll(siteGroup.getDescendants(true));
            groups.addAll(GroupLocalServiceUtil.getGroups(siteGroup.getCompanyId(), Layout.class.getName(), siteGroup.getGroupId()));
        }
        if (PrefsPropsUtil.getBoolean(companyId, "sites.content.sharing.through.administrators.enabled")) {
            groups.addAll(GroupLocalServiceUtil.getUserSitesGroups(userId));
        }
        if ((sitesContentSharingWithChildrenEnabled = PrefsPropsUtil.getInteger(companyId, "sites.content.sharing.with.children.enabled")) != 0) {
            groups.addAll(this.getAncestorSiteGroups(groupId, true));
        }
        Iterator iterator = groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (StagingUtil.isGroupAccessible(group, siteGroup)) continue;
            iterator.remove();
        }
        long[] groupIds = new long[groups.size()];
        int i = 0;
        for (Group group : groups) {
            groupIds[i++] = group.getGroupId();
        }
        return groupIds;
    }

    @Override
    @Deprecated
    public String getSiteAdminURL(Company company, Group group, String ppid, Map<String, String[]> params) throws PortalException {
        return this._getSiteAdminURL(this.getPortalURL(company.getVirtualHostname(), this.getPortalServerPort(false), false), group, ppid, params);
    }

    @Override
    @Deprecated
    public String getSiteAdminURL(Group group, String ppid, Map<String, String[]> params) throws PortalException {
        Company company = CompanyLocalServiceUtil.getCompany(group.getCompanyId());
        return this._getSiteAdminURL(this.getPortalURL(company.getVirtualHostname(), this.getPortalServerPort(false), false), group, ppid, params);
    }

    @Override
    public String getSiteAdminURL(ThemeDisplay themeDisplay, String ppid, Map<String, String[]> params) throws PortalException {
        return this._getSiteAdminURL(themeDisplay.getPortalURL(), themeDisplay.getScopeGroup(), ppid, params);
    }

    @Override
    public Locale getSiteDefaultLocale(Group group) throws PortalException {
        if (group == null) {
            return LocaleUtil.getDefault();
        }
        Group liveGroup = group;
        if (group.isStagingGroup()) {
            liveGroup = group.getLiveGroup();
        }
        if (LanguageUtil.isInheritLocales(liveGroup.getGroupId())) {
            Company company = CompanyLocalServiceUtil.getCompany(liveGroup.getCompanyId());
            return company.getLocale();
        }
        UnicodeProperties typeSettingsProperties = liveGroup.getTypeSettingsProperties();
        User defaultUser = UserLocalServiceUtil.getDefaultUser(group.getCompanyId());
        String languageId = GetterUtil.getString(typeSettingsProperties.getProperty("languageId"), defaultUser.getLanguageId());
        return LocaleUtil.fromLanguageId(languageId);
    }

    @Override
    public Locale getSiteDefaultLocale(long groupId) throws PortalException {
        if (groupId <= 0L) {
            return LocaleUtil.getDefault();
        }
        Group group = GroupLocalServiceUtil.fetchGroup(groupId);
        return this.getSiteDefaultLocale(group);
    }

    @Override
    public long getSiteGroupId(long groupId) {
        Group group = this._getSiteGroup(groupId);
        if (group == null) {
            return 0L;
        }
        return group.getGroupId();
    }

    @Override
    public String getSiteLoginURL(ThemeDisplay themeDisplay) throws PortalException {
        if (Validator.isNull(PropsValues.AUTH_LOGIN_SITE_URL)) {
            return null;
        }
        List<Layout> layouts = themeDisplay.getUnfilteredLayouts();
        if (layouts == null) {
            return null;
        }
        for (Layout layout : layouts) {
            String friendlyURL = themeDisplay.getLayoutFriendlyURL(layout);
            if (!friendlyURL.equals(PropsValues.AUTH_LOGIN_SITE_URL)) continue;
            if (themeDisplay.getLayout() == null) break;
            String layoutSetFriendlyURL = this.getLayoutSetFriendlyURL(layout.getLayoutSet(), themeDisplay);
            return layoutSetFriendlyURL + PropsValues.AUTH_LOGIN_SITE_URL;
        }
        return null;
    }

    @Override
    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri) {
        return this.getStaticResourceURL(httpServletRequest, uri, null, 0L);
    }

    @Override
    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri, long timestamp) {
        return this.getStaticResourceURL(httpServletRequest, uri, null, timestamp);
    }

    @Override
    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri, String queryString) {
        return this.getStaticResourceURL(httpServletRequest, uri, queryString, 0L);
    }

    @Override
    public String getStaticResourceURL(HttpServletRequest httpServletRequest, String uri, String queryString, long timestamp) {
        if (uri.indexOf(63) != -1) {
            return uri;
        }
        if (uri.startsWith("//")) {
            uri = uri.substring(1);
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Theme theme = themeDisplay.getTheme();
        Map<String, String[]> parameterMap = null;
        if (Validator.isNotNull(queryString)) {
            parameterMap = HttpUtil.getParameterMap(queryString);
        }
        StringBundler sb = new StringBundler(17);
        sb.append(uri);
        boolean firstParam = true;
        if (parameterMap == null || !parameterMap.containsKey("browserId")) {
            sb.append("?browserId=");
            sb.append(BrowserSnifferUtil.getBrowserId(httpServletRequest));
            firstParam = false;
        }
        if (!(!uri.endsWith(".css") && !uri.endsWith(".jsp") || parameterMap != null && parameterMap.containsKey("themeId"))) {
            if (firstParam) {
                sb.append("?themeId=");
                firstParam = false;
            } else {
                sb.append("&themeId=");
            }
            sb.append(URLCodec.encodeURL(theme.getThemeId()));
        }
        if (uri.endsWith(".jsp") && (parameterMap == null || !parameterMap.containsKey("colorSchemeId"))) {
            if (firstParam) {
                sb.append("?colorSchemeId=");
                firstParam = false;
            } else {
                sb.append("&colorSchemeId=");
            }
            ColorScheme colorScheme = themeDisplay.getColorScheme();
            sb.append(URLCodec.encodeURL(colorScheme.getColorSchemeId()));
        }
        if (parameterMap == null || !parameterMap.containsKey("minifierType")) {
            String minifierType = "";
            if (uri.endsWith(".css") || uri.endsWith("css.jsp") || uri.endsWith(".jsp") && uri.contains("/css/")) {
                if (themeDisplay.isThemeCssFastLoad()) {
                    minifierType = "css";
                }
            } else if (themeDisplay.isThemeJsFastLoad()) {
                minifierType = "js";
            }
            if (Validator.isNotNull(minifierType)) {
                if (firstParam) {
                    sb.append("?minifierType=");
                    firstParam = false;
                } else {
                    sb.append("&minifierType=");
                }
                sb.append(minifierType);
            }
        }
        if (Validator.isNotNull(queryString)) {
            if (queryString.charAt(0) == '&') {
                if (firstParam) {
                    sb.append("?");
                    sb.append(queryString.substring(1));
                } else {
                    sb.append(queryString);
                }
            } else if (firstParam) {
                sb.append("?");
                sb.append(queryString);
            } else {
                sb.append("&");
                sb.append(queryString);
            }
            firstParam = false;
        }
        if (firstParam) {
            sb.append("?languageId=");
        } else {
            sb.append("&languageId=");
        }
        sb.append(themeDisplay.getLanguageId());
        sb.append("&b=");
        sb.append(ReleaseInfo.getBuildNumber());
        if (!(parameterMap != null && parameterMap.containsKey("t") || timestamp < 0L)) {
            if (timestamp == 0L) {
                String portalURL = this.getPortalURL(httpServletRequest);
                String path = uri;
                if (uri.startsWith(portalURL)) {
                    path = uri.substring(portalURL.length());
                }
                if (path.startsWith("/html")) {
                    ServletContext servletContext = (ServletContext)httpServletRequest.getAttribute("CTX");
                    timestamp = ServletContextUtil.getLastModified(servletContext, path, true);
                } else {
                    timestamp = PortalWebResourcesUtil.getPathLastModified(path, theme.getTimestamp());
                }
            }
            sb.append("&t=");
            sb.append(timestamp);
        }
        return sb.toString();
    }

    @Override
    public String getStrutsAction(HttpServletRequest httpServletRequest) {
        String strutsAction = ParamUtil.getString(httpServletRequest, "struts_action");
        if (Validator.isNotNull(strutsAction)) {
            return "";
        }
        return this.getPortletParam(httpServletRequest, "struts_action");
    }

    @Override
    public String[] getSystemGroups() {
        return this._allSystemGroups;
    }

    @Override
    public String[] getSystemOrganizationRoles() {
        return this._allSystemOrganizationRoles;
    }

    @Override
    public String[] getSystemRoles() {
        return this._allSystemRoles;
    }

    @Override
    public String[] getSystemSiteRoles() {
        return this._allSystemSiteRoles;
    }

    @Override
    public String getUniqueElementId(HttpServletRequest httpServletRequest, String namespace, String elementId) {
        String uniqueElementId = elementId;
        Set uniqueElementIds = (Set)httpServletRequest.getAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS");
        if (uniqueElementIds == null) {
            uniqueElementIds = Collections.newSetFromMap(new ConcurrentHashMap());
            httpServletRequest.setAttribute("LIFERAY_SHARED_UNIQUE_ELEMENT_IDS", uniqueElementIds);
        } else {
            int i = 1;
            while (uniqueElementIds.contains(namespace.concat(uniqueElementId))) {
                uniqueElementId = Validator.isNull(elementId) || elementId.endsWith("_") ? elementId.concat(String.valueOf(i)) : elementId.concat("_").concat(String.valueOf(i));
                ++i;
            }
        }
        uniqueElementIds.add(namespace.concat(uniqueElementId));
        return uniqueElementId;
    }

    @Override
    public String getUniqueElementId(PortletRequest request, String namespace, String elementId) {
        return this.getUniqueElementId(this.getHttpServletRequest(request), namespace, elementId);
    }

    @Override
    public UploadPortletRequest getUploadPortletRequest(PortletRequest portletRequest) {
        LiferayPortletRequest liferayPortletRequest = LiferayPortletUtil.getLiferayPortletRequest(portletRequest);
        DynamicServletRequest dynamicRequest = (DynamicServletRequest)liferayPortletRequest.getHttpServletRequest();
        HttpServletRequestWrapper requestWrapper = (HttpServletRequestWrapper)dynamicRequest.getRequest();
        UploadServletRequest uploadServletRequest = this.getUploadServletRequest((HttpServletRequest)requestWrapper);
        return new UploadPortletRequestImpl(uploadServletRequest, liferayPortletRequest, this.getPortletNamespace(liferayPortletRequest.getPortletName()));
    }

    @Override
    public UploadServletRequest getUploadServletRequest(HttpServletRequest httpServletRequest) {
        return this.getUploadServletRequest(httpServletRequest, 0, null, 0L, 0L);
    }

    @Override
    public UploadServletRequest getUploadServletRequest(HttpServletRequest httpServletRequest, int fileSizeThreshold, String location, long maxRequestSize, long maxFileSize) {
        ArrayList<PersistentHttpServletRequestWrapper> persistentHttpServletRequestWrappers = new ArrayList<PersistentHttpServletRequestWrapper>();
        Object currentHttpServletRequest = httpServletRequest;
        while (currentHttpServletRequest instanceof HttpServletRequestWrapper) {
            if (currentHttpServletRequest instanceof UploadServletRequest) {
                return (UploadServletRequest)currentHttpServletRequest;
            }
            Class<?> currentRequestClass = currentHttpServletRequest.getClass();
            String currentRequestClassName = currentRequestClass.getName();
            if (!this.isUnwrapRequest(currentRequestClassName)) break;
            if (currentHttpServletRequest instanceof PersistentHttpServletRequestWrapper) {
                PersistentHttpServletRequestWrapper persistentHttpServletRequestWrapper = (PersistentHttpServletRequestWrapper)currentHttpServletRequest;
                persistentHttpServletRequestWrappers.add(persistentHttpServletRequestWrapper.clone());
            }
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)currentHttpServletRequest;
            currentHttpServletRequest = (HttpServletRequest)httpServletRequestWrapper.getRequest();
        }
        if (ServerDetector.isWebLogic()) {
            currentHttpServletRequest = new NonSerializableObjectRequestWrapper((HttpServletRequest)currentHttpServletRequest);
        }
        for (int i = persistentHttpServletRequestWrappers.size() - 1; i >= 0; --i) {
            HttpServletRequestWrapper httpServletRequestWrapper = (HttpServletRequestWrapper)persistentHttpServletRequestWrappers.get(i);
            httpServletRequestWrapper.setRequest((ServletRequest)currentHttpServletRequest);
            currentHttpServletRequest = httpServletRequestWrapper;
        }
        return new UploadServletRequestImpl((HttpServletRequest)currentHttpServletRequest, fileSizeThreshold, location, maxRequestSize, maxFileSize);
    }

    @Override
    public Date getUptime() {
        return _upTime;
    }

    @Override
    public String getURLWithSessionId(String url, String sessionId) {
        int y;
        StringBundler sb;
        HttpSession httpSession;
        if (!PropsValues.SESSION_ENABLE_URL_WITH_SESSION_ID) {
            return url;
        }
        if (Validator.isNull(url)) {
            return url;
        }
        int x = url.indexOf(59);
        if (x != -1) {
            return url;
        }
        if (CompoundSessionIdSplitterUtil.hasSessionDelimiter() && (httpSession = PortalSessionContext.get(sessionId)) != null) {
            while (httpSession instanceof HttpSessionWrapper) {
                HttpSessionWrapper httpSessionWrapper = (HttpSessionWrapper)httpSession;
                httpSession = httpSessionWrapper.getWrappedSession();
            }
            sessionId = httpSession.getId();
        }
        if ((x = url.indexOf(63)) != -1) {
            sb = new StringBundler(4);
            sb.append(url.substring(0, x));
            sb.append(";jsessionid=");
            sb.append(sessionId);
            sb.append(url.substring(x));
            return sb.toString();
        }
        x = url.indexOf("//");
        sb = new StringBundler(4);
        sb.append(url);
        if (x != -1 && x + 1 == (y = url.lastIndexOf(47))) {
            sb.append("/");
        }
        sb.append(";jsessionid=");
        sb.append(sessionId);
        return sb.toString();
    }

    @Override
    public User getUser(HttpServletRequest httpServletRequest) throws PortalException {
        Cookie[] cookies;
        User user = (User)httpServletRequest.getAttribute("USER");
        if (user != null) {
            return user;
        }
        long userId = this.getUserId(httpServletRequest);
        if (userId <= 0L) {
            String remoteUser = httpServletRequest.getRemoteUser();
            if (remoteUser == null && !PropsValues.PORTAL_JAAS_ENABLE) {
                HttpSession session = httpServletRequest.getSession();
                remoteUser = (String)session.getAttribute("j_remoteuser");
            }
            if (remoteUser == null) {
                return null;
            }
            if (PropsValues.PORTAL_JAAS_ENABLE) {
                long companyId = this.getCompanyId(httpServletRequest);
                try {
                    userId = JAASHelper.getJaasUserId(companyId, remoteUser);
                }
                catch (Exception e) {
                    if (_log.isWarnEnabled()) {
                        _log.warn(e, e);
                    }
                }
            } else {
                userId = GetterUtil.getLong(remoteUser);
            }
        }
        if (userId > 0L) {
            user = UserLocalServiceUtil.getUserById(userId);
            httpServletRequest.setAttribute("USER", (Object)user);
        }
        if ((cookies = httpServletRequest.getCookies()) != null) {
            for (Cookie cookie : cookies) {
                String cookieName = cookie.getName();
                if (!cookieName.startsWith("REMOTE_PREFERENCE_")) continue;
                user.addRemotePreference(new CookieRemotePreference(cookie));
            }
        }
        return user;
    }

    @Override
    public User getUser(PortletRequest portletRequest) throws PortalException {
        return this.getUser(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public String getUserEmailAddress(long userId) {
        try {
            User user = UserLocalServiceUtil.getUserById(userId);
            return user.getEmailAddress();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug(pe, pe);
            }
            return "";
        }
    }

    @Override
    public long getUserId(HttpServletRequest httpServletRequest) {
        HttpSession session;
        Long userIdObj = (Long)httpServletRequest.getAttribute("USER_ID");
        if (userIdObj != null) {
            return userIdObj;
        }
        String doAsUserIdString = ParamUtil.getString(httpServletRequest, "doAsUserId", null);
        if (doAsUserIdString != null) {
            String actionName = this.getPortletParam(httpServletRequest, "actionName");
            String mvcRenderCommandName = ParamUtil.getString(httpServletRequest, "mvcRenderCommandName");
            String path = GetterUtil.getString(httpServletRequest.getPathInfo());
            String strutsAction = this.getStrutsAction(httpServletRequest);
            boolean alwaysAllowDoAsUser = false;
            if (actionName.equals("addFile") || mvcRenderCommandName.equals("/document_library/edit_file_entry") || path.equals("/portal/session_click") || this.isAlwaysAllowDoAsUser(actionName, mvcRenderCommandName, path, strutsAction)) {
                try {
                    alwaysAllowDoAsUser = this.isAlwaysAllowDoAsUser(httpServletRequest);
                }
                catch (Exception e) {
                    _log.error(e, e);
                }
            }
            if (!PropsValues.PORTAL_JAAS_ENABLE && PropsValues.PORTAL_IMPERSONATION_ENABLE || alwaysAllowDoAsUser) {
                try {
                    long doAsUserId = this.getDoAsUserId(httpServletRequest, doAsUserIdString, alwaysAllowDoAsUser);
                    if (doAsUserId > 0L) {
                        if (_log.isDebugEnabled()) {
                            _log.debug("Impersonating user " + doAsUserId);
                        }
                        return doAsUserId;
                    }
                }
                catch (Exception e) {
                    _log.error("Unable to impersonate user " + doAsUserIdString, e);
                }
            }
        }
        if ((userIdObj = (Long)(session = httpServletRequest.getSession()).getAttribute("USER_ID")) != null) {
            httpServletRequest.setAttribute("USER_ID", (Object)userIdObj);
            return userIdObj;
        }
        return 0L;
    }

    @Override
    public long getUserId(PortletRequest portletRequest) {
        return this.getUserId(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public String getUserName(BaseModel<?> baseModel) {
        long userId = 0L;
        String userName = "";
        if (baseModel instanceof AuditedModel) {
            AuditedModel auditedModel = (AuditedModel)((Object)baseModel);
            userId = auditedModel.getUserId();
            userName = auditedModel.getUserName();
        } else {
            userId = BeanPropertiesUtil.getLongSilent(baseModel, "userId");
            userName = BeanPropertiesUtil.getStringSilent(baseModel, "userName");
        }
        if (userId == 0L) {
            return "";
        }
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.unescape(userName);
        }
        userName = this.getUserName(userId, userName);
        if (baseModel.isEscapedModel()) {
            userName = HtmlUtil.escape(userName);
        }
        return userName;
    }

    @Override
    public String getUserName(long userId, String defaultUserName) {
        return this.getUserName(userId, defaultUserName, "user.name.full");
    }

    @Override
    public String getUserName(long userId, String defaultUserName, HttpServletRequest httpServletRequest) {
        return this.getUserName(userId, defaultUserName, "user.name.full", httpServletRequest);
    }

    @Override
    public String getUserName(long userId, String defaultUserName, String userAttribute) {
        return this.getUserName(userId, defaultUserName, userAttribute, null);
    }

    @Override
    public String getUserName(long userId, String defaultUserName, String userAttribute, HttpServletRequest httpServletRequest) {
        String userName = defaultUserName;
        try {
            User user = UserLocalServiceUtil.getUserById(userId);
            userName = userAttribute.equals("user.name.full") ? user.getFullName() : user.getScreenName();
            if (httpServletRequest != null) {
                Layout layout = (Layout)httpServletRequest.getAttribute("LAYOUT");
                LiferayPortletURL portletURL = PortletURLFactoryUtil.create(httpServletRequest, "com_liferay_directory_web_portlet_DirectoryPortlet", layout, "RENDER_PHASE");
                portletURL.setParameter("struts_action", "/directory/view_user");
                portletURL.setParameter("p_u_i_d", String.valueOf(user.getUserId()));
                portletURL.setPortletMode(PortletMode.VIEW);
                portletURL.setWindowState(WindowState.MAXIMIZED);
                userName = StringBundler.concat("<a href=\"", portletURL.toString(), "\">", HtmlUtil.escape(userName), "</a>");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return userName;
    }

    @Override
    public String getUserPassword(HttpServletRequest httpServletRequest) {
        httpServletRequest = this.getOriginalServletRequest(httpServletRequest);
        HttpSession session = httpServletRequest.getSession();
        return this.getUserPassword(session);
    }

    @Override
    public String getUserPassword(HttpSession session) {
        return (String)session.getAttribute("USER_PASSWORD");
    }

    @Override
    public String getUserPassword(PortletRequest portletRequest) {
        return this.getUserPassword(this.getHttpServletRequest(portletRequest));
    }

    @Override
    public String getValidPortalDomain(long companyId, String domain) {
        if (this._validPortalDomainCheckDisabled) {
            return domain;
        }
        for (String virtualHost : PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) {
            if (!StringUtil.equalsIgnoreCase(domain, virtualHost) && !StringUtil.wildcardMatches(domain, virtualHost, '?', '*', '%', false)) continue;
            return domain;
        }
        if (_log.isWarnEnabled()) {
            _log.warn(StringBundler.concat("Set the property \"", "virtual.hosts.valid.hosts", "\" in portal.properties to allow \"", domain, "\" as a domain"));
        }
        try {
            Company company = CompanyLocalServiceUtil.getCompanyById(this.getDefaultCompanyId());
            return company.getVirtualHostname();
        }
        catch (Exception e) {
            _log.error("Unable to load default portal instance", e);
            return _LOCALHOST;
        }
    }

    @Override
    public long getValidUserId(long companyId, long userId) throws PortalException {
        User user = UserLocalServiceUtil.fetchUser(userId);
        if (user == null) {
            return UserLocalServiceUtil.getDefaultUserId(companyId);
        }
        if (user.getCompanyId() == companyId) {
            return user.getUserId();
        }
        return userId;
    }

    @Override
    public String getVirtualHostname(LayoutSet layoutSet) {
        String virtualHostname = layoutSet.getVirtualHostname();
        if (Validator.isNull(virtualHostname)) {
            virtualHostname = layoutSet.getCompanyFallbackVirtualHostname();
        }
        return virtualHostname;
    }

    @Override
    public String getWidgetURL(Portlet portlet, ThemeDisplay themeDisplay) throws PortalException {
        return this.getServletURL(portlet, PropsValues.WIDGET_SERVLET_MAPPING, themeDisplay);
    }

    @Override
    public void initCustomSQL() {
        this._customSqlKeys = new String[]{"[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.GROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.LAYOUT$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ORGANIZATION$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.ROLE$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.TEAM$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USER$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTAL.MODEL.USERGROUP$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFILEENTRY$]", "[$CLASS_NAME_ID_COM.LIFERAY.PORTLET.DOCUMENTLIBRARY.MODEL.DLFOLDER$]", "[$RESOURCE_SCOPE_COMPANY$]", "[$RESOURCE_SCOPE_GROUP$]", "[$RESOURCE_SCOPE_GROUP_TEMPLATE$]", "[$RESOURCE_SCOPE_INDIVIDUAL$]", "[$SOCIAL_RELATION_TYPE_BI_COWORKER$]", "[$SOCIAL_RELATION_TYPE_BI_FRIEND$]", "[$SOCIAL_RELATION_TYPE_BI_ROMANTIC_PARTNER$]", "[$SOCIAL_RELATION_TYPE_BI_SIBLING$]", "[$SOCIAL_RELATION_TYPE_BI_SPOUSE$]", "[$SOCIAL_RELATION_TYPE_UNI_CHILD$]", "[$SOCIAL_RELATION_TYPE_UNI_ENEMY$]", "[$SOCIAL_RELATION_TYPE_UNI_FOLLOWER$]", "[$SOCIAL_RELATION_TYPE_UNI_PARENT$]", "[$SOCIAL_RELATION_TYPE_UNI_SUBORDINATE$]", "[$SOCIAL_RELATION_TYPE_UNI_SUPERVISOR$]", "[$FALSE$]", "[$TRUE$]"};
        DB db = DBManagerUtil.getDB();
        Object[] customSqlValues = new Object[]{this.getClassNameId(Group.class), this.getClassNameId(Layout.class), this.getClassNameId(Organization.class), this.getClassNameId(Role.class), this.getClassNameId(Team.class), this.getClassNameId(User.class), this.getClassNameId(UserGroup.class), this.getClassNameId(DLFileEntry.class), this.getClassNameId(DLFolder.class), 1, 2, 3, 4, 1, 2, 3, 4, 5, 6, 9, 8, 7, 10, 11, db.getTemplateFalse(), db.getTemplateTrue()};
        this._customSqlValues = ArrayUtil.toStringArray(customSqlValues);
    }

    @Override
    public User initUser(HttpServletRequest httpServletRequest) throws Exception {
        User user = null;
        try {
            user = this.getUser(httpServletRequest);
        }
        catch (NoSuchUserException nsue) {
            long userId;
            if (_log.isWarnEnabled()) {
                _log.warn(nsue.getMessage());
            }
            if ((userId = this.getUserId(httpServletRequest)) > 0L) {
                HttpSession session = httpServletRequest.getSession();
                session.invalidate();
            }
            throw nsue;
        }
        if (user != null) {
            return user;
        }
        Company company = this.getCompany(httpServletRequest);
        return company.getDefaultUser();
    }

    @Override
    @Deprecated
    public void invokeTaglibDiscussionPagination(PortletConfig portletConfig, ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (this._getCommentsStrutsAction == null) {
            _log.error("Unable to find a Struts Action component with property \"path=/portal/comment/discussion/get_comments\"");
            return;
        }
        try {
            this._getCommentsStrutsAction.execute(this.getHttpServletRequest((PortletRequest)resourceRequest), this.getHttpServletResponse((PortletResponse)resourceResponse));
        }
        catch (IOException | RuntimeException | PortletException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    @Override
    public boolean isCDNDynamicResourcesEnabled(HttpServletRequest httpServletRequest) throws PortalException {
        Company company = this.getCompany(httpServletRequest);
        return this.isCDNDynamicResourcesEnabled(company.getCompanyId());
    }

    @Override
    public boolean isCDNDynamicResourcesEnabled(long companyId) {
        try {
            return PrefsPropsUtil.getBoolean(companyId, "cdn.dynamic.resources.enabled", PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED);
        }
        catch (SystemException se) {
            if (_log.isDebugEnabled()) {
                _log.debug(se, se);
            }
            return PropsValues.CDN_DYNAMIC_RESOURCES_ENABLED;
        }
    }

    @Override
    public boolean isCompanyAdmin(User user) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
        return permissionChecker.isCompanyAdmin();
    }

    @Override
    public boolean isCompanyControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) throws PortalException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup(themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, category, themeDisplay);
    }

    @Override
    public boolean isCompanyControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) throws PortalException {
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return true;
        }
        Group companyGroup = GroupLocalServiceUtil.getCompanyGroup(themeDisplay.getCompanyId());
        themeDisplay.setScopeGroupId(companyGroup.getGroupId());
        return this.isControlPanelPortlet(portletId, themeDisplay);
    }

    @Override
    public boolean isControlPanelPortlet(String portletId, String category, ThemeDisplay themeDisplay) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(themeDisplay.getCompanyId(), portletId);
        String controlPanelEntryCategory = portlet.getControlPanelEntryCategory();
        if (controlPanelEntryCategory.equals(category) || category.endsWith(".") && StringUtil.startsWith(controlPanelEntryCategory, category)) {
            return this.isControlPanelPortlet(portletId, themeDisplay);
        }
        return false;
    }

    @Override
    public boolean isControlPanelPortlet(String portletId, ThemeDisplay themeDisplay) {
        try {
            return PortletPermissionUtil.hasControlPanelAccessPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portletId);
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to check control panel access permission", pe);
            }
            return false;
        }
    }

    @Override
    public boolean isCustomPortletMode(PortletMode portletMode) {
        return !LiferayPortletMode.ABOUT.equals((Object)portletMode) && !LiferayPortletMode.CONFIG.equals((Object)portletMode) && !LiferayPortletMode.EDIT.equals((Object)portletMode) && !LiferayPortletMode.EDIT_DEFAULTS.equals((Object)portletMode) && !LiferayPortletMode.EDIT_GUEST.equals((Object)portletMode) && !LiferayPortletMode.HELP.equals((Object)portletMode) && !LiferayPortletMode.PREVIEW.equals((Object)portletMode) && !LiferayPortletMode.PRINT.equals((Object)portletMode) && !LiferayPortletMode.VIEW.equals((Object)portletMode);
    }

    @Override
    public boolean isForwardedSecure(HttpServletRequest httpServletRequest) {
        String forwardedProtocol;
        if (PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_ENABLED && Validator.isNotNull(forwardedProtocol = httpServletRequest.getHeader(PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_HEADER)) && Objects.equals("https", forwardedProtocol)) {
            return true;
        }
        return httpServletRequest.isSecure();
    }

    @Override
    public boolean isGroupAdmin(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
        return permissionChecker.isGroupAdmin(groupId);
    }

    @Override
    public boolean isGroupFriendlyURL(String fullURL, String groupFriendlyURL, String layoutFriendlyURL) {
        return fullURL.endsWith(groupFriendlyURL) && !fullURL.endsWith(groupFriendlyURL.concat(layoutFriendlyURL));
    }

    @Override
    public boolean isGroupOwner(User user, long groupId) throws Exception {
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(user);
        return permissionChecker.isGroupOwner(groupId);
    }

    @Override
    public boolean isLayoutDescendant(Layout layout, long layoutId) throws PortalException {
        if (layout.getLayoutId() == layoutId) {
            return true;
        }
        for (Layout childLayout : layout.getChildren()) {
            if (!this.isLayoutDescendant(childLayout, layoutId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isLayoutSitemapable(Layout layout) {
        if (layout.isPrivateLayout()) {
            return false;
        }
        LayoutType layoutType = layout.getLayoutType();
        return layoutType.isSitemapable();
    }

    @Override
    public boolean isLoginRedirectRequired(HttpServletRequest httpServletRequest) {
        if (PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS && !httpServletRequest.isSecure()) {
            return true;
        }
        long companyId = this.getCompanyId(httpServletRequest);
        return SSOUtil.isLoginRedirectRequired(companyId);
    }

    @Override
    public boolean isMethodGet(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString(httpServletRequest.getMethod());
        return StringUtil.equalsIgnoreCase(method, "GET");
    }

    @Override
    public boolean isMethodPost(PortletRequest portletRequest) {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
        String method = GetterUtil.getString(httpServletRequest.getMethod());
        return StringUtil.equalsIgnoreCase(method, "POST");
    }

    @Override
    public boolean isMultipartRequest(HttpServletRequest httpServletRequest) {
        String contentType = httpServletRequest.getHeader("Content-Type");
        return contentType != null && contentType.startsWith("multipart/form-data");
    }

    @Override
    public boolean isOmniadmin(long userId) {
        return OmniadminUtil.isOmniadmin(userId);
    }

    @Override
    public boolean isOmniadmin(User user) {
        return OmniadminUtil.isOmniadmin(user);
    }

    @Override
    public boolean isReservedParameter(String name) {
        return this._reservedParams.contains(name);
    }

    @Override
    public boolean isRightToLeft(HttpServletRequest httpServletRequest) {
        String languageId = LanguageUtil.getLanguageId(httpServletRequest);
        Locale locale = LocaleUtil.fromLanguageId(languageId);
        String langDir = LanguageUtil.get(locale, "lang.dir");
        return langDir.equals("rtl");
    }

    @Override
    public boolean isRSSFeedsEnabled() {
        return PropsValues.RSS_FEEDS_ENABLED;
    }

    @Override
    public boolean isSecure(HttpServletRequest httpServletRequest) {
        if (PropsValues.WEB_SERVER_FORWARDED_PROTOCOL_ENABLED) {
            return this.isForwardedSecure(httpServletRequest);
        }
        if (!PropsValues.COMPANY_SECURITY_AUTH_REQUIRES_HTTPS || PropsValues.SESSION_ENABLE_PHISHING_PROTECTION) {
            return httpServletRequest.isSecure();
        }
        HttpSession session = httpServletRequest.getSession();
        if (session == null) {
            return httpServletRequest.isSecure();
        }
        Boolean httpsInitial = (Boolean)session.getAttribute("HTTPS_INITIAL");
        if (httpsInitial == null || httpsInitial.booleanValue()) {
            return httpServletRequest.isSecure();
        }
        return false;
    }

    @Override
    @Deprecated
    public boolean isSkipPortletContentProcessing(Group group, HttpServletRequest httpServletRequest, LayoutTypePortlet layoutTypePortlet, PortletDisplay portletDisplay, String portletName) throws Exception {
        return this.isSkipPortletContentRendering(group, layoutTypePortlet, portletDisplay, portletName);
    }

    @Override
    public boolean isSkipPortletContentRendering(Group group, LayoutTypePortlet layoutTypePortlet, PortletDisplay portletDisplay, String portletName) {
        Portlet portlet = PortletLocalServiceUtil.getPortletById(group.getCompanyId(), portletDisplay.getId());
        if (portlet.isSystem()) {
            return false;
        }
        return group.isLayoutPrototype() && layoutTypePortlet.hasPortletId(portletDisplay.getId()) && portletDisplay.isModeView() && !portletName.equals("com_liferay_nested_portlets_web_portlet_NestedPortletsPortlet");
    }

    @Override
    public boolean isSystemGroup(String groupName) {
        if (groupName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemGroups, groupName = groupName.trim(), new StringComparator());
        return pos >= 0;
    }

    @Override
    public boolean isSystemRole(String roleName) {
        if (roleName == null) {
            return false;
        }
        int pos = Arrays.binarySearch(this._sortedSystemRoles, roleName = roleName.trim(), new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemSiteRoles, roleName, new StringComparator());
        if (pos >= 0) {
            return true;
        }
        pos = Arrays.binarySearch(this._sortedSystemOrganizationRoles, roleName, new StringComparator());
        return pos >= 0;
    }

    @Override
    public boolean isUpdateAvailable() {
        return PluginPackageUtil.isUpdateAvailable();
    }

    @Override
    public boolean isValidResourceId(String resourceId) {
        if (Validator.isNull(resourceId)) {
            return true;
        }
        Matcher matcher = _bannedResourceIdPattern.matcher(resourceId);
        return !matcher.matches();
    }

    @Override
    public boolean removePortalInetSocketAddressEventListener(PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        return this._portalInetSocketAddressEventListeners.remove(portalInetSocketAddressEventListener);
    }

    @Override
    public void resetCDNHosts() {
        _cdnHostHttpMap.clear();
        _cdnHostHttpsMap.clear();
        if (!ClusterInvokeThreadLocal.isEnabled()) {
            return;
        }
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest(_resetCDNHostsMethodHandler, true);
        try {
            ClusterExecutorUtil.execute(clusterRequest);
        }
        catch (Exception e) {
            _log.error("Unable to clear cluster wide CDN hosts", e);
        }
    }

    @Override
    public String resetPortletParameters(String url, String portletId) {
        if (Validator.isNull(url) || Validator.isNull(portletId)) {
            return url;
        }
        String portletNamespace = this.getPortletNamespace(portletId);
        Map<String, String[]> parameterMap = HttpUtil.getParameterMap(url);
        for (String name : parameterMap.keySet()) {
            if (!name.startsWith(portletNamespace)) continue;
            url = HttpUtil.removeParameter(url, name);
        }
        return url;
    }

    @Override
    public void sendError(Exception e, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        this.sendError(0, e, actionRequest, actionResponse);
    }

    @Override
    public void sendError(Exception e, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.sendError(0, e, httpServletRequest, httpServletResponse);
    }

    @Override
    public void sendError(int status, Exception e, ActionRequest actionRequest, ActionResponse actionResponse) throws IOException {
        StringBundler sb = new StringBundler(7);
        sb.append(this._pathMain);
        sb.append("/portal/status?status=");
        sb.append(status);
        sb.append("&exception=");
        Class<?> clazz = e.getClass();
        sb.append(clazz.getName());
        sb.append("&previousURL=");
        sb.append(URLCodec.encodeURL(this.getCurrentURL((PortletRequest)actionRequest)));
        actionResponse.sendRedirect(sb.toString());
    }

    @Override
    public void sendError(int status, Exception e, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (_log.isDebugEnabled()) {
            String currentURL = (String)httpServletRequest.getAttribute("CURRENT_URL");
            _log.debug(StringBundler.concat("Current URL ", currentURL, " generates exception: ", e.getMessage()));
        }
        if (e instanceof NoSuchImageException) {
            if (_logWebServerServlet.isWarnEnabled()) {
                _logWebServerServlet.warn(e, e);
            }
        } else if (e instanceof PortalException) {
            if (_log.isDebugEnabled()) {
                if (e instanceof NoSuchLayoutException || e instanceof PrincipalException) {
                    String msg = e.getMessage();
                    if (Validator.isNotNull(msg)) {
                        _log.debug(msg);
                    }
                } else {
                    _log.debug(e, e);
                }
            }
        } else if (_log.isWarnEnabled()) {
            _log.warn(e, e);
        }
        if (httpServletResponse.isCommitted()) {
            return;
        }
        if (status == 0) {
            if (e instanceof PrincipalException) {
                status = 403;
            } else {
                Class<?> clazz = e.getClass();
                String name = clazz.getName();
                if ((name = name.substring(name.lastIndexOf(46) + 1)).startsWith("NoSuch") && name.endsWith("Exception")) {
                    status = 404;
                }
            }
            if (status == 0) {
                status = 400;
            }
        }
        String redirect = null;
        if (e instanceof NoSuchGroupException && Validator.isNotNull(PropsValues.SITES_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            redirect = PropsValues.SITES_FRIENDLY_URL_PAGE_NOT_FOUND;
        } else if (e instanceof NoSuchLayoutException && Validator.isNotNull(PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND)) {
            redirect = PropsValues.LAYOUT_FRIENDLY_URL_PAGE_NOT_FOUND;
        } else if (PropsValues.LAYOUT_SHOW_HTTP_STATUS) {
            DynamicServletRequest dynamicRequest = new DynamicServletRequest((HttpServletRequest)httpServletRequest);
            dynamicRequest.setParameter("p_l_id", "");
            dynamicRequest.setParameter("groupId", "");
            dynamicRequest.setParameter("layoutId", "");
            dynamicRequest.setParameter("privateLayout", "");
            httpServletRequest = dynamicRequest;
            redirect = "/c/portal/status";
        }
        if (Objects.equals(redirect, httpServletRequest.getRequestURI())) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to redirect to missing URI: " + redirect);
            }
            redirect = null;
        }
        if (Validator.isNotNull(redirect)) {
            HttpSession session = PortalSessionThreadLocal.getHttpSession();
            if (session == null) {
                session = httpServletRequest.getSession();
            }
            httpServletResponse.setStatus(status);
            SessionErrors.add(session, e.getClass(), (Object)e);
            ServletContext servletContext = session.getServletContext();
            RequestDispatcher requestDispatcher = servletContext.getRequestDispatcher(redirect);
            if (requestDispatcher != null) {
                requestDispatcher.forward((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            }
        } else if (e != null) {
            httpServletResponse.sendError(status, "A " + e.getClass() + " error occurred while processing your request");
        } else {
            String currentURL = (String)httpServletRequest.getAttribute("CURRENT_URL");
            httpServletResponse.sendError(status, "Current URL " + currentURL);
        }
    }

    @Override
    public void sendRSSFeedsDisabledError(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.sendError(404, (Exception)new RSSFeedException(), httpServletRequest, httpServletResponse);
    }

    @Override
    public void sendRSSFeedsDisabledError(PortletRequest portletRequest, PortletResponse portletResponse) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = this.getHttpServletRequest(portletRequest);
        HttpServletResponse httpServletResponse = this.getHttpServletResponse(portletResponse);
        this.sendRSSFeedsDisabledError(httpServletRequest, httpServletResponse);
    }

    @Override
    public void setPageDescription(String description, HttpServletRequest httpServletRequest) {
        ListMergeable<String> descriptionListMergeable = new ListMergeable<String>();
        descriptionListMergeable.add(description);
        httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_DESCRIPTION", descriptionListMergeable);
    }

    @Override
    public void setPageKeywords(String keywords, HttpServletRequest httpServletRequest) {
        httpServletRequest.removeAttribute("LIFERAY_SHARED_PAGE_KEYWORDS");
        this.addPageKeywords(keywords, httpServletRequest);
    }

    @Override
    public void setPageSubtitle(String subtitle, HttpServletRequest httpServletRequest) {
        ListMergeable<String> subtitleListMergeable = new ListMergeable<String>();
        subtitleListMergeable.add(subtitle);
        httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_SUBTITLE", subtitleListMergeable);
    }

    @Override
    public void setPageTitle(String title, HttpServletRequest httpServletRequest) {
        ListMergeable<String> titleListMergeable = new ListMergeable<String>();
        titleListMergeable.add(title);
        httpServletRequest.setAttribute("LIFERAY_SHARED_PAGE_TITLE", titleListMergeable);
    }

    @Override
    public void setPortalInetSocketAddresses(HttpServletRequest httpServletRequest) {
        boolean secure = httpServletRequest.isSecure();
        if (secure && this._securePortalLocalInetSocketAddress.get() != null && this._securePortalServerInetSocketAddress.get() != null || !secure && this._portalLocalInetSocketAddress.get() != null && this._portalServerInetSocketAddress.get() != null) {
            return;
        }
        InetAddress localInetAddress = null;
        InetAddress serverInetAddress = null;
        try {
            localInetAddress = InetAddress.getByName(httpServletRequest.getLocalAddr());
            serverInetAddress = InetAddress.getByName(httpServletRequest.getServerName());
        }
        catch (UnknownHostException uhe) {
            if (_log.isWarnEnabled()) {
                _log.warn("Unable to resolve portal host", uhe);
            }
            return;
        }
        InetSocketAddress localInetSocketAddress = new InetSocketAddress(localInetAddress, httpServletRequest.getLocalPort());
        InetSocketAddress serverInetSocketAddress = new InetSocketAddress(serverInetAddress, httpServletRequest.getServerPort());
        if (secure) {
            if (this._securePortalLocalInetSocketAddress.compareAndSet(null, localInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(localInetSocketAddress, true, true);
            }
            if (this._securePortalServerInetSocketAddress.compareAndSet(null, serverInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(serverInetSocketAddress, false, true);
            }
        } else {
            if (this._portalLocalInetSocketAddress.compareAndSet(null, localInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(localInetSocketAddress, true, false);
            }
            if (this._portalServerInetSocketAddress.compareAndSet(null, serverInetSocketAddress)) {
                this.notifyPortalInetSocketAddressEventListeners(serverInetSocketAddress, false, false);
            }
        }
    }

    @Override
    public void storePreferences(PortletPreferences portletPreferences) throws IOException, ValidatorException {
        PortletPreferencesWrapper portletPreferencesWrapper = (PortletPreferencesWrapper)portletPreferences;
        PortletPreferencesImpl portletPreferencesImpl = portletPreferencesWrapper.getPortletPreferencesImpl();
        portletPreferencesImpl.store();
    }

    @Override
    public String[] stripURLAnchor(String url, String separator) {
        String anchor = "";
        int pos = url.indexOf(separator);
        if (pos != -1) {
            anchor = url.substring(pos);
            url = url.substring(0, pos);
        }
        return new String[]{url, anchor};
    }

    @Override
    public String transformCustomSQL(String sql) {
        if (this._customSqlKeys == null || this._customSqlValues == null) {
            this.initCustomSQL();
        }
        return StringUtil.replace(sql, this._customSqlKeys, this._customSqlValues);
    }

    @Override
    public String transformSQL(String sql) {
        return SQLTransformer.transform(sql);
    }

    @Override
    public void updateImageId(BaseModel<?> baseModel, boolean hasImage, byte[] bytes, String fieldName, long maxSize, int maxHeight, int maxWidth) throws PortalException {
        long imageId = BeanPropertiesUtil.getLong(baseModel, fieldName);
        if (!hasImage) {
            if (imageId > 0L) {
                ImageLocalServiceUtil.deleteImage(imageId);
                BeanPropertiesUtil.setProperty(baseModel, fieldName, 0);
            }
            return;
        }
        if (ArrayUtil.isEmpty(bytes)) {
            return;
        }
        if (maxSize > 0L && (long)bytes.length > maxSize) {
            throw new ImageSizeException();
        }
        if (maxHeight > 0 || maxWidth > 0) {
            try {
                ImageBag imageBag = ImageToolUtil.read(bytes);
                RenderedImage renderedImage = imageBag.getRenderedImage();
                if (renderedImage == null) {
                    throw new ImageTypeException();
                }
                renderedImage = ImageToolUtil.scale(renderedImage, maxHeight, maxWidth);
                bytes = ImageToolUtil.getBytes(renderedImage, imageBag.getType());
            }
            catch (IOException ioe) {
                throw new ImageSizeException(ioe);
            }
        }
        Image image = ImageLocalServiceUtil.moveImage(imageId, bytes);
        BeanPropertiesUtil.setProperty(baseModel, fieldName, image.getImageId());
    }

    @Override
    public PortletMode updatePortletMode(String portletId, User user, Layout layout, PortletMode portletMode, HttpServletRequest httpServletRequest) throws PortalException {
        LayoutClone layoutClone;
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (portletMode == null || Validator.isNull(portletMode.toString())) {
            if (layoutType.hasModeAboutPortletId(portletId)) {
                return LiferayPortletMode.ABOUT;
            }
            if (layoutType.hasModeConfigPortletId(portletId)) {
                return LiferayPortletMode.CONFIG;
            }
            if (layoutType.hasModeEditPortletId(portletId)) {
                return PortletMode.EDIT;
            }
            if (layoutType.hasModeEditDefaultsPortletId(portletId)) {
                return LiferayPortletMode.EDIT_DEFAULTS;
            }
            if (layoutType.hasModeEditGuestPortletId(portletId)) {
                return LiferayPortletMode.EDIT_GUEST;
            }
            if (layoutType.hasModeHelpPortletId(portletId)) {
                return PortletMode.HELP;
            }
            if (layoutType.hasModePreviewPortletId(portletId)) {
                return LiferayPortletMode.PREVIEW;
            }
            if (layoutType.hasModePrintPortletId(portletId)) {
                return LiferayPortletMode.PRINT;
            }
            return PortletMode.VIEW;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        Portlet portlet = PortletLocalServiceUtil.getPortletById(this.getCompanyId(httpServletRequest), portletId);
        boolean updateLayout = false;
        if (portletMode.equals((Object)LiferayPortletMode.ABOUT) && !layoutType.hasModeAboutPortletId(portletId)) {
            layoutType.addModeAboutPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.CONFIG) && !layoutType.hasModeConfigPortletId(portletId) && PortletPermissionUtil.contains(permissionChecker, this.getScopeGroupId(httpServletRequest), layout, portlet, "CONFIGURATION")) {
            layoutType.addModeConfigPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.EDIT) && !layoutType.hasModeEditPortletId(portletId) && PortletPermissionUtil.contains(permissionChecker, this.getScopeGroupId(httpServletRequest), layout, portlet, "PREFERENCES")) {
            layoutType.addModeEditPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_DEFAULTS) && !layoutType.hasModeEditDefaultsPortletId(portletId) && PortletPermissionUtil.contains(permissionChecker, this.getScopeGroupId(httpServletRequest), layout, portlet, "PREFERENCES")) {
            layoutType.addModeEditDefaultsPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.EDIT_GUEST) && !layoutType.hasModeEditGuestPortletId(portletId) && PortletPermissionUtil.contains(permissionChecker, this.getScopeGroupId(httpServletRequest), layout, portlet, "GUEST_PREFERENCES")) {
            layoutType.addModeEditGuestPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.HELP) && !layoutType.hasModeHelpPortletId(portletId)) {
            layoutType.addModeHelpPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PREVIEW) && !layoutType.hasModePreviewPortletId(portletId)) {
            layoutType.addModePreviewPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)LiferayPortletMode.PRINT) && !layoutType.hasModePrintPortletId(portletId)) {
            layoutType.addModePrintPortletId(portletId);
            updateLayout = true;
        } else if (portletMode.equals((Object)PortletMode.VIEW) && !layoutType.hasModeViewPortletId(portletId)) {
            layoutType.removeModesPortletId(portletId);
            updateLayout = true;
        } else if (this.isCustomPortletMode(portletMode) && !layoutType.hasModeCustomPortletId(portletId, portletMode.toString())) {
            layoutType.addModeCustomPortletId(portletId, portletMode.toString());
            updateLayout = true;
        }
        if (updateLayout && PortletPermissionUtil.contains(permissionChecker, this.getScopeGroupId(httpServletRequest), layout, portlet, "VIEW") && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
            layoutClone.update(httpServletRequest, layout.getPlid(), layout.getTypeSettings());
        }
        return portletMode;
    }

    @Override
    public String updateRedirect(String redirect, String oldPath, String newPath) {
        if (Validator.isNull(redirect) || oldPath == null || oldPath.equals(newPath)) {
            return redirect;
        }
        String queryString = HttpUtil.getQueryString(redirect);
        String redirectParam = HttpUtil.getParameter(redirect, "redirect", false);
        if (Validator.isNotNull(redirectParam)) {
            String newRedirectParam = StringUtil.replace(redirectParam, URLCodec.encodeURL(oldPath), URLCodec.encodeURL(newPath));
            queryString = StringUtil.replace(queryString, redirectParam, newRedirectParam);
        }
        String redirectPath = HttpUtil.getPath(redirect);
        int pos = redirect.indexOf(redirectPath);
        String prefix = redirect.substring(0, pos);
        pos = redirectPath.lastIndexOf(oldPath);
        if (pos != -1) {
            prefix = prefix + redirectPath.substring(0, pos);
            String suffix = redirectPath.substring(pos + oldPath.length());
            redirect = prefix + newPath + suffix;
        } else {
            redirect = prefix + redirectPath;
        }
        if (Validator.isNotNull(queryString)) {
            redirect = redirect + "?" + queryString;
        }
        return redirect;
    }

    @Override
    public WindowState updateWindowState(String portletId, User user, Layout layout, WindowState windowState, HttpServletRequest httpServletRequest) {
        LayoutTypePortlet layoutType = (LayoutTypePortlet)layout.getLayoutType();
        if (windowState == null || Validator.isNull(windowState.toString())) {
            windowState = layoutType.hasStateMaxPortletId(portletId) ? WindowState.MAXIMIZED : (layoutType.hasStateMinPortletId(portletId) ? WindowState.MINIMIZED : WindowState.NORMAL);
        } else {
            LayoutClone layoutClone;
            boolean updateLayout = false;
            if (windowState.equals((Object)WindowState.MAXIMIZED) && !layoutType.hasStateMaxPortletId(portletId)) {
                layoutType.addStateMaxPortletId(portletId);
                if (PropsValues.LAYOUT_REMEMBER_MAXIMIZED_WINDOW_STATE) {
                    updateLayout = true;
                }
            } else if (windowState.equals((Object)WindowState.MINIMIZED) && !layoutType.hasStateMinPortletId(portletId)) {
                layoutType.addStateMinPortletId(portletId);
                updateLayout = true;
            } else if (windowState.equals((Object)WindowState.NORMAL) && !layoutType.hasStateNormalPortletId(portletId)) {
                layoutType.removeStatesPortletId(portletId);
                updateLayout = true;
            }
            if (updateLayout && (layoutClone = LayoutCloneFactory.getInstance()) != null) {
                layoutClone.update(httpServletRequest, layout.getPlid(), layout.getTypeSettings());
            }
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        themeDisplay.setStateExclusive(windowState.equals((Object)LiferayWindowState.EXCLUSIVE));
        themeDisplay.setStateMaximized(windowState.equals((Object)WindowState.MAXIMIZED));
        themeDisplay.setStatePopUp(windowState.equals((Object)LiferayWindowState.POP_UP));
        httpServletRequest.setAttribute("WINDOW_STATE", (Object)windowState);
        return windowState;
    }

    @Deprecated
    protected void addDefaultResource(long companyId, Layout layout, Portlet portlet, boolean portletActions) throws PortalException {
        long groupId = this.getScopeGroupId(layout, portlet.getPortletId());
        this.addRootModelResource(companyId, groupId, portlet);
    }

    @Deprecated
    protected void addDefaultResource(long companyId, long groupId, Layout layout, Portlet portlet, boolean portletActions) throws PortalException {
        this.addRootModelResource(companyId, groupId, portlet);
    }

    @Deprecated
    protected void addRootModelResource(long companyId, long groupId, Portlet portlet) throws PortalException {
        String name = ResourceActionsUtil.getPortletBaseResource(portlet.getRootPortletId());
        if (Validator.isNull(name)) {
            return;
        }
        this.addRootModelResource(companyId, groupId, name);
    }

    protected void addRootModelResource(long companyId, long groupId, String name) throws PortalException {
        String primaryKey;
        int count;
        Group group = GroupLocalServiceUtil.fetchGroup(groupId);
        if (group != null && group.isStagingGroup()) {
            groupId = group.getLiveGroupId();
        }
        if ((count = ResourcePermissionLocalServiceUtil.getResourcePermissionsCount(companyId, name, 4, primaryKey = String.valueOf(groupId))) > 0) {
            return;
        }
        ResourceLocalServiceUtil.addResources(companyId, groupId, 0L, name, primaryKey, false, true, true);
    }

    @Deprecated
    protected String buildI18NPath(Locale locale) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this._buildI18NPath(languageId, locale);
    }

    protected long doGetPlidFromPortletId(long groupId, boolean privateLayout, String portletId) {
        long scopeGroupId = groupId;
        try {
            List<Layout> layouts;
            long plid;
            Group group = GroupLocalServiceUtil.getGroup(groupId);
            if (group.isLayout()) {
                Layout scopeLayout = LayoutLocalServiceUtil.getLayout(group.getClassPK());
                groupId = scopeLayout.getGroupId();
            }
            if ((plid = this.getPlidFromPortletId(layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, "portlet"), portletId, scopeGroupId)) != 0L) {
                return plid;
            }
            layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, "full_page_application");
            plid = this.getPlidFromPortletId(layouts, portletId, scopeGroupId);
            if (plid != 0L) {
                return plid;
            }
            layouts = LayoutLocalServiceUtil.getLayouts(groupId, privateLayout, "panel");
            return this.getPlidFromPortletId(layouts, portletId, scopeGroupId);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn(e, e);
            }
            return 0L;
        }
    }

    protected List<Portlet> filterControlPanelPortlets(Set<Portlet> portlets, ThemeDisplay themeDisplay) {
        ArrayList<Portlet> filteredPortlets = new ArrayList<Portlet>(portlets);
        Iterator itr = filteredPortlets.iterator();
        while (itr.hasNext()) {
            Portlet portlet = (Portlet)itr.next();
            try {
                if (portlet.isActive() && !portlet.isInstanceable() && PortletPermissionUtil.hasControlPanelAccessPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), portlet)) continue;
                itr.remove();
            }
            catch (Exception e) {
                _log.error(e, e);
                itr.remove();
            }
        }
        return filteredPortlets;
    }

    protected Set<Group> getAncestorSiteGroups(long groupId, boolean checkContentSharingWithChildrenEnabled) {
        Group siteGroup = this._getSiteGroup(groupId);
        if (siteGroup == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<Group> groups = null;
        for (Group group : siteGroup.getAncestors()) {
            if (checkContentSharingWithChildrenEnabled && !SitesUtil.isContentSharingWithChildrenEnabled(group)) continue;
            if (groups == null) {
                groups = new LinkedHashSet<Group>();
            }
            groups.add(group);
        }
        if (!siteGroup.isCompany()) {
            String cacheKey;
            ThreadLocalCache<Group> threadLocalCache = ThreadLocalCacheManager.getThreadLocalCache(Lifecycle.REQUEST, (Serializable)((Object)Company.class.getName()));
            Group companyGroup = (Group)threadLocalCache.get(cacheKey = StringUtil.toHexString(siteGroup.getCompanyId()));
            if (companyGroup == null) {
                companyGroup = GroupLocalServiceUtil.fetchCompanyGroup(siteGroup.getCompanyId());
                threadLocalCache.put(cacheKey, companyGroup);
            }
            if (companyGroup != null) {
                if (groups == null) {
                    return Collections.singleton(companyGroup);
                }
                groups.add(companyGroup);
                return groups;
            }
        }
        if (groups == null) {
            return Collections.emptySet();
        }
        return groups;
    }

    protected Locale getAvailableLocale(long groupId, Locale locale) {
        if (Validator.isNull(locale.getCountry())) {
            locale = LanguageUtil.getLocale(locale.getLanguage());
        }
        if (!LanguageUtil.isAvailableLocale(groupId, locale)) {
            return null;
        }
        return locale;
    }

    protected Layout getBrowsableLayout(Layout layout) {
        LayoutTypeController layoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(layout.getType());
        if (layoutTypeController.isBrowsable()) {
            return layout;
        }
        Layout browsableChildLayout = null;
        List<Layout> childLayouts = layout.getAllChildren();
        for (Layout childLayout : childLayouts) {
            LayoutTypeController childLayoutTypeController = LayoutTypeControllerTracker.getLayoutTypeController(childLayout.getType());
            if (!childLayoutTypeController.isBrowsable()) continue;
            browsableChildLayout = childLayout;
            break;
        }
        if (browsableChildLayout != null) {
            return browsableChildLayout;
        }
        long defaultPlid = LayoutLocalServiceUtil.getDefaultPlid(layout.getGroupId(), layout.isPrivateLayout());
        return LayoutLocalServiceUtil.fetchLayout(defaultPlid);
    }

    protected String getCanonicalDomain(String virtualHostname, String portalDomain) {
        if (Validator.isBlank(portalDomain) || StringUtil.equalsIgnoreCase(portalDomain, _LOCALHOST) || !StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST)) {
            return virtualHostname;
        }
        int pos = portalDomain.indexOf(58);
        if (pos == -1) {
            return portalDomain;
        }
        return portalDomain.substring(0, pos);
    }

    protected String getContextPath(String contextPath) {
        if ((contextPath = GetterUtil.getString(contextPath)).length() == 0 || contextPath.equals("/")) {
            contextPath = "";
        } else if (!contextPath.startsWith("/")) {
            contextPath = "/".concat(contextPath);
        }
        return contextPath;
    }

    protected Group getControlPanelDisplayGroup(Group controlPanelGroup, Group scopeGroup, long doAsGroupId, String portletId) {
        Group doAsGroup;
        Portlet portlet = PortletLocalServiceUtil.getPortletById(controlPanelGroup.getCompanyId(), portletId);
        String portletCategory = portlet.getControlPanelEntryCategory();
        if (portletCategory.equals("control_panel.apps") || portletCategory.equals("control_panel.configuration") || portletCategory.equals("control_panel.sites") || portletCategory.equals("control_panel.system") || portletCategory.equals("control_panel.users") || portletCategory.equals("control_panel.workflow") || portletCategory.equals("user.my_account")) {
            return controlPanelGroup;
        }
        if (doAsGroupId > 0L && (doAsGroup = GroupLocalServiceUtil.fetchGroup(doAsGroupId)) != null) {
            return doAsGroup;
        }
        return scopeGroup;
    }

    protected Group getControlPanelDisplayGroup(long companyId, long scopeGroupId, long doAsGroupId, String portletId) {
        return this.getControlPanelDisplayGroup(GroupLocalServiceUtil.fetchGroup(companyId, "Control Panel"), GroupLocalServiceUtil.fetchGroup(scopeGroupId), doAsGroupId, portletId);
    }

    protected Group getCurrentSiteGroup(long groupId) throws PortalException {
        Group siteGroup = this._getSiteGroup(groupId);
        if (!siteGroup.isLayoutPrototype()) {
            return siteGroup;
        }
        return null;
    }

    protected long getDoAsUserId(HttpServletRequest httpServletRequest, String doAsUserIdString, boolean alwaysAllowDoAsUser) throws Exception {
        if (Validator.isNull(doAsUserIdString)) {
            return 0L;
        }
        long doAsUserId = GetterUtil.getLong(doAsUserIdString);
        if (doAsUserId == 0L) {
            try {
                Company company = this.getCompany(httpServletRequest);
                doAsUserId = GetterUtil.getLong(Encryptor.decrypt(company.getKeyObj(), doAsUserIdString));
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Unable to impersonate " + doAsUserIdString + " because the string cannot be decrypted");
                }
                return 0L;
            }
        }
        if (_log.isDebugEnabled()) {
            if (alwaysAllowDoAsUser) {
                _log.debug("doAsUserId path or Struts action is always allowed");
            } else {
                _log.debug("doAsUserId path is Struts action not always allowed");
            }
        }
        if (alwaysAllowDoAsUser) {
            httpServletRequest.setAttribute("USER_ID", (Object)doAsUserId);
            return doAsUserId;
        }
        HttpSession session = httpServletRequest.getSession();
        Long realUserIdObj = (Long)session.getAttribute("USER_ID");
        if (realUserIdObj == null) {
            return 0L;
        }
        User doAsUser = UserLocalServiceUtil.getUserById(doAsUserId);
        long[] organizationIds = doAsUser.getOrganizationIds();
        User realUser = UserLocalServiceUtil.getUserById(realUserIdObj);
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create(realUser);
        if (doAsUser.isDefaultUser() || UserPermissionUtil.contains(permissionChecker, doAsUserId, organizationIds, "IMPERSONATE")) {
            httpServletRequest.setAttribute("USER_ID", (Object)doAsUserId);
            return doAsUserId;
        }
        _log.error(StringBundler.concat("User ", realUserIdObj, " does not have the permission to impersonate ", doAsUserId));
        return 0L;
    }

    protected String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL) throws PortalException {
        return this.getGroupFriendlyURL(layoutSet, themeDisplay, canonicalURL, false);
    }

    protected String getGroupFriendlyURL(LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL, boolean controlPanel) throws PortalException {
        Group group = themeDisplay.getSiteGroup();
        if (group.getGroupId() != layoutSet.getGroupId()) {
            group = layoutSet.getGroup();
        }
        return this._getGroupFriendlyURL(group, layoutSet, themeDisplay, canonicalURL, controlPanel);
    }

    protected String[] getGroupPermissions(String[] groupPermissions, String className, String inputPermissionsShowOptions) {
        if (groupPermissions != null || inputPermissionsShowOptions != null) {
            return groupPermissions;
        }
        List<String> groupDefaultActions = ResourceActionsUtil.getModelResourceGroupDefaultActions(className);
        return groupDefaultActions.toArray(new String[0]);
    }

    protected String[] getGuestPermissions(String[] guestPermissions, String className, String inputPermissionsShowOptions) {
        if (guestPermissions != null || inputPermissionsShowOptions != null) {
            return guestPermissions;
        }
        List<String> guestDefaultActions = ResourceActionsUtil.getModelResourceGuestDefaultActions(className);
        return guestDefaultActions.toArray(new String[0]);
    }

    protected long getPlidFromPortletId(List<Layout> layouts, String portletId, long scopeGroupId) {
        for (Layout layout : layouts) {
            LayoutTypePortlet layoutTypePortlet = (LayoutTypePortlet)layout.getLayoutType();
            if (!layoutTypePortlet.hasPortletId(portletId, true) || this.getScopeGroupId(layout, portletId) != scopeGroupId) continue;
            return layout.getPlid();
        }
        return 0L;
    }

    protected String getPortletParam(HttpServletRequest httpServletRequest, String name) {
        String portletId = ParamUtil.getString(httpServletRequest, "p_p_id");
        if (Validator.isNull(portletId)) {
            return "";
        }
        Object value = null;
        int valueCount = 0;
        String keyName = "_".concat(name);
        Map parameterMap = httpServletRequest.getParameterMap();
        for (Map.Entry entry : parameterMap.entrySet()) {
            String portletId1;
            String parameterName = (String)entry.getKey();
            int pos = parameterName.indexOf(keyName);
            if (pos == -1) continue;
            if (++valueCount > 1) {
                return "";
            }
            Object[] parameterValues = (String[])entry.getValue();
            if (ArrayUtil.isEmpty(parameterValues) || Validator.isNull((String)parameterValues[0]) || !portletId.equals(portletId1 = parameterName.substring(1, pos))) continue;
            value = parameterValues[0];
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    protected String getServletURL(Portlet portlet, String servletPath, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = themeDisplay.getLayout();
        StringBundler sb = new StringBundler(9);
        sb.append(themeDisplay.getPortalURL());
        if (Validator.isNotNull(this._pathContext)) {
            sb.append(this._pathContext);
        }
        if (themeDisplay.isI18n()) {
            sb.append(themeDisplay.getI18nPath());
        }
        sb.append(servletPath);
        Group group = layout.getGroup();
        if (layout.isPrivateLayout()) {
            if (group.isUser()) {
                sb.append(_PRIVATE_USER_SERVLET_MAPPING);
            } else {
                sb.append(_PRIVATE_GROUP_SERVLET_MAPPING);
            }
        } else {
            sb.append(_PUBLIC_GROUP_SERVLET_MAPPING);
        }
        sb.append(group.getFriendlyURL());
        sb.append(themeDisplay.getLayoutFriendlyURL(layout));
        sb.append("/-/");
        FriendlyURLMapper friendlyURLMapper = portlet.getFriendlyURLMapperInstance();
        if (friendlyURLMapper != null && !portlet.isInstanceable()) {
            sb.append(friendlyURLMapper.getMapping());
        } else {
            sb.append(portlet.getPortletId());
        }
        return sb.toString();
    }

    protected boolean isAlwaysAllowDoAsUser(HttpServletRequest httpServletRequest) throws Exception {
        String ticketKey = ParamUtil.getString(httpServletRequest, "ticketKey");
        if (Validator.isNull(ticketKey)) {
            return false;
        }
        Ticket ticket = TicketLocalServiceUtil.fetchTicket(ticketKey);
        if (ticket == null || ticket.getType() != 2) {
            return false;
        }
        String className = ticket.getClassName();
        if (!className.equals(User.class.getName())) {
            return false;
        }
        long doAsUserId = 0L;
        try {
            String doAsUserIdString = ParamUtil.getString(httpServletRequest, "doAsUserId");
            if (Validator.isNotNull(doAsUserIdString)) {
                Company company = this.getCompany(httpServletRequest);
                doAsUserId = GetterUtil.getLong(Encryptor.decrypt(company.getKeyObj(), doAsUserIdString));
            }
        }
        catch (Exception e) {
            return false;
        }
        if (ticket.getClassPK() != doAsUserId) {
            return false;
        }
        if (ticket.isExpired()) {
            TicketLocalServiceUtil.deleteTicket(ticket);
            return false;
        }
        Date expirationDate = new Date(System.currentTimeMillis() + (long)PropsValues.SESSION_TIMEOUT * 60000L);
        ticket.setExpirationDate(expirationDate);
        TicketLocalServiceUtil.updateTicket(ticket);
        return true;
    }

    protected boolean isAlwaysAllowDoAsUser(String actionName, String mvcRenderCommandName, String path, String strutsAction) {
        for (AlwaysAllowDoAsUser alwaysAllowDoAsUser : this._alwaysAllowDoAsUsers) {
            Collection<String> actionNames = alwaysAllowDoAsUser.getActionNames();
            if (actionNames.contains(actionName)) {
                return true;
            }
            Collection<String> mvcRenderCommandNames = alwaysAllowDoAsUser.getMVCRenderCommandNames();
            if (mvcRenderCommandNames.contains(mvcRenderCommandName)) {
                return true;
            }
            Collection<String> paths = alwaysAllowDoAsUser.getPaths();
            if (paths.contains(path)) {
                return true;
            }
            Collection<String> strutsActions = alwaysAllowDoAsUser.getStrutsActions();
            if (!strutsActions.contains(strutsAction)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnwrapRequest(String currentRequestClassName) {
        for (String packageName : PropsValues.REQUEST_UNWRAP_PACKAGES) {
            if (!currentRequestClassName.startsWith(packageName)) continue;
            return true;
        }
        return false;
    }

    protected boolean isValidPortalDomain(long companyId, String domain) {
        if (this._validPortalDomainCheckDisabled) {
            return true;
        }
        if (!Validator.isHostName(domain)) {
            return false;
        }
        for (String virtualHost : PropsValues.VIRTUAL_HOSTS_VALID_HOSTS) {
            if (!StringUtil.equalsIgnoreCase(domain, virtualHost) && !StringUtil.wildcardMatches(domain, virtualHost, '?', '*', '%', false)) continue;
            return true;
        }
        if (StringUtil.equalsIgnoreCase(domain, PropsValues.WEB_SERVER_HOST)) {
            return true;
        }
        if (this.isValidVirtualHostname(domain)) {
            return true;
        }
        if (StringUtil.equalsIgnoreCase(domain, this.getCDNHostHttp(companyId))) {
            return true;
        }
        return StringUtil.equalsIgnoreCase(domain, this.getCDNHostHttps(companyId));
    }

    protected boolean isValidPortalDomain(String domain) {
        long companyId = CompanyThreadLocal.getCompanyId();
        return this.isValidPortalDomain(companyId, domain);
    }

    protected boolean isValidVirtualHostname(String virtualHostname) {
        try {
            virtualHostname = StringUtil.toLowerCase(virtualHostname.trim());
            VirtualHost virtualHost = VirtualHostLocalServiceUtil.fetchVirtualHost(virtualHostname);
            if (virtualHost != null) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void notifyPortalInetSocketAddressEventListeners(InetSocketAddress inetSocketAddress, boolean local, boolean secure) {
        for (PortalInetSocketAddressEventListener portalInetSocketAddressEventListener : this._portalInetSocketAddressEventListeners) {
            if (local) {
                portalInetSocketAddressEventListener.portalLocalInetSocketAddressConfigured(inetSocketAddress, secure);
                continue;
            }
            portalInetSocketAddressEventListener.portalServerInetSocketAddressConfigured(inetSocketAddress, secure);
        }
    }

    protected String removeRedirectParameter(String url) {
        String queryString = HttpUtil.getQueryString(url);
        Map<String, String[]> parameterMap = HttpUtil.getParameterMap(queryString);
        for (String parameter : parameterMap.keySet()) {
            if (!parameter.endsWith("redirect")) continue;
            url = HttpUtil.removeParameter(url, parameter);
        }
        return url;
    }

    protected void resetThemeDisplayI18n(ThemeDisplay themeDisplay, String languageId, String path, Locale locale) {
        themeDisplay.setI18nLanguageId(languageId);
        themeDisplay.setI18nPath(path);
        themeDisplay.setLocale(locale);
    }

    protected void setLocale(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Locale locale) {
        HttpSession session = httpServletRequest.getSession();
        session.setAttribute("LOCALE", (Object)locale);
        LanguageUtil.updateCookie(httpServletRequest, httpServletResponse, locale);
    }

    protected void setThemeDisplayI18n(ThemeDisplay themeDisplay, Locale locale) {
        String i18nPath = null;
        Set<String> languageIds = I18nFilter.getLanguageIds();
        if (languageIds.contains(locale.toString()) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 1 && !locale.equals(LocaleUtil.getDefault()) || PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2) {
            i18nPath = this._buildI18NPath(locale, themeDisplay.getSiteGroup());
        }
        themeDisplay.setI18nLanguageId(locale.toString());
        themeDisplay.setI18nPath(i18nPath);
        themeDisplay.setLocale(locale);
    }

    private String _buildI18NPath(Locale locale, Group group) {
        String languageId = LocaleUtil.toLanguageId(locale);
        return this._buildI18NPath(languageId, locale, group);
    }

    private String _buildI18NPath(String languageId, Locale locale) {
        if (Validator.isNull(languageId)) {
            return null;
        }
        if (LanguageUtil.isDuplicateLanguageCode(locale.getLanguage())) {
            Locale priorityLocale = LanguageUtil.getLocale(locale.getLanguage());
            if (locale.equals(priorityLocale)) {
                languageId = locale.getLanguage();
            }
        } else {
            languageId = locale.getLanguage();
        }
        return "/".concat(languageId);
    }

    private String _buildI18NPath(String languageId, Locale locale, Group group) {
        Locale siteDefaultLocale;
        block6: {
            if (Validator.isNull(languageId)) {
                return null;
            }
            siteDefaultLocale = null;
            try {
                siteDefaultLocale = this.getSiteDefaultLocale(group);
                if (!LanguageUtil.isSameLanguage(locale, siteDefaultLocale)) {
                    siteDefaultLocale = LanguageUtil.getLocale(group.getGroupId(), locale.getLanguage());
                }
            }
            catch (Exception e) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Unable to get default locale from group: " + group.getGroupId() + ".  Using portal defaults.");
                }
                if (LanguageUtil.isSameLanguage(locale, siteDefaultLocale = LocaleUtil.getDefault())) break block6;
                siteDefaultLocale = LanguageUtil.getLocale(locale.getLanguage());
            }
        }
        String siteDefaultLanguageId = LanguageUtil.getLanguageId(siteDefaultLocale);
        if (siteDefaultLanguageId.startsWith(languageId)) {
            languageId = siteDefaultLocale.getLanguage();
        }
        return "/".concat(languageId);
    }

    private Map<Locale, String> _getAlternateURLs(String canonicalURL, ThemeDisplay themeDisplay, Layout layout, Set<Locale> availableLocales) throws PortalException {
        String i18nPath;
        int y;
        String portalDomain;
        String virtualHostname = this.getVirtualHostname(themeDisplay.getLayoutSet());
        if (Validator.isNull(virtualHostname)) {
            Company company = themeDisplay.getCompany();
            virtualHostname = company.getVirtualHostname();
        }
        if (!Validator.isBlank(portalDomain = themeDisplay.getPortalDomain()) && !StringUtil.equalsIgnoreCase(portalDomain, _LOCALHOST) && StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST)) {
            virtualHostname = portalDomain;
        }
        HashMap<Locale, String> alternateURLs = new HashMap<Locale, String>();
        if (Validator.isNull(virtualHostname)) {
            for (Locale locale : availableLocales) {
                String i18nPath2 = this._buildI18NPath(locale, themeDisplay.getSiteGroup());
                alternateURLs.put(locale, canonicalURL.replaceFirst(_PUBLIC_GROUP_SERVLET_MAPPING, i18nPath2.concat(_PUBLIC_GROUP_SERVLET_MAPPING)));
            }
            return alternateURLs;
        }
        int pos = canonicalURL.indexOf(virtualHostname);
        if (pos > 0) {
            pos = canonicalURL.indexOf(47, pos + virtualHostname.length());
            if (Validator.isNotNull(this._pathContext)) {
                pos = canonicalURL.indexOf(47, pos + this._pathContext.length());
            }
        }
        if (pos <= 0 || pos >= canonicalURL.length()) {
            for (Locale locale : availableLocales) {
                alternateURLs.put(locale, canonicalURL.concat(this._buildI18NPath(locale, themeDisplay.getSiteGroup())));
            }
            return alternateURLs;
        }
        boolean replaceFriendlyURL = true;
        String currentURL = canonicalURL.substring(pos);
        int[] friendlyURLIndex = this.getGroupFriendlyURLIndex(currentURL);
        if (friendlyURLIndex != null && (currentURL = currentURL.substring(y = friendlyURLIndex[1])).equals("/")) {
            replaceFriendlyURL = false;
        }
        Locale siteDefaultLocale = this.getSiteDefaultLocale(layout.getGroupId());
        List<LayoutFriendlyURL> layoutFriendlyURLs = null;
        String groupFriendlyURLPrefix = null;
        if (replaceFriendlyURL) {
            layoutFriendlyURLs = LayoutFriendlyURLLocalServiceUtil.getLayoutFriendlyURLs(layout.getPlid());
            if (layout instanceof VirtualLayout) {
                VirtualLayout virtualLayout = (VirtualLayout)layout;
                layout = virtualLayout.getSourceLayout();
                Group group = layout.getGroup();
                groupFriendlyURLPrefix = "/~".concat(group.getFriendlyURL());
            }
        }
        String canonicalURLPrefix = canonicalURL.substring(0, pos);
        String canonicalURLSuffix = canonicalURL.substring(pos);
        if (PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE == 2 && canonicalURLSuffix.startsWith(i18nPath = this._buildI18NPath(siteDefaultLocale, layout.getGroup()))) {
            canonicalURLSuffix = canonicalURLSuffix.substring(i18nPath.length());
        }
        for (Locale locale : availableLocales) {
            String alternateURL = canonicalURL;
            String alternateURLSuffix = canonicalURLSuffix;
            String languageId = LocaleUtil.toLanguageId(locale);
            if (replaceFriendlyURL) {
                String friendlyURL = null;
                for (LayoutFriendlyURL layoutFriendlyURL : layoutFriendlyURLs) {
                    if (!languageId.equals(layoutFriendlyURL.getLanguageId())) continue;
                    friendlyURL = layoutFriendlyURL.getFriendlyURL();
                    if (groupFriendlyURLPrefix == null) break;
                    friendlyURL = groupFriendlyURLPrefix.concat(friendlyURL);
                    break;
                }
                if (friendlyURL != null) {
                    alternateURLSuffix = StringUtil.replaceFirst(alternateURLSuffix, layout.getFriendlyURL(), friendlyURL);
                }
                alternateURL = canonicalURLPrefix.concat(alternateURLSuffix);
            }
            if (siteDefaultLocale.equals(locale) && PropsValues.LOCALE_PREPEND_FRIENDLY_URL_STYLE != 2) {
                alternateURLs.put(locale, alternateURL);
                continue;
            }
            alternateURLs.put(locale, canonicalURLPrefix.concat(this._buildI18NPath(languageId, locale, themeDisplay.getSiteGroup())).concat(alternateURLSuffix));
        }
        return alternateURLs;
    }

    private String _getGroupFriendlyURL(Group group, LayoutSet layoutSet, ThemeDisplay themeDisplay, boolean canonicalURL, boolean controlPanel) throws PortalException {
        Layout refererLayout;
        long refererPlid;
        boolean privateLayoutSet = layoutSet.isPrivateLayout();
        String portalURL = themeDisplay.getPortalURL();
        boolean useGroupVirtualHostName = false;
        if (canonicalURL || !StringUtil.equalsIgnoreCase(themeDisplay.getServerName(), _LOCALHOST)) {
            useGroupVirtualHostName = true;
        }
        if ((refererPlid = themeDisplay.getRefererPlid()) > 0L && (refererLayout = LayoutLocalServiceUtil.fetchLayout(refererPlid)) != null && (refererLayout.getGroupId() != group.getGroupId() || refererLayout.isPrivateLayout() != privateLayoutSet)) {
            useGroupVirtualHostName = false;
        }
        if (useGroupVirtualHostName) {
            String virtualHostname = this.getVirtualHostname(layoutSet);
            String portalDomain = themeDisplay.getPortalDomain();
            if (Validator.isNotNull(virtualHostname) && (canonicalURL || !StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST))) {
                if (!controlPanel) {
                    if (canonicalURL) {
                        String path = "";
                        if (themeDisplay.isWidget()) {
                            path = PropsValues.WIDGET_SERVLET_MAPPING;
                        }
                        if (!StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST) && !this._isSameHostName(virtualHostname, portalDomain)) {
                            portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                        }
                        return portalURL.concat(this._pathContext).concat(path);
                    }
                    if (this._isSameHostName(virtualHostname, portalDomain) && (virtualHostname.equals(layoutSet.getVirtualHostname()) || PropsValues.VIRTUAL_HOSTS_DEFAULT_SITE_NAME.equals(group.getGroupKey()))) {
                        String path = "";
                        if (themeDisplay.isWidget()) {
                            path = PropsValues.WIDGET_SERVLET_MAPPING;
                        }
                        if (themeDisplay.isI18n()) {
                            path = themeDisplay.getI18nPath();
                        }
                        return portalURL.concat(this._pathContext).concat(path);
                    }
                }
            } else if (canonicalURL || layoutSet.getGroupId() != themeDisplay.getSiteGroupId() && group.getClassPK() != themeDisplay.getUserId()) {
                if ((group.isControlPanel() || controlPanel) && (Validator.isNull(virtualHostname = themeDisplay.getServerName()) || StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST))) {
                    LayoutSet curLayoutSet = LayoutSetLocalServiceUtil.getLayoutSet(themeDisplay.getSiteGroupId(), privateLayoutSet);
                    virtualHostname = curLayoutSet.getVirtualHostname();
                }
                if (Validator.isNull(virtualHostname) || StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST)) {
                    Company company = themeDisplay.getCompany();
                    virtualHostname = company.getVirtualHostname();
                }
                if (canonicalURL || !StringUtil.equalsIgnoreCase(virtualHostname, _LOCALHOST)) {
                    virtualHostname = this.getCanonicalDomain(virtualHostname, portalDomain);
                    portalURL = this.getPortalURL(virtualHostname, themeDisplay.getServerPort(), themeDisplay.isSecure());
                }
            }
        }
        String friendlyURL = null;
        friendlyURL = privateLayoutSet ? (group.isUser() ? _PRIVATE_USER_SERVLET_MAPPING : _PRIVATE_GROUP_SERVLET_MAPPING) : _PUBLIC_GROUP_SERVLET_MAPPING;
        StringBundler sb = new StringBundler(6);
        sb.append(portalURL);
        sb.append(this._pathContext);
        if (themeDisplay.isI18n() && !canonicalURL) {
            sb.append(themeDisplay.getI18nPath());
        }
        if (themeDisplay.isWidget()) {
            sb.append(PropsValues.WIDGET_SERVLET_MAPPING);
        }
        sb.append(friendlyURL);
        sb.append(group.getFriendlyURL());
        return sb.toString();
    }

    private String _getPortalURL(String serverName, int serverPort, boolean secure) {
        StringBundler sb = new StringBundler(4);
        boolean https = false;
        if (secure || StringUtil.equalsIgnoreCase("https", PropsValues.WEB_SERVER_PROTOCOL)) {
            https = true;
        }
        if (https) {
            sb.append("https://");
        } else {
            sb.append("http://");
        }
        sb.append(serverName);
        if (!https) {
            if (PropsValues.WEB_SERVER_HTTP_PORT == -1) {
                if (serverPort != -1 && serverPort != 80 && serverPort != 443) {
                    sb.append(":");
                    sb.append(serverPort);
                }
            } else if (PropsValues.WEB_SERVER_HTTP_PORT != 80) {
                sb.append(":");
                sb.append(PropsValues.WEB_SERVER_HTTP_PORT);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT == -1) {
            if (serverPort != -1 && serverPort != 80 && serverPort != 443) {
                sb.append(":");
                sb.append(serverPort);
            }
        } else if (PropsValues.WEB_SERVER_HTTPS_PORT != 443) {
            sb.append(":");
            sb.append(PropsValues.WEB_SERVER_HTTPS_PORT);
        }
        return sb.toString();
    }

    private String _getPortletTitle(String rootPortletId, PortletConfig portletConfig, Locale locale) {
        ResourceBundle resourceBundle = portletConfig.getResourceBundle(locale);
        String portletTitle = LanguageUtil.get(resourceBundle, "javax.portlet.title".concat(".").concat(rootPortletId), null);
        if (Validator.isNull(portletTitle)) {
            portletTitle = LanguageUtil.get(resourceBundle, "javax.portlet.title");
        }
        return portletTitle;
    }

    private long _getScopeGroupId(ThemeDisplay themeDisplay, Layout layout, String portletId) {
        if (layout == null) {
            return 0L;
        }
        if (Validator.isNull(portletId)) {
            return layout.getGroupId();
        }
        try {
            PortletPreferences portletSetup = null;
            portletSetup = themeDisplay == null ? PortletPreferencesFactoryUtil.getStrictLayoutPortletSetup(layout, portletId) : themeDisplay.getStrictLayoutPortletSetup(layout, portletId);
            String scopeType = GetterUtil.getString(portletSetup.getValue("lfrScopeType", null));
            if (Validator.isNull(scopeType)) {
                return layout.getGroupId();
            }
            if (scopeType.equals("company")) {
                Group companyGroup = GroupLocalServiceUtil.getCompanyGroup(layout.getCompanyId());
                return companyGroup.getGroupId();
            }
            String scopeLayoutUuid = GetterUtil.getString(portletSetup.getValue("lfrScopeLayoutUuid", null));
            Layout scopeLayout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId(scopeLayoutUuid, layout.getGroupId(), layout.isPrivateLayout());
            Group scopeGroup = scopeLayout.getScopeGroup();
            return scopeGroup.getGroupId();
        }
        catch (Exception e) {
            return layout.getGroupId();
        }
    }

    private String _getSiteAdminURL(String portalURL, Group group, String ppid, Map<String, String[]> params) throws PortalException {
        StringBundler sb = new StringBundler(7);
        sb.append(portalURL);
        sb.append(this.getPathFriendlyURLPrivateGroup());
        if (group != null && !group.isControlPanel()) {
            sb.append(group.getFriendlyURL());
            sb.append("/~");
        }
        sb.append("/control_panel");
        sb.append(PropsValues.CONTROL_PANEL_LAYOUT_FRIENDLY_URL);
        params = params != null ? new LinkedHashMap<String, String[]>(params) : new LinkedHashMap<String, String[]>();
        if (Validator.isNotNull(ppid)) {
            params.put("p_p_id", new String[]{ppid});
        }
        params.put("p_p_lifecycle", new String[]{"0"});
        params.put("p_p_state", new String[]{WindowState.MAXIMIZED.toString()});
        params.put("p_p_mode", new String[]{PortletMode.VIEW.toString()});
        sb.append(HttpUtil.parameterMapToString(params, true));
        return sb.toString();
    }

    private Group _getSiteGroup(long groupId) {
        if (groupId <= 0L) {
            return null;
        }
        Group group = GroupLocalServiceUtil.fetchGroup(groupId);
        if (group == null) {
            return null;
        }
        if (group.isLayout()) {
            return group.getParentGroup();
        }
        return group;
    }

    private boolean _isSameHostName(String virtualHostName, String portalDomain) {
        int pos = portalDomain.indexOf(58);
        if (pos > 0) {
            return virtualHostName.regionMatches(0, portalDomain, 0, pos);
        }
        return virtualHostName.equals(portalDomain);
    }

    static {
        _PRIVATE_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_GROUP_SERVLET_MAPPING;
        _PRIVATE_USER_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PRIVATE_USER_SERVLET_MAPPING;
        _PUBLIC_GROUP_SERVLET_MAPPING = PropsValues.LAYOUT_FRIENDLY_URL_PUBLIC_SERVLET_MAPPING;
        _log = LogFactoryUtil.getLog(PortalImpl.class);
        _bannedResourceIdPattern = Pattern.compile(PropsValues.PORTLET_RESOURCE_ID_BANNED_PATHS_REGEXP, 2);
        _cdnHostHttpMap = new ConcurrentHashMap<Long, String>();
        _cdnHostHttpsMap = new ConcurrentHashMap<Long, String>();
        _resetCDNHostsMethodHandler = new MethodHandler(new MethodKey(PortalUtil.class, "resetCDNHosts", new Class[0]), new Object[0]);
        _upTime = new Date();
        Locale locale = LocaleUtil.getDefault();
        _NULL_LOCALE = (Locale)locale.clone();
    }

    private class PortalInetSocketAddressEventListenerServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<PortalInetSocketAddressEventListener, PortalInetSocketAddressEventListener> {
        private PortalInetSocketAddressEventListenerServiceTrackerCustomizer() {
        }

        @Override
        public PortalInetSocketAddressEventListener addingService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            PortalInetSocketAddressEventListener portalInetSocketAddressEventListener = registry.getService(serviceReference);
            PortalImpl.this.addPortalInetSocketAddressEventListener(portalInetSocketAddressEventListener);
            return portalInetSocketAddressEventListener;
        }

        @Override
        public void modifiedService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference, PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
        }

        @Override
        public void removedService(ServiceReference<PortalInetSocketAddressEventListener> serviceReference, PortalInetSocketAddressEventListener portalInetSocketAddressEventListener) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            PortalImpl.this.removePortalInetSocketAddressEventListener(portalInetSocketAddressEventListener);
        }
    }

    private class CommentsStrutsActionServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<StrutsAction, StrutsAction> {
        private CommentsStrutsActionServiceTrackerCustomizer() {
        }

        @Override
        public StrutsAction addingService(ServiceReference<StrutsAction> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            String path = GetterUtil.getString(serviceReference.getProperty("path"));
            StrutsAction strutsAction = registry.getService(serviceReference);
            if (Objects.equals(path, "/portal/comment/discussion/edit")) {
                PortalImpl.this._editDiscussionStrutsAction = strutsAction;
            } else if (Objects.equals(path, "/portal/comment/discussion/get_comments")) {
                PortalImpl.this._getCommentsStrutsAction = strutsAction;
            }
            return strutsAction;
        }

        @Override
        public void modifiedService(ServiceReference<StrutsAction> serviceReference, StrutsAction strutsAction) {
            this.removedService(serviceReference, strutsAction);
            this.addingService((ServiceReference)serviceReference);
        }

        @Override
        public void removedService(ServiceReference<StrutsAction> serviceReference, StrutsAction strutsAction) {
            Registry registry = RegistryUtil.getRegistry();
            String path = GetterUtil.getString(serviceReference.getProperty("path"));
            if (Objects.equals(path, "/portal/comment/discussion/edit")) {
                PortalImpl.this._editDiscussionStrutsAction = null;
            } else if (Objects.equals(path, "/portal/comment/discussion/get_comments")) {
                PortalImpl.this._getCommentsStrutsAction = null;
            }
            registry.ungetService(serviceReference);
        }
    }

    private class AlwaysAllowDoAsUserServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<AlwaysAllowDoAsUser, AlwaysAllowDoAsUser> {
        private AlwaysAllowDoAsUserServiceTrackerCustomizer() {
        }

        @Override
        public AlwaysAllowDoAsUser addingService(ServiceReference<AlwaysAllowDoAsUser> serviceReference) {
            Registry registry = RegistryUtil.getRegistry();
            AlwaysAllowDoAsUser alwaysAllowDoAsUser = registry.getService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug("Add alway sallow do as user " + ClassUtil.getClassName(alwaysAllowDoAsUser));
            }
            PortalImpl.this._alwaysAllowDoAsUsers.add(alwaysAllowDoAsUser);
            if (_log.isDebugEnabled()) {
                _log.debug("There are " + PortalImpl.this._alwaysAllowDoAsUsers.size() + " alway sallow do as user instances");
            }
            return alwaysAllowDoAsUser;
        }

        @Override
        public void modifiedService(ServiceReference<AlwaysAllowDoAsUser> serviceReference, AlwaysAllowDoAsUser alwaysAllowDoAsUser) {
        }

        @Override
        public void removedService(ServiceReference<AlwaysAllowDoAsUser> serviceReference, AlwaysAllowDoAsUser alwaysAllowDoAsUser) {
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
            if (_log.isDebugEnabled()) {
                _log.debug("Delete alway sallow do as user " + ClassUtil.getClassName(alwaysAllowDoAsUser));
            }
            PortalImpl.this._alwaysAllowDoAsUsers.remove(alwaysAllowDoAsUser);
            if (_log.isDebugEnabled()) {
                _log.debug("There are " + PortalImpl.this._alwaysAllowDoAsUsers.size() + " alway sallow do as user instances");
            }
        }
    }
}

