/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.io.CloseShieldInputStream;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReaderMetKeys;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class MimeTypesImpl
implements com.liferay.portal.kernel.util.MimeTypes,
MimeTypesReaderMetKeys {
    private static final Log _log = LogFactoryUtil.getLog(MimeTypesImpl.class);
    private final Map<String, Set<String>> _customExtensionsMap = new HashMap<String, Set<String>>();
    private final Detector _detector;
    private final Map<String, Set<String>> _extensionsMap = new HashMap<String, Set<String>>();
    private final Set<String> _webImageMimeTypes;

    public MimeTypesImpl() {
        this._detector = new DefaultDetector(MimeTypes.getDefaultMimeTypes());
        this._webImageMimeTypes = SetUtil.fromArray(PropsValues.MIME_TYPES_WEB_IMAGES);
    }

    public void afterPropertiesSet() {
        URL url = MimeTypes.class.getResource("tika-mimetypes.xml");
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        URL customMimeTypesUrl = classLoader.getResource("tika/custom-mimetypes.xml");
        try {
            this.read(url.openStream(), this._extensionsMap);
            this.read(customMimeTypesUrl.openStream(), this._customExtensionsMap);
        }
        catch (Exception e) {
            _log.error("Unable to populate extensions map", e);
        }
    }

    @Override
    public String getContentType(File file) {
        return this.getContentType(file, file.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getContentType(File file, String fileName) {
        if (file == null) return this.getContentType(fileName);
        if (!file.exists()) {
            return this.getContentType(fileName);
        }
        try (TikaInputStream is = TikaInputStream.get((File)file);){
            String string = this.getContentType((InputStream)is, fileName);
            return string;
        }
        catch (IOException ioe) {
            if (!_log.isWarnEnabled()) return this.getContentType(fileName);
            _log.warn(ioe, ioe);
            return this.getContentType(fileName);
        }
    }

    @Override
    public String getContentType(InputStream inputStream, String fileName) {
        if (inputStream == null) {
            return this.getContentType(fileName);
        }
        String contentType = null;
        try (TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)new CloseShieldInputStream(inputStream));){
            String extension = FileUtil.getExtension(fileName);
            contentType = this.getCustomContentType(extension);
            if ("application/octet-stream".equals(contentType)) {
                Metadata metadata = new Metadata();
                metadata.set("resourceName", fileName);
                MediaType mediaType = this._detector.detect((InputStream)tikaInputStream, metadata);
                contentType = mediaType.toString();
            }
            if (contentType.contains("tika")) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Retrieved invalid content type " + contentType);
                }
                contentType = this.getContentType(fileName);
            }
            if (contentType.contains("tika")) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Retrieved invalid content type " + contentType);
                }
                contentType = "application/octet-stream";
            }
        }
        catch (Exception e) {
            _log.error(e, e);
            contentType = "application/octet-stream";
        }
        return contentType;
    }

    @Override
    public String getContentType(String fileName) {
        if (Validator.isNull(fileName)) {
            return "application/octet-stream";
        }
        String contentType = null;
        try {
            String extension = FileUtil.getExtension(fileName);
            contentType = this.getCustomContentType(extension);
            if ("application/octet-stream".equals(contentType)) {
                Metadata metadata = new Metadata();
                metadata.set("resourceName", fileName);
                MediaType mediaType = this._detector.detect(null, metadata);
                contentType = mediaType.toString();
            }
            if (!contentType.contains("tika")) {
                return contentType;
            }
            if (_log.isDebugEnabled()) {
                _log.debug("Retrieved invalid content type " + contentType);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        return "application/octet-stream";
    }

    @Override
    public String getExtensionContentType(String extension) {
        if (Validator.isNull(extension)) {
            return "application/octet-stream";
        }
        return this.getContentType("A.".concat(extension));
    }

    @Override
    public Set<String> getExtensions(String contentType) {
        Set<String> extensions = this._extensionsMap.get(contentType);
        if (extensions == null) {
            extensions = Collections.emptySet();
        }
        return extensions;
    }

    @Override
    public boolean isWebImage(String mimeType) {
        return this._webImageMimeTypes.contains(mimeType);
    }

    protected String getCustomContentType(String extension) {
        if (Validator.isNull(extension)) {
            return "application/octet-stream";
        }
        for (Map.Entry<String, Set<String>> entry : this._customExtensionsMap.entrySet()) {
            Set<String> set = entry.getValue();
            if (!set.contains(".".concat(extension))) continue;
            return entry.getKey();
        }
        return "application/octet-stream";
    }

    @Deprecated
    protected void read(InputStream stream) throws Exception {
        this.read(stream, this._extensionsMap);
    }

    protected void read(InputStream stream, Map<String, Set<String>> extensionsMap) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(new InputSource(stream));
        Element element = document.getDocumentElement();
        if (element == null || !"mime-info".equals(element.getTagName())) {
            throw new SystemException("Invalid configuration file");
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element childElement;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1 || !"mime-type".equals((childElement = (Element)node).getTagName())) continue;
            this.readMimeType(childElement, extensionsMap);
        }
    }

    @Deprecated
    protected void readMimeType(Element element) {
        this.readMimeType(element, this._extensionsMap);
    }

    protected void readMimeType(Element element, Map<String, Set<String>> extensionsMap) {
        HashSet<String> mimeTypes = new HashSet<String>();
        HashSet<String> extensions = new HashSet<String>();
        String name = element.getAttribute("type");
        mimeTypes.add(name);
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String extension;
            String pattern;
            boolean regex;
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element childElement = (Element)node;
            if ("alias".equals(childElement.getTagName())) {
                String alias = childElement.getAttribute("type");
                mimeTypes.add(alias);
                continue;
            }
            if (!"glob".equals(childElement.getTagName()) || (regex = GetterUtil.getBoolean(childElement.getAttribute("isregex"))) || !(pattern = childElement.getAttribute("pattern")).startsWith("*") || (extension = pattern.substring(1)).contains("*") || extension.contains("?") || extension.contains("[")) continue;
            extensions.add(extension);
        }
        for (String mimeType : mimeTypes) {
            extensionsMap.put(mimeType, extensions);
        }
    }
}

