/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.util.MethodParameter;
import com.liferay.portal.kernel.util.MethodParametersResolver;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentMap;
import jodd.paramo.Paramo;

public class MethodParametersResolverImpl
implements MethodParametersResolver {
    private static final ConcurrentMap<AccessibleObject, MethodParameter[]> _methodParameters = new ConcurrentReferenceKeyHashMap<AccessibleObject, MethodParameter[]>(FinalizeManager.WEAK_REFERENCE_FACTORY);

    @Override
    public MethodParameter[] resolveMethodParameters(Method method) {
        MethodParameter[] methodParameters = (MethodParameter[])_methodParameters.get(method);
        if (methodParameters != null) {
            return methodParameters;
        }
        Class<?> clazz = method.getDeclaringClass();
        ClassLoader classLoader = clazz.getClassLoader();
        Class<?>[] methodParameterTypes = method.getParameterTypes();
        jodd.paramo.MethodParameter[] joddMethodParameters = Paramo.resolveParameters((AccessibleObject)method);
        methodParameters = new MethodParameter[joddMethodParameters.length];
        for (int i = 0; i < joddMethodParameters.length; ++i) {
            methodParameters[i] = new MethodParameter(classLoader, joddMethodParameters[i].getName(), joddMethodParameters[i].getSignature(), methodParameterTypes[i]);
        }
        _methodParameters.put(method, methodParameters);
        return methodParameters;
    }
}

