/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.persistence.LayoutUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import javax.servlet.http.HttpServletRequest;

public class LayoutURLUtil {
    public static String getLayoutURL(Layout layout, ServiceContext serviceContext) {
        HttpServletRequest httpServletRequest = serviceContext.getRequest();
        if (httpServletRequest == null) {
            return "";
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        try {
            return PortalUtil.getLayoutURL(layout, themeDisplay, false);
        }
        catch (Exception e) {
            return "";
        }
    }

    public static String getLayoutURL(long groupId, String portletId, ServiceContext serviceContext) throws PortalException {
        long controlPanelPlid;
        long plid = serviceContext.getPlid();
        if (plid == (controlPanelPlid = PortalUtil.getControlPanelPlid(serviceContext.getCompanyId()))) {
            plid = PortalUtil.getPlidFromPortletId(groupId, portletId);
        }
        String layoutURL = "";
        if (plid != 0L) {
            Layout layout = LayoutUtil.findByPrimaryKey(plid);
            layoutURL = LayoutURLUtil.getLayoutURL(layout, serviceContext);
        }
        return layoutURL;
    }
}

