/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.layouts.admin.kernel.util.SitemapURLProvider;
import com.liferay.layouts.admin.kernel.util.SitemapUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.model.LayoutTypeController;
import com.liferay.portal.kernel.service.LayoutLocalServiceUtil;
import com.liferay.portal.kernel.spring.osgi.OSGiBeanProperties;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.util.LayoutTypeControllerTracker;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@OSGiBeanProperties
public class LayoutSitemapURLProvider
implements SitemapURLProvider {
    @Override
    public String getClassName() {
        return Layout.class.getName();
    }

    @Override
    public void visitLayout(Element element, String layoutUuid, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        Layout layout = LayoutLocalServiceUtil.getLayoutByUuidAndGroupId(layoutUuid, layoutSet.getGroupId(), layoutSet.isPrivateLayout());
        this.visitLayout(element, layout, themeDisplay);
    }

    @Override
    public void visitLayoutSet(Element element, LayoutSet layoutSet, ThemeDisplay themeDisplay) throws PortalException {
        if (layoutSet.isPrivateLayout()) {
            return;
        }
        Map<String, LayoutTypeController> layoutTypeControllers = LayoutTypeControllerTracker.getLayoutTypeControllers();
        for (Map.Entry<String, LayoutTypeController> entry : layoutTypeControllers.entrySet()) {
            LayoutTypeController layoutTypeController = entry.getValue();
            if (!layoutTypeController.isSitemapable()) continue;
            List<Layout> layouts = LayoutLocalServiceUtil.getLayouts(layoutSet.getGroupId(), layoutSet.isPrivateLayout(), entry.getKey());
            for (Layout layout : layouts) {
                this.visitLayout(element, layout, themeDisplay);
            }
        }
    }

    protected void visitLayout(Element element, Layout layout, ThemeDisplay themeDisplay) throws PortalException {
        UnicodeProperties typeSettingsProperties = layout.getTypeSettingsProperties();
        if (!GetterUtil.getBoolean(typeSettingsProperties.getProperty("sitemap-include"), true)) {
            return;
        }
        String layoutFullURL = PortalUtil.getLayoutFullURL(layout, themeDisplay);
        layoutFullURL = PortalUtil.getCanonicalURL(layoutFullURL, themeDisplay, layout);
        Map<Locale, String> alternateURLs = SitemapUtil.getAlternateURLs(layoutFullURL, themeDisplay, layout);
        for (String alternateURL : alternateURLs.values()) {
            SitemapUtil.addURLElement(element, alternateURL, typeSettingsProperties, layout.getModifiedDate(), layoutFullURL, alternateURLs);
        }
    }
}

