/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.bean.BeanLocatorImpl;
import com.liferay.portal.configuration.ConfigurationFactoryImpl;
import com.liferay.portal.dao.db.DBManagerImpl;
import com.liferay.portal.dao.jdbc.DataSourceFactoryImpl;
import com.liferay.portal.kernel.bean.PortalBeanLocatorUtil;
import com.liferay.portal.kernel.configuration.ConfigurationFactoryUtil;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.DataSourceFactoryUtil;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.log.SanitizerLogWrapper;
import com.liferay.portal.kernel.module.framework.ModuleServiceLifecycle;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.JavaDetector;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.log.Log4jLogFactoryImpl;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderImpl;
import com.liferay.portal.spring.bean.LiferayBeanFactory;
import com.liferay.portal.spring.configurator.ConfigurableApplicationContextConfigurator;
import com.liferay.portal.spring.context.ArrayApplicationContext;
import com.liferay.portal.util.PropsImpl;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceRegistration;
import com.sun.syndication.io.XmlReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import org.apache.commons.lang.time.StopWatch;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class InitUtil {
    private static final boolean _PRINT_TIME = false;
    private static ApplicationContext _appApplicationContext;
    private static boolean _initialized;

    public static synchronized void init() {
        if (_initialized) {
            return;
        }
        try {
            Field field;
            if (!OSDetector.isWindows() && !JavaDetector.isJDK11() && ((Boolean)(field = ReflectionUtil.getDeclaredField(ZipFile.class, "usemmap")).get(null)).booleanValue()) {
                field.setBoolean(null, false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        String userLanguage = SystemProperties.get("user.language");
        String userCountry = SystemProperties.get("user.country");
        String userVariant = SystemProperties.get("user.variant");
        LocaleUtil.setDefault(userLanguage, userCountry, userVariant);
        String userTimeZone = SystemProperties.get("user.timezone");
        TimeZoneUtil.setDefault(userTimeZone);
        Thread currentThread = Thread.currentThread();
        try {
            PortalClassLoaderUtil.setClassLoader(currentThread.getContextClassLoader());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        com.liferay.portal.kernel.util.PropsUtil.setProps(new PropsImpl());
        if (GetterUtil.getBoolean(SystemProperties.get("log4j.configure.on.startup"), true)) {
            ClassLoader classLoader = InitUtil.class.getClassLoader();
            Log4JUtil.configureLog4J(classLoader);
        }
        try {
            LogFactoryUtil.setLogFactory(new Log4jLogFactoryImpl());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SanitizerLogWrapper.init();
        ConfigurationFactoryUtil.setConfigurationFactory(new ConfigurationFactoryImpl());
        DataSourceFactoryUtil.setDataSourceFactory(new DataSourceFactoryImpl());
        DBManagerUtil.setDBManager(new DBManagerImpl());
        SecureXMLFactoryProviderUtil secureXMLFactoryProviderUtil = new SecureXMLFactoryProviderUtil();
        secureXMLFactoryProviderUtil.setSecureXMLFactoryProvider(new SecureXMLFactoryProviderImpl());
        UnsecureSAXReaderUtil unsecureSAXReaderUtil = new UnsecureSAXReaderUtil();
        unsecureSAXReaderUtil.setSAXReader(new SAXReaderImpl());
        XmlReader.setDefaultEncoding((String)"UTF-8");
        _initialized = true;
    }

    public static synchronized void initWithSpring(boolean initModuleFramework, boolean registerContext) {
        List<String> configLocations = ListUtil.fromArray(PropsUtil.getArray("spring.configs"));
        InitUtil.initWithSpring(configLocations, initModuleFramework, registerContext);
    }

    public static synchronized void initWithSpring(List<String> configLocations, boolean initModuleFramework, boolean registerContext) {
        if (_initialized) {
            return;
        }
        InitUtil.init();
        try {
            if (initModuleFramework) {
                PropsValues.LIFERAY_WEB_PORTAL_CONTEXT_TEMPDIR = System.getProperty("java.io.tmpdir");
                ModuleFrameworkUtilAdapter.initFramework();
            }
            ArrayApplicationContext infrastructureApplicationContext = new ArrayApplicationContext(PropsValues.SPRING_INFRASTRUCTURE_CONFIGS);
            if (initModuleFramework) {
                ModuleFrameworkUtilAdapter.registerContext((Object)infrastructureApplicationContext);
                ModuleFrameworkUtilAdapter.startFramework();
            }
            ClassPathXmlApplicationContext configurableApplicationContext = new ClassPathXmlApplicationContext(configLocations.toArray(new String[0]), false, (ApplicationContext)infrastructureApplicationContext){

                protected DefaultListableBeanFactory createBeanFactory() {
                    return new LiferayBeanFactory(this.getInternalParentBeanFactory());
                }
            };
            if (infrastructureApplicationContext.containsBean("configurableApplicationContextConfigurator")) {
                ConfigurableApplicationContextConfigurator configurableApplicationContextConfigurator = (ConfigurableApplicationContextConfigurator)infrastructureApplicationContext.getBean("configurableApplicationContextConfigurator", ConfigurableApplicationContextConfigurator.class);
                configurableApplicationContextConfigurator.configure((ConfigurableApplicationContext)configurableApplicationContext);
            }
            configurableApplicationContext.refresh();
            BeanLocatorImpl beanLocator = new BeanLocatorImpl(PortalClassLoaderUtil.getClassLoader(), (ApplicationContext)configurableApplicationContext);
            PortalBeanLocatorUtil.setBeanLocator(beanLocator);
            if (initModuleFramework) {
                ModuleFrameworkUtilAdapter.startRuntime();
            }
            _appApplicationContext = configurableApplicationContext;
            if (initModuleFramework && registerContext) {
                InitUtil.registerContext();
            }
            InitUtil.registerSpringInitialized();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        _initialized = true;
    }

    public static boolean isInitialized() {
        return _initialized;
    }

    public static void registerContext() {
        if (_appApplicationContext != null) {
            ModuleFrameworkUtilAdapter.registerContext(_appApplicationContext);
        }
    }

    public static void registerSpringInitialized() {
        Registry registry = RegistryUtil.getRegistry();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("module.service.lifecycle", "spring.initialized");
        properties.put("service.vendor", ReleaseInfo.getVendor());
        properties.put("service.version", ReleaseInfo.getVersion());
        final ServiceRegistration<2> moduleServiceLifecycleServiceRegistration = registry.registerService(ModuleServiceLifecycle.class, new ModuleServiceLifecycle(){}, properties);
        PortalLifecycleUtil.register(new BasePortalLifecycle(){

            @Override
            protected void doPortalDestroy() {
                moduleServiceLifecycleServiceRegistration.unregister();
            }

            @Override
            protected void doPortalInit() {
            }
        }, 1);
    }

    public static synchronized void stopModuleFramework() {
        try {
            ModuleFrameworkUtilAdapter.stopFramework(0L);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static synchronized void stopRuntime() {
        try {
            ModuleFrameworkUtilAdapter.stopRuntime();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

