/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.Html;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.htmlparser.jericho.Renderer;
import net.htmlparser.jericho.Source;
import net.htmlparser.jericho.TextExtractor;

public class HtmlImpl
implements Html {
    @Deprecated
    public static final int ESCAPE_MODE_ATTRIBUTE = 1;
    @Deprecated
    public static final int ESCAPE_MODE_CSS = 2;
    @Deprecated
    public static final int ESCAPE_MODE_JS = 3;
    @Deprecated
    public static final int ESCAPE_MODE_TEXT = 4;
    @Deprecated
    public static final int ESCAPE_MODE_URL = 5;
    private static final String[] _ATTRIBUTE_ESCAPES = new String[256];
    private static final char[] _HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static final char[] _TAG_SCRIPT = new char[]{'s', 'c', 'r', 'i', 'p', 't'};
    private static final char[] _TAG_STYLE = new char[]{'s', 't', 'y', 'l', 'e'};
    private static final boolean[] _VALID_CHARS = new boolean[256];
    private static final char[] _XPATH_TOKENS = new char[]{'(', ')', '[', ']', '.', '@', ',', ':', '/', '|', '+', '-', '=', '!', '<', '>', '*', '$', '\"', '\"', ' ', '\t', '\n', '\r', '\u0085', '\u2028'};
    private static final Pattern _pattern = Pattern.compile("([\\s<&]|$)");
    private static final Map<String, String> _unescapeMap = new HashMap<String, String>(){
        {
            this.put("#34", "\"");
            this.put("#35", "#");
            this.put("#37", "%");
            this.put("#39", "'");
            this.put("#40", "(");
            this.put("#41", ")");
            this.put("#43", "+");
            this.put("#44", ",");
            this.put("#45", "-");
            this.put("#59", ";");
            this.put("#61", "=");
            this.put("amp", "&");
            this.put("gt", ">");
            this.put("lt", "<");
            this.put("rsquo", "\u2019");
        }
    };

    @Override
    public String buildData(Map<String, Object> data) {
        if (data == null || data.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(data.size() * 5);
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            sb.append("data-");
            sb.append(entry.getKey());
            sb.append("=\"");
            sb.append(this.escapeAttribute(String.valueOf(entry.getValue())));
            sb.append("\" ");
        }
        return sb.toString();
    }

    @Override
    public String escape(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        StringBundler sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c < '\u0100' && (c >= '\u0080' || _VALID_CHARS[c])) continue;
            String replacement = null;
            if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '\"') {
                replacement = "&#34;";
            } else if (c == '\'') {
                replacement = "&#39;";
            } else if (c == '\u00bb') {
                replacement = "&#187;";
            } else if (c == '\u2013') {
                replacement = "&#8211;";
            } else if (c == '\u2014') {
                replacement = "&#8212;";
            } else if (c == '\u2028') {
                replacement = "&#8232;";
            } else {
                if (HtmlImpl._isValidXmlCharacter(c) && !this._isUnicodeCompatibilityCharacter(c)) continue;
                replacement = " ";
            }
            if (sb == null) {
                sb = new StringBundler();
            }
            if (i > lastReplacementIndex) {
                sb.append(text.substring(lastReplacementIndex, i));
            }
            sb.append(replacement);
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    @Override
    @Deprecated
    public String escape(String text, int mode) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        if (mode == 1) {
            return this.escapeAttribute(text);
        }
        if (mode == 3) {
            return this.escapeJS(text);
        }
        if (mode == 2) {
            return this.escapeCSS(text);
        }
        if (mode == 5) {
            return this.escapeURL(text);
        }
        return this.escape(text);
    }

    @Override
    public String escapeAttribute(String attribute) {
        if (attribute == null) {
            return null;
        }
        if (attribute.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < attribute.length(); ++i) {
            char c = attribute.charAt(i);
            if (c < _ATTRIBUTE_ESCAPES.length) {
                String replacement = _ATTRIBUTE_ESCAPES[c];
                if (replacement == null) continue;
                if (sb == null) {
                    sb = new StringBuilder(attribute.length() + 64);
                }
                if (i > lastReplacementIndex) {
                    sb.append(attribute, lastReplacementIndex, i);
                }
                sb.append(replacement);
                lastReplacementIndex = i + 1;
                continue;
            }
            if (HtmlImpl._isValidXmlCharacter(c) && !this._isUnicodeCompatibilityCharacter(c)) continue;
            if (sb == null) {
                sb = new StringBuilder(attribute.length() + 64);
            }
            if (i > lastReplacementIndex) {
                sb.append(attribute, lastReplacementIndex, i);
            }
            sb.append(' ');
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return attribute;
        }
        if (lastReplacementIndex < attribute.length()) {
            sb.append(attribute, lastReplacementIndex, attribute.length());
        }
        return sb.toString();
    }

    @Override
    public String escapeCSS(String css) {
        if (css == null) {
            return null;
        }
        if (css.length() == 0) {
            return "";
        }
        String prefix = "\\";
        StringBuilder sb = null;
        char[] hexBuffer = new char[4];
        int lastReplacementIndex = 0;
        for (int i = 0; i < css.length(); ++i) {
            char nextChar;
            char c = css.charAt(i);
            if (c >= _VALID_CHARS.length || _VALID_CHARS[c]) continue;
            if (sb == null) {
                sb = new StringBuilder(css.length() + 64);
            }
            if (i > lastReplacementIndex) {
                sb.append(css, lastReplacementIndex, i);
            }
            sb.append(prefix);
            HtmlImpl._appendHexChars(sb, hexBuffer, c);
            if (i < css.length() - 1 && (nextChar = css.charAt(i + 1)) >= '0' && nextChar <= '9') {
                sb.append(' ');
            }
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return css;
        }
        if (lastReplacementIndex < css.length()) {
            sb.append(css, lastReplacementIndex, css.length());
        }
        return sb.toString();
    }

    @Override
    public String escapeHREF(String href) {
        if (href == null) {
            return null;
        }
        if (href.length() == 0) {
            return "";
        }
        char c = href.charAt(0);
        if (c == '\\' || c == '/') {
            return this.escapeAttribute(href);
        }
        if ((c = Character.toLowerCase(c)) >= 'a' && c <= 'z' && c != 'd' && c != 'j') {
            return this.escapeAttribute(href);
        }
        int index = href.indexOf(":");
        if (index > -1) {
            href = StringUtil.replaceFirst(href, ":", "%3a", index);
        }
        return this.escapeAttribute(href);
    }

    @Override
    public String escapeJS(String js) {
        if (js == null) {
            return null;
        }
        if (js.length() == 0) {
            return "";
        }
        String prefix = "\\x";
        StringBuilder sb = null;
        char[] hexBuffer = new char[4];
        int lastReplacementIndex = 0;
        for (int i = 0; i < js.length(); ++i) {
            char c = js.charAt(i);
            if (c < _VALID_CHARS.length) {
                if (_VALID_CHARS[c]) continue;
                if (sb == null) {
                    sb = new StringBuilder(js.length() + 64);
                }
                if (i > lastReplacementIndex) {
                    sb.append(js, lastReplacementIndex, i);
                }
                sb.append(prefix);
                HtmlImpl._appendHexChars(sb, hexBuffer, c);
                lastReplacementIndex = i + 1;
                continue;
            }
            if (c != '\u2028' && c != '\u2029') continue;
            if (sb == null) {
                sb = new StringBuilder(js.length() + 64);
            }
            if (i > lastReplacementIndex) {
                sb.append(js, lastReplacementIndex, i);
            }
            sb.append("\\u");
            HtmlImpl._appendHexChars(sb, hexBuffer, c);
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return js;
        }
        if (lastReplacementIndex < js.length()) {
            sb.append(js, lastReplacementIndex, js.length());
        }
        return sb.toString();
    }

    @Override
    public String escapeJSLink(String link) {
        String protocol;
        if (Validator.isNull(link)) {
            return "";
        }
        if (link.indexOf(":") == 10 && (protocol = StringUtil.toLowerCase(link.substring(0, 10))).equals("javascript")) {
            link = StringUtil.replaceFirst(link, ':', "%3a");
        }
        return link;
    }

    @Override
    public String escapeURL(String url) {
        return URLCodec.encodeURL(url, true);
    }

    @Override
    public String escapeXPath(String xPath) {
        if (Validator.isNull(xPath)) {
            return xPath;
        }
        StringBuilder sb = new StringBuilder(xPath.length());
        for (int i = 0; i < xPath.length(); ++i) {
            char c = xPath.charAt(i);
            boolean hasToken = false;
            for (char xPathToken : _XPATH_TOKENS) {
                if (c != xPathToken) continue;
                hasToken = true;
                break;
            }
            if (hasToken) {
                sb.append('_');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    @Override
    public String escapeXPathAttribute(String xPathAttribute) {
        boolean hasApostrophe = xPathAttribute.contains("'");
        boolean hasQuote = xPathAttribute.contains("\"");
        if (hasQuote && hasApostrophe) {
            Object[] parts = xPathAttribute.split("'");
            return "concat('".concat(StringUtil.merge(parts, "', \"'\", '")).concat("')");
        }
        if (hasQuote) {
            return "'".concat(xPathAttribute).concat("'");
        }
        return "\"".concat(xPathAttribute).concat("\"");
    }

    @Override
    public String extractText(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        TextExtractor textExtractor = source.getTextExtractor();
        return textExtractor.toString();
    }

    @Override
    public String fromInputSafe(String text) {
        return StringUtil.replace(text, new String[]{"&amp;", "&quot;"}, new String[]{"&", "\""});
    }

    @Override
    public String getAUICompatibleId(String text) {
        if (Validator.isNull(text)) {
            return text;
        }
        StringBundler sb = null;
        int lastReplacementIndex = 0;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c <= '\u007f' && (Validator.isChar(c) || Validator.isDigit(c)) || c > '\u007f' && c != '\u2007' && c != '\u202f' && c != '\u00a0') continue;
            if (sb == null) {
                sb = new StringBundler();
            }
            if (i > lastReplacementIndex) {
                sb.append(text.substring(lastReplacementIndex, i));
            }
            sb.append("_");
            if (c != '_') {
                sb.append(StringUtil.toHexString(c));
            }
            sb.append("_");
            lastReplacementIndex = i + 1;
        }
        if (sb == null) {
            return text;
        }
        if (lastReplacementIndex < text.length()) {
            sb.append(text.substring(lastReplacementIndex));
        }
        return sb.toString();
    }

    @Override
    public String render(String html) {
        if (html == null) {
            return null;
        }
        Source source = new Source((CharSequence)html);
        Renderer renderer = source.getRenderer();
        return renderer.toString();
    }

    @Override
    public String replaceNewLine(String html) {
        if (html == null) {
            return null;
        }
        html = StringUtil.replace(html, "\r\n", "<br />");
        return StringUtil.replace(html, '\n', "<br />");
    }

    @Override
    public String stripBetween(String text, String tag) {
        return StringUtil.stripBetween(text, "<" + tag, "</" + tag + ">");
    }

    @Override
    public String stripComments(String text) {
        return StringUtil.stripBetween(text, "<!--", "-->");
    }

    @Override
    public String stripHtml(String text) {
        if (text == null) {
            return null;
        }
        text = this.stripComments(text);
        StringBuilder sb = new StringBuilder(text.length());
        int x = 0;
        int y = text.indexOf("<");
        while (y != -1) {
            sb.append(text.substring(x, y));
            if (this.isTag(_TAG_SCRIPT, text, y + 1)) {
                y = this.stripTag(_TAG_SCRIPT, text, y);
            } else if (this.isTag(_TAG_STYLE, text, y + 1)) {
                y = this.stripTag(_TAG_STYLE, text, y);
            }
            x = text.indexOf(">", y);
            if (x == -1 || ++x < y) break;
            y = text.indexOf("<", x);
        }
        if (y == -1) {
            sb.append(text.substring(x));
        }
        return sb.toString();
    }

    @Override
    public String toInputSafe(String text) {
        return StringUtil.replace(text, new char[]{'&', '\"'}, new String[]{"&amp;", "&quot;"});
    }

    @Override
    public String unescape(String text) {
        return StringUtil.replace(text, "&", ";", _unescapeMap);
    }

    @Override
    public String unescapeCDATA(String text) {
        if (text == null) {
            return null;
        }
        if (text.length() == 0) {
            return "";
        }
        text = StringUtil.replace(text, "&lt;![CDATA[", "<![CDATA[");
        text = StringUtil.replace(text, "]]&gt;", "]]>");
        return text;
    }

    @Override
    public String wordBreak(String text, int columns) {
        StringBundler sb = new StringBundler();
        int length = 0;
        int lastWrite = 0;
        int pos = 0;
        Matcher matcher = _pattern.matcher(text);
        while (matcher.find()) {
            int x;
            if (matcher.start() < pos) continue;
            while (length + matcher.start() - pos >= columns) {
                sb.append(text.substring(lastWrite, pos += columns - length));
                sb.append("<wbr/>&shy;");
                length = 0;
                lastWrite = pos;
            }
            length += matcher.start() - pos;
            String group = matcher.group();
            if (group.equals("&")) {
                x = text.indexOf(";", matcher.start());
                if (x == -1) continue;
                ++length;
                pos = x + 1;
                continue;
            }
            if (group.equals("<")) {
                x = text.indexOf(">", matcher.start());
                if (x == -1) continue;
                pos = x + 1;
                continue;
            }
            if (!group.equals(" ") && !group.equals("\n")) continue;
            length = 0;
            pos = matcher.start() + 1;
        }
        sb.append(text.substring(lastWrite));
        return sb.toString();
    }

    protected boolean isTag(char[] tag, String text, int pos) {
        if (pos + tag.length + 1 <= text.length()) {
            char item = '\u0000';
            for (char c : tag) {
                if (Character.toLowerCase(item = text.charAt(pos++)) == c) continue;
                return false;
            }
            item = text.charAt(pos);
            return !Character.isLetter(item);
        }
        return false;
    }

    protected int stripTag(char[] tag, String text, int pos) {
        int x = pos + tag.length;
        if ((x = text.indexOf(">", x)) < 0) {
            return pos;
        }
        if (text.charAt(x - 1) == '/') {
            return pos;
        }
        while ((x = text.indexOf("</", x)) >= 0) {
            if (this.isTag(tag, text, x + 2)) {
                pos = x;
                break;
            }
            x += 2;
        }
        return pos;
    }

    private static void _appendHexChars(StringBuilder sb, char[] buffer, char c) {
        int index = buffer.length;
        do {
            buffer[--index] = _HEX_DIGITS[c & 0xF];
        } while ((c = (char)(c >>> 4)) != '\u0000');
        if (index == buffer.length - 1) {
            sb.append('0');
            sb.append(buffer[index]);
            return;
        }
        sb.append(buffer, index, buffer.length - index);
    }

    private static boolean _isValidXmlCharacter(char c) {
        return c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || Character.isSurrogate(c) || c == '\t' || c == '\n' || c == '\r';
    }

    private boolean _isUnicodeCompatibilityCharacter(char c) {
        return c >= '\u007f' && c <= '\u0084' || c >= '\u0086' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef';
    }

    static {
        for (int i = 0; i < 256; ++i) {
            char c = (char)i;
            if (!HtmlImpl._isValidXmlCharacter(c)) {
                HtmlImpl._ATTRIBUTE_ESCAPES[i] = " ";
            }
            HtmlImpl._ATTRIBUTE_ESCAPES[38] = "&amp;";
            HtmlImpl._ATTRIBUTE_ESCAPES[39] = "&#39;";
            HtmlImpl._ATTRIBUTE_ESCAPES[62] = "&gt;";
            HtmlImpl._ATTRIBUTE_ESCAPES[60] = "&lt;";
            HtmlImpl._ATTRIBUTE_ESCAPES[34] = "&quot;";
            if (!Character.isLetterOrDigit(c)) continue;
            HtmlImpl._VALID_CHARS[i] = true;
        }
        HtmlImpl._VALID_CHARS[45] = true;
        HtmlImpl._VALID_CHARS[95] = true;
    }
}

