/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.concurrent.NoticeableFuture;
import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.petra.process.ProcessCallable;
import com.liferay.petra.process.ProcessChannel;
import com.liferay.petra.process.ProcessException;
import com.liferay.petra.process.ProcessExecutor;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayOutputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.FileComparator;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.Time;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.util.ant.ExpandTask;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.compress.archivers.zip.UnsupportedZipFeatureException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.tika.Tika;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.txt.UniversalEncodingDetector;
import org.apache.tools.ant.DirectoryScanner;
import org.mozilla.intl.chardet.nsDetector;

public class FileImpl
implements File {
    private static final String[] _SAFE_FILE_NAME_1 = new String[]{"&", ")", "(", ";"};
    private static final String[] _SAFE_FILE_NAME_2 = new String[]{PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_AMPERSAND, PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_CLOSE_PARENTHESIS, PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_OPEN_PARENTHESIS, PropsValues.DL_STORE_FILE_IMPL_SAFE_FILE_NAME_2_SEMICOLON};
    private static final Log _log = LogFactoryUtil.getLog(FileImpl.class);
    private static final FileImpl _instance = new FileImpl();

    public static FileImpl getInstance() {
        return _instance;
    }

    @Override
    public String appendParentheticalSuffix(String fileName, String suffix) {
        String fileNameWithoutExtension = this.stripExtension(fileName);
        String fileNameWithParentheticalSuffix = StringUtil.appendParentheticalSuffix(fileNameWithoutExtension, suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNull(extension)) {
            return fileNameWithParentheticalSuffix;
        }
        StringBundler sb = new StringBundler(3);
        sb.append(fileNameWithParentheticalSuffix);
        sb.append(".");
        sb.append(extension);
        return sb.toString();
    }

    @Override
    public String appendSuffix(String fileName, String suffix) {
        StringBundler sb = new StringBundler(4);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(fileNameWithoutExtension);
        sb.append(suffix);
        String extension = this.getExtension(fileName);
        if (Validator.isNotNull(extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    @Override
    public void copyDirectory(java.io.File source, java.io.File destination) throws IOException {
        java.io.File[] fileArray;
        if (!source.exists() || !source.isDirectory()) {
            return;
        }
        this.mkdirs(destination);
        for (java.io.File file : fileArray = source.listFiles()) {
            if (file.isDirectory()) {
                this.copyDirectory(file, new java.io.File(destination.getPath() + java.io.File.separator + file.getName()));
                continue;
            }
            this.copyFile(file, new java.io.File(destination.getPath() + java.io.File.separator + file.getName()));
        }
    }

    @Override
    public void copyDirectory(String sourceDirName, String destinationDirName) throws IOException {
        this.copyDirectory(new java.io.File(sourceDirName), new java.io.File(destinationDirName));
    }

    @Override
    public void copyFile(java.io.File source, java.io.File destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    @Override
    public void copyFile(java.io.File source, java.io.File destination, boolean lazy) throws IOException {
        if (!source.exists()) {
            return;
        }
        if (lazy) {
            String oldContent = null;
            try {
                oldContent = this.read(source);
            }
            catch (Exception e) {
                return;
            }
            String newContent = null;
            try {
                newContent = this.read(destination);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (oldContent == null || !oldContent.equals(newContent)) {
                this.copyFile(source, destination, false);
            }
        } else {
            this.mkdirsParentFile(destination);
            StreamUtil.transfer(new FileInputStream(source), new FileOutputStream(destination));
        }
    }

    @Override
    public void copyFile(String source, String destination) throws IOException {
        this.copyFile(source, destination, false);
    }

    @Override
    public void copyFile(String source, String destination, boolean lazy) throws IOException {
        this.copyFile(new java.io.File(source), new java.io.File(destination), lazy);
    }

    @Override
    public java.io.File createTempFile() {
        return this.createTempFile("");
    }

    @Override
    public java.io.File createTempFile(byte[] bytes) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, bytes, false);
        return file;
    }

    @Override
    public java.io.File createTempFile(InputStream is) throws IOException {
        java.io.File file = this.createTempFile("");
        this.write(file, is);
        return file;
    }

    @Override
    public java.io.File createTempFile(String extension) {
        return new java.io.File(this.createTempFileName(extension));
    }

    @Override
    public java.io.File createTempFile(String prefix, String extension) {
        return new java.io.File(this.createTempFileName(prefix, extension));
    }

    @Override
    public String createTempFileName() {
        return this.createTempFileName(null, null);
    }

    @Override
    public String createTempFileName(String extension) {
        return this.createTempFileName(null, extension);
    }

    @Override
    public String createTempFileName(String prefix, String extension) {
        StringBundler sb = new StringBundler(7);
        sb.append(SystemProperties.get("java.io.tmpdir"));
        sb.append("/");
        if (Validator.isNotNull(prefix)) {
            sb.append(prefix);
        }
        sb.append(Time.getTimestamp());
        sb.append(PwdGenerator.getPassword(8, "ABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        if (Validator.isFileExtension(extension)) {
            sb.append(".");
            sb.append(extension);
        }
        return sb.toString();
    }

    @Override
    public java.io.File createTempFolder() throws IOException {
        java.io.File file = new java.io.File(this.createTempFileName());
        this.mkdirs(file);
        return file;
    }

    @Override
    public String decodeSafeFileName(String fileName) {
        return StringUtil.replace(fileName, _SAFE_FILE_NAME_2, _SAFE_FILE_NAME_1);
    }

    @Override
    public boolean delete(java.io.File file) {
        if (file != null) {
            boolean exists = true;
            try {
                exists = file.exists();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            if (exists) {
                return file.delete();
            }
        }
        return false;
    }

    @Override
    public boolean delete(String file) {
        return this.delete(new java.io.File(file));
    }

    @Override
    public void deltree(java.io.File directory) {
        if (directory.exists() && directory.isDirectory()) {
            java.io.File[] fileArray;
            for (java.io.File file : fileArray = directory.listFiles()) {
                if (file.isDirectory()) {
                    this.deltree(file);
                    continue;
                }
                file.delete();
            }
            directory.delete();
        }
    }

    @Override
    public void deltree(String directory) {
        this.deltree(new java.io.File(directory));
    }

    @Override
    public String encodeSafeFileName(String fileName) {
        if (fileName == null) {
            return "";
        }
        return StringUtil.replace(fileName, _SAFE_FILE_NAME_1, _SAFE_FILE_NAME_2);
    }

    @Override
    public boolean exists(java.io.File file) {
        return file.exists();
    }

    @Override
    public boolean exists(String fileName) {
        return this.exists(new java.io.File(fileName));
    }

    @Override
    public String extractText(InputStream is, String fileName) {
        return this.extractText(is, fileName, -1);
    }

    @Override
    public String extractText(InputStream is, String fileName, int maxStringLength) {
        if (maxStringLength == 0) {
            return "";
        }
        String text = null;
        try {
            String mimeType;
            Tika tika = new Tika(TikaConfigHolder._tikaConfig);
            tika.setMaxStringLength(maxStringLength);
            boolean forkProcess = false;
            if (PropsValues.TEXT_EXTRACTION_FORK_PROCESS_ENABLED && ArrayUtil.contains(PropsValues.TEXT_EXTRACTION_FORK_PROCESS_MIME_TYPES, mimeType = tika.detect(is))) {
                forkProcess = true;
            }
            if (forkProcess) {
                Registry registry = RegistryUtil.getRegistry();
                ProcessChannel processChannel = registry.callService(ProcessExecutor.class, processExecutor -> {
                    try {
                        return processExecutor.execute(PortalClassPathUtil.getPortalProcessConfig(), new ExtractTextProcessCallable(this.getBytes(is)));
                    }
                    catch (Exception e) {
                        return (ProcessChannel)ReflectionUtil.throwException(e);
                    }
                });
                NoticeableFuture future = processChannel.getProcessNoticeableFuture();
                text = (String)future.get();
            } else {
                TikaInputStream tikaInputStream = TikaInputStream.get((InputStream)is);
                if (!this._isEmptyTikaInputStream(tikaInputStream)) {
                    UniversalEncodingDetector universalEncodingDetector = new UniversalEncodingDetector();
                    Metadata metadata = new Metadata();
                    Charset charset = universalEncodingDetector.detect((InputStream)tikaInputStream, metadata);
                    String contentEncoding = "";
                    if (charset != null) {
                        contentEncoding = charset.name();
                    }
                    if (!contentEncoding.equals("")) {
                        metadata.set("Content-Encoding", contentEncoding);
                        metadata.set("Content-Type", "text/plain; charset=" + contentEncoding);
                    }
                    text = tika.parseToString((InputStream)tikaInputStream, metadata);
                }
            }
        }
        catch (Throwable t) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)t);
            if (throwable instanceof EncryptedDocumentException || throwable instanceof UnsupportedZipFeatureException) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Unable to extract text from an encrypted file " + fileName, t);
                }
            }
            if (t instanceof TikaException) {
                if (_log.isWarnEnabled()) {
                    _log.warn("Unable to extract text from " + fileName, t);
                }
            }
            _log.error(t, t);
        }
        if (_log.isInfoEnabled()) {
            if (text == null) {
                _log.info("Text extraction failed for " + fileName);
            } else {
                _log.info("Text was extracted for " + fileName);
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Extractor returned text:\n\n" + text);
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    @Override
    public String[] find(String directory, String includes, String excludes) {
        if (directory.length() > 0 && (directory = this.replaceSeparator(directory)).charAt(directory.length() - 1) == '/') {
            directory = directory.substring(0, directory.length() - 1);
        }
        if (!this.exists(directory)) {
            if (_log.isWarnEnabled()) {
                _log.warn("Directory " + directory + " does not exist");
            }
            return new String[0];
        }
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(directory);
        directoryScanner.setExcludes(StringUtil.split(excludes));
        directoryScanner.setIncludes(StringUtil.split(includes));
        directoryScanner.scan();
        String[] includedFiles = directoryScanner.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            includedFiles[i] = directory.concat("/").concat(this.replaceSeparator(includedFiles[i]));
        }
        return includedFiles;
    }

    @Override
    public String getAbsolutePath(java.io.File file) {
        return StringUtil.replace(file.getAbsolutePath(), '\\', '/');
    }

    @Override
    public byte[] getBytes(Class<?> clazz, String fileName) throws IOException {
        return this.getBytes(clazz.getResourceAsStream(fileName));
    }

    @Override
    public byte[] getBytes(java.io.File file) throws IOException {
        if (file == null || !file.exists()) {
            return null;
        }
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            byte[] bytes = new byte[(int)randomAccessFile.length()];
            randomAccessFile.readFully(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
    }

    @Override
    public byte[] getBytes(InputStream is) throws IOException {
        return this.getBytes(is, -1);
    }

    @Override
    public byte[] getBytes(InputStream inputStream, int bufferSize) throws IOException {
        return this.getBytes(inputStream, bufferSize, true);
    }

    @Override
    public byte[] getBytes(InputStream inputStream, int bufferSize, boolean cleanUpStream) throws IOException {
        if (inputStream == null) {
            return null;
        }
        UnsyncByteArrayOutputStream unsyncByteArrayOutputStream = new UnsyncByteArrayOutputStream();
        StreamUtil.transfer(inputStream, unsyncByteArrayOutputStream, bufferSize, cleanUpStream);
        return unsyncByteArrayOutputStream.toByteArray();
    }

    @Override
    public String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int pos = fileName.lastIndexOf(46);
        if (pos > 0) {
            return StringUtil.toLowerCase(fileName.substring(pos + 1));
        }
        return "";
    }

    @Override
    public String getMD5Checksum(java.io.File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            String string = DigesterUtil.digestHex("MD5", fileInputStream);
            return string;
        }
    }

    @Override
    public String getPath(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        if (x == -1 && y == -1) {
            return "/";
        }
        return fullFileName.substring(0, Math.max(x, y));
    }

    @Override
    public String getShortFileName(String fullFileName) {
        int x = fullFileName.lastIndexOf(47);
        int y = fullFileName.lastIndexOf(92);
        return fullFileName.substring(Math.max(x, y) + 1);
    }

    @Override
    public boolean isAscii(java.io.File file) throws IOException {
        boolean ascii = true;
        nsDetector detector = new nsDetector(0);
        try (FileInputStream inputStream = new FileInputStream(file);){
            byte[] buffer = new byte[1024];
            int len = 0;
            while ((len = ((InputStream)inputStream).read(buffer, 0, buffer.length)) != -1 && (!ascii || (ascii = detector.isAscii(buffer, len)))) {
            }
            detector.DataEnd();
        }
        return ascii;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isSameContent(java.io.File file, byte[] bytes, int length) {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            FileChannel fileChannel = fileInputStream.getChannel();
            if (fileChannel.size() != (long)length) {
                boolean bl = false;
                return bl;
            }
            byte[] buffer = new byte[1024];
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            int bufferIndex = 0;
            int bufferLength = -1;
            while (true) {
                if ((bufferLength = fileChannel.read(byteBuffer)) > 0 && bufferIndex < length) {
                } else {
                    boolean bl;
                    if (bufferIndex != length || bufferLength != -1) {
                        bl = false;
                        return bl;
                    }
                    bl = true;
                    return bl;
                }
                for (int i = 0; i < bufferLength; ++i) {
                    if (buffer[i] == bytes[bufferIndex++]) continue;
                    boolean bl = false;
                    return bl;
                }
                byteBuffer.clear();
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean isSameContent(java.io.File file, String s) {
        ByteBuffer byteBuffer = CharsetEncoderUtil.encode("UTF-8", CharBuffer.wrap(s));
        return this.isSameContent(file, byteBuffer.array(), byteBuffer.limit());
    }

    @Override
    public String[] listDirs(java.io.File file) {
        ArrayList<String> dirs = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isDirectory()) continue;
            dirs.add(fileArray[i].getName());
        }
        return dirs.toArray(new String[0]);
    }

    @Override
    public String[] listDirs(String fileName) {
        return this.listDirs(new java.io.File(fileName));
    }

    @Override
    public String[] listFiles(java.io.File file) {
        ArrayList<String> files = new ArrayList<String>();
        java.io.File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            files.add(fileArray[i].getName());
        }
        return files.toArray(new String[0]);
    }

    @Override
    public String[] listFiles(String fileName) {
        if (Validator.isNull(fileName)) {
            return new String[0];
        }
        return this.listFiles(new java.io.File(fileName));
    }

    @Override
    public void mkdirs(java.io.File file) throws IOException {
        FileUtils.forceMkdir((java.io.File)file);
    }

    @Override
    public void mkdirs(String pathName) {
        java.io.File file = new java.io.File(pathName);
        if (file.exists() && file.isDirectory()) {
            if (_log.isDebugEnabled()) {
                _log.debug("Directory " + pathName + " already exists");
            }
            return;
        }
        try {
            this.mkdirs(file);
        }
        catch (IOException ioe) {
            ReflectionUtil.throwException(ioe);
        }
    }

    @Override
    public boolean move(java.io.File source, java.io.File destination) {
        if (!source.exists()) {
            return false;
        }
        destination.delete();
        try {
            if (source.isDirectory()) {
                FileUtils.moveDirectory((java.io.File)source, (java.io.File)destination);
            } else {
                FileUtils.moveFile((java.io.File)source, (java.io.File)destination);
            }
        }
        catch (IOException ioe) {
            return false;
        }
        return true;
    }

    @Override
    public boolean move(String sourceFileName, String destinationFileName) {
        return this.move(new java.io.File(sourceFileName), new java.io.File(destinationFileName));
    }

    @Override
    public String read(java.io.File file) throws IOException {
        return this.read(file, false);
    }

    @Override
    public String read(java.io.File file, boolean raw) throws IOException {
        byte[] bytes = this.getBytes(file);
        if (bytes == null) {
            return null;
        }
        String s = new String(bytes, "UTF-8");
        if (raw) {
            return s;
        }
        return StringUtil.replace(s, "\r\n", "\n");
    }

    @Override
    public String read(String fileName) throws IOException {
        return this.read(new java.io.File(fileName));
    }

    @Override
    public String replaceSeparator(String fileName) {
        return StringUtil.replace(fileName, '\\', '/');
    }

    @Override
    public java.io.File[] sortFiles(java.io.File[] files) {
        if (files == null) {
            return null;
        }
        Arrays.sort(files, new FileComparator());
        ArrayList<java.io.File> directoryList = new ArrayList<java.io.File>();
        ArrayList<java.io.File> fileList = new ArrayList<java.io.File>();
        for (java.io.File file : files) {
            if (file.isDirectory()) {
                directoryList.add(file);
                continue;
            }
            fileList.add(file);
        }
        directoryList.addAll(fileList);
        return directoryList.toArray(new java.io.File[0]);
    }

    @Override
    public String stripExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String ext = this.getExtension(fileName);
        if (ext.length() > 0) {
            return fileName.substring(0, fileName.length() - ext.length() - 1);
        }
        return fileName;
    }

    @Override
    public String stripParentheticalSuffix(String fileName) {
        StringBundler sb = new StringBundler(3);
        String fileNameWithoutExtension = this.stripExtension(fileName);
        sb.append(StringUtil.stripParentheticalSuffix(fileNameWithoutExtension));
        sb.append(".");
        String extension = this.getExtension(fileName);
        sb.append(extension);
        return sb.toString();
    }

    @Override
    public List<String> toList(Reader reader) {
        ArrayList<String> list = new ArrayList<String>();
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(reader);){
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                list.add(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    @Override
    public List<String> toList(String fileName) {
        try {
            return this.toList(new FileReader(fileName));
        }
        catch (IOException ioe) {
            return new ArrayList<String>();
        }
    }

    @Override
    public Properties toProperties(FileInputStream fis) {
        Properties properties = new Properties();
        try {
            properties.load(fis);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return properties;
    }

    @Override
    public Properties toProperties(String fileName) {
        try {
            return this.toProperties(new FileInputStream(fileName));
        }
        catch (IOException ioe) {
            return new Properties();
        }
    }

    @Override
    public void touch(java.io.File file) throws IOException {
        FileUtils.touch((java.io.File)file);
    }

    @Override
    public void touch(String fileName) throws IOException {
        this.touch(new java.io.File(fileName));
    }

    @Override
    public void unzip(java.io.File source, java.io.File destination) {
        ExpandTask.expand(source, destination);
    }

    @Override
    public void write(java.io.File file, byte[] bytes) throws IOException {
        this.write(file, bytes, 0, bytes.length, false);
    }

    @Override
    public void write(java.io.File file, byte[] bytes, boolean append) throws IOException {
        this.write(file, bytes, 0, bytes.length, append);
    }

    @Override
    public void write(java.io.File file, byte[] bytes, int offset, int length) throws IOException {
        this.write(file, bytes, offset, bytes.length, false);
    }

    @Override
    public void write(java.io.File file, byte[] bytes, int offset, int length, boolean append) throws IOException {
        this.mkdirsParentFile(file);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file, append);){
            fileOutputStream.write(bytes, offset, length);
        }
    }

    @Override
    public void write(java.io.File file, InputStream is) throws IOException {
        this.mkdirsParentFile(file);
        StreamUtil.transfer(is, new FileOutputStream(file));
    }

    @Override
    public void write(java.io.File file, String s) throws IOException {
        this.write(file, s, false);
    }

    @Override
    public void write(java.io.File file, String s, boolean lazy) throws IOException {
        this.write(file, s, lazy, false);
    }

    @Override
    public void write(java.io.File file, String s, boolean lazy, boolean append) throws IOException {
        String content;
        if (s == null) {
            return;
        }
        this.mkdirsParentFile(file);
        if (lazy && file.exists() && (content = this.read(file)).equals(s)) {
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");){
            writer.write(s);
        }
    }

    @Override
    public void write(String fileName, byte[] bytes) throws IOException {
        this.write(new java.io.File(fileName), bytes);
    }

    @Override
    public void write(String fileName, InputStream is) throws IOException {
        this.write(new java.io.File(fileName), is);
    }

    @Override
    public void write(String fileName, String s) throws IOException {
        this.write(new java.io.File(fileName), s);
    }

    @Override
    public void write(String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(fileName), s, lazy);
    }

    @Override
    public void write(String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(fileName), s, lazy, append);
    }

    @Override
    public void write(String pathName, String fileName, String s) throws IOException {
        this.write(new java.io.File(pathName, fileName), s);
    }

    @Override
    public void write(String pathName, String fileName, String s, boolean lazy) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy);
    }

    @Override
    public void write(String pathName, String fileName, String s, boolean lazy, boolean append) throws IOException {
        this.write(new java.io.File(pathName, fileName), s, lazy, append);
    }

    protected void mkdirsParentFile(java.io.File file) throws IOException {
        java.io.File parentFile = file.getParentFile();
        if (parentFile == null) {
            return;
        }
        try {
            this.mkdirs(parentFile);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    private boolean _isEmptyTikaInputStream(TikaInputStream tikaInputStream) throws IOException {
        if (tikaInputStream.hasLength() && tikaInputStream.getLength() > 0L) {
            return false;
        }
        byte[] bytes = new byte[1];
        int count = tikaInputStream.peek(bytes);
        return count <= 0;
    }

    private static class TikaConfigHolder {
        private static final TikaConfig _tikaConfig;

        private TikaConfigHolder() {
        }

        static {
            try {
                _tikaConfig = new TikaConfig();
            }
            catch (Exception e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private static class ExtractTextProcessCallable
    implements ProcessCallable<String> {
        private static final long serialVersionUID = 1L;
        private final byte[] _data;

        public ExtractTextProcessCallable(byte[] data) {
            this._data = data;
        }

        @Override
        public String call() throws ProcessException {
            if (ArrayUtil.isEmpty(this._data)) {
                return "";
            }
            Tika tika = new Tika(TikaConfigHolder._tikaConfig);
            try {
                return tika.parseToString((InputStream)new UnsyncByteArrayInputStream(this._data));
            }
            catch (Exception e) {
                throw new ProcessException(e);
            }
        }
    }
}

