/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.lang.HashUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.FastDateFormatFactory;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.text.Format;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.time.FastDateFormat;

public class FastDateFormatFactoryImpl
implements FastDateFormatFactory {
    private final Map<DateOrTimeCacheKey, Format> _dateFormats = new ConcurrentHashMap<DateOrTimeCacheKey, Format>();
    private final Map<DateAndTimeCacheKey, Format> _dateTimeFormats = new ConcurrentHashMap<DateAndTimeCacheKey, Format>();
    private final Map<SimpleDateCacheKey, Format> _simpleDateFormats = new ConcurrentHashMap<SimpleDateCacheKey, Format>();
    private final Map<DateOrTimeCacheKey, Format> _timeFormats = new ConcurrentHashMap<DateOrTimeCacheKey, Format>();

    @Override
    public Format getDate(int style, Locale locale, TimeZone timeZone) {
        DateOrTimeCacheKey dateOrTimeCacheKey = new DateOrTimeCacheKey(style, locale, timeZone);
        Format format = this._dateFormats.get(dateOrTimeCacheKey);
        if (format == null) {
            format = FastDateFormat.getDateInstance((int)style, (TimeZone)timeZone, (Locale)locale);
            this._dateFormats.put(dateOrTimeCacheKey, format);
        }
        return format;
    }

    @Override
    public Format getDate(Locale locale) {
        return this.getDate(locale, null);
    }

    @Override
    public Format getDate(Locale locale, TimeZone timeZone) {
        return this.getDate(3, locale, timeZone);
    }

    @Override
    public Format getDate(TimeZone timeZone) {
        return this.getDate(LocaleUtil.getDefault(), timeZone);
    }

    @Override
    public Format getDateTime(int dateStyle, int timeStyle, Locale locale, TimeZone timeZone) {
        DateAndTimeCacheKey dateAndTimeCacheKey = new DateAndTimeCacheKey(dateStyle, timeStyle, locale, timeZone);
        Format format = this._dateTimeFormats.get(dateAndTimeCacheKey);
        if (format == null) {
            format = FastDateFormat.getDateTimeInstance((int)dateStyle, (int)timeStyle, (TimeZone)timeZone, (Locale)locale);
            this._dateTimeFormats.put(dateAndTimeCacheKey, format);
        }
        return format;
    }

    @Override
    public Format getDateTime(Locale locale) {
        return this.getDateTime(locale, null);
    }

    @Override
    public Format getDateTime(Locale locale, TimeZone timeZone) {
        return this.getDateTime(3, 3, locale, timeZone);
    }

    @Override
    public Format getDateTime(TimeZone timeZone) {
        return this.getDateTime(LocaleUtil.getDefault(), timeZone);
    }

    @Override
    public Format getSimpleDateFormat(String pattern) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), null);
    }

    @Override
    public Format getSimpleDateFormat(String pattern, Locale locale) {
        return this.getSimpleDateFormat(pattern, locale, null);
    }

    @Override
    public Format getSimpleDateFormat(String pattern, Locale locale, TimeZone timeZone) {
        SimpleDateCacheKey simpleDateCacheKey = new SimpleDateCacheKey(pattern, locale, timeZone);
        Format format = this._simpleDateFormats.get(simpleDateCacheKey);
        if (format == null) {
            format = FastDateFormat.getInstance((String)pattern, (TimeZone)timeZone, (Locale)locale);
            this._simpleDateFormats.put(simpleDateCacheKey, format);
        }
        return format;
    }

    @Override
    public Format getSimpleDateFormat(String pattern, TimeZone timeZone) {
        return this.getSimpleDateFormat(pattern, LocaleUtil.getDefault(), timeZone);
    }

    @Override
    public Format getTime(int style, Locale locale, TimeZone timeZone) {
        DateOrTimeCacheKey dateOrTimeCacheKey = new DateOrTimeCacheKey(style, locale, timeZone);
        Format format = this._timeFormats.get(dateOrTimeCacheKey);
        if (format == null) {
            format = FastDateFormat.getTimeInstance((int)style, (TimeZone)timeZone, (Locale)locale);
            this._timeFormats.put(dateOrTimeCacheKey, format);
        }
        return format;
    }

    @Override
    public Format getTime(Locale locale) {
        return this.getTime(locale, null);
    }

    @Override
    public Format getTime(Locale locale, TimeZone timeZone) {
        return this.getTime(3, locale, timeZone);
    }

    @Override
    public Format getTime(TimeZone timeZone) {
        return this.getTime(LocaleUtil.getDefault(), timeZone);
    }

    protected String getKey(Object ... arguments) {
        StringBundler sb = new StringBundler(arguments.length * 2 - 1);
        for (int i = 0; i < arguments.length; ++i) {
            sb.append(arguments[i]);
            if (i + 1 >= arguments.length) continue;
            sb.append("_");
        }
        return sb.toString();
    }

    private static class SimpleDateCacheKey {
        private final Locale _locale;
        private final String _pattern;
        private final TimeZone _timeZone;

        public boolean equals(Object obj) {
            SimpleDateCacheKey simpleDateCacheKey = (SimpleDateCacheKey)obj;
            return Objects.equals(simpleDateCacheKey._pattern, this._pattern) && Objects.equals(simpleDateCacheKey._locale, this._locale) && Objects.equals(simpleDateCacheKey._timeZone, this._timeZone);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash(0, this._pattern);
            hashCode = HashUtil.hash(hashCode, this._locale);
            return HashUtil.hash(hashCode, this._timeZone);
        }

        private SimpleDateCacheKey(String pattern, Locale locale, TimeZone timeZone) {
            this._pattern = pattern;
            this._locale = locale;
            this._timeZone = timeZone;
        }
    }

    private static class DateOrTimeCacheKey {
        private final Locale _locale;
        private final int _style;
        private final TimeZone _timeZone;

        public boolean equals(Object obj) {
            DateOrTimeCacheKey dateOrTimeCacheKey = (DateOrTimeCacheKey)obj;
            return dateOrTimeCacheKey._style == this._style && Objects.equals(dateOrTimeCacheKey._locale, this._locale) && Objects.equals(dateOrTimeCacheKey._timeZone, this._timeZone);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash(0, this._style);
            hashCode = HashUtil.hash(hashCode, this._locale);
            return HashUtil.hash(hashCode, this._timeZone);
        }

        private DateOrTimeCacheKey(int style, Locale locale, TimeZone timeZone) {
            this._style = style;
            this._locale = locale;
            this._timeZone = timeZone;
        }
    }

    private static class DateAndTimeCacheKey {
        private final int _dateStyle;
        private final Locale _locale;
        private final int _timeStyle;
        private final TimeZone _timeZone;

        public boolean equals(Object obj) {
            DateAndTimeCacheKey dateAndTimeCacheKey = (DateAndTimeCacheKey)obj;
            return dateAndTimeCacheKey._dateStyle == this._dateStyle && dateAndTimeCacheKey._timeStyle == this._timeStyle && Objects.equals(dateAndTimeCacheKey._locale, this._locale) && Objects.equals(dateAndTimeCacheKey._timeZone, this._timeZone);
        }

        public int hashCode() {
            int hashCode = HashUtil.hash(0, this._dateStyle);
            hashCode = HashUtil.hash(hashCode, this._timeStyle);
            hashCode = HashUtil.hash(hashCode, this._locale);
            return HashUtil.hash(hashCode, this._timeZone);
        }

        private DateAndTimeCacheKey(int dateStyle, int timeStyle, Locale locale, TimeZone timeZone) {
            this._dateStyle = dateStyle;
            this._timeStyle = timeStyle;
            this._locale = locale;
            this._timeZone = timeZone;
        }
    }
}

