/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.ServletContext;

public class ExtRegistry {
    private static final String[] _IGNORED_FILE_NAMES = new String[]{"log4j.dtd", "service.xml", "sql/"};
    private static final String[] _SUPPORTED_MERGING_FILE_NAMES = new String[]{"content/Language-ext", "ext-hbm.xml", "ext-model-hints.xml", "ext-spring.xml", "portal-log4j-ext.xml"};
    private static final Map<String, Set<String>> _extMap = new HashMap<String, Set<String>>();

    public static Map<String, Set<String>> getConflicts(ServletContext servletContext) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        Set<String> fileNames = ExtRegistry._readExtFileNames(servletContext, "/WEB-INF/ext-" + servletContextName + ".xml");
        HashMap<String, Set<String>> conflicts = new HashMap<String, Set<String>>();
        for (Map.Entry<String, Set<String>> entry : _extMap.entrySet()) {
            String curServletContextName = entry.getKey();
            Set<String> curFileNames = entry.getValue();
            for (String fileName : fileNames) {
                if (!curFileNames.contains(fileName)) continue;
                TreeSet<String> conflictFileNames = (TreeSet<String>)conflicts.get(curServletContextName);
                if (conflictFileNames == null) {
                    conflictFileNames = new TreeSet<String>();
                    conflicts.put(curServletContextName, conflictFileNames);
                }
                conflictFileNames.add(fileName);
            }
        }
        return conflicts;
    }

    public static Set<String> getServletContextNames() {
        return Collections.unmodifiableSet(_extMap.keySet());
    }

    public static boolean isIgnoredFileName(String fileName) {
        if (ExtRegistry.isMergedFileName(fileName)) {
            return true;
        }
        for (String ignoredFileName : _IGNORED_FILE_NAMES) {
            if (!fileName.contains(ignoredFileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isMergedFileName(String fileName) {
        for (String mergedFileName : _SUPPORTED_MERGING_FILE_NAMES) {
            if (!fileName.contains(mergedFileName)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRegistered(String servletContextName) {
        return _extMap.containsKey(servletContextName);
    }

    public static void registerExt(ServletContext servletContext) throws Exception {
        String servletContextName = servletContext.getServletContextName();
        Set<String> fileNames = ExtRegistry._readExtFileNames(servletContext, "/WEB-INF/ext-" + servletContextName + ".xml");
        _extMap.put(servletContextName, fileNames);
    }

    public static void registerPortal(ServletContext servletContext) throws Exception {
        Set resourcePaths = servletContext.getResourcePaths("/WEB-INF");
        if (resourcePaths == null || resourcePaths.isEmpty()) {
            return;
        }
        for (String resourcePath : resourcePaths) {
            if (!resourcePath.startsWith("/WEB-INF/ext-") || !resourcePath.endsWith("-ext.xml")) continue;
            String servletContextName = resourcePath.substring(13, resourcePath.length() - 4);
            Set<String> fileNames = ExtRegistry._readExtFileNames(servletContext, resourcePath);
            _extMap.put(servletContextName, fileNames);
        }
    }

    private static Set<String> _readExtFileNames(ServletContext servletContext, String resourcePath) throws Exception {
        TreeSet<String> fileNames = new TreeSet<String>();
        Document document = UnsecureSAXReaderUtil.read(servletContext.getResourceAsStream(resourcePath));
        Element rootElement = document.getRootElement();
        Element filesElement = rootElement.element("files");
        List<Element> fileElements = filesElement.elements("file");
        for (Element fileElement : fileElements) {
            String fileName = fileElement.getText();
            if (ExtRegistry.isIgnoredFileName(fileName)) continue;
            fileNames.add(fileName);
        }
        return fileNames;
    }
}

