/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.util.CalendarFactory;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class CalendarFactoryImpl
implements CalendarFactory {
    @Override
    public Calendar getCalendar() {
        return new GregorianCalendar();
    }

    @Override
    public Calendar getCalendar(int year, int month, int date) {
        return new GregorianCalendar(year, month, date);
    }

    @Override
    public Calendar getCalendar(int year, int month, int date, int hour, int minute) {
        return new GregorianCalendar(year, month, date, hour, minute);
    }

    @Override
    public Calendar getCalendar(int year, int month, int date, int hour, int minute, int second) {
        return new GregorianCalendar(year, month, date, hour, minute, second);
    }

    @Override
    public Calendar getCalendar(int year, int month, int date, int hour, int minute, int second, int millisecond) {
        return this.getCalendar(year, month, date, hour, minute, second, millisecond, TimeZoneUtil.getDefault());
    }

    @Override
    public Calendar getCalendar(int year, int month, int date, int hour, int minute, int second, int millisecond, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, date);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisecond);
        return calendar;
    }

    @Override
    public Calendar getCalendar(Locale locale) {
        return new GregorianCalendar(locale);
    }

    @Override
    public Calendar getCalendar(long time) {
        return this.getCalendar(time, TimeZoneUtil.getDefault());
    }

    @Override
    public Calendar getCalendar(long time, TimeZone timeZone) {
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.setTimeInMillis(time);
        return calendar;
    }

    @Override
    public Calendar getCalendar(TimeZone timeZone) {
        return new GregorianCalendar(timeZone);
    }

    @Override
    public Calendar getCalendar(TimeZone timeZone, Locale locale) {
        return new GregorianCalendar(timeZone, locale);
    }
}

