/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.petra.process.ConsumerOutputProcessor;
import com.liferay.petra.process.ProcessUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.util.PropsValues;
import java.net.HttpURLConnection;
import java.net.URL;

public class BrowserLauncher
implements Runnable {
    private static final String[] _BROWSERS = new String[]{"xdg-open", "firefox", "mozilla", "konqueror", "opera"};

    @Override
    public void run() {
        try {
            URL url = new URL(PropsValues.BROWSER_LAUNCHER_URL);
            HttpURLConnection urlc = (HttpURLConnection)url.openConnection();
            urlc.setConnectTimeout(0);
            urlc.setReadTimeout(0);
            urlc.setRequestMethod("HEAD");
            int responseCode = urlc.getResponseCode();
            if (responseCode == 200) {
                try {
                    this.launchBrowser();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void launchBrowser() throws Exception {
        if (OSDetector.isApple()) {
            this.launchBrowserApple(null);
        } else if (OSDetector.isWindows()) {
            this.launchBrowserWindows(null);
        } else {
            this.launchBrowserUnix(null);
        }
    }

    protected void launchBrowserApple(Runtime runtime) throws Exception {
        ProcessUtil.execute(ConsumerOutputProcessor.INSTANCE, "open", PropsValues.BROWSER_LAUNCHER_URL);
    }

    protected void launchBrowserUnix(Runtime runtime) throws Exception {
        StringBundler sb = new StringBundler(_BROWSERS.length * 5 - 1);
        for (int i = 0; i < _BROWSERS.length; ++i) {
            if (i != 0) {
                sb.append(" || ");
            }
            sb.append(_BROWSERS[i]);
            sb.append(" \"");
            sb.append(PropsValues.BROWSER_LAUNCHER_URL);
            sb.append("\" ");
        }
        ProcessUtil.execute(ConsumerOutputProcessor.INSTANCE, "sh", "-c", sb.toString());
    }

    protected void launchBrowserWindows(Runtime runtime) throws Exception {
        ProcessUtil.execute(ConsumerOutputProcessor.INSTANCE, "cmd.exe", "/c", "start", PropsValues.BROWSER_LAUNCHER_URL);
    }
}

