/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_1_x;

import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Iterator;

public class UpgradePortalPreferences
extends UpgradeProcess {
    protected String convertDefaultReminderQueries(String localizedPreference, String preferences) throws Exception {
        Document document = SAXReaderUtil.read(preferences);
        Element rootElement = document.getRootElement();
        Iterator<Element> iterator = rootElement.elementIterator();
        while (iterator.hasNext()) {
            Element preferenceElement = iterator.next();
            String preferenceName = preferenceElement.elementText("name");
            if (!preferenceName.equals("reminderQueries")) continue;
            Element defaultReminderQueryElement = preferenceElement.createCopy();
            Element nameElement = defaultReminderQueryElement.element("name");
            defaultReminderQueryElement.remove(nameElement);
            nameElement.setText(localizedPreference);
            defaultReminderQueryElement.add(nameElement);
            rootElement.add(defaultReminderQueryElement);
            break;
        }
        return XMLUtil.formatXML(document);
    }

    @Override
    protected void doUpgrade() throws Exception {
        this.upgradeOrganizationReminderQueries();
    }

    protected void upgradeOrganizationReminderQueries() throws Exception {
        StringBundler sb1 = new StringBundler(7);
        sb1.append("select PortalPreferences.portalPreferencesId, ");
        sb1.append("PortalPreferences.preferences, Organization_.companyId ");
        sb1.append("from PortalPreferences inner join Organization_ on ");
        sb1.append("PortalPreferences.ownerId = Organization_.organizationId ");
        sb1.append("where PortalPreferences.ownerType = ");
        sb1.append(6);
        sb1.append(" and preferences like '%reminderQueries%'");
        try (PreparedStatement ps1 = this.connection.prepareStatement(sb1.toString());
             ResultSet rs = ps1.executeQuery();
             PreparedStatement ps2 = AutoBatchPreparedStatementUtil.concurrentAutoBatch(this.connection, "update PortalPreferences set preferences = ? where portalPreferencesId = ?");){
            while (rs.next()) {
                long companyId = rs.getLong("companyId");
                String preferences = rs.getString("preferences");
                String defaultLanguageId = UpgradeProcessUtil.getDefaultLanguageId(companyId);
                String localizedPreference = "reminderQueries_" + defaultLanguageId;
                if (preferences.contains(localizedPreference)) continue;
                ps2.setString(1, this.convertDefaultReminderQueries(localizedPreference, preferences));
                long portalPreferencesId = rs.getLong("portalPreferencesId");
                ps2.setLong(2, portalPreferencesId);
                ps2.addBatch();
            }
            ps2.executeBatch();
        }
    }
}

