/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_5;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;

public class UpgradePortalPreferences
extends UpgradeProcess {
    private static final String[] _OBSOLETE_PORTAL_PREFERENCES = new String[]{"auto.deploy.custom.portlet.xml", "auto.deploy.deploy.dir", "auto.deploy.dest.dir", "auto.deploy.enabled", "auto.deploy.interval", "auto.deploy.jboss.prefix", "auto.deploy.tomcat.conf.dir", "auto.deploy.tomcat.lib.dir", "auto.deploy.unpack.war", "plugin.notifications.enabled", "plugin.notifications.packages.ignored", "plugin.repositories.trusted", "plugin.repositories.untrusted"};
    private static final Log _log = LogFactoryUtil.getLog(UpgradePortalPreferences.class);

    @Override
    protected void doUpgrade() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select companyId from Company");
             ResultSet rs = ps.executeQuery();){
            this.upgradePortalPreferences(0L);
            while (rs.next()) {
                this.upgradePortalPreferences(rs.getLong("companyId"));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void upgradePortalPreferences(long companyId) throws Exception {
        String sql = StringBundler.concat("select portalPreferencesId, preferences from PortalPreferences ", "where ownerId = ", companyId, " and ownerType = ", 1);
        try (PreparedStatement ps1 = this.connection.prepareStatement(sql);
             ResultSet rs = ps1.executeQuery();){
            while (rs.next()) {
                PreparedStatement ps2;
                block37: {
                    String preferences = rs.getString("preferences");
                    Document document = SAXReaderUtil.read(preferences);
                    Element portletPreferencesElement = document.getRootElement();
                    boolean updatedDocument = false;
                    for (String obsoletePortalPreference : _OBSOLETE_PORTAL_PREFERENCES) {
                        XPath xPath = SAXReaderUtil.createXPath("/portlet-preferences/preference[name='" + obsoletePortalPreference + "']");
                        List<Node> nodes = xPath.selectNodes(document);
                        for (Node node : nodes) {
                            Element element = (Element)node;
                            if (_log.isWarnEnabled()) {
                                Element valueElement = element.element("value");
                                String value = valueElement.getStringValue();
                                StringBundler sb = new StringBundler(10);
                                sb.append("Detected a value of \"");
                                sb.append(value);
                                sb.append("\" for portal property ");
                                sb.append(obsoletePortalPreference);
                                sb.append(" stored in portal preferences. ");
                                sb.append("Storing this property in portal ");
                                sb.append("preferences is no longer supported; ");
                                sb.append("please set this property to this ");
                                sb.append("value in portal-ext.properties if you ");
                                sb.append("wish to retain it.");
                                _log.warn(sb.toString());
                            }
                            portletPreferencesElement.remove(element);
                            updatedDocument = true;
                        }
                    }
                    if (!updatedDocument) continue;
                    ps2 = this.connection.prepareStatement("update PortalPreferences set preferences = ? where portalPreferencesId = ?");
                    Throwable throwable = null;
                    try {
                        ps2.setString(1, document.asXML());
                        ps2.setLong(2, rs.getLong("portalPreferencesId"));
                        ps2.executeUpdate();
                        if (ps2 == null) continue;
                        if (throwable == null) break block37;
                    }
                    catch (Throwable throwable2) {
                        try {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (ps2 == null) throw throwable3;
                            if (throwable != null) {
                                try {
                                    ps2.close();
                                    throw throwable3;
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                    throw throwable3;
                                }
                            }
                            ps2.close();
                            throw throwable3;
                        }
                    }
                    try {
                        ps2.close();
                        continue;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                        continue;
                    }
                }
                ps2.close();
            }
            return;
        }
    }
}

