/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBInspector;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class UpgradeMySQL
extends UpgradeProcess {
    private static final Log _log = LogFactoryUtil.getLog(UpgradeMySQL.class);

    @Override
    protected void doUpgrade() throws Exception {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() == DBType.MARIADB || db.getDBType() == DBType.MYSQL) {
            this.upgradeDatetimePrecision();
            this.upgradeTableEngine();
        }
    }

    protected String getActualColumnType(Statement statement, String tableName, String columnName) throws SQLException {
        StringBundler sb = new StringBundler(5);
        sb.append("show columns from ");
        sb.append(tableName);
        sb.append(" like \"");
        sb.append(columnName);
        sb.append("\"");
        try (ResultSet rs = statement.executeQuery(sb.toString());){
            if (!rs.next()) {
                throw new IllegalStateException(StringBundler.concat("Table ", tableName, " does not have column ", columnName));
            }
            String string = rs.getString("Type");
            return string;
        }
    }

    protected void upgradeDatetimePrecision() throws Exception {
        DatabaseMetaData databaseMetaData = this.connection.getMetaData();
        DBInspector dbInspector = new DBInspector(this.connection);
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs = databaseMetaData.getTables(dbInspector.getCatalog(), dbInspector.getSchema(), null, new String[]{"TABLE"});){
            while (rs.next()) {
                String tableName = rs.getString("TABLE_NAME");
                if (!this.isPortal62TableName(tableName)) continue;
                this.upgradeDatetimePrecision(databaseMetaData, statement, rs.getString("TABLE_CAT"), rs.getString("TABLE_SCHEM"), tableName);
            }
        }
    }

    protected void upgradeDatetimePrecision(DatabaseMetaData databaseMetaData, Statement statement, String catalog, String schemaPattern, String tableName) throws SQLException {
        try (ResultSet rs = databaseMetaData.getColumns(catalog, schemaPattern, tableName, null);){
            String modifyClause = "";
            while (rs.next()) {
                String columnName;
                String actualColumnType;
                if (93 != rs.getInt("DATA_TYPE") || (actualColumnType = this.getActualColumnType(statement, tableName, columnName = rs.getString("COLUMN_NAME"))).equals("datetime(6)")) continue;
                if (!modifyClause.equals("")) {
                    modifyClause = modifyClause + ",";
                }
                modifyClause = modifyClause + StringBundler.concat(" MODIFY ", columnName, " datetime(6)");
            }
            if (modifyClause.equals("")) {
                return;
            }
            if (_log.isInfoEnabled()) {
                _log.info(StringBundler.concat("Updating columns for table ", tableName, " to datetime(6)"));
            }
            statement.executeUpdate(StringBundler.concat("ALTER TABLE ", tableName, modifyClause));
        }
    }

    protected void upgradeTableEngine() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             Statement statement = this.connection.createStatement();
             ResultSet rs = statement.executeQuery("show table status");){
            while (rs.next()) {
                String engine;
                String comment;
                String tableName = rs.getString("Name");
                if (!this.isPortal62TableName(tableName) || StringUtil.equalsIgnoreCase(comment = GetterUtil.getString(rs.getString("Comment")), "VIEW") || StringUtil.equalsIgnoreCase(engine = GetterUtil.getString(rs.getString("Engine")), PropsValues.DATABASE_MYSQL_ENGINE)) continue;
                if (_log.isInfoEnabled()) {
                    _log.info(StringBundler.concat("Updating table ", tableName, " to use engine ", PropsValues.DATABASE_MYSQL_ENGINE));
                }
                statement.executeUpdate(StringBundler.concat("alter table ", tableName, " engine ", PropsValues.DATABASE_MYSQL_ENGINE));
            }
        }
    }
}

