/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v7_0_0;

import com.liferay.petra.string.StringPool;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.upgrade.BaseUpgradePortletPreferences;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;

public class UpgradeMessageBoards
extends BaseUpgradePortletPreferences {
    private static final boolean _MESSAGE_BOARDS_EMAIL_HTML_FORMAT = GetterUtil.getBoolean(PropsUtil.get("message.boards.email.html.format"));

    protected String getEmailSignatureSeparator(PortletPreferences portletPreferences) {
        boolean emailHtmlFormat = _MESSAGE_BOARDS_EMAIL_HTML_FORMAT;
        String emailHtmlFormatString = portletPreferences.getValue("emailHtmlFormat", "");
        if (Validator.isNotNull(emailHtmlFormatString)) {
            emailHtmlFormat = GetterUtil.getBoolean(emailHtmlFormatString);
        }
        if (emailHtmlFormat) {
            return "<br />--<br />";
        }
        return "\n--\n";
    }

    @Override
    protected String[] getPortletIds() {
        return new String[]{"19"};
    }

    protected void upgradeEmailSignature(PortletPreferences portletPreferences, String emailMessageBodyPortletPreferencesKey, String emailMessageSignaturePortletPreferencesKey) throws ReadOnlyException {
        String emailMessageSignature = portletPreferences.getValue(emailMessageSignaturePortletPreferencesKey, "");
        if (Validator.isNotNull(emailMessageSignature)) {
            String emailMessageBody = portletPreferences.getValue(emailMessageBodyPortletPreferencesKey, "");
            String signatureSeparator = this.getEmailSignatureSeparator(portletPreferences);
            emailMessageBody = emailMessageBody + signatureSeparator + emailMessageSignature;
            portletPreferences.setValue(emailMessageBodyPortletPreferencesKey, emailMessageBody);
        }
        portletPreferences.reset(emailMessageSignaturePortletPreferencesKey);
    }

    @Override
    protected String upgradePreferences(long companyId, long ownerId, int ownerType, long plid, String portletId, String xml) throws Exception {
        PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.fromXML(companyId, ownerId, ownerType, plid, portletId, xml);
        this.upgradeEmailSignature(portletPreferences, "emailMessageAddedBody", "emailMessageAddedSignature");
        this.upgradeEmailSignature(portletPreferences, "emailMessageUpdatedBody", "emailMessageUpdatedSignature");
        this.upgradeThreadPriorities(portletPreferences);
        return PortletPreferencesFactoryUtil.toXML(portletPreferences);
    }

    protected void upgradeThreadPriorities(PortletPreferences portletPreferences) throws ReadOnlyException {
        Object[] threadPriorities = portletPreferences.getValues("priorities", StringPool.EMPTY_ARRAY);
        if (ArrayUtil.isNotEmpty(threadPriorities)) {
            String[] upgradedThreadPriorities = new String[threadPriorities.length];
            for (int i = 0; i < threadPriorities.length; ++i) {
                Object[] parts = StringUtil.split((String)threadPriorities[i]);
                upgradedThreadPriorities[i] = StringUtil.merge(parts, "|");
            }
            portletPreferences.setValues("priorities", upgradedThreadPriorities);
        }
    }
}

