/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.step.util;

import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeStep;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;

public class UpgradeStepFactory {
    public static UpgradeStep addColumns(final Class<?> tableClass, final String ... columnDefinitions) {
        return new UpgradeProcess(){

            @Override
            protected void doUpgrade() throws Exception {
                this.alter(tableClass, UpgradeStepFactory._getAlterables(x$0 -> new UpgradeProcess.AlterTableAddColumn(this, (String)x$0), columnDefinitions));
            }
        };
    }

    public static UpgradeStep alterColumnTypes(final Class<?> tableClass, final String newType, final String ... columnNames) {
        return new UpgradeProcess(){

            @Override
            protected void doUpgrade() throws Exception {
                this.alter(tableClass, UpgradeStepFactory._getAlterables((x$0, x$1) -> new UpgradeProcess.AlterColumnType(this, (String)x$0, (String)x$1), newType, columnNames));
            }
        };
    }

    public static UpgradeStep dropColumns(final Class<?> tableClass, final String ... tableNames) {
        return new UpgradeProcess(){

            @Override
            protected void doUpgrade() throws Exception {
                this.alter(tableClass, UpgradeStepFactory._getAlterables(x$0 -> new UpgradeProcess.AlterTableDropColumn(this, (String)x$0), tableNames));
            }
        };
    }

    public static UpgradeProcess runSql(final String sql) {
        return new UpgradeProcess(){

            @Override
            protected void doUpgrade() throws Exception {
                this.runSQL(sql);
            }
        };
    }

    private static UpgradeProcess.Alterable[] _getAlterables(BiFunction<String, String, UpgradeProcess.Alterable> alterableBiFunction, String newType, String ... columnNames) {
        return (UpgradeProcess.Alterable[])Arrays.stream(columnNames).map(columnName -> (UpgradeProcess.Alterable)alterableBiFunction.apply((String)columnName, newType)).toArray(UpgradeProcess.Alterable[]::new);
    }

    private static UpgradeProcess.Alterable[] _getAlterables(Function<String, UpgradeProcess.Alterable> alterableFunction, String ... alterableStrings) {
        return (UpgradeProcess.Alterable[])Arrays.stream(alterableStrings).map(alterableFunction).toArray(UpgradeProcess.Alterable[]::new);
    }
}

