/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade;

import com.liferay.portal.kernel.upgrade.DummyUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.version.Version;
import com.liferay.portal.upgrade.v7_2_x.PortalUpgradeProcessRegistryImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;

public class PortalUpgradeProcess
extends UpgradeProcess {
    private static final Version _initialSchemaVersion = new Version(0, 1, 0);
    private static final TreeMap<Version, UpgradeProcess> _upgradeProcesses = new TreeMap<Version, UpgradeProcess>(){
        {
            this.put(_initialSchemaVersion, new DummyUpgradeProcess());
        }
    };

    public static Version getCurrentSchemaVersion(Connection connection) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement("select schemaVersion from Release_ where servletContextName = ?");){
            ps.setString(1, "portal");
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String schemaVersion = rs.getString("schemaVersion");
                    Version version = Version.parseVersion(schemaVersion);
                    return version;
                }
            }
        }
        return new Version(0, 0, 0);
    }

    public static Version getLatestSchemaVersion() {
        return _upgradeProcesses.lastKey();
    }

    public static Version getRequiredSchemaVersion() {
        NavigableSet<Version> reverseSchemaVersions = _upgradeProcesses.descendingKeySet();
        Iterator<Version> itr = reverseSchemaVersions.iterator();
        Version requiredSchemaVersion = itr.next();
        while (itr.hasNext()) {
            Version nextSchemaVersion = itr.next();
            if (requiredSchemaVersion.getMajor() != nextSchemaVersion.getMajor() || requiredSchemaVersion.getMinor() != nextSchemaVersion.getMinor()) break;
            requiredSchemaVersion = nextSchemaVersion;
        }
        return requiredSchemaVersion;
    }

    public static boolean isInLatestSchemaVersion(Connection connection) throws SQLException {
        Version latestSchemaVersion = PortalUpgradeProcess.getLatestSchemaVersion();
        return latestSchemaVersion.equals(PortalUpgradeProcess.getCurrentSchemaVersion(connection));
    }

    public static boolean isInRequiredSchemaVersion(Connection connection) throws SQLException {
        Version requiredSchemaVersion = PortalUpgradeProcess.getRequiredSchemaVersion();
        return requiredSchemaVersion.compareTo(PortalUpgradeProcess.getCurrentSchemaVersion(connection)) <= 0;
    }

    @Override
    protected void doUpgrade() throws Exception {
        PortalUpgradeProcess._initializeSchemaVersion(this.connection);
        for (Version pendingSchemaVersion : this.getPendingSchemaVersions(PortalUpgradeProcess.getCurrentSchemaVersion(this.connection))) {
            this.upgrade(_upgradeProcesses.get(pendingSchemaVersion));
            this.updateSchemaVersion(pendingSchemaVersion);
        }
        this.clearIndexesCache();
    }

    protected Set<Version> getPendingSchemaVersions(Version fromSchemaVersion) {
        NavigableMap<Version, UpgradeProcess> pendingUpgradeProcesses = _upgradeProcesses.tailMap(fromSchemaVersion, false);
        return pendingUpgradeProcesses.keySet();
    }

    protected void updateSchemaVersion(Version newSchemaVersion) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("update Release_ set schemaVersion = ? where servletContextName = ?");){
            ps.setString(1, newSchemaVersion.toString());
            ps.setString(2, "portal");
            ps.execute();
        }
    }

    private static void _initializeSchemaVersion(Connection connection) throws SQLException {
        try (PreparedStatement ps = connection.prepareStatement("update Release_ set schemaVersion = ? where servletContextName = ? and buildNumber < 7100");){
            ps.setString(1, _initialSchemaVersion.toString());
            ps.setString(2, "portal");
            ps.execute();
        }
    }

    static {
        com.liferay.portal.upgrade.v7_1_x.PortalUpgradeProcessRegistryImpl portalUpgradeProcessRegistry = new com.liferay.portal.upgrade.v7_1_x.PortalUpgradeProcessRegistryImpl();
        portalUpgradeProcessRegistry.registerUpgradeProcesses(_upgradeProcesses);
        PortalUpgradeProcessRegistryImpl v72xPortalUpgradeProcessRegistry = new PortalUpgradeProcessRegistryImpl();
        v72xPortalUpgradeProcessRegistry.registerUpgradeProcesses(_upgradeProcesses);
    }
}

