/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.jspc.resin;

import com.liferay.portal.kernel.util.StackTraceUtil;
import com.liferay.portal.util.FileImpl;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.apache.tools.ant.DirectoryScanner;

public class BatchJspCompiler {
    private static final FileImpl _fileUtil = FileImpl.getInstance();
    private final String _appDir;
    private final String _classDir;

    public static void main(String[] args) {
        if (args.length != 2) {
            throw new IllegalArgumentException();
        }
        new BatchJspCompiler(args[0], args[1]);
    }

    public BatchJspCompiler(String appDir, String classDir) {
        this._appDir = appDir;
        this._classDir = classDir;
        try {
            DirectoryScanner ds = new DirectoryScanner();
            ds.setBasedir(appDir);
            ds.setIncludes(new String[]{"**\\*.jsp"});
            ds.scan();
            Object[] fileNames = ds.getIncludedFiles();
            Arrays.sort(fileNames);
            this._compile((String[])fileNames);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _compile(String[] fileNames) throws Exception {
        if (fileNames.length == 0) {
            return;
        }
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.add("-app-dir");
        arguments.add(this._appDir);
        arguments.add("-class-dir");
        arguments.add(this._classDir);
        Collections.addAll(arguments, fileNames);
        Class<?> clazz = Class.forName("com.caucho.jsp.JspCompiler");
        Method method = clazz.getMethod("main", String[].class);
        try {
            method.invoke(null, new Object[]{arguments.toArray(new String[0])});
        }
        catch (Exception e) {
            _fileUtil.write(this._appDir + "/../jspc_error", StackTraceUtil.getStackTrace(e));
        }
    }
}

