/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.deploy;

import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.xml.DocUtil;
import com.liferay.petra.xml.XMLUtil;
import com.liferay.portal.deploy.DeployUtil;
import com.liferay.portal.kernel.deploy.Deployer;
import com.liferay.portal.kernel.deploy.auto.AutoDeployException;
import com.liferay.portal.kernel.deploy.auto.AutoDeployer;
import com.liferay.portal.kernel.deploy.auto.context.AutoDeploymentContext;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.plugin.License;
import com.liferay.portal.kernel.plugin.PluginPackage;
import com.liferay.portal.kernel.servlet.PluginContextListener;
import com.liferay.portal.kernel.servlet.PortalClassLoaderServlet;
import com.liferay.portal.kernel.servlet.PortalDelegateServlet;
import com.liferay.portal.kernel.servlet.PortletServlet;
import com.liferay.portal.kernel.servlet.SecurePluginContextListener;
import com.liferay.portal.kernel.servlet.SecureServlet;
import com.liferay.portal.kernel.servlet.SerializableSessionAttributeListener;
import com.liferay.portal.kernel.servlet.filters.invoker.InvokerFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.ServerDetector;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.plugin.PluginPackageUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.WebXMLBuilder;
import com.liferay.portal.tools.deploy.DeploymentHandler;
import com.liferay.portal.tools.deploy.extension.DeploymentExtension;
import com.liferay.portal.util.ExtRegistry;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.webserver.DynamicResourceServlet;
import com.liferay.util.ant.CopyTask;
import com.liferay.util.ant.DeleteTask;
import com.liferay.util.ant.ExpandTask;
import com.liferay.util.ant.UpToDateTask;
import com.liferay.util.ant.WarTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.oro.io.GlobFilenameFilter;

public class BaseDeployer
implements AutoDeployer,
Deployer {
    public static final String DEPLOY_TO_PREFIX = "DEPLOY_TO__";
    protected String appServerType;
    protected String auiTaglibDTD;
    protected String baseDir;
    protected String destDir;
    protected String filePattern;
    protected List<String> jars;
    protected String jbossPrefix;
    protected String portletExtTaglibDTD;
    protected String portletTaglibDTD;
    protected String securityTaglibDTD;
    protected final Set<Path> tempDirPaths = new HashSet<Path>();
    protected String themeTaglibDTD;
    protected String tomcatLibDir;
    protected String uiTaglibDTD;
    protected boolean unpackWar;
    protected String utilTaglibDTD;
    protected List<String> wars;
    protected String wildflyPrefix;
    private static final String _PORTAL_CLASS_LOADER = "com.liferay.support.tomcat.loader.PortalClassLoader";
    private static final Log _log = LogFactoryUtil.getLog(BaseDeployer.class);
    private final List<DeploymentExtension> _deploymentExtensions = new ArrayList<DeploymentExtension>();

    public static void main(String[] args) {
        block9: {
            ToolDependencies.wireDeployers();
            ArrayList<String> wars = new ArrayList<String>();
            ArrayList<String> jars = new ArrayList<String>();
            for (String arg : args) {
                String fileName = StringUtil.toLowerCase(arg);
                if (fileName.endsWith(".war")) {
                    wars.add(arg);
                    continue;
                }
                if (!fileName.endsWith(".jar")) continue;
                jars.add(arg);
            }
            try {
                BaseDeployer baseDeployer = new BaseDeployer(wars, jars);
                Throwable throwable = null;
                if (baseDeployer != null) {
                    if (throwable != null) {
                        try {
                            baseDeployer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    } else {
                        baseDeployer.close();
                    }
                }
            }
            catch (IOException ioe) {
                if (!_log.isWarnEnabled()) break block9;
                _log.warn(ioe, ioe);
            }
        }
    }

    public BaseDeployer() {
        ServiceLoader<DeploymentExtension> serviceLoader = ServiceLoader.load(DeploymentExtension.class, BaseDeployer.class.getClassLoader());
        for (DeploymentExtension deploymentExtension : serviceLoader) {
            this._deploymentExtensions.add(deploymentExtension);
        }
    }

    public BaseDeployer(List<String> wars, List<String> jars) {
        this();
        this.baseDir = System.getProperty("deployer.base.dir");
        this.destDir = System.getProperty("deployer.dest.dir");
        this.appServerType = System.getProperty("deployer.app.server.type");
        this.auiTaglibDTD = System.getProperty("deployer.aui.taglib.dtd");
        this.portletTaglibDTD = System.getProperty("deployer.portlet.taglib.dtd");
        this.portletExtTaglibDTD = System.getProperty("deployer.portlet-ext.taglib.dtd");
        this.securityTaglibDTD = System.getProperty("deployer.security.taglib.dtd");
        this.themeTaglibDTD = System.getProperty("deployer.theme.taglib.dtd");
        this.uiTaglibDTD = System.getProperty("deployer.ui.taglib.dtd");
        this.utilTaglibDTD = System.getProperty("deployer.util.taglib.dtd");
        this.unpackWar = GetterUtil.getBoolean(System.getProperty("deployer.unpack.war"), true);
        this.filePattern = System.getProperty("deployer.file.pattern");
        this.jbossPrefix = GetterUtil.getString(System.getProperty("deployer.jboss.prefix"));
        this.tomcatLibDir = System.getProperty("deployer.tomcat.lib.dir");
        this.wildflyPrefix = GetterUtil.getString(System.getProperty("deployer.wildfly.prefix"));
        this.wars = wars;
        this.jars = jars;
        this.checkArguments();
        String context = System.getProperty("deployer.context");
        try {
            this.deploy(context);
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public void addExtJar(List<String> jars, String resource) throws Exception {
        Set<String> servletContextNames = ExtRegistry.getServletContextNames();
        for (String servletContextName : servletContextNames) {
            String extResource = "ext-" + servletContextName + resource.substring(3);
            String path = DeployUtil.getResourcePath(this.tempDirPaths, extResource);
            if (_log.isDebugEnabled()) {
                if (path == null) {
                    _log.debug("Resource " + extResource + " is not available");
                } else {
                    _log.debug(StringBundler.concat("Resource ", extResource, " is available at ", path));
                }
            }
            if (path == null) continue;
            jars.add(path);
        }
    }

    @Override
    public void addRequiredJar(List<String> jars, String resource) throws Exception {
        String path = DeployUtil.getResourcePath(this.tempDirPaths, resource);
        if (path == null) {
            throw new RuntimeException("Resource " + resource + " does not exist");
        }
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Resource ", resource, " is available at ", path));
        }
        jars.add(path);
    }

    @Override
    public int autoDeploy(AutoDeploymentContext autoDeploymentContext) throws AutoDeployException {
        ArrayList<String> wars = new ArrayList<String>();
        File file = autoDeploymentContext.getFile();
        wars.add(file.getName());
        this.wars = wars;
        try {
            return this.deployFile(autoDeploymentContext);
        }
        catch (Exception e) {
            throw new AutoDeployException(e);
        }
    }

    @Override
    public void checkArguments() {
        if (Validator.isNull(this.baseDir)) {
            throw new IllegalArgumentException("The system property deployer.base.dir is not set");
        }
        if (Validator.isNull(this.destDir)) {
            throw new IllegalArgumentException("The system property deployer.dest.dir is not set");
        }
        if (Validator.isNull(this.appServerType)) {
            throw new IllegalArgumentException("The system property deployer.app.server.type is not set");
        }
        if (!ServerDetector.isSupported(this.appServerType)) {
            throw new IllegalArgumentException(this.appServerType + " is not a valid application server type");
        }
        if (this.appServerType.equals("glassfish") || this.appServerType.equals("websphere")) {
            this.unpackWar = false;
        }
        if (Validator.isNotNull(this.jbossPrefix) && !Validator.isNumber(this.jbossPrefix)) {
            this.jbossPrefix = "1";
        }
        if (Validator.isNotNull(this.wildflyPrefix) && !Validator.isNumber(this.wildflyPrefix)) {
            this.wildflyPrefix = "1";
        }
    }

    @Override
    public AutoDeployer cloneAutoDeployer() throws AutoDeployException {
        try {
            Class<?> clazz = this.getClass();
            BaseDeployer baseDeployer = (BaseDeployer)clazz.newInstance();
            baseDeployer.setAppServerType(this.appServerType);
            baseDeployer.setAuiTaglibDTD(this.auiTaglibDTD);
            baseDeployer.setBaseDir(this.baseDir);
            baseDeployer.setDestDir(this.destDir);
            baseDeployer.setFilePattern(this.filePattern);
            baseDeployer.setJars(this.jars);
            baseDeployer.setJbossPrefix(this.jbossPrefix);
            baseDeployer.setPortletExtTaglibDTD(this.portletExtTaglibDTD);
            baseDeployer.setPortletTaglibDTD(this.portletTaglibDTD);
            baseDeployer.setSecurityTaglibDTD(this.securityTaglibDTD);
            baseDeployer.setThemeTaglibDTD(this.themeTaglibDTD);
            baseDeployer.setTomcatLibDir(this.tomcatLibDir);
            baseDeployer.setUiTaglibDTD(this.uiTaglibDTD);
            baseDeployer.setUnpackWar(this.unpackWar);
            baseDeployer.setUtilTaglibDTD(this.utilTaglibDTD);
            baseDeployer.setWars(this.wars);
            baseDeployer.setWildflyPrefix(this.wildflyPrefix);
            return baseDeployer;
        }
        catch (Exception e) {
            throw new AutoDeployException(e);
        }
    }

    @Override
    public void close() throws IOException {
        UnsafeConsumer.accept(this.tempDirPaths, DeployUtil::deletePath, IOException.class);
    }

    @Override
    public void copyDependencyXml(String fileName, String targetDir) throws Exception {
        this.copyDependencyXml(fileName, targetDir, null);
    }

    @Override
    public void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap) throws Exception {
        this.copyDependencyXml(fileName, targetDir, filterMap, false);
    }

    @Override
    public void copyDependencyXml(String fileName, String targetDir, Map<String, String> filterMap, boolean overwrite) throws Exception {
        DeployUtil.copyDependencyXml(fileName, targetDir, fileName, filterMap, overwrite);
    }

    @Override
    public void copyJars(File srcFile, PluginPackage pluginPackage) throws Exception {
        for (String jarFullName : this.jars) {
            String jarName = jarFullName.substring(jarFullName.lastIndexOf("/") + 1);
            if (!FileUtil.exists(jarFullName)) {
                DeployUtil.getResourcePath(this.tempDirPaths, jarName);
            }
            FileUtil.copyFile(jarFullName, srcFile + "/WEB-INF/lib/" + jarName, false);
        }
    }

    public void copyPortalDependencies(File srcFile) throws Exception {
        Object[] log4jJars;
        Object[] commonsLoggingJars;
        String[] portalTlds;
        String[] portalJars;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null) {
            return;
        }
        for (String portalJar : portalJars = StringUtil.split(properties.getProperty("portal-dependency-jars", properties.getProperty("portal.dependency.jars")))) {
            portalJar = portalJar.trim();
            portalJar = this.fixPortalDependencyJar(portalJar);
            if (_log.isDebugEnabled()) {
                _log.debug("Copy portal JAR " + portalJar);
            }
            try {
                String portalJarPath = PortalUtil.getPortalLibDir() + portalJar;
                FileUtil.copyFile(portalJarPath, srcFile + "/WEB-INF/lib/" + portalJar, true);
            }
            catch (Exception e) {
                _log.error("Unable to copy portal JAR " + portalJar, e);
            }
        }
        for (String portalTld : portalTlds = StringUtil.split(properties.getProperty("portal-dependency-tlds", properties.getProperty("portal.dependency.tlds")))) {
            portalTld = portalTld.trim();
            if (_log.isDebugEnabled()) {
                _log.debug("Copy portal TLD " + portalTld);
            }
            try {
                String portalTldPath = DeployUtil.getResourcePath(this.tempDirPaths, portalTld);
                FileUtil.copyFile(portalTldPath, srcFile + "/WEB-INF/tld/" + portalTld, true);
            }
            catch (Exception e) {
                _log.error("Unable to copy portal TLD " + portalTld, e);
            }
        }
        File pluginLibDir = new File(srcFile + "/WEB-INF/lib/");
        if (PropsValues.AUTO_DEPLOY_COPY_COMMONS_LOGGING && ArrayUtil.isEmpty(commonsLoggingJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("commons-logging*.jar")))) {
            String portalJarPath = PortalUtil.getPortalLibDir() + "commons-logging.jar";
            FileUtil.copyFile(portalJarPath, srcFile + "/WEB-INF/lib/commons-logging.jar", true);
        }
        if (PropsValues.AUTO_DEPLOY_COPY_LOG4J && ArrayUtil.isEmpty(log4jJars = pluginLibDir.list((FilenameFilter)new GlobFilenameFilter("log4j*.jar")))) {
            String portalJarPath = PortalUtil.getPortalLibDir() + "log4j.jar";
            FileUtil.copyFile(portalJarPath, srcFile + "/WEB-INF/lib/log4j.jar", true);
            portalJarPath = PortalUtil.getPortalLibDir() + "log4j-extras.jar";
            FileUtil.copyFile(portalJarPath, srcFile + "/WEB-INF/lib/log4j-extras.jar", true);
        }
    }

    @Override
    public void copyProperties(File srcFile, PluginPackage pluginPackage) throws Exception {
        File servicePropertiesFile;
        if (PropsValues.AUTO_DEPLOY_COPY_COMMONS_LOGGING) {
            this.copyDependencyXml("logging.properties", srcFile + "/WEB-INF/classes");
        }
        if (PropsValues.AUTO_DEPLOY_COPY_LOG4J) {
            this.copyDependencyXml("log4j.properties", srcFile + "/WEB-INF/classes");
        }
        if (!(servicePropertiesFile = new File(srcFile.getAbsolutePath() + "/WEB-INF/classes/service.properties")).exists()) {
            return;
        }
        File portletPropertiesFile = new File(srcFile.getAbsolutePath() + "/WEB-INF/classes/portlet.properties");
        if (portletPropertiesFile.exists()) {
            return;
        }
        String pluginPackageName = null;
        pluginPackageName = pluginPackage != null ? pluginPackage.getName() : srcFile.getName();
        FileUtil.write(portletPropertiesFile, "plugin.package.name=" + pluginPackageName);
    }

    @Override
    public void copyTlds(File srcFile, PluginPackage pluginPackage) throws Exception {
        if (Validator.isNotNull(this.auiTaglibDTD)) {
            FileUtil.copyFile(this.auiTaglibDTD, srcFile + "/WEB-INF/tld/liferay-aui.tld", true);
        }
        if (Validator.isNotNull(this.portletTaglibDTD)) {
            FileUtil.copyFile(this.portletTaglibDTD, srcFile + "/WEB-INF/tld/liferay-portlet.tld", true);
            FileUtil.copyFile(DeployUtil.getResourcePath(this.tempDirPaths, "liferay-portlet_2_0.tld"), srcFile + "/WEB-INF/tld/liferay-portlet_2_0.tld", true);
        }
        if (Validator.isNotNull(this.portletExtTaglibDTD)) {
            FileUtil.copyFile(this.portletExtTaglibDTD, srcFile + "/WEB-INF/tld/liferay-portlet-ext.tld", true);
        }
        if (Validator.isNotNull(this.securityTaglibDTD)) {
            FileUtil.copyFile(this.securityTaglibDTD, srcFile + "/WEB-INF/tld/liferay-security.tld", true);
        }
        if (Validator.isNotNull(this.themeTaglibDTD)) {
            FileUtil.copyFile(this.themeTaglibDTD, srcFile + "/WEB-INF/tld/liferay-theme.tld", true);
        }
        if (Validator.isNotNull(this.uiTaglibDTD)) {
            FileUtil.copyFile(this.uiTaglibDTD, srcFile + "/WEB-INF/tld/liferay-ui.tld", true);
        }
        if (Validator.isNotNull(this.utilTaglibDTD)) {
            FileUtil.copyFile(this.utilTaglibDTD, srcFile + "/WEB-INF/tld/liferay-util.tld", true);
        }
    }

    public void copyTomcatContextXml(File targetDir) throws Exception {
        if (!this.appServerType.equals("tomcat")) {
            return;
        }
        File targetFile = new File(targetDir, "META-INF/context.xml");
        if (targetFile.exists()) {
            return;
        }
        String contextPath = DeployUtil.getResourcePath(this.tempDirPaths, "context.xml");
        String content = FileUtil.read(contextPath);
        if (!PropsValues.AUTO_DEPLOY_UNPACK_WAR) {
            content = StringUtil.replace(content, "antiResourceLocking=\"true\"", "");
        }
        FileUtil.write(targetFile, content);
    }

    @Override
    public void copyXmls(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (this.appServerType.equals("jboss") || this.appServerType.equals("wildfly")) {
            File file = new File(PropsValues.LIFERAY_WEB_PORTAL_DIR);
            this.copyDependencyXml("jboss-all.xml", srcFile + "/WEB-INF", Collections.singletonMap("root_war", file.getName()), true);
            this.copyDependencyXml("jboss-deployment-structure.xml", srcFile + "/WEB-INF");
        }
        for (DeploymentExtension deploymentExtension : this._deploymentExtensions) {
            if (!Objects.equals(this.appServerType, deploymentExtension.getServerId())) continue;
            deploymentExtension.copyXmls(this, srcFile);
        }
        this.copyDependencyXml("web.xml", srcFile + "/WEB-INF");
    }

    public void deploy(String context) throws Exception {
        try {
            File baseDirFile = new File(this.baseDir);
            File[] files = baseDirFile.listFiles();
            if (files == null) {
                return;
            }
            for (File srcFile : files = FileUtil.sortFiles(files)) {
                String fileName = StringUtil.toLowerCase(srcFile.getName());
                boolean deploy = false;
                if (fileName.endsWith(".war") || fileName.endsWith(".zip")) {
                    deploy = true;
                    if (!this.wars.isEmpty()) {
                        if (!this.wars.contains(srcFile.getName())) {
                            deploy = false;
                        }
                    } else if (Validator.isNotNull(this.filePattern) && !StringUtil.matchesIgnoreCase(fileName, this.filePattern)) {
                        deploy = false;
                    }
                }
                if (!deploy) continue;
                AutoDeploymentContext autoDeploymentContext = new AutoDeploymentContext();
                autoDeploymentContext.setContext(context);
                autoDeploymentContext.setFile(srcFile);
                this.deployFile(autoDeploymentContext);
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    public void deployDirectory(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        File extLibPortalDir;
        this.rewriteFiles(srcFile);
        this.mergeDirectory(mergeDir, srcFile);
        this.processPluginPackageProperties(srcFile, displayName, pluginPackage);
        this.copyJars(srcFile, pluginPackage);
        this.copyProperties(srcFile, pluginPackage);
        this.copyTlds(srcFile, pluginPackage);
        this.copyXmls(srcFile, displayName, pluginPackage);
        this.copyPortalDependencies(srcFile);
        File webXml = new File(srcFile + "/WEB-INF/web.xml");
        this.updateWebXml(webXml, srcFile, displayName, pluginPackage);
        File extLibGlobalDir = new File(srcFile.getAbsolutePath() + "/WEB-INF/ext-lib/global");
        if (extLibGlobalDir.exists()) {
            File globalLibDir = new File(PortalUtil.getGlobalLibDir());
            CopyTask.copyDirectory(extLibGlobalDir, globalLibDir, "*.jar", "", overwrite, true);
        }
        if ((extLibPortalDir = new File(srcFile.getAbsolutePath() + "/WEB-INF/ext-lib/portal")).exists()) {
            File portalLibDir = new File(PortalUtil.getPortalLibDir());
            CopyTask.copyDirectory(extLibPortalDir, portalLibDir, "*.jar", "", overwrite, true);
        }
        if (deployDir == null || this.baseDir.equals(this.destDir)) {
            return;
        }
        this.updateDeployDirectory(srcFile);
        String excludes = "";
        if (this.appServerType.equals("jboss") || this.appServerType.equals("wildfly")) {
            excludes = excludes + "**/WEB-INF/lib/log4j.jar,";
        } else if (this.appServerType.equals("tomcat")) {
            String content22;
            String[] libs;
            for (String lib : libs = FileUtil.listFiles(this.tomcatLibDir)) {
                excludes = excludes + "**/WEB-INF/lib/" + lib + ",";
            }
            File contextXml = new File(srcFile + "/META-INF/context.xml");
            if (contextXml.exists() && (content22 = FileUtil.read(contextXml)).contains(_PORTAL_CLASS_LOADER)) {
                excludes = excludes + "**/WEB-INF/lib/util-bridges.jar,";
                excludes = excludes + "**/WEB-INF/lib/util-java.jar,";
                excludes = excludes + "**/WEB-INF/lib/util-taglib.jar,";
            }
            try {
                Class.forName("javax.el.ELContext");
                excludes = excludes + "**/WEB-INF/lib/el-api.jar,";
            }
            catch (ClassNotFoundException content22) {
                // empty catch block
            }
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            String deployExcludes = properties.getProperty("deploy-excludes");
            if (deployExcludes != null && !(excludes = excludes + deployExcludes.trim()).endsWith(",")) {
                excludes = excludes + ",";
            }
            if ((deployExcludes = properties.getProperty("deploy-excludes-" + this.appServerType)) != null && !(excludes = excludes + deployExcludes.trim()).endsWith(",")) {
                excludes = excludes + ",";
            }
        }
        if (_log.isDebugEnabled()) {
            _log.debug("Excludes " + excludes);
        }
        if (!this.unpackWar) {
            Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get("java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
            File tempDir = tempDirPath.toFile();
            excludes = excludes + "/WEB-INF/web.xml";
            File tempFile = new File(tempDir, displayName + ".war");
            WarTask.war(srcFile, tempFile, excludes, webXml);
            if (this.isJEEDeploymentEnabled()) {
                File tempWarDir = new File(tempDir.getParent(), deployDir.getName());
                if (tempWarDir.exists()) {
                    tempWarDir.delete();
                }
                if (!tempDir.renameTo(tempWarDir)) {
                    tempWarDir = tempDir;
                }
                DeploymentHandler deploymentHandler = this.getDeploymentHandler();
                deploymentHandler.deploy(tempWarDir, displayName);
                deploymentHandler.releaseDeploymentManager();
                DeleteTask.deleteDirectory(tempWarDir);
            } else {
                if (!tempFile.renameTo(deployDir)) {
                    WarTask.war(srcFile, deployDir, excludes, webXml);
                }
                if (tempDir.isDirectory()) {
                    DeleteTask.deleteDirectory(tempDir);
                } else {
                    tempDir.delete();
                }
            }
        } else {
            excludes = excludes + "**/WEB-INF/web.xml";
            CopyTask.copyDirectory(srcFile, deployDir, "", excludes, overwrite, true);
            CopyTask.copyDirectory(srcFile, deployDir, "**/WEB-INF/web.xml", "", true, false);
            if (this.appServerType.equals("tomcat")) {
                File deployWebXml = new File(deployDir + "/WEB-INF/web.xml");
                deployWebXml.setLastModified(System.currentTimeMillis() + 6000L);
            }
        }
        if (this.appServerType.equals("jetty")) {
            DeployUtil.redeployJetty(displayName);
        }
    }

    public void deployDirectory(File srcFile, String displayName, boolean override, PluginPackage pluginPackage) throws Exception {
        this.deployDirectory(srcFile, null, null, displayName, override, pluginPackage);
    }

    public int deployFile(AutoDeploymentContext autoDeploymentContext) throws Exception {
        String specifiedContext;
        String autoDeploymentContextAppServerType;
        File srcFile = autoDeploymentContext.getFile();
        PluginPackage pluginPackage = autoDeploymentContext.getPluginPackage();
        if (pluginPackage == null) {
            pluginPackage = this.readPluginPackage(srcFile);
            autoDeploymentContext.setPluginPackage(pluginPackage);
        }
        if (_log.isInfoEnabled()) {
            _log.info("Deploying " + srcFile.getName());
        }
        if (Validator.isNotNull(autoDeploymentContextAppServerType = autoDeploymentContext.getAppServerType())) {
            this.appServerType = autoDeploymentContextAppServerType;
        }
        String displayName = specifiedContext = autoDeploymentContext.getContext();
        boolean overwrite = false;
        String preliminaryContext = specifiedContext;
        String srcFileName = srcFile.getName();
        if (Validator.isNull(specifiedContext) && srcFileName.startsWith(DEPLOY_TO_PREFIX)) {
            displayName = srcFileName.substring(DEPLOY_TO_PREFIX.length(), srcFileName.length() - 4);
            overwrite = true;
            preliminaryContext = displayName;
        }
        if (preliminaryContext == null) {
            preliminaryContext = this.getDisplayName(srcFile);
        }
        if (pluginPackage != null) {
            if (!PluginPackageUtil.isCurrentVersionSupported(pluginPackage.getLiferayVersions())) {
                throw new AutoDeployException(srcFile.getName() + " does not support this version of Liferay");
            }
            if (displayName == null) {
                displayName = pluginPackage.getRecommendedDeploymentContext();
            }
            if (Validator.isNull(displayName)) {
                displayName = this.getDisplayName(srcFile);
            }
            pluginPackage.setContext(displayName);
            PluginPackageUtil.updateInstallingPluginPackage(preliminaryContext, pluginPackage);
        }
        String deployDir = null;
        if (Validator.isNotNull(displayName)) {
            deployDir = displayName + ".war";
        } else {
            deployDir = srcFile.getName();
            displayName = this.getDisplayName(srcFile);
        }
        if (this.appServerType.equals("jboss")) {
            deployDir = this.jbossPrefix + deployDir;
        } else if (this.appServerType.equals("wildfly")) {
            deployDir = GetterUtil.getString(this.wildflyPrefix) + deployDir;
        } else if ((this.appServerType.equals("glassfish") || this.appServerType.equals("jetty") || this.appServerType.equals("jonas") || this.appServerType.equals("oc4j") || this.appServerType.equals("resin") || this.appServerType.equals("tomcat") || this.appServerType.equals("weblogic")) && this.unpackWar) {
            deployDir = deployDir.substring(0, deployDir.length() - 4);
        }
        String destDir = this.destDir;
        if (autoDeploymentContext.getDestDir() != null) {
            destDir = autoDeploymentContext.getDestDir();
        }
        File deployDirFile = new File(destDir + "/" + deployDir);
        try {
            PluginPackage previousPluginPackage = this.readPluginPackage(deployDirFile);
            if (pluginPackage != null && previousPluginPackage != null) {
                String name = pluginPackage.getName();
                String previousVersion = previousPluginPackage.getVersion();
                String version = pluginPackage.getVersion();
                if (_log.isInfoEnabled()) {
                    _log.info(StringBundler.concat("Updating ", name, " from version ", previousVersion, " to version ", version));
                }
                if (pluginPackage.isPreviousVersionThan(previousPluginPackage)) {
                    if (_log.isInfoEnabled()) {
                        _log.info(StringBundler.concat("Not updating ", name, " because version ", previousVersion, " is newer than version ", version));
                    }
                    return 2;
                }
                overwrite = true;
            }
            File mergeDirFile = new File(srcFile.getParent() + "/merge/" + srcFile.getName());
            if (srcFile.isDirectory()) {
                this.deployDirectory(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
            } else {
                boolean deployed = this.deployFile(srcFile, mergeDirFile, deployDirFile, displayName, overwrite, pluginPackage);
                if (!deployed) {
                    String context = preliminaryContext;
                    if (pluginPackage != null) {
                        context = pluginPackage.getContext();
                    }
                    PluginPackageUtil.endPluginPackageInstallation(context);
                } else {
                    this.postDeploy(destDir, deployDir);
                }
            }
            return 1;
        }
        catch (Exception e) {
            if (pluginPackage != null) {
                PluginPackageUtil.endPluginPackageInstallation(pluginPackage.getContext());
            }
            throw e;
        }
    }

    public boolean deployFile(File srcFile, File mergeDir, File deployDir, String displayName, boolean overwrite, PluginPackage pluginPackage) throws Exception {
        boolean undeployOnRedeploy = false;
        try {
            undeployOnRedeploy = PrefsPropsUtil.getBoolean("hot.undeploy.on.redeploy", PropsValues.HOT_UNDEPLOY_ON_REDEPLOY);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (undeployOnRedeploy) {
            DeployUtil.undeploy(this.appServerType, deployDir);
        }
        if (!overwrite && UpToDateTask.isUpToDate(srcFile, deployDir)) {
            if (_log.isInfoEnabled()) {
                _log.info(deployDir + " is already up to date");
            }
            return false;
        }
        Path tempDirPath = Files.createTempDirectory(Paths.get(SystemProperties.get("java.io.tmpdir"), new String[0]), null, new FileAttribute[0]);
        File tempDir = tempDirPath.toFile();
        ExpandTask.expand(srcFile, tempDir);
        this.deployDirectory(tempDir, mergeDir, deployDir, displayName, overwrite, pluginPackage);
        DeleteTask.deleteDirectory(tempDir);
        return true;
    }

    public String fixPortalDependencyJar(String portalJar) {
        if (portalJar.equals("antlr.jar")) {
            portalJar = "antlr2.jar";
        }
        return portalJar;
    }

    public DeploymentHandler getDeploymentHandler() {
        String prefix = "auto.deploy." + ServerDetector.getServerId() + ".jee.";
        String dmId = PropsUtil.get(prefix + "dm.id");
        String dmUser = PropsUtil.get(prefix + "dm.user");
        String dmPassword = PropsUtil.get(prefix + "dm.passwd");
        String dfClassName = PropsUtil.get(prefix + "df.classname");
        return new DeploymentHandler(dmId, dmUser, dmPassword, dfClassName);
    }

    public String getDisplayName(File srcFile) {
        String displayName = srcFile.getName();
        if (StringUtil.endsWith(displayName, ".war") || StringUtil.endsWith(displayName, ".xml")) {
            displayName = displayName.substring(0, displayName.length() - 4);
        }
        if (this.appServerType.equals("jboss") && Validator.isNotNull(this.jbossPrefix) && displayName.startsWith(this.jbossPrefix) || this.appServerType.equals("wildfly") && Validator.isNotNull(this.wildflyPrefix) && displayName.startsWith(this.wildflyPrefix)) {
            displayName = displayName.substring(1);
        }
        return displayName;
    }

    public String getDynamicResourceServletContent() {
        StringBundler sb = new StringBundler();
        sb.append("<servlet>");
        sb.append("<servlet-name>");
        sb.append("Dynamic Resource Servlet");
        sb.append("</servlet-name>");
        sb.append("<servlet-class>");
        sb.append(PortalClassLoaderServlet.class.getName());
        sb.append("</servlet-class>");
        sb.append("<init-param>");
        sb.append("<param-name>");
        sb.append("servlet-class");
        sb.append("</param-name>");
        sb.append("<param-value>");
        sb.append(DynamicResourceServlet.class.getName());
        sb.append("</param-value>");
        sb.append("</init-param>");
        sb.append("<load-on-startup>1</load-on-startup>");
        sb.append("</servlet>");
        for (String allowedPath : PropsValues.DYNAMIC_RESOURCE_SERVLET_ALLOWED_PATHS) {
            sb.append("<servlet-mapping>");
            sb.append("<servlet-name>");
            sb.append("Dynamic Resource Servlet");
            sb.append("</servlet-name>");
            sb.append("<url-pattern>");
            sb.append(allowedPath);
            if (!allowedPath.endsWith("/")) {
                sb.append("/");
            }
            sb.append("*");
            sb.append("</url-pattern>");
            sb.append("</servlet-mapping>");
        }
        return sb.toString();
    }

    public String getExtraContent(double webXmlVersion, File srcFile, String displayName) throws Exception {
        if (displayName.startsWith("/")) {
            displayName = displayName.substring(1);
        }
        StringBundler sb = new StringBundler(70);
        sb.append("<display-name>");
        sb.append(displayName);
        sb.append("</display-name>");
        if (webXmlVersion < 2.4) {
            sb.append("<context-param>");
            sb.append("<param-name>liferay-invoker-enabled</param-name>");
            sb.append("<param-value>false</param-value>");
            sb.append("</context-param>");
        }
        if (PropsValues.SESSION_VERIFY_SERIALIZABLE_ATTRIBUTE) {
            sb.append("<listener>");
            sb.append("<listener-class>");
            sb.append(SerializableSessionAttributeListener.class.getName());
            sb.append("</listener-class>");
            sb.append("</listener>");
        }
        sb.append(this.getDynamicResourceServletContent());
        boolean hasTaglib = false;
        if (Validator.isNotNull(this.auiTaglibDTD) || Validator.isNotNull(this.portletTaglibDTD) || Validator.isNotNull(this.portletExtTaglibDTD) || Validator.isNotNull(this.securityTaglibDTD) || Validator.isNotNull(this.themeTaglibDTD) || Validator.isNotNull(this.uiTaglibDTD) || Validator.isNotNull(this.utilTaglibDTD)) {
            hasTaglib = true;
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("<jsp-config>");
        }
        if (Validator.isNotNull(this.auiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/aui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-aui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull(this.portletTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://java.sun.com/portlet_2_0");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet_2_0.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://xmlns.jcp.org/portlet_3_0");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull(this.portletExtTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/portlet");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-portlet-ext.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull(this.securityTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>");
            sb.append("http://liferay.com/tld/security");
            sb.append("</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-security.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull(this.themeTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/theme</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-theme.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull(this.uiTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/ui</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-ui.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (Validator.isNotNull(this.utilTaglibDTD)) {
            sb.append("<taglib>");
            sb.append("<taglib-uri>http://liferay.com/tld/util</taglib-uri>");
            sb.append("<taglib-location>");
            sb.append("/WEB-INF/tld/liferay-util.tld");
            sb.append("</taglib-location>");
            sb.append("</taglib>");
        }
        if (hasTaglib && webXmlVersion > 2.3) {
            sb.append("</jsp-config>");
        }
        return sb.toString();
    }

    public String getExtraFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        return this.getSessionFiltersContent();
    }

    public String getIgnoreFiltersContent(File srcFile) throws Exception {
        boolean ignoreFiltersEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            ignoreFiltersEnabled = GetterUtil.getBoolean(properties.getProperty("ignore-filters-enabled"), true);
        }
        if (ignoreFiltersEnabled) {
            return FileUtil.read(DeployUtil.getResourcePath(this.tempDirPaths, "ignore-filters-web.xml"));
        }
        return "";
    }

    public String getInvokerFilterContent() {
        StringBundler sb = new StringBundler(5);
        sb.append(this.getInvokerFilterContent("ASYNC"));
        sb.append(this.getInvokerFilterContent("ERROR"));
        sb.append(this.getInvokerFilterContent("FORWARD"));
        sb.append(this.getInvokerFilterContent("INCLUDE"));
        sb.append(this.getInvokerFilterContent("REQUEST"));
        return sb.toString();
    }

    public String getInvokerFilterContent(String dispatcher) {
        StringBundler sb = new StringBundler(24);
        sb.append("<filter>");
        sb.append("<filter-name>Invoker Filter - ");
        sb.append(dispatcher);
        sb.append("</filter-name>");
        sb.append("<filter-class>");
        sb.append(InvokerFilter.class.getName());
        sb.append("</filter-class>");
        sb.append("<async-supported>true</async-supported>");
        sb.append("<init-param>");
        sb.append("<param-name>dispatcher</param-name>");
        sb.append("<param-value>");
        sb.append(dispatcher);
        sb.append("</param-value>");
        sb.append("</init-param>");
        sb.append("</filter>");
        sb.append("<filter-mapping>");
        sb.append("<filter-name>Invoker Filter - ");
        sb.append(dispatcher);
        sb.append("</filter-name>");
        sb.append("<url-pattern>/*</url-pattern>");
        sb.append("<dispatcher>");
        sb.append(dispatcher);
        sb.append("</dispatcher>");
        sb.append("</filter-mapping>");
        return sb.toString();
    }

    public String getPluginPackageLicensesXml(List<License> licenses) {
        if (licenses.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(5 * licenses.size() + 2);
        for (int i = 0; i < licenses.size(); ++i) {
            License license = licenses.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<license osi-approved=\"");
            sb.append(license.isOsiApproved());
            sb.append("\">");
            sb.append(license.getName());
            sb.append("</license>\r\n");
            if (i + 1 != licenses.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    public String getPluginPackageLiferayVersionsXml(List<String> liferayVersions) {
        if (liferayVersions.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(liferayVersions.size() * 3 + 2);
        for (int i = 0; i < liferayVersions.size(); ++i) {
            String liferayVersion = liferayVersions.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<liferay-version>");
            sb.append(liferayVersion);
            sb.append("</liferay-version>\r\n");
            if (i + 1 != liferayVersions.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    public Properties getPluginPackageProperties(File srcFile) throws Exception {
        File propertiesFile = new File(srcFile + "/WEB-INF/liferay-plugin-package.properties");
        if (!propertiesFile.exists()) {
            return null;
        }
        String propertiesString = FileUtil.read(propertiesFile);
        return PropertiesUtil.load(propertiesString);
    }

    public String getPluginPackageRequiredDeploymentContextsXml(List<String> requiredDeploymentContexts) {
        if (requiredDeploymentContexts.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(requiredDeploymentContexts.size() * 3 + 2);
        for (int i = 0; i < requiredDeploymentContexts.size(); ++i) {
            String requiredDeploymentContext = requiredDeploymentContexts.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<required-deployment-context>");
            sb.append(requiredDeploymentContext);
            sb.append("</required-deployment-context>\r\n");
            if (i + 1 != requiredDeploymentContexts.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    public String getPluginPackageTagsXml(List<String> tags) {
        if (tags.isEmpty()) {
            return "";
        }
        StringBundler sb = new StringBundler(tags.size() * 3 + 2);
        for (int i = 0; i < tags.size(); ++i) {
            String tag = tags.get(i);
            if (i == 0) {
                sb.append("\r\n");
            }
            sb.append("\t\t<tag>");
            sb.append(tag);
            sb.append("</tag>\r\n");
            if (i + 1 != tags.size()) continue;
            sb.append("\t");
        }
        return sb.toString();
    }

    public Map<String, String> getPluginPackageXmlFilterMap(PluginPackage pluginPackage) {
        List<String> pluginTypes = pluginPackage.getTypes();
        String pluginType = pluginTypes.get(0);
        if (!pluginType.equals(this.getPluginType())) {
            return null;
        }
        HashMap<String, String> filterMap = new HashMap<String, String>();
        filterMap.put("author", this.wrapCDATA(pluginPackage.getAuthor()));
        filterMap.put("change_log", this.wrapCDATA(pluginPackage.getChangeLog()));
        filterMap.put("licenses", this.getPluginPackageLicensesXml(pluginPackage.getLicenses()));
        filterMap.put("liferay_versions", this.getPluginPackageLiferayVersionsXml(pluginPackage.getLiferayVersions()));
        filterMap.put("long_description", this.wrapCDATA(pluginPackage.getLongDescription()));
        filterMap.put("module_artifact_id", pluginPackage.getArtifactId());
        filterMap.put("module_group_id", pluginPackage.getGroupId());
        filterMap.put("module_version", pluginPackage.getVersion());
        filterMap.put("page_url", pluginPackage.getPageURL());
        filterMap.put("plugin_name", this.wrapCDATA(pluginPackage.getName()));
        filterMap.put("plugin_type", pluginType);
        filterMap.put("plugin_type_name", TextFormatter.format(pluginType, 9));
        filterMap.put("recommended_deployment_context", pluginPackage.getRecommendedDeploymentContext());
        filterMap.put("required_deployment_contexts", this.getPluginPackageRequiredDeploymentContextsXml(pluginPackage.getRequiredDeploymentContexts()));
        filterMap.put("short_description", this.wrapCDATA(pluginPackage.getShortDescription()));
        filterMap.put("tags", this.getPluginPackageTagsXml(pluginPackage.getTags()));
        return filterMap;
    }

    public String getPluginType() {
        return null;
    }

    public String getServletContextIncludeFiltersContent(double webXmlVersion, File srcFile) throws Exception {
        if (webXmlVersion < 2.4) {
            return "";
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null) {
            return "";
        }
        if (!GetterUtil.getBoolean(properties.getProperty("servlet-context-include-filters-enabled"), true)) {
            return "";
        }
        return FileUtil.read(DeployUtil.getResourcePath(this.tempDirPaths, "servlet-context-include-filters-web.xml"));
    }

    public String getSessionFiltersContent() throws Exception {
        return FileUtil.read(DeployUtil.getResourcePath(this.tempDirPaths, "session-filters-web.xml"));
    }

    public String getSpeedFiltersContent(File srcFile) throws Exception {
        boolean speedFiltersEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            speedFiltersEnabled = GetterUtil.getBoolean(properties.getProperty("speed-filters-enabled"), true);
        }
        if (speedFiltersEnabled) {
            return FileUtil.read(DeployUtil.getResourcePath(this.tempDirPaths, "speed-filters-web.xml"));
        }
        return "";
    }

    public boolean isJEEDeploymentEnabled() {
        return GetterUtil.getBoolean(PropsUtil.get("auto.deploy." + ServerDetector.getServerId() + ".jee.deployment.enabled"));
    }

    public void mergeDirectory(File mergeDir, File targetDir) {
        if (mergeDir == null || !mergeDir.exists()) {
            return;
        }
        CopyTask.copyDirectory(mergeDir, targetDir, null, null, true, false);
    }

    public void postDeploy(String destDir, String deployDir) throws Exception {
        if (this.appServerType.equals("glassfish")) {
            this.postDeployGlassfish(destDir, deployDir);
        } else if (this.appServerType.equals("jboss")) {
            this.postDeployJBoss(destDir, deployDir);
        } else if (this.appServerType.equals("wildfly")) {
            this.postDeployWildfly(destDir, deployDir);
        }
        for (DeploymentExtension deploymentExtension : this._deploymentExtensions) {
            if (!Objects.equals(this.appServerType, deploymentExtension.getServerId())) continue;
            deploymentExtension.postDeploy(destDir, deployDir);
        }
    }

    public void postDeployGlassfish(String destDir, String deployDir) throws Exception {
        FileUtil.delete(destDir + "/.autodeploystatus/" + deployDir);
    }

    public void postDeployJBoss(String destDir, String deployDir) throws Exception {
        FileUtil.write(StringBundler.concat(destDir, "/", deployDir, ".dodeploy"), "");
    }

    public void postDeployWildfly(String destDir, String deployDir) throws Exception {
        FileUtil.write(StringBundler.concat(destDir, "/", deployDir, ".dodeploy"), "");
    }

    @Override
    public Map<String, String> processPluginPackageProperties(File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        if (pluginPackage == null) {
            return null;
        }
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties == null || properties.isEmpty()) {
            return null;
        }
        Map<String, String> filterMap = this.getPluginPackageXmlFilterMap(pluginPackage);
        if (filterMap == null) {
            return null;
        }
        this.copyDependencyXml("liferay-plugin-package.xml", srcFile + "/WEB-INF", filterMap, true);
        return filterMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PluginPackage readPluginPackage(File file) {
        if (!file.exists()) {
            return null;
        }
        InputStream is = null;
        ZipFile zipFile = null;
        try {
            File pluginPackageXmlFile;
            boolean parseProps;
            block46: {
                block45: {
                    parseProps = false;
                    if (!file.isDirectory()) break block45;
                    String path = file.getPath();
                    File pluginPackageXmlFile2 = new File(StringBundler.concat(file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.xml"));
                    if (pluginPackageXmlFile2.exists()) {
                        is = new FileInputStream(pluginPackageXmlFile2);
                    } else {
                        pluginPackageXmlFile2 = new File(path + "/WEB-INF/liferay-plugin-package.xml");
                        if (pluginPackageXmlFile2.exists()) {
                            is = new FileInputStream(pluginPackageXmlFile2);
                        }
                    }
                    File pluginPackagePropertiesFile = new File(StringBundler.concat(file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.properties"));
                    if (is == null && pluginPackagePropertiesFile.exists()) {
                        is = new FileInputStream(pluginPackagePropertiesFile);
                        parseProps = true;
                        break block46;
                    } else {
                        pluginPackagePropertiesFile = new File(path + "/WEB-INF/liferay-plugin-package.properties");
                        if (is == null && pluginPackagePropertiesFile.exists()) {
                            is = new FileInputStream(pluginPackagePropertiesFile);
                            parseProps = true;
                        }
                    }
                    break block46;
                }
                zipFile = new ZipFile(file);
                pluginPackageXmlFile = new File(StringBundler.concat(file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.xml"));
                if (pluginPackageXmlFile.exists()) {
                    is = new FileInputStream(pluginPackageXmlFile);
                } else {
                    ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.xml");
                    if (zipEntry != null) {
                        is = zipFile.getInputStream(zipEntry);
                    }
                }
                File pluginPackagePropertiesFile = new File(StringBundler.concat(file.getParent(), "/merge/", file.getName(), "/WEB-INF/liferay-plugin-package.properties"));
                if (is == null && pluginPackagePropertiesFile.exists()) {
                    is = new FileInputStream(pluginPackagePropertiesFile);
                    parseProps = true;
                } else {
                    ZipEntry zipEntry = zipFile.getEntry("WEB-INF/liferay-plugin-package.properties");
                    if (is == null && zipEntry != null) {
                        is = zipFile.getInputStream(zipEntry);
                        parseProps = true;
                    }
                }
            }
            if (is == null) {
                if (_log.isInfoEnabled()) {
                    _log.info(StringBundler.concat(file.getPath(), " does not have a ", "WEB-INF/liferay-plugin-package.xml or ", "WEB-INF/liferay-plugin-package.properties"));
                }
                pluginPackageXmlFile = null;
                return pluginPackageXmlFile;
            }
            if (parseProps) {
                String displayName = this.getDisplayName(file);
                String propertiesString = StringUtil.read(is);
                Properties properties = PropertiesUtil.load(propertiesString);
                PluginPackage pluginPackage = PluginPackageUtil.readPluginPackageProperties(displayName, properties);
                return pluginPackage;
            }
            String xml = StringUtil.read(is);
            xml = XMLUtil.fixProlog(xml);
            PluginPackage pluginPackage = PluginPackageUtil.readPluginPackageXml(xml);
            return pluginPackage;
        }
        catch (Exception e) {
            _log.error(file.getPath() + ": " + e.toString(), e);
            return null;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void rewriteFiles(File srcDir) throws Exception {
        String[] fileNames;
        for (String fileName : fileNames = FileUtil.listFiles(srcDir + "/WEB-INF/")) {
            String ext;
            String shortFileName = GetterUtil.getString(FileUtil.getShortFileName(fileName));
            if (StringUtil.equalsIgnoreCase(shortFileName, "mule-config.xml") || !StringUtil.equalsIgnoreCase(ext = GetterUtil.getString(FileUtil.getExtension(fileName)), "xml")) continue;
            File file = new File(srcDir + "/WEB-INF/" + fileName);
            try {
                Document doc = UnsecureSAXReaderUtil.read(file);
                String content = doc.formattedString("\t", true);
                FileUtil.write(file, content);
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn(StringBundler.concat("Unable to format ", file, ": ", e.getMessage()));
            }
        }
    }

    public String secureWebXml(String content, boolean hasCustomServletListener, boolean securityManagerEnabled) throws Exception {
        if (!hasCustomServletListener && !securityManagerEnabled) {
            return content;
        }
        Document document = UnsecureSAXReaderUtil.read(content);
        Element rootElement = document.getRootElement();
        ArrayList<String> listenerClasses = new ArrayList<String>();
        List<Element> listenerElements = rootElement.elements("listener");
        for (Element listenerElement : listenerElements) {
            String listenerClass = GetterUtil.getString(listenerElement.elementText("listener-class"));
            if (listenerClass.equals(PluginContextListener.class.getName()) || listenerClass.equals(SecurePluginContextListener.class.getName())) continue;
            listenerClasses.add(listenerClass);
            listenerElement.detach();
        }
        Element contextParamElement = rootElement.addElement("context-param");
        DocUtil.add(contextParamElement, "param-name", "portalListenerClasses");
        DocUtil.add(contextParamElement, "param-value", StringUtil.merge(listenerClasses));
        if (!securityManagerEnabled) {
            return document.compactString();
        }
        List<Element> servletElements = rootElement.elements("servlet");
        for (Element servletElement : servletElements) {
            Element servletClassElement = servletElement.element("servlet-class");
            String servletClass = GetterUtil.getString(servletClassElement.getText());
            if (servletClass.equals(PortalClassLoaderServlet.class.getName()) || servletClass.equals(PortalDelegateServlet.class.getName()) || servletClass.equals(PortletServlet.class.getName())) continue;
            servletClassElement.setText(SecureServlet.class.getName());
            Element initParamElement = servletElement.addElement("init-param");
            DocUtil.add(initParamElement, "param-name", "servlet-class");
            DocUtil.add(initParamElement, "param-value", servletClass);
        }
        return document.compactString();
    }

    @Override
    public void setAppServerType(String appServerType) {
        this.appServerType = appServerType;
    }

    @Override
    public void setAuiTaglibDTD(String auiTaglibDTD) {
        this.auiTaglibDTD = auiTaglibDTD;
    }

    @Override
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    @Override
    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    @Override
    public void setJars(List<String> jars) {
        this.jars = jars;
    }

    @Override
    public void setJbossPrefix(String jbossPrefix) {
        this.jbossPrefix = jbossPrefix;
    }

    @Override
    public void setPortletExtTaglibDTD(String portletExtTaglibDTD) {
        this.portletExtTaglibDTD = portletExtTaglibDTD;
    }

    @Override
    public void setPortletTaglibDTD(String portletTaglibDTD) {
        this.portletTaglibDTD = portletTaglibDTD;
    }

    @Override
    public void setSecurityTaglibDTD(String securityTaglibDTD) {
        this.securityTaglibDTD = securityTaglibDTD;
    }

    @Override
    public void setThemeTaglibDTD(String themeTaglibDTD) {
        this.themeTaglibDTD = themeTaglibDTD;
    }

    @Override
    public void setTomcatLibDir(String tomcatLibDir) {
        this.tomcatLibDir = tomcatLibDir;
    }

    @Override
    public void setUiTaglibDTD(String uiTaglibDTD) {
        this.uiTaglibDTD = uiTaglibDTD;
    }

    @Override
    public void setUnpackWar(boolean unpackWar) {
        this.unpackWar = unpackWar;
    }

    @Override
    public void setUtilTaglibDTD(String utilTaglibDTD) {
        this.utilTaglibDTD = utilTaglibDTD;
    }

    @Override
    public void setWars(List<String> wars) {
        this.wars = wars;
    }

    @Override
    public void setWildflyPrefix(String wildflyPrefix) {
        this.wildflyPrefix = wildflyPrefix;
    }

    public void updateDeployDirectory(File srcFile) throws Exception {
    }

    public String updateLiferayWebXml(double webXmlVersion, File srcFile, String webXmlContent) throws Exception {
        boolean liferayWebXmlEnabled = true;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            liferayWebXmlEnabled = GetterUtil.getBoolean(properties.getProperty("liferay-web-xml-enabled"), true);
        }
        webXmlContent = WebXMLBuilder.organizeWebXML(webXmlContent);
        int x = webXmlContent.indexOf("<filter>");
        int y = webXmlContent.lastIndexOf("</filter-mapping>");
        String webXmlFiltersContent = "";
        if (x == -1 || y == -1) {
            y = x = webXmlContent.lastIndexOf("</display-name>") + 15;
        } else if (liferayWebXmlEnabled && webXmlVersion > 2.3) {
            webXmlFiltersContent = webXmlContent.substring(x, y + 17);
            y += 17;
        } else {
            x = y + 17;
            y += 17;
        }
        if (webXmlVersion < 2.4) {
            webXmlContent = webXmlContent.substring(0, x) + this.getExtraFiltersContent(webXmlVersion, srcFile) + webXmlContent.substring(y);
            return webXmlContent;
        }
        String filtersContent = webXmlFiltersContent + this.getExtraFiltersContent(webXmlVersion, srcFile);
        String liferayWebXmlContent = FileUtil.read(DeployUtil.getResourcePath(this.tempDirPaths, "web.xml"));
        int z = liferayWebXmlContent.indexOf("</web-app>");
        liferayWebXmlContent = liferayWebXmlContent.substring(0, z) + filtersContent + liferayWebXmlContent.substring(z);
        liferayWebXmlContent = WebXMLBuilder.organizeWebXML(liferayWebXmlContent);
        FileUtil.write(srcFile + "/WEB-INF/liferay-web.xml", liferayWebXmlContent);
        webXmlContent = webXmlContent.substring(0, x) + this.getInvokerFilterContent() + webXmlContent.substring(y);
        return webXmlContent;
    }

    @Override
    public void updateWebXml(File webXml, File srcFile, String displayName, PluginPackage pluginPackage) throws Exception {
        Document document;
        Element rootElement;
        double webXmlVersion;
        String content = FileUtil.read(webXml);
        int x = (content = WebXMLBuilder.organizeWebXML(content)).indexOf("<display-name>");
        if (x != -1) {
            int y = content.indexOf("</display-name>", x);
            y = content.indexOf(">", y) + 1;
            content = content.substring(0, x) + content.substring(y);
        }
        if ((webXmlVersion = GetterUtil.getDouble((rootElement = (document = UnsecureSAXReaderUtil.read(content)).getRootElement()).attributeValue("version"), 2.3)) <= 2.3) {
            throw new AutoDeployException(webXml.getName() + " must be updated to the Servlet 2.4 specification");
        }
        StringBundler sb = new StringBundler(5);
        sb.append("<listener>");
        sb.append("<listener-class>");
        boolean hasCustomServletListener = false;
        List<Element> listenerElements = rootElement.elements("listener");
        for (Element listenerElement : listenerElements) {
            String listenerClass = GetterUtil.getString(listenerElement.elementText("listener-class"));
            if (listenerClass.equals(PluginContextListener.class.getName()) || listenerClass.equals(SerializableSessionAttributeListener.class.getName()) || listenerClass.equals(SecurePluginContextListener.class.getName())) continue;
            hasCustomServletListener = true;
            break;
        }
        boolean securityManagerEnabled = false;
        Properties properties = this.getPluginPackageProperties(srcFile);
        if (properties != null) {
            securityManagerEnabled = GetterUtil.getBoolean(properties.getProperty("security-manager-enabled"));
        }
        if (hasCustomServletListener || securityManagerEnabled) {
            sb.append(SecurePluginContextListener.class.getName());
        } else {
            sb.append(PluginContextListener.class.getName());
        }
        sb.append("</listener-class>");
        sb.append("</listener>");
        String pluginContextListenerContent = sb.toString();
        String extraContent = this.getExtraContent(webXmlVersion, srcFile, displayName);
        int pos = content.indexOf("<listener>");
        if (pos == -1) {
            pos = content.indexOf("</web-app>");
        }
        String newContent = StringBundler.concat(content.substring(0, pos), pluginContextListenerContent, extraContent, content.substring(pos));
        newContent = this.updateLiferayWebXml(webXmlVersion, srcFile, newContent);
        newContent = this.secureWebXml(newContent, hasCustomServletListener, securityManagerEnabled);
        newContent = WebXMLBuilder.organizeWebXML(newContent);
        FileUtil.write(webXml, newContent, true);
        if (_log.isDebugEnabled()) {
            _log.debug(StringBundler.concat("Modifying Servlet ", webXmlVersion, " ", webXml));
        }
    }

    @Override
    public String wrapCDATA(String string) {
        return "<![CDATA[" + string + "]]>";
    }
}

