/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.servlet.filters.absoluteredirects.AbsoluteRedirectsFilter;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.xml.DocumentImpl;
import com.liferay.util.xml.XMLMerger;
import com.liferay.util.xml.descriptor.SimpleXMLDescriptor;
import com.liferay.util.xml.descriptor.WebXML23Descriptor;
import com.liferay.util.xml.descriptor.WebXML24Descriptor;
import com.liferay.util.xml.descriptor.WebXML30Descriptor;
import java.io.IOException;

public class WebXMLBuilder {
    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        if (args.length != 3) {
            throw new IllegalArgumentException();
        }
        WebXMLBuilder.mergeWebXML(args[0], args[1], args[2]);
    }

    public static void mergeWebXML(String originalWebXML, String customWebXML, String mergedWebXML) {
        try {
            String originalContent;
            String customContent = WebXMLBuilder.getCustomContent(customWebXML);
            String mergedContent = originalContent = FileUtil.read(originalWebXML);
            int x = customContent.indexOf("<filter-mapping>");
            if (x != -1) {
                int y = customContent.lastIndexOf("</filter-mapping>") + 17;
                String filterMappings = customContent.substring(x, y);
                int z = WebXMLBuilder.getOriginalContentIndex(originalContent);
                mergedContent = mergedContent.substring(0, z) + filterMappings + mergedContent.substring(z);
                customContent = customContent.substring(0, x) + customContent.substring(y + 1);
            }
            int z = WebXMLBuilder.getMergedContentIndex(mergedContent);
            mergedContent = mergedContent.substring(0, z) + customContent + mergedContent.substring(z);
            mergedContent = WebXMLBuilder.organizeWebXML(mergedContent);
            FileUtil.write(mergedWebXML, mergedContent, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String organizeWebXML(String webXML) throws DocumentException, IOException {
        webXML = HtmlUtil.stripComments(webXML);
        Document document = UnsecureSAXReaderUtil.read(webXML);
        Element rootElement = document.getRootElement();
        double version = 2.3;
        version = GetterUtil.getDouble(rootElement.attributeValue("version"), version);
        SimpleXMLDescriptor xmlDescriptor = null;
        xmlDescriptor = version == 2.3 ? new WebXML23Descriptor() : (version == 2.4 ? new WebXML24Descriptor() : new WebXML30Descriptor());
        XMLMerger xmlMerger = new XMLMerger(xmlDescriptor);
        DocumentImpl documentImpl = (DocumentImpl)document;
        xmlMerger.organizeXML(documentImpl.getWrappedDocument());
        webXML = document.formattedString();
        return webXML;
    }

    protected static String getCustomContent(String customWebXML) throws IOException {
        String customContent = FileUtil.read(customWebXML);
        int x = customContent.indexOf("<web-app");
        x = customContent.indexOf(">", x) + 1;
        int y = customContent.indexOf("</web-app>");
        return customContent.substring(x, y);
    }

    protected static int getMergedContentIndex(String content) {
        int x = content.indexOf("<web-app");
        x = content.indexOf(">", x) + 1;
        return x;
    }

    protected static int getOriginalContentIndex(String content) {
        int x = content.indexOf(AbsoluteRedirectsFilter.class.getName());
        if (x == -1) {
            x = content.indexOf("<web-app");
            x = content.indexOf(">", x) + 1;
            return x;
        }
        x = content.lastIndexOf("<filter-name", x);
        x = content.indexOf(">", x) + 1;
        int y = content.indexOf("</filter-name>", x);
        String filterName = content.substring(x, y);
        x = content.lastIndexOf(filterName);
        y = content.indexOf("</filter-mapping>", x);
        y = content.indexOf(">", y) + 1;
        return y;
    }
}

