/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.cache.key.SimpleCacheKeyGenerator;
import com.liferay.portal.json.JSONFactoryImpl;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.PortalCacheException;
import com.liferay.portal.kernel.cache.PortalCacheListener;
import com.liferay.portal.kernel.cache.PortalCacheListenerScope;
import com.liferay.portal.kernel.cache.PortalCacheManager;
import com.liferay.portal.kernel.cache.PortalCacheManagerListener;
import com.liferay.portal.kernel.cache.PortalCacheManagerProvider;
import com.liferay.portal.kernel.cache.SingleVMPool;
import com.liferay.portal.kernel.cache.key.CacheKeyGeneratorUtil;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.security.auth.DefaultFullNameGenerator;
import com.liferay.portal.kernel.security.auth.FullNameGenerator;
import com.liferay.portal.kernel.security.permission.ResourceActionsUtil;
import com.liferay.portal.kernel.security.xml.SecureXMLFactoryProviderUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.FriendlyURLNormalizerUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.model.DefaultModelHintsImpl;
import com.liferay.portal.security.permission.ResourceActionsImpl;
import com.liferay.portal.security.xml.SecureXMLFactoryProviderImpl;
import com.liferay.portal.service.permission.PortletPermissionImpl;
import com.liferay.portal.util.DigesterImpl;
import com.liferay.portal.util.FastDateFormatFactoryImpl;
import com.liferay.portal.util.FileImpl;
import com.liferay.portal.util.FriendlyURLNormalizerImpl;
import com.liferay.portal.util.HtmlImpl;
import com.liferay.portal.util.HttpImpl;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalImpl;
import com.liferay.portal.xml.SAXReaderImpl;
import com.liferay.registry.BasicRegistryImpl;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ToolDependencies {
    public static void wireBasic() {
        InitUtil.init();
        ToolDependencies.wireCaches();
        Registry registry = RegistryUtil.getRegistry();
        registry.registerService(FullNameGenerator.class, new DefaultFullNameGenerator());
        CacheKeyGeneratorUtil cacheKeyGeneratorUtil = new CacheKeyGeneratorUtil();
        cacheKeyGeneratorUtil.setDefaultCacheKeyGenerator(new SimpleCacheKeyGenerator());
        DigesterUtil digesterUtil = new DigesterUtil();
        digesterUtil.setDigester(new DigesterImpl());
        FastDateFormatFactoryUtil fastDateFormatFactoryUtil = new FastDateFormatFactoryUtil();
        fastDateFormatFactoryUtil.setFastDateFormatFactory(new FastDateFormatFactoryImpl());
        FileUtil fileUtil = new FileUtil();
        fileUtil.setFile(new FileImpl());
        FriendlyURLNormalizerUtil friendlyURLNormalizerUtil = new FriendlyURLNormalizerUtil();
        friendlyURLNormalizerUtil.setFriendlyURLNormalizer(new FriendlyURLNormalizerImpl());
        HtmlUtil htmlUtil = new HtmlUtil();
        htmlUtil.setHtml(new HtmlImpl());
        HttpUtil httpUtil = new HttpUtil();
        httpUtil.setHttp(new HttpImpl());
        JSONFactoryUtil jsonFactoryUtil = new JSONFactoryUtil();
        jsonFactoryUtil.setJSONFactory(new JSONFactoryImpl());
        PortletPermissionUtil portletPermissionUtil = new PortletPermissionUtil();
        portletPermissionUtil.setPortletPermission(new PortletPermissionImpl());
        SAXReaderUtil saxReaderUtil = new SAXReaderUtil();
        SAXReaderImpl secureSAXReader = new SAXReaderImpl();
        secureSAXReader.setSecure(true);
        saxReaderUtil.setSAXReader(secureSAXReader);
        SecureXMLFactoryProviderUtil secureXMLFactoryProviderUtil = new SecureXMLFactoryProviderUtil();
        secureXMLFactoryProviderUtil.setSecureXMLFactoryProvider(new SecureXMLFactoryProviderImpl());
        UnsecureSAXReaderUtil unsecureSAXReaderUtil = new UnsecureSAXReaderUtil();
        SAXReaderImpl unsecureSAXReader = new SAXReaderImpl();
        unsecureSAXReaderUtil.setSAXReader(unsecureSAXReader);
        ModelHintsUtil modelHintsUtil = new ModelHintsUtil();
        DefaultModelHintsImpl defaultModelHintsImpl = new DefaultModelHintsImpl();
        defaultModelHintsImpl.afterPropertiesSet();
        modelHintsUtil.setModelHints(defaultModelHintsImpl);
    }

    public static void wireCaches() {
        RegistryUtil.setRegistry(new BasicRegistryImpl());
        Registry registry = RegistryUtil.getRegistry();
        registry.registerService(PortalCacheManager.class, new TestPortalCacheManager("MULTI_VM_PORTAL_CACHE_MANAGER"));
        registry.registerService(PortalCacheManager.class, new TestPortalCacheManager("SINGLE_VM_PORTAL_CACHE_MANAGER"));
        registry.registerService(MultiVMPool.class, new TestMultiVMPool());
        registry.registerService(SingleVMPool.class, new TestSingleVMPool());
    }

    public static void wireDeployers() {
        ToolDependencies.wireBasic();
        PortalUtil portalUtil = new PortalUtil();
        portalUtil.setPortal(new PortalImpl());
    }

    public static void wireServiceBuilder() {
        ToolDependencies.wireDeployers();
        ResourceActionsUtil resourceActionsUtil = new ResourceActionsUtil();
        ResourceActionsImpl resourceActionsImpl = new ResourceActionsImpl();
        resourceActionsImpl.afterPropertiesSet();
        resourceActionsUtil.setResourceActions(resourceActionsImpl);
    }

    private static class TestSingleVMPool
    implements SingleVMPool {
        private final PortalCacheManager<? extends Serializable, ?> _portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager("SINGLE_VM_PORTAL_CACHE_MANAGER");

        private TestSingleVMPool() {
        }

        @Override
        public void clear() {
            this._portalCacheManager.clearAll();
        }

        @Override
        public PortalCache<? extends Serializable, ?> getPortalCache(String portalCacheName) {
            return this._portalCacheManager.getPortalCache(portalCacheName);
        }

        @Override
        public PortalCache<? extends Serializable, ?> getPortalCache(String portalCacheName, boolean blocking) {
            return this.getPortalCache(portalCacheName);
        }

        @Override
        public PortalCacheManager<? extends Serializable, ?> getPortalCacheManager() {
            return this._portalCacheManager;
        }

        @Override
        public void removePortalCache(String portalCacheName) {
            this._portalCacheManager.removePortalCache(portalCacheName);
        }
    }

    private static class TestPortalCacheManager<K extends Serializable, V>
    implements PortalCacheManager<K, V> {
        private final String _portalCacheManagerName;
        private final ConcurrentMap<String, PortalCache<K, V>> _portalCaches = new ConcurrentHashMap<String, PortalCache<K, V>>();

        @Override
        public void clearAll() throws PortalCacheException {
            for (PortalCache portalCache : this._portalCaches.values()) {
                portalCache.removeAll();
            }
        }

        @Override
        public void destroy() {
            this._portalCaches.clear();
        }

        @Override
        public PortalCache<K, V> fetchPortalCache(String portalCacheName) {
            return (PortalCache)this._portalCaches.get(portalCacheName);
        }

        @Override
        public PortalCache<K, V> getPortalCache(String portalCacheName) throws PortalCacheException {
            return this.getPortalCache(portalCacheName, false);
        }

        @Override
        public PortalCache<K, V> getPortalCache(String portalCacheName, boolean blocking) throws PortalCacheException {
            return this.getPortalCache(portalCacheName, blocking, false);
        }

        @Override
        public PortalCache<K, V> getPortalCache(String portalCacheName, boolean blocking, boolean mvcc) throws PortalCacheException {
            TestPortalCache portalCache = (TestPortalCache)this._portalCaches.get(portalCacheName);
            if (portalCache != null) {
                return portalCache;
            }
            portalCache = new TestPortalCache(portalCacheName);
            PortalCache previousPortalCache = this._portalCaches.putIfAbsent(portalCacheName, portalCache);
            if (previousPortalCache != null) {
                return previousPortalCache;
            }
            return portalCache;
        }

        @Override
        public Set<PortalCacheManagerListener> getPortalCacheManagerListeners() {
            return Collections.emptySet();
        }

        @Override
        public String getPortalCacheManagerName() {
            return this._portalCacheManagerName;
        }

        @Override
        public boolean isClusterAware() {
            return false;
        }

        @Override
        @Deprecated
        public void reconfigurePortalCaches(URL configurationURL) {
        }

        @Override
        public void reconfigurePortalCaches(URL configurationURL, ClassLoader classLoader) {
        }

        @Override
        public boolean registerPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
            return false;
        }

        @Override
        public void removePortalCache(String portalCacheName) {
            this._portalCaches.remove(portalCacheName);
        }

        @Override
        public boolean unregisterPortalCacheManagerListener(PortalCacheManagerListener portalCacheManagerListener) {
            return false;
        }

        @Override
        public void unregisterPortalCacheManagerListeners() {
        }

        private TestPortalCacheManager(String portalCacheManagerName) {
            this._portalCacheManagerName = portalCacheManagerName;
        }
    }

    private static class TestPortalCache<K extends Serializable, V>
    implements PortalCache<K, V> {
        private final Map<K, V> _map = new ConcurrentHashMap();
        private final List<PortalCacheListener<K, V>> _portalCacheListeners = new ArrayList<PortalCacheListener<K, V>>();
        private final String _portalCacheName;

        public TestPortalCache(String portalCacheName) {
            this._portalCacheName = portalCacheName;
        }

        @Override
        public V get(K key) {
            return this._map.get(key);
        }

        @Override
        public List<K> getKeys() {
            return new ArrayList<K>(this._map.keySet());
        }

        @Override
        public PortalCacheManager<K, V> getPortalCacheManager() {
            return null;
        }

        @Override
        public String getPortalCacheName() {
            return this._portalCacheName;
        }

        @Override
        public boolean isBlocking() {
            return false;
        }

        @Override
        public boolean isMVCC() {
            return false;
        }

        @Override
        public void put(K key, V value) {
            this.put(key, value, 0);
        }

        @Override
        public void put(K key, V value, int timeToLive) {
            V oldValue = this._map.put(key, value);
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                if (oldValue != null) {
                    portalCacheListener.notifyEntryUpdated(this, key, value, timeToLive);
                    continue;
                }
                portalCacheListener.notifyEntryPut(this, key, value, timeToLive);
            }
        }

        @Override
        public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
            this._portalCacheListeners.add(portalCacheListener);
        }

        @Override
        public void registerPortalCacheListener(PortalCacheListener<K, V> portalCacheListener, PortalCacheListenerScope portalCacheListenerScope) {
            this._portalCacheListeners.add(portalCacheListener);
        }

        @Override
        public void remove(K key) {
            this._map.remove(key);
            for (PortalCacheListener<K, Object> portalCacheListener : this._portalCacheListeners) {
                portalCacheListener.notifyEntryRemoved(this, key, null, 0);
            }
        }

        @Override
        public void removeAll() {
            this._map.clear();
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                portalCacheListener.notifyRemoveAll(this);
            }
        }

        @Override
        public void unregisterPortalCacheListener(PortalCacheListener<K, V> portalCacheListener) {
            portalCacheListener.dispose();
            this._portalCacheListeners.remove(portalCacheListener);
        }

        @Override
        public void unregisterPortalCacheListeners() {
            for (PortalCacheListener<K, V> portalCacheListener : this._portalCacheListeners) {
                portalCacheListener.dispose();
            }
            this._portalCacheListeners.clear();
        }
    }

    private static class TestMultiVMPool
    implements MultiVMPool {
        private final PortalCacheManager<? extends Serializable, ? extends Serializable> _portalCacheManager = PortalCacheManagerProvider.getPortalCacheManager("MULTI_VM_PORTAL_CACHE_MANAGER");

        private TestMultiVMPool() {
        }

        @Override
        public void clear() {
            this._portalCacheManager.clearAll();
        }

        @Override
        public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName) {
            return this._portalCacheManager.getPortalCache(portalCacheName);
        }

        @Override
        public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName, boolean blocking) {
            return this.getPortalCache(portalCacheName);
        }

        @Override
        public PortalCache<? extends Serializable, ? extends Serializable> getPortalCache(String portalCacheName, boolean blocking, boolean mvcc) {
            return this.getPortalCache(portalCacheName);
        }

        @Override
        public PortalCacheManager<? extends Serializable, ? extends Serializable> getPortalCacheManager() {
            return this._portalCacheManager;
        }

        @Override
        public void removePortalCache(String portalCacheName) {
            this._portalCacheManager.removePortalCache(portalCacheName);
        }
    }
}

