/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import org.apache.tools.ant.DirectoryScanner;

public class TextReplacer {
    private static final FileImpl _fileUtil = FileImpl.getInstance();

    public static void main(String[] args) {
        String dirs = System.getProperty("text.replacer.dirs");
        String includes = System.getProperty("text.replacer.includes");
        String excludes = System.getProperty("text.replacer.excludes");
        String tokenFile = System.getProperty("text.replacer.token.file");
        String valueFile = System.getProperty("text.replacer.value.file");
        new TextReplacer(dirs, includes, excludes, tokenFile, valueFile);
    }

    public TextReplacer(String dirs, String includes, String excludes, String tokenFile, String valueFile) {
        try {
            String token = _fileUtil.read(tokenFile);
            if (token == null) {
                System.out.println(tokenFile + " does not exist");
                return;
            }
            String value = _fileUtil.read(valueFile);
            if (value == null) {
                System.out.println(valueFile + " does not exist");
                return;
            }
            for (String dir : StringUtil.split(dirs)) {
                if (!dir.endsWith("/")) {
                    dir = dir + "/";
                }
                if (!_fileUtil.exists(dir)) {
                    System.out.println(dir + " does not exist");
                    continue;
                }
                DirectoryScanner directoryScanner = new DirectoryScanner();
                directoryScanner.setBasedir(dir);
                directoryScanner.setIncludes(StringUtil.split(includes));
                directoryScanner.setExcludes(StringUtil.split(excludes));
                directoryScanner.scan();
                for (String fileName : directoryScanner.getIncludedFiles()) {
                    String newContent;
                    File file = new File(dir + fileName);
                    String content = _fileUtil.read(file);
                    if (content.equals(newContent = StringUtil.replace(content, token, value))) continue;
                    _fileUtil.write(file, newContent);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

