/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.CSVUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.io.DocumentSource;
import org.dom4j.io.SAXReader;

public class SPDXBuilder {
    private static final Namespace _NAMESPACE_RDF = new Namespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
    private static final Namespace _NAMESPACE_SPDX = new Namespace("spdx", "http://spdx.org/rdf/terms#");
    private static final Map<String, QName> _qNameMap = new HashMap<String, QName>();

    public static void main(String[] args) throws IOException {
        String xmls = null;
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));){
            xmls = bufferedReader.readLine();
        }
        new SPDXBuilder(StringUtil.split(xmls), args[0]);
    }

    public SPDXBuilder(String[] xmls, String rdf) {
        try {
            System.setProperty("line.separator", "\n");
            Document document = this._getDocument(xmls, rdf);
            File rdfFile = new File(rdf);
            this._write(new File(rdfFile.getParentFile(), "versions-spdx.xml"), Dom4jUtil.toString((Node)document));
            this._write(new File(rdfFile.getParentFile(), "versions-spdx.csv"), this._toCSV(document));
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(new File(rdfFile.getParentFile(), "versions.xsl")));
            File versionHtmlFile = new File(rdfFile.getParentFile(), "versions-spdx.html");
            transformer.transform((Source)new DocumentSource(document), new StreamResult(new FileOutputStream(versionHtmlFile)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<Element> _createLibraryElements(Element packageElement) {
        ArrayList<Element> libraryElements = new ArrayList<Element>();
        String downloadLocation = packageElement.elementText(this._getQName("downloadLocation"));
        String name = packageElement.elementText(this._getQName("name"));
        String versionInfo = packageElement.elementText(this._getQName("versionInfo"));
        Element hasFileElement = packageElement.element(this._getQName("hasFile"));
        List fileElements = hasFileElement.elements(this._getQName("File"));
        for (Element fileElement : fileElements) {
            String licenseName;
            String fileName = fileElement.elementText(this._getQName("fileName"));
            String dirName = fileName.substring(0, fileName.indexOf(47) + 1);
            if (dirName.endsWith("portal/") || dirName.endsWith("portal-ee/")) {
                fileName = fileName.substring(dirName.length());
            }
            Element libraryElement = DocumentHelper.createElement((String)"library");
            Element fileNameElement = libraryElement.addElement("file-name");
            fileNameElement.addText(fileName);
            Element versionElement = libraryElement.addElement("version");
            versionElement.addText(versionInfo);
            Element projectNameElement = libraryElement.addElement("project-name");
            projectNameElement.addText(name);
            if (downloadLocation != null && downloadLocation.startsWith("http")) {
                Element element = libraryElement.addElement("project-url");
                element.addText(downloadLocation);
            }
            if ((licenseName = this._getLicenseName(packageElement)) != null) {
                Element licensesElement = libraryElement.addElement("licenses");
                Element licenseElement = licensesElement.addElement("license");
                Element element = licenseElement.addElement("license-name");
                element.addText(licenseName);
                String licenseURL = this._getLicenseURL(packageElement);
                if (licenseURL != null) {
                    element = licenseElement.addElement("license-url");
                    element.addText(licenseURL);
                }
            }
            libraryElements.add(libraryElement);
        }
        return libraryElements;
    }

    private String _encode(Node node) {
        if (node == null) {
            return "";
        }
        String text = node.getText();
        text = StringUtil.trim(text.replaceAll("\\s+", " "));
        return CSVUtil.encode(text);
    }

    private Document _getDocument(String[] xmls, String rdf) throws Exception {
        Comparator comparator = String.CASE_INSENSITIVE_ORDER;
        TreeMap<String, Element> libraryElementMap = new TreeMap<String, Element>(comparator);
        SAXReader saxReader = SAXReaderFactory.getSAXReader(null, false, false);
        for (String xml : xmls) {
            Document xmlDocument = saxReader.read(new File(xml));
            List fileNameNodes = xmlDocument.selectNodes("//file-name");
            for (Node fileNameNode : fileNameNodes) {
                Element libraryElement = fileNameNode.getParent();
                String key = this._getKey("portal", libraryElement);
                libraryElementMap.put(key, libraryElement);
            }
        }
        Document spdxDocument = saxReader.read(new File(rdf));
        Element spdxRootElement = spdxDocument.getRootElement();
        Element spdxDocumentElement = spdxRootElement.element(this._getQName("SpdxDocument"));
        List elements = spdxDocumentElement.elements(this._getQName("relationship"));
        for (Element element : elements) {
            Element relationshipElement = element.element(this._getQName("Relationship"));
            Element relatedSPDXElement = relationshipElement.element(this._getQName("relatedSpdxElement"));
            Element packageElement = relatedSPDXElement.element(this._getQName("Package"));
            List<Element> libraryElements = this._createLibraryElements(packageElement);
            for (Element libraryElement : libraryElements) {
                String key = this._getKey("spdx", libraryElement);
                libraryElementMap.put(key, libraryElement);
            }
        }
        Document document = DocumentHelper.createDocument();
        HashMap<String, String> args = new HashMap<String, String>();
        args.put("href", "versions.xsl");
        args.put("type", "text/xsl");
        document.addProcessingInstruction("xml-stylesheet", args);
        Element versionsElement = document.addElement("versions");
        Element versionElement = versionsElement.addElement("version");
        Element librariesElement = versionElement.addElement("libraries");
        for (Element libraryElement : libraryElementMap.values()) {
            librariesElement.add(libraryElement.detach());
        }
        return document;
    }

    private String _getKey(String type, Element libraryElement) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtil.upperCase(type));
        sb.append(":");
        Node fileNameNode = libraryElement.selectSingleNode("file-name");
        sb.append(fileNameNode.getText());
        sb.append(":");
        Node versionNode = libraryElement.selectSingleNode("version");
        sb.append(versionNode.getText());
        return sb.toString();
    }

    private String _getLicenseName(Element packageElement) {
        Element licenseConcludedElement = packageElement.element(this._getQName("licenseConcluded"));
        if (licenseConcludedElement == null) {
            return null;
        }
        String resource = licenseConcludedElement.attributeValue(this._getQName("resource"));
        if (resource.startsWith("http://spdx.org/licenses/")) {
            return resource.substring(25);
        }
        if (resource.startsWith("LicenseRef-")) {
            return resource.substring(11);
        }
        return null;
    }

    private String _getLicenseURL(Element packageElement) {
        Element licenseConcludedElement = packageElement.element(this._getQName("licenseConcluded"));
        String resource = licenseConcludedElement.attributeValue(this._getQName("resource"));
        if (!resource.startsWith("http")) {
            return null;
        }
        return resource;
    }

    private QName _getQName(String name) {
        if (!_qNameMap.containsKey(name)) {
            QName qName = new QName(name, _NAMESPACE_SPDX, "spdx:" + name);
            if (Objects.equals(name, "resource")) {
                qName = new QName(name, _NAMESPACE_RDF, "rdf:" + name);
            }
            _qNameMap.put(name, qName);
        }
        return _qNameMap.get(name);
    }

    private String _toCSV(Document document) {
        StringBuilder sb = new StringBuilder();
        sb.append("File Name,Version,Project,License,Comments");
        List libraryNodes = document.selectNodes("//library");
        for (Node libraryNode : libraryNodes) {
            sb.append('\n');
            sb.append(this._encode(libraryNode.selectSingleNode("file-name")));
            sb.append(',');
            sb.append(this._encode(libraryNode.selectSingleNode("version")));
            sb.append(',');
            sb.append(this._encode(libraryNode.selectSingleNode("project-name")));
            sb.append(',');
            String[] licenses = new String[]{};
            List licenseNameNodes = libraryNode.selectNodes("./licenses/license/license-name");
            if (!licenseNameNodes.isEmpty()) {
                String text = "";
                if (licenseNameNodes.get(0) != null) {
                    Node node = (Node)licenseNameNodes.get(0);
                    text = node.getText();
                    text = StringUtil.trim(text.replaceAll("\\s+", " "));
                }
                licenses = ArrayUtil.append(licenses, text);
            }
            sb.append(CSVUtil.encode(licenses));
            sb.append(',');
            sb.append(this._encode(libraryNode.selectSingleNode("comments")));
        }
        return sb.toString();
    }

    private void _write(File file, String s) throws Exception {
        Files.write(file.toPath(), s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

