/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.NaturalOrderStringComparator;
import com.liferay.portal.kernel.util.OSDetector;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.util.FileImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.tools.ant.DirectoryScanner;

public class PluginsSummaryBuilder {
    private static final String[] _TICKET_ID_PREFIXES = new String[]{"CLDSVCS", "LPS", "SOS", "SYNC"};
    private static final FileImpl _fileUtil = FileImpl.getInstance();
    private final Set<String> _distinctAuthors = new TreeSet<String>();
    private final Set<String> _distinctLicenses = new TreeSet<String>();
    private final String _latestHASH;
    private final File _pluginsDir;

    public static void main(String[] args) throws Exception {
        ToolDependencies.wireBasic();
        File pluginsDir = new File(System.getProperty("plugins.dir"));
        new PluginsSummaryBuilder(pluginsDir);
    }

    public PluginsSummaryBuilder(File pluginsDir) throws Exception {
        String latestHASH;
        this._pluginsDir = pluginsDir;
        this._latestHASH = latestHASH = this._getLatestHASH(pluginsDir);
        this._createPluginsSummary();
    }

    private void _createPluginsSummary() throws Exception {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(this._pluginsDir);
        directoryScanner.setExcludes(new String[]{"**\\tmp\\**", "**\\tools\\**"});
        directoryScanner.setIncludes(new String[]{"**\\liferay-plugin-package.properties"});
        directoryScanner.scan();
        Object[] fileNames = directoryScanner.getIncludedFiles();
        Arrays.sort(fileNames);
        this._createPluginsSummary((String[])fileNames);
    }

    private void _createPluginsSummary(String[] fileNames) throws Exception {
        StringBundler sb = new StringBundler();
        sb.append("<plugins-summary>\n");
        for (String fileName : fileNames) {
            fileName = StringUtil.replace(fileName, '\\', '/');
            this._createPluginSummary(sb, fileName);
        }
        for (String author : this._distinctAuthors) {
            sb.append("\t<author>");
            sb.append(author);
            sb.append("</author>\n");
        }
        for (String license : this._distinctLicenses) {
            sb.append("\t<license>");
            sb.append(license);
            sb.append("</license>\n");
        }
        sb.append("</plugins-summary>");
        FileUtil.write(this._pluginsDir + "/summary.xml", sb.toString());
    }

    private void _createPluginSummary(StringBundler sb, String fileName) throws Exception {
        String content = FileUtil.read(fileName);
        int x = fileName.indexOf("/");
        String type = fileName.substring(0, x);
        if (type.endsWith("s")) {
            type = type.substring(0, type.length() - 1);
        }
        x = fileName.indexOf("/", x) + 1;
        int y = fileName.indexOf("/", x);
        String artifactId = fileName.substring(x, y);
        Properties properties = PropertiesUtil.load(content);
        String name = this._readProperty(properties, "name");
        String tags = this._readProperty(properties, "tags");
        String shortDescription = this._readProperty(properties, "short-description");
        String longDescription = this._readProperty(properties, "long-description");
        String changeLog = this._readProperty(properties, "change-log");
        String pageURL = this._readProperty(properties, "page-url");
        String author = this._readProperty(properties, "author");
        String licenses = this._readProperty(properties, "licenses");
        String liferayVersions = this._readProperty(properties, "liferay-versions");
        this._distinctAuthors.add(author);
        this._distinctLicenses.add(licenses);
        sb.append("\t<plugin>\n");
        this._writeElement(sb, "artifact-id", artifactId, 2);
        this._writeElement(sb, "name", name, 2);
        this._writeElement(sb, "type", type, 2);
        this._writeElement(sb, "tags", tags, 2);
        this._writeElement(sb, "short-description", shortDescription, 2);
        this._writeElement(sb, "long-description", longDescription, 2);
        this._writeElement(sb, "change-log", changeLog, 2);
        this._writeElement(sb, "page-url", pageURL, 2);
        this._writeElement(sb, "author", author, 2);
        this._writeElement(sb, "licenses", licenses, 2);
        this._writeElement(sb, "liferay-versions", liferayVersions, 2);
        sb.append("\t\t<releng>\n");
        sb.append(this._readReleng(fileName, properties));
        sb.append("\t\t</releng>\n");
        sb.append("\t</plugin>\n");
    }

    private Set<String> _extractTicketIds(File pluginDir, String range) throws Exception {
        TreeSet<String> ticketIds = new TreeSet<String>(new NaturalOrderStringComparator());
        Runtime runtime = Runtime.getRuntime();
        String command = "git log " + range + " .";
        if (OSDetector.isWindows()) {
            command = "cmd /c " + command;
        }
        Process process = runtime.exec(command, null, pluginDir);
        String content = StringUtil.read(process.getInputStream());
        content = StringUtil.replace(content, '\n', ' ');
        for (String ticketIdPrefix : _TICKET_ID_PREFIXES) {
            int x = 0;
            while ((x = content.indexOf(ticketIdPrefix + "-", x)) != -1) {
                int y = x + ticketIdPrefix.length() + 1;
                while (y + 1 <= content.length() && Character.isDigit(content.charAt(y))) {
                    ++y;
                }
                String ticketId = content.substring(x, y);
                ticketIds.add(ticketId);
                x = y;
            }
        }
        File buildXmlFile = new File(pluginDir, "build.xml");
        System.out.println("## read a " + buildXmlFile);
        String buildXmlContent = _fileUtil.read(buildXmlFile);
        int x = buildXmlContent.indexOf("import.shared");
        if (x == -1) {
            return ticketIds;
        }
        x = buildXmlContent.indexOf("value=\"", x);
        x = buildXmlContent.indexOf("\"", x);
        int y = buildXmlContent.indexOf("\" />", x);
        if (x == -1 || y == -1) {
            return ticketIds;
        }
        String[] importShared = StringUtil.split(buildXmlContent.substring(x + 1, y));
        if (importShared.length == 0) {
            return ticketIds;
        }
        for (String currentImportShared : importShared) {
            File currentImportSharedDir = new File(pluginDir, "../../shared/" + currentImportShared);
            if (!currentImportSharedDir.exists()) continue;
            ticketIds.addAll(this._extractTicketIds(currentImportSharedDir, range));
        }
        return ticketIds;
    }

    private String _getChangeLogEntry(int changeLogVersion, String range, String ticketIdsString) {
        StringBundler sb = new StringBundler(8);
        if (changeLogVersion > 1) {
            sb.append("\n\n");
        }
        sb.append("#\n");
        sb.append("# Module Incremental Version ");
        sb.append(changeLogVersion);
        sb.append("\n#\n");
        sb.append(range);
        sb.append("=");
        sb.append(ticketIdsString);
        return sb.toString();
    }

    private String _getLatestHASH(File pluginDir) throws Exception {
        Runtime runtime = Runtime.getRuntime();
        String command = "git rev-parse HEAD";
        if (OSDetector.isWindows()) {
            command = "cmd /c " + command;
        }
        Process process = runtime.exec(command, null, pluginDir);
        return StringUtil.read(process.getInputStream());
    }

    private String _readProperty(Properties properties, String key) {
        return GetterUtil.getString(properties.getProperty(key));
    }

    private String _readReleng(String fileName, Properties pluginPackageProperties) throws Exception {
        String relengPropertiesContent;
        int x = fileName.indexOf("WEB-INF");
        String relativeWebInfDirName = fileName.substring(0, x + 8);
        String fullWebInfDirName = this._pluginsDir + "/" + relativeWebInfDirName;
        String relengPropertiesFileName = fullWebInfDirName + "liferay-releng.properties";
        Properties relengProperties = null;
        if (FileUtil.exists(relengPropertiesFileName)) {
            relengPropertiesContent = FileUtil.read(relengPropertiesFileName);
            relengProperties = PropertiesUtil.load(relengPropertiesContent);
        } else {
            relengProperties = new Properties();
        }
        relengPropertiesContent = this._updateRelengPropertiesFile(relengPropertiesFileName, relengProperties);
        relengProperties = PropertiesUtil.load(relengPropertiesContent);
        StringBundler sb = new StringBundler();
        this._writeElement(sb, "bundle", relengProperties, 3);
        this._writeElement(sb, "category", relengProperties, 3);
        this._writeElement(sb, "demo-url", relengProperties, 3);
        this._writeElement(sb, "dependent-apps", relengProperties, 3);
        if (FileUtil.exists(fullWebInfDirName + "releng/icons/90x90.png")) {
            this._writeElement(sb, "icon", relativeWebInfDirName + "releng/icons/90x90.png", 3);
        }
        this._writeElement(sb, "labs", relengProperties, 3);
        this._writeElement(sb, "marketplace", relengProperties, 3);
        this._writeElement(sb, "public", relengProperties, 3);
        String fullScreenshotsDirName = fullWebInfDirName + "releng/screenshots/";
        if (FileUtil.exists(fullScreenshotsDirName)) {
            Object[] screenshotsFileNames = FileUtil.listFiles(fullScreenshotsDirName);
            Arrays.sort(screenshotsFileNames);
            String relativeScreenshotsDirName = relativeWebInfDirName + "releng/screenshots/";
            for (Object screenshotsFileName : screenshotsFileNames) {
                if (((String)screenshotsFileName).equals("Thumbs.db") || ((String)screenshotsFileName).endsWith(".png")) {
                    FileUtil.delete(fullScreenshotsDirName + (String)screenshotsFileName);
                }
                if (!((String)screenshotsFileName).endsWith(".jpg")) continue;
                this._writeElement(sb, "screenshot", relativeScreenshotsDirName + (String)screenshotsFileName, 3);
            }
        }
        this._writeElement(sb, "support-url", relengProperties, 3);
        this._writeElement(sb, "supported", relengProperties, 3);
        File relengChangeLogFile = new File(fullWebInfDirName + "liferay-releng.changelog");
        if (GetterUtil.getBoolean(relengProperties.getProperty("marketplace"))) {
            this._updateRelengChangeLogFile(pluginPackageProperties, relengChangeLogFile, relengProperties);
        } else {
            relengChangeLogFile.delete();
        }
        return sb.toString();
    }

    private void _updateRelengChangeLogFile(Properties pluginPackageProperties, File relengChangeLogFile, Properties relengProperties) throws Exception {
        File pluginPackagePropertiesFile;
        String pluginPackagePropertiesContent;
        StringBundler sb = new StringBundler();
        int changeLogVersion = 0;
        int moduleIncrementalVersion = GetterUtil.getInteger(pluginPackageProperties.getProperty("module-incremental-version"));
        if (!relengChangeLogFile.exists()) {
            FileUtil.write(relengChangeLogFile, "TEMP=");
        }
        String relengChangeLogContent = FileUtil.read(relengChangeLogFile);
        ArrayList<String> relengChangeLogEntries = new ArrayList<String>();
        String[] relengChangeLogEntriesArray = StringUtil.split(relengChangeLogContent, "\n");
        for (int i = 0; i < relengChangeLogEntriesArray.length; ++i) {
            String relengChangeLogEntry = relengChangeLogEntriesArray[i];
            if (Validator.isNull(relengChangeLogEntry) || relengChangeLogEntry.startsWith("#")) continue;
            relengChangeLogEntries.add(relengChangeLogEntry);
            if (i + 1 != relengChangeLogEntriesArray.length || relengChangeLogEntry.contains("HEAD=") || relengChangeLogEntry.contains("TEMP=") || relengChangeLogEntry.contains(this._latestHASH) || relengChangeLogEntries.isEmpty()) continue;
            int x = relengChangeLogEntry.indexOf("..");
            int y = relengChangeLogEntry.indexOf("=", x);
            String range = relengChangeLogEntry.substring(x + 2, y) + "^.." + this._latestHASH;
            relengChangeLogEntries.add(range);
        }
        File webInfDir = relengChangeLogFile.getParentFile();
        File docrootDir = webInfDir.getParentFile();
        File pluginDir = docrootDir.getParentFile();
        for (String relengChangeLogEntry : relengChangeLogEntries) {
            String[] dependentApps;
            String[] relengChangeLogEntryParts = StringUtil.split(relengChangeLogEntry, "=");
            String range = relengChangeLogEntryParts[0];
            if (range.equals("TEMP")) {
                sb.append(this._getChangeLogEntry(++changeLogVersion, range, ""));
                break;
            }
            Set<String> ticketIds = this._extractTicketIds(pluginDir, range);
            if (range.endsWith("^.." + this._latestHASH) && ticketIds.isEmpty() && relengChangeLogEntries.size() > 1) continue;
            if (ticketIds.isEmpty()) {
                System.out.println(pluginDir + " does not have changes for range " + range);
            }
            for (String dependentApp : dependentApps = StringUtil.split(relengProperties.getProperty("dependent-apps"))) {
                if ((dependentApp = dependentApp.trim()).equals("resources-impoter-web")) continue;
                String dependentAppDirName = null;
                if (dependentApp.endsWith("-hook")) {
                    dependentAppDirName = "hooks";
                } else if (dependentApp.endsWith("-layouttpl")) {
                    dependentAppDirName = "layouttpl";
                } else if (dependentApp.endsWith("-portlet")) {
                    dependentAppDirName = "portlets";
                } else if (dependentApp.endsWith("-theme")) {
                    dependentAppDirName = "themes";
                } else if (dependentApp.endsWith("-web")) {
                    dependentAppDirName = "webs";
                }
                File dependentAppDir = new File(this._pluginsDir, dependentAppDirName + "/" + dependentApp);
                if (!dependentAppDir.exists()) {
                    throw new RuntimeException(dependentAppDir + " does not exist");
                }
                ticketIds.addAll(this._extractTicketIds(dependentAppDir, range));
            }
            String ticketIdsString = StringUtil.merge(ticketIds.toArray(new String[0]), " ");
            sb.append(this._getChangeLogEntry(++changeLogVersion, range, ticketIdsString));
        }
        if (!(pluginPackagePropertiesContent = FileUtil.read(pluginPackagePropertiesFile = new File(webInfDir, "liferay-plugin-package.properties"))).contains("long-description")) {
            int x = pluginPackagePropertiesContent.indexOf("change-log=");
            pluginPackagePropertiesContent = pluginPackagePropertiesContent.substring(0, x) + "long-description=\n" + pluginPackagePropertiesContent.substring(x);
        }
        if (moduleIncrementalVersion != changeLogVersion) {
            pluginPackagePropertiesContent = StringUtil.replace(pluginPackagePropertiesContent, "module-incremental-version=" + moduleIncrementalVersion, "module-incremental-version=" + changeLogVersion);
        }
        FileUtil.write(pluginPackagePropertiesFile, pluginPackagePropertiesContent);
        FileUtil.write(relengChangeLogFile, sb.toString());
        File relengChangeLogMD5File = new File(webInfDir, "liferay-releng.changelog.md5");
        String md5Checksum = FileUtil.getMD5Checksum(relengChangeLogFile);
        FileUtil.write(relengChangeLogMD5File, md5Checksum);
    }

    private String _updateRelengPropertiesFile(String relengPropertiesFileName, Properties relengProperties) throws Exception {
        StringBundler sb = new StringBundler();
        this._writeProperty(sb, relengProperties, "bundle", "false");
        this._writeProperty(sb, relengProperties, "category", "");
        this._writeProperty(sb, relengProperties, "demo-url", "");
        this._writeProperty(sb, relengProperties, "dependent-apps", "");
        this._writeProperty(sb, relengProperties, "labs", "true");
        this._writeProperty(sb, relengProperties, "marketplace", "false");
        this._writeProperty(sb, relengProperties, "public", "true");
        this._writeProperty(sb, relengProperties, "support-url", "");
        this._writeProperty(sb, relengProperties, "supported", "false");
        String relengPropertiesContent = sb.toString();
        FileUtil.write(relengPropertiesFileName, relengPropertiesContent);
        return relengPropertiesContent;
    }

    private void _writeElement(StringBundler sb, String name, Properties properties, int tabsCount) {
        this._writeElement(sb, name, this._readProperty(properties, name), tabsCount);
    }

    private void _writeElement(StringBundler sb, String name, String value, int tabsCount) {
        for (int i = 0; i < tabsCount; ++i) {
            sb.append("\t");
        }
        sb.append("<");
        sb.append(name);
        sb.append("><![CDATA[");
        sb.append(value);
        sb.append("]]></");
        sb.append(name);
        sb.append(">\n");
    }

    private void _writeProperty(StringBundler sb, Properties properties, String key, String defaultValue) {
        String value = GetterUtil.getString(properties.getProperty(key), defaultValue);
        if (sb.index() > 0) {
            sb.append("\n");
        }
        sb.append(key);
        sb.append("=");
        sb.append(value);
    }
}

