/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.tools.ToolDependencies;
import com.liferay.portal.tools.ToolsUtil;
import com.thoughtworks.qdox.JavaDocBuilder;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.Type;
import com.thoughtworks.qdox.model.TypeVariable;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.List;

public class InstanceWrapperBuilder {
    public static void main(String[] args) {
        ToolDependencies.wireBasic();
        if (args.length != 1) {
            throw new IllegalArgumentException();
        }
        new InstanceWrapperBuilder(args[0]);
    }

    public InstanceWrapperBuilder(String xml) {
        try {
            File file = new File(xml);
            Document document = UnsecureSAXReaderUtil.read(file);
            Element rootElement = document.getRootElement();
            List<Element> instanceWrapperElements = rootElement.elements("instance-wrapper");
            for (Element instanceWrapperElement : instanceWrapperElements) {
                String parentDir = instanceWrapperElement.attributeValue("parent-dir");
                String srcFile = instanceWrapperElement.attributeValue("src-file");
                this._createIW(parentDir, srcFile);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void _createIW(String parentDir, String srcFile) throws IOException {
        JavaClass javaClass = this._getJavaClass(parentDir, srcFile);
        JavaMethod[] javaMethods = javaClass.getMethods();
        StringBundler sb = new StringBundler();
        sb.append("package ");
        JavaPackage javaPackage = javaClass.getPackage();
        sb.append(javaPackage.getName());
        sb.append(";");
        sb.append("public class ");
        sb.append(javaClass.getName());
        sb.append("_IW {");
        sb.append("public static ");
        sb.append(javaClass.getName());
        sb.append("_IW getInstance() {return _instance;}\n");
        for (JavaMethod javaMethod : javaMethods) {
            void var17_23;
            JavaParameter[] javaParameters;
            Object[] docletTags;
            String methodName = javaMethod.getName();
            if (!javaMethod.isPublic() || !javaMethod.isStatic()) continue;
            if (methodName.equals("getInstance")) {
                methodName = "getWrappedInstance";
            }
            if (ArrayUtil.isNotEmpty(docletTags = javaMethod.getTagsByName("deprecated"))) {
                sb.append("\t/**\n");
                sb.append("\t * @deprecated\n");
                sb.append("\t */\n");
                sb.append("\t@Deprecated\n");
            }
            sb.append("public ");
            TypeVariable[] typeParameters = javaMethod.getTypeParameters();
            if (typeParameters.length > 0) {
                sb.append(" <");
                for (TypeVariable typeVariable : typeParameters) {
                    sb.append(typeVariable.getName());
                    sb.append(", ");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("> ");
            }
            sb.append(this._getTypeGenericsName(javaMethod.getReturnType()));
            sb.append(" ");
            sb.append(methodName);
            sb.append("(");
            JavaParameter[] javaParameterArray = javaParameters = javaMethod.getParameters();
            int n = javaParameterArray.length;
            boolean bl = false;
            while (var17_23 < n) {
                JavaParameter javaParameter = javaParameterArray[var17_23];
                sb.append(this._getTypeGenericsName(javaParameter.getType()));
                if (javaParameter.isVarArgs()) {
                    sb.append("...");
                }
                sb.append(" ");
                sb.append(javaParameter.getName());
                sb.append(", ");
                ++var17_23;
            }
            if (javaParameters.length > 0) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append(")");
            Type[] thrownExceptions = javaMethod.getExceptions();
            LinkedHashSet<String> newExceptions = new LinkedHashSet<String>();
            for (Type thrownException : thrownExceptions) {
                newExceptions.add(thrownException.getValue());
            }
            if (!newExceptions.isEmpty()) {
                sb.append(" throws ");
                for (String newException : newExceptions) {
                    sb.append(newException);
                    sb.append(", ");
                }
                sb.setIndex(sb.index() - 1);
            }
            sb.append("{\n");
            Type type = javaMethod.getReturnType();
            String returnTypeValue = type.getValue();
            if (!returnTypeValue.equals("void")) {
                sb.append("return ");
            }
            sb.append(javaClass.getName());
            sb.append(".");
            sb.append(javaMethod.getName());
            sb.append("(");
            for (JavaParameter javaParameter2 : javaParameters) {
                sb.append(javaParameter2.getName());
                sb.append(", ");
            }
            if (javaParameters.length > 0) {
                sb.setIndex(sb.index() - 1);
            }
            sb.append(");}\n");
        }
        sb.append("private ");
        sb.append(javaClass.getName());
        sb.append("_IW() {}");
        sb.append("private static ");
        sb.append(javaClass.getName());
        sb.append("_IW _instance = new ");
        sb.append(javaClass.getName());
        sb.append("_IW();");
        sb.append("}");
        File file = new File(StringBundler.concat(parentDir, "/", StringUtil.replace(javaPackage.getName(), '.', '/'), "/", javaClass.getName(), "_IW.java"));
        ToolsUtil.writeFile(file, sb.toString(), null);
    }

    private String _getDimensions(Type type) {
        String dimensions = "";
        for (int i = 0; i < type.getDimensions(); ++i) {
            dimensions = dimensions + "[]";
        }
        return dimensions;
    }

    private JavaClass _getJavaClass(String parentDir, String srcFile) throws IOException {
        String className = StringUtil.replace(srcFile.substring(0, srcFile.length() - 5), '/', '.');
        JavaDocBuilder builder = new JavaDocBuilder();
        builder.addSource(new File(parentDir + "/" + srcFile));
        return builder.getClassByName(className);
    }

    private String _getTypeGenericsName(Type type) {
        Type[] actualTypeArguments = type.getActualTypeArguments();
        if (actualTypeArguments == null) {
            String value = type.getValue();
            return value.concat(this._getDimensions(type));
        }
        StringBundler sb = new StringBundler(actualTypeArguments.length * 2 + 3);
        sb.append(type.getValue());
        sb.append("<");
        for (Type actualTypeArgument : actualTypeArguments) {
            sb.append(this._getTypeGenericsName(actualTypeArgument));
            sb.append(", ");
        }
        if (actualTypeArguments.length > 0) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(">");
        sb.append(this._getDimensions(type));
        return sb.toString();
    }
}

