/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolDependencies;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public class DBBuilder {
    private final String _databaseName;
    private final DBType[] _dbTypes;

    public static void main(String[] args) throws Exception {
        ToolDependencies.wireBasic();
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String databaseName = arguments.get("db.database.name");
        String databaseTypesString = arguments.get("db.database.types");
        DBType[] dbTypes = DBType.values();
        if (databaseTypesString != null) {
            String[] databaseTypeValues = StringUtil.split(databaseTypesString);
            dbTypes = new DBType[databaseTypeValues.length];
            for (int i = 0; i < dbTypes.length; ++i) {
                dbTypes[i] = DBType.valueOf(StringUtil.toUpperCase(databaseTypeValues[i]));
            }
        }
        String sqlDir = arguments.get("db.sql.dir");
        try {
            new DBBuilder(databaseName, dbTypes, sqlDir);
        }
        catch (Exception e) {
            ArgumentsUtil.processMainException(arguments, e);
        }
    }

    public DBBuilder(String databaseName, DBType[] dbTypes, String sqlDir) throws Exception {
        this._databaseName = databaseName;
        this._dbTypes = dbTypes;
        if (!sqlDir.endsWith("/META-INF/sql") && !sqlDir.endsWith("/WEB-INF/sql")) {
            this._buildSQLFile(sqlDir, "portal");
            this._buildSQLFile(sqlDir, "portal-tables");
        } else {
            this._buildSQLFile(sqlDir, "tables");
        }
        this._buildSQLFile(sqlDir, "indexes");
        this._buildSQLFile(sqlDir, "sequences");
        this._buildSQLFile(sqlDir, "update-6.1.0-6.1.1");
        this._buildSQLFiles(sqlDir, "update-6.1.1-6.2.0*");
        this._buildSQLFiles(sqlDir, "update-6.2.0-7.0.0*");
        this._buildSQLFiles(sqlDir, "update-7.0.0-7.0.1*");
        this._buildCreateFile(sqlDir);
    }

    private void _buildCreateFile(String sqlDir) throws IOException {
        for (DBType dbType : this._dbTypes) {
            DB db;
            if (dbType == DBType.HYPERSONIC || (db = DBManagerUtil.getDB(dbType, null)) == null) continue;
            if (!sqlDir.endsWith("/WEB-INF/sql")) {
                db.buildCreateFile(sqlDir, this._databaseName);
                continue;
            }
            db.buildCreateFile(sqlDir, this._databaseName, 1);
        }
    }

    private void _buildSQLFile(String sqlDir, String fileName) throws IOException {
        if (!FileUtil.exists(StringBundler.concat(sqlDir, "/", fileName, ".sql"))) {
            return;
        }
        this._generateSQLFile(sqlDir, fileName);
    }

    private void _buildSQLFiles(String sqlDir, String regex) throws IOException {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(sqlDir, new String[0]), regex);){
            for (Path path : paths) {
                Path fileNamePath = path.getFileName();
                String fileName = fileNamePath.toString();
                this._generateSQLFile(sqlDir, fileName.replace(".sql", ""));
            }
        }
    }

    private void _generateSQLFile(String sqlDir, String fileName) throws IOException {
        for (DBType dbType : this._dbTypes) {
            DB db = DBManagerUtil.getDB(dbType, null);
            if (db == null) continue;
            db.buildSQLFile(sqlDir, fileName);
        }
    }
}

