/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.theme;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.service.ThemeLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;

public class ThemeLoader {
    private static final Log _log = LogFactoryUtil.getLog(ThemeLoader.class);
    private final File _fileStorage;
    private final Map<String, Long> _lastModifiedMap = new HashMap<String, Long>();
    private final boolean _loadFromServletContext;
    private final ServletContext _servletContext;
    private final String _servletContextName;
    private final String _themesPath;

    public File getFileStorage() {
        return this._fileStorage;
    }

    public String getServletContextName() {
        return this._servletContextName;
    }

    public String getThemesPath() {
        return this._themesPath;
    }

    public synchronized void loadThemes() {
        File[] files;
        if (_log.isInfoEnabled()) {
            _log.info("Loading themes in " + this._fileStorage);
        }
        if ((files = this._fileStorage.listFiles()) == null) {
            if (_log.isWarnEnabled()) {
                _log.warn("There are no directories to process for " + this._fileStorage);
            }
            return;
        }
        for (File directory : files) {
            File liferayLookAndFeelXML;
            if (_log.isDebugEnabled()) {
                _log.debug("Process directory " + directory);
            }
            if ((liferayLookAndFeelXML = new File(directory + "/liferay-look-and-feel.xml")).exists()) {
                String lastModifiedKey = liferayLookAndFeelXML.toString();
                Long prevLastModified = this._lastModifiedMap.get(lastModifiedKey);
                long lastModified = liferayLookAndFeelXML.lastModified();
                if (prevLastModified == null || prevLastModified < lastModified) {
                    this.registerTheme(liferayLookAndFeelXML);
                    this._lastModifiedMap.put(lastModifiedKey, lastModified);
                    continue;
                }
                if (!_log.isDebugEnabled()) continue;
                _log.debug("Do not refresh " + liferayLookAndFeelXML + " because it is has not been modified");
                continue;
            }
            if (!_log.isWarnEnabled()) continue;
            _log.warn(liferayLookAndFeelXML + " does not exist");
        }
    }

    protected ThemeLoader(String servletContextName, ServletContext servletContext, String[] xmls) {
        this._servletContextName = servletContextName;
        this._servletContext = servletContext;
        boolean loadFromServletContext = true;
        File fileStorage = null;
        String themesPath = null;
        try {
            Document doc = UnsecureSAXReaderUtil.read(xmls[0], true);
            Element root = doc.getRootElement();
            themesPath = GetterUtil.getString(root.elementText("themes-path"), "/themes");
            String fileStorageValue = PropsValues.THEME_LOADER_STORAGE_PATH;
            fileStorageValue = GetterUtil.getString(root.elementText("file-storage"), fileStorageValue);
            if (Validator.isNotNull(fileStorageValue)) {
                fileStorage = new File(fileStorageValue);
                loadFromServletContext = false;
            } else {
                fileStorage = new File(servletContext.getRealPath(themesPath));
                loadFromServletContext = true;
            }
            if (!fileStorage.exists()) {
                if (_log.isWarnEnabled()) {
                    _log.warn("File storage " + fileStorage + " does not exist");
                }
                if (!fileStorage.mkdirs()) {
                    _log.error("Unable to create theme loader file storage at " + fileStorage);
                }
            }
        }
        catch (Exception e) {
            _log.error(e, e);
        }
        this._loadFromServletContext = loadFromServletContext;
        this._fileStorage = fileStorage;
        this._themesPath = themesPath;
        this.loadThemes();
    }

    protected void destroy() {
    }

    protected void registerTheme(File liferayLookAndFeelXML) {
        if (_log.isDebugEnabled()) {
            _log.debug("Registering " + liferayLookAndFeelXML);
        }
        try {
            String content = FileUtil.read(liferayLookAndFeelXML);
            ThemeLocalServiceUtil.init(this._servletContextName, this._servletContext, this._themesPath, this._loadFromServletContext, new String[]{content}, null);
        }
        catch (Exception e) {
            _log.error("Error registering theme " + liferayLookAndFeelXML.toString(), e);
        }
    }
}

