/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.StatementWrapper;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.TransactionConfig;
import com.liferay.portal.kernel.transaction.TransactionInvokerUtil;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.Callable;
import org.junit.Assert;
import org.junit.internal.runners.statements.RunAfters;
import org.junit.internal.runners.statements.RunBefores;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class TransactionalTestRule
implements TestRule {
    public static final TransactionalTestRule INSTANCE = new TransactionalTestRule(Propagation.SUPPORTS, null);
    private final String _originBundleSymbolicName;
    private final TransactionConfig _transactionConfig;

    public TransactionalTestRule(Propagation propagation) {
        this(propagation, null);
    }

    public TransactionalTestRule(Propagation propagation, String originBundleSymbolicName) {
        this._transactionConfig = TransactionConfig.Factory.create(propagation, new Class[]{PortalException.class, SystemException.class}, new Class[0]);
        this._originBundleSymbolicName = originBundleSymbolicName;
    }

    @Override
    public Statement apply(Statement statement, final Description description) {
        Statement currentStatement = statement;
        while (true) {
            if (currentStatement instanceof StatementWrapper) {
                StatementWrapper statementWrapper = (StatementWrapper)currentStatement;
                currentStatement = statementWrapper.getStatement();
                continue;
            }
            if (currentStatement instanceof RunRules) {
                currentStatement = (Statement)ReflectionTestUtil.getFieldValue(currentStatement, "statement");
                continue;
            }
            if (currentStatement instanceof RunBefores) {
                this.replaceFrameworkMethods(currentStatement, "befores");
                currentStatement = (Statement)ReflectionTestUtil.getFieldValue(currentStatement, "next");
                continue;
            }
            if (!(currentStatement instanceof RunAfters)) break;
            this.replaceFrameworkMethods(currentStatement, "afters");
            currentStatement = (Statement)ReflectionTestUtil.getFieldValue(currentStatement, "next");
        }
        return new StatementWrapper(statement){

            @Override
            public void evaluate() throws Throwable {
                try (Closeable closeable = TransactionalTestRule._installTransactionExecutor(TransactionalTestRule.this._originBundleSymbolicName);){
                    TransactionInvokerUtil.invoke(TransactionalTestRule.this.getTransactionConfig(description.getAnnotation(Transactional.class)), new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            try {
                                statement.evaluate();
                            }
                            catch (Throwable t) {
                                ReflectionUtil.throwException(t);
                            }
                            return null;
                        }
                    });
                }
            }
        };
    }

    public TransactionConfig getTransactionConfig(Transactional transactional) {
        if (transactional != null) {
            return TransactionConfig.Factory.create(transactional.isolation(), transactional.propagation(), transactional.readOnly(), transactional.timeout(), transactional.rollbackFor(), transactional.rollbackForClassName(), transactional.noRollbackFor(), transactional.noRollbackForClassName());
        }
        return this._transactionConfig;
    }

    protected void replaceFrameworkMethods(Statement statement, String name) {
        ArrayList<FrameworkMethod> newFrameworkMethods = new ArrayList<FrameworkMethod>();
        List frameworkMethods = (List)ReflectionTestUtil.getFieldValue(statement, name);
        for (FrameworkMethod frameworkMethod : frameworkMethods) {
            if (frameworkMethod instanceof TransactionalFrameworkMethod) {
                newFrameworkMethods.add(frameworkMethod);
                continue;
            }
            newFrameworkMethods.add(new TransactionalFrameworkMethod(frameworkMethod.getMethod(), this.getTransactionConfig(frameworkMethod.getAnnotation(Transactional.class)), this._originBundleSymbolicName));
        }
        ReflectionTestUtil.setFieldValue(statement, name, newFrameworkMethods);
    }

    private static Closeable _installTransactionExecutor(String originBundleSymbolicName) throws Exception {
        if (originBundleSymbolicName == null) {
            return () -> {};
        }
        ClassLoader classLoader = PortalClassLoaderUtil.getClassLoader();
        Class<?> clazz = classLoader.loadClass("com.liferay.portal.spring.transaction.TransactionExecutorThreadLocal");
        Field field = clazz.getDeclaredField("_transactionExecutorThreadLocal");
        field.setAccessible(true);
        ThreadLocal transactionExecutorsThreadLocal = (ThreadLocal)field.get(null);
        Deque transactionExecutors = (Deque)transactionExecutorsThreadLocal.get();
        Registry registry = RegistryUtil.getRegistry();
        Object[] serviceReferences = registry.getAllServiceReferences("com.liferay.portal.spring.transaction.TransactionExecutor", "(origin.bundle.symbolic.name=" + originBundleSymbolicName + ")");
        Assert.assertEquals(StringBundler.concat("Expected 1 TransactionExecutor for ", originBundleSymbolicName, ", actually have ", Arrays.toString(serviceReferences)), 1L, serviceReferences.length);
        Object serviceReference = serviceReferences[0];
        Object portletTransactionExecutor = registry.getService(serviceReference);
        if (portletTransactionExecutor == transactionExecutors.peek()) {
            return () -> {};
        }
        transactionExecutors.push(portletTransactionExecutor);
        return () -> TransactionalTestRule.lambda$_installTransactionExecutor$2(transactionExecutors, registry, (ServiceReference)serviceReference);
    }

    private static /* synthetic */ void lambda$_installTransactionExecutor$2(Deque transactionExecutors, Registry registry, ServiceReference serviceReference) throws IOException {
        transactionExecutors.pop();
        registry.ungetService(serviceReference);
    }

    protected static class TransactionalFrameworkMethod
    extends FrameworkMethod {
        private final String _originBundleSymbolicName;
        private final TransactionConfig _transactionConfig;

        @Override
        public Object invokeExplosively(final Object target, final Object ... params) throws Throwable {
            try (Closeable closeable = TransactionalTestRule._installTransactionExecutor(this._originBundleSymbolicName);){
                Object object = TransactionInvokerUtil.invoke(this._transactionConfig, new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        try {
                            return TransactionalFrameworkMethod.super.invokeExplosively(target, params);
                        }
                        catch (Throwable t) {
                            ReflectionUtil.throwException(t);
                            return null;
                        }
                    }
                });
                return object;
            }
        }

        protected TransactionalFrameworkMethod(Method method, TransactionConfig transactionConfig, String originBundleSymbolicName) {
            super(method);
            this._transactionConfig = transactionConfig;
            this._originBundleSymbolicName = originBundleSymbolicName;
        }
    }
}

