/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.DataAccess;
import com.liferay.portal.kernel.test.rule.AbstractTestRule;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.test.rule.SybaseDump;
import com.liferay.portal.test.rule.SybaseDumpTransactionLog;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import org.junit.runner.Description;

public class SybaseDumpTransactionLogTestRule
extends AbstractTestRule<Void, Void> {
    public static final SybaseDumpTransactionLogTestRule INSTANCE = new SybaseDumpTransactionLogTestRule();
    private Thread _thread;

    @Override
    public void afterMethod(Description description, Void v, Object target) throws Exception {
        if (this._thread != null) {
            this._thread.interrupt();
            this._thread.join();
        }
    }

    @Override
    public Void beforeClass(Description description) throws SQLException {
        SybaseDump[] sybaseDumps;
        SybaseDumpTransactionLog sybaseDumpTransactionLog = description.getAnnotation(SybaseDumpTransactionLog.class);
        if (sybaseDumpTransactionLog != null && !ArrayUtil.contains((Object[])(sybaseDumps = sybaseDumpTransactionLog.dumpBefore()), (Object)SybaseDump.CLASS)) {
            return null;
        }
        this._dumpTransactionLog();
        return null;
    }

    @Override
    public Void beforeMethod(Description description, Object target) throws SQLException {
        SybaseDump[] sybaseDumps;
        Class<?> testClass = description.getTestClass();
        SybaseDumpTransactionLog sybaseDumpTransactionLog = testClass.getAnnotation(SybaseDumpTransactionLog.class);
        if (sybaseDumpTransactionLog != null && ArrayUtil.contains((Object[])(sybaseDumps = sybaseDumpTransactionLog.dumpBefore()), (Object)SybaseDump.METHOD)) {
            this._dumpTransactionLog();
            this._thread = new Thread(() -> {
                try {
                    while (true) {
                        Thread.sleep(10000L);
                        this._dumpTransactionLog();
                    }
                }
                catch (InterruptedException ie) {
                }
                catch (SQLException sqle) {
                    throw new RuntimeException(sqle);
                }
            }, SybaseDumpTransactionLogTestRule.class.getName());
            this._thread.setDaemon(true);
            this._thread.start();
        }
        return null;
    }

    @Override
    protected void afterClass(Description description, Void v) {
    }

    private SybaseDumpTransactionLogTestRule() {
    }

    private void _dumpTransactionLog() throws SQLException {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.SYBASE) {
            return;
        }
        try (Connection connection = DataAccess.getConnection();
             Statement statement = connection.createStatement();){
            statement.execute("dump transaction " + connection.getCatalog() + " with no_log");
        }
    }
}

