/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.ModelListenerRegistrationUtil;
import com.liferay.portal.kernel.test.ReflectionTestUtil;
import com.liferay.portal.kernel.test.rule.AbstractTestRule;
import com.liferay.portal.kernel.test.rule.ArquillianUtil;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.service.test.ServiceTestUtil;
import com.liferay.portal.tools.DBUpgrader;
import java.util.concurrent.ConcurrentHashMap;
import org.junit.runner.Description;

public class PersistenceTestRule
extends AbstractTestRule<Object, Object> {
    public static final PersistenceTestRule INSTANCE = new PersistenceTestRule();
    private static boolean _initialized;

    @Override
    public void afterMethod(Description description, Object modelListeners, Object target) {
        Object instance = ReflectionTestUtil.getFieldValue(ModelListenerRegistrationUtil.class, "_instance");
        CacheRegistryUtil.setActive(true);
        ReflectionTestUtil.setFieldValue(instance, "_modelListeners", modelListeners);
    }

    @Override
    public Object beforeClass(Description description) {
        if (_initialized || ArquillianUtil.isArquillianTest(description)) {
            return null;
        }
        try {
            DBUpgrader.upgrade();
        }
        catch (Throwable t) {
            throw new ExceptionInInitializerError(t);
        }
        finally {
            CacheRegistryUtil.setActive(true);
        }
        _initialized = true;
        return null;
    }

    @Override
    public Object beforeMethod(Description description, Object target) throws Exception {
        Object instance = ReflectionTestUtil.getFieldValue(ModelListenerRegistrationUtil.class, "_instance");
        Object modelListeners = ReflectionTestUtil.getFieldValue(instance, "_modelListeners");
        ReflectionTestUtil.setFieldValue(instance, "_modelListeners", new ConcurrentHashMap());
        CacheRegistryUtil.setActive(false);
        ServiceTestUtil.setUser(TestPropsValues.getUser());
        return modelListeners;
    }

    @Override
    protected void afterClass(Description description, Object object) {
    }

    private PersistenceTestRule() {
    }
}

