/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.test.rule.MethodTestRule;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.security.permission.SimplePermissionChecker;
import org.junit.runner.Description;

public class PermissionCheckerMethodTestRule
extends MethodTestRule<Void> {
    public static final PermissionCheckerMethodTestRule INSTANCE = new PermissionCheckerMethodTestRule();
    private String _originalName;
    private PermissionChecker _originalPermissionChecker;

    @Override
    public void afterMethod(Description description, Void c, Object target) throws Throwable {
        PermissionThreadLocal.setPermissionChecker(this._originalPermissionChecker);
        PrincipalThreadLocal.setName(this._originalName);
    }

    @Override
    public Void beforeMethod(Description description, Object target) throws Exception {
        this.setUpPermissionThreadLocal();
        this.setUpPrincipalThreadLocal();
        return null;
    }

    protected void setUpPermissionThreadLocal() throws Exception {
        this._originalPermissionChecker = PermissionThreadLocal.getPermissionChecker();
        PermissionThreadLocal.setPermissionChecker(new SimplePermissionChecker(){
            {
                this.init(TestPropsValues.getUser());
            }

            @Override
            public boolean hasOwnerPermission(long companyId, String name, String primKey, long ownerId, String actionId) {
                return true;
            }
        });
    }

    protected void setUpPrincipalThreadLocal() throws Exception {
        this._originalName = PrincipalThreadLocal.getName();
        PrincipalThreadLocal.setName(TestPropsValues.getUserId());
    }

    private PermissionCheckerMethodTestRule() {
    }
}

