/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.internal.servlet.MainServlet;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.search.SearchEngineHelperUtil;
import com.liferay.portal.kernel.servlet.ServletContextClassLoaderPool;
import com.liferay.portal.kernel.servlet.ServletContextPool;
import com.liferay.portal.kernel.test.rule.ArquillianUtil;
import com.liferay.portal.kernel.test.rule.ClassTestRule;
import com.liferay.portal.kernel.test.util.TestPropsValues;
import com.liferay.portal.kernel.util.PortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import com.liferay.portal.module.framework.ModuleFrameworkUtilAdapter;
import com.liferay.portal.service.test.ServiceTestUtil;
import com.liferay.portal.test.mock.AutoDeployMockServletContext;
import javax.servlet.ServletException;
import org.junit.runner.Description;
import org.springframework.core.io.FileSystemResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.springframework.mock.web.MockServletConfig;

public class MainServletClassTestRule
extends ClassTestRule<Void> {
    public static final MainServletClassTestRule INSTANCE = new MainServletClassTestRule();
    private static MainServlet _mainServlet;

    public static MainServlet getMainServlet() {
        return _mainServlet;
    }

    @Override
    public void afterClass(Description description, Void v) throws PortalException {
        if (ArquillianUtil.isArquillianTest(description)) {
            return;
        }
        SearchEngineHelperUtil.removeCompany(TestPropsValues.getCompanyId());
    }

    @Override
    public Void beforeClass(Description description) {
        if (ArquillianUtil.isArquillianTest(description)) {
            return null;
        }
        if (_mainServlet == null) {
            final AutoDeployMockServletContext mockServletContext = new AutoDeployMockServletContext((ResourceLoader)new FileSystemResourceLoader());
            mockServletContext.setServletContextName("");
            Thread currentThread = Thread.currentThread();
            ServletContextClassLoaderPool.register("", currentThread.getContextClassLoader());
            PortalLifecycleUtil.register(new PortalLifecycle(){

                @Override
                public void portalDestroy() {
                }

                @Override
                public void portalInit() {
                    ModuleFrameworkUtilAdapter.registerContext(mockServletContext);
                }
            });
            ServletContextPool.put("", mockServletContext);
            MockServletConfig mockServletConfig = new MockServletConfig(mockServletContext, "Main Servlet");
            mockServletConfig.addInitParameter("config", "/WEB-INF/struts-config.xml");
            _mainServlet = new MainServlet();
            try {
                _mainServlet.init(mockServletConfig);
            }
            catch (ServletException se) {
                throw new RuntimeException("The main servlet could not be initialized", se);
            }
            ServiceTestUtil.initStaticServices();
        }
        ServiceTestUtil.initServices();
        ServiceTestUtil.initPermissions();
        return null;
    }

    protected MainServletClassTestRule() {
    }
}

