/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.petra.log4j.Log4JUtil;
import com.liferay.portal.kernel.test.rule.AggregateTestRule;
import com.liferay.portal.kernel.test.rule.ClassTestRule;
import com.liferay.portal.kernel.test.rule.CompanyProviderClassTestRule;
import com.liferay.portal.kernel.test.rule.DeleteAfterTestRunMethodTestRule;
import com.liferay.portal.kernel.test.rule.SynchronousDestinationTestRule;
import com.liferay.portal.kernel.test.rule.TimeoutTestRule;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import com.liferay.portal.spring.hibernate.DialectDetector;
import com.liferay.portal.test.rule.ClearThreadLocalClassTestRule;
import com.liferay.portal.test.rule.DestinationAwaitClassTestRule;
import com.liferay.portal.test.rule.InjectTestRule;
import com.liferay.portal.test.rule.LogAssertionTestRule;
import com.liferay.portal.test.rule.MainServletClassTestRule;
import com.liferay.portal.test.rule.SybaseDumpTransactionLogTestRule;
import com.liferay.portal.test.rule.UniqueStringRandomizerBumperClassTestRule;
import com.liferay.portal.util.InitUtil;
import com.liferay.portal.util.PortalClassPathUtil;
import com.liferay.portal.util.PropsUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Level;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.springframework.mock.web.MockServletContext;

public class LiferayIntegrationTestRule
extends AggregateTestRule {
    private static final TestRule _springInitializationClassTestRule = new ClassTestRule<Void>(){

        @Override
        protected void afterClass(Description description, Void v) {
        }

        @Override
        protected Void beforeClass(Description description) {
            if (!InitUtil.isInitialized()) {
                List<String> configLocations = ListUtil.fromArray(PropsUtil.getArray("spring.configs"));
                boolean configureLog4j = false;
                if (GetterUtil.getBoolean(SystemProperties.get("log4j.configure.on.startup"), true)) {
                    SystemProperties.set("log4j.configure.on.startup", "false");
                    configureLog4j = true;
                }
                Log4JUtil.setLevel(DialectDetector.class.getName(), Level.INFO.toString(), false);
                PortalClassPathUtil.initializeClassPaths(new MockServletContext());
                InitUtil.initWithSpring(configLocations, true, true);
                if (configureLog4j) {
                    Log4JUtil.configureLog4J(InitUtil.class.getClassLoader());
                    LogAssertionTestRule.startAssert(Collections.emptyList());
                }
                if (System.getProperty("external-properties") == null) {
                    System.setProperty("external-properties", "portal-test.properties");
                }
            }
            return null;
        }
    };

    public LiferayIntegrationTestRule() {
        super(false, LiferayIntegrationTestRule._getTestRules());
    }

    private static TestRule[] _getTestRules() {
        ArrayList<TestRule> testRules = new ArrayList<TestRule>();
        if (System.getenv("JENKINS_HOME") != null) {
            testRules.add(TimeoutTestRule.INSTANCE);
        }
        testRules.add(LogAssertionTestRule.INSTANCE);
        testRules.add(_springInitializationClassTestRule);
        testRules.add(SybaseDumpTransactionLogTestRule.INSTANCE);
        testRules.add(ClearThreadLocalClassTestRule.INSTANCE);
        testRules.add(UniqueStringRandomizerBumperClassTestRule.INSTANCE);
        testRules.add(MainServletClassTestRule.INSTANCE);
        testRules.add(DestinationAwaitClassTestRule.INSTANCE);
        testRules.add(CompanyProviderClassTestRule.INSTANCE);
        testRules.add(DeleteAfterTestRunMethodTestRule.INSTANCE);
        testRules.add(SynchronousDestinationTestRule.INSTANCE);
        testRules.add(InjectTestRule.INSTANCE);
        return testRules.toArray(new TestRule[0]);
    }
}

