/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.test.rule;

import com.liferay.portal.kernel.io.unsync.UnsyncPrintWriter;
import com.liferay.portal.kernel.test.rule.ClassTestRule;
import com.liferay.portal.util.PropsImpl;
import com.liferay.portal.util.PropsValues;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.server.Server;
import org.junit.runner.Description;

public class HypersonicServerClassTestRule
extends ClassTestRule<Server> {
    public static final String DATABASE_URL_BASE = "jdbc:hsqldb:hsql://localhost/";
    public static final HypersonicServerClassTestRule INSTANCE;
    private static final String _DATABASE_NAME;
    private static final String _DATABASE_URL;
    private static final boolean _HYPERSONIC;
    private static final String _HYPERSONIC_TEMP_DIR_NAME;

    @Override
    public void afterClass(Description description, Server server) throws Exception {
        try (Connection connection = DriverManager.getConnection(DATABASE_URL_BASE + _DATABASE_NAME, "sa", "");
             Statement statement = connection.createStatement();){
            statement.execute("SHUTDOWN COMPACT");
        }
        server.stop();
        this.deleteFolder(Paths.get(_HYPERSONIC_TEMP_DIR_NAME, new String[0]));
    }

    @Override
    public Server beforeClass(Description description) throws Exception {
        final CountDownLatch startCountDownLatch = new CountDownLatch(1);
        Server server = new Server(){
            private final CountDownLatch _shutdownCountDownLatch = new CountDownLatch(1);

            /*
             * Exception decompiling
             */
            public int stop() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            protected synchronized void setState(int state) {
                super.setState(state);
                if (state == 1) {
                    startCountDownLatch.countDown();
                } else if (state == 16) {
                    this._shutdownCountDownLatch.countDown();
                }
            }
        };
        try (Connection connection = DriverManager.getConnection(PropsValues.JDBC_DEFAULT_URL, "sa", "");
             Statement statement = connection.createStatement();){
            statement.execute("BACKUP DATABASE TO '" + _HYPERSONIC_TEMP_DIR_NAME + "' BLOCKING AS FILES");
        }
        server.setErrWriter((PrintWriter)new UnsyncPrintWriter(new File(_HYPERSONIC_TEMP_DIR_NAME, _DATABASE_NAME + ".err.log")));
        server.setLogWriter((PrintWriter)new UnsyncPrintWriter(new File(_HYPERSONIC_TEMP_DIR_NAME, _DATABASE_NAME + ".std.log")));
        server.setDatabaseName(0, _DATABASE_NAME);
        server.setDatabasePath(0, _HYPERSONIC_TEMP_DIR_NAME + _DATABASE_NAME);
        server.start();
        if (!startCountDownLatch.await(1L, TimeUnit.MINUTES)) {
            throw new IllegalStateException("Unable to start up Hypersonic " + _DATABASE_NAME);
        }
        return server;
    }

    public List<String> getJdbcProperties() {
        if (_HYPERSONIC) {
            return Arrays.asList("portal:jdbc.default.url=" + _DATABASE_URL, "portal:jdbc.default.username=sa", "portal:jdbc.default.password=");
        }
        return Collections.emptyList();
    }

    protected void copyFile(String fileName, Path fromFolderPath, Path toFolderPath) throws IOException {
        Path filePath = fromFolderPath.resolve(fileName);
        if (Files.exists(filePath, new LinkOption[0])) {
            Files.createDirectories(toFolderPath, new FileAttribute[0]);
            Files.copy(filePath, toFolderPath.resolve(fileName), new CopyOption[0]);
        }
    }

    @Override
    protected org.junit.runners.model.Statement createClassStatement(org.junit.runners.model.Statement statement, Description description) {
        if (!_HYPERSONIC) {
            return statement;
        }
        return super.createClassStatement(statement, description);
    }

    protected void deleteFolder(Path folderPath) throws IOException {
        if (!Files.exists(folderPath, new LinkOption[0])) {
            return;
        }
        Files.walkFileTree(folderPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult postVisitDirectory(Path dirPath, IOException ioe) throws IOException {
                if (ioe != null) {
                    throw ioe;
                }
                Files.delete(dirPath);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                Files.delete(filePath);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private HypersonicServerClassTestRule() {
    }

    static /* synthetic */ String access$000() {
        return _DATABASE_NAME;
    }

    static {
        _HYPERSONIC_TEMP_DIR_NAME = PropsValues.LIFERAY_HOME + "/data/hypersonic_temp/";
        PropsImpl props = new PropsImpl();
        String className = props.get("jdbc.default.driverClassName");
        _HYPERSONIC = className.equals(JDBCDriver.class.getName());
        if (_HYPERSONIC) {
            String jdbcURL = props.get("jdbc.default.url");
            int index = jdbcURL.lastIndexOf(47);
            if (index < 0) {
                throw new ExceptionInInitializerError("Invalid Hypersonic JDBC URL " + jdbcURL);
            }
            String databaseName = jdbcURL.substring(index + 1);
            if ((index = databaseName.indexOf(59)) >= 0) {
                databaseName = databaseName.substring(0, index);
            }
            _DATABASE_NAME = databaseName;
            _DATABASE_URL = DATABASE_URL_BASE + _DATABASE_NAME;
        } else {
            _DATABASE_NAME = null;
            _DATABASE_URL = null;
        }
        INSTANCE = new HypersonicServerClassTestRule();
    }
}

